/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Expectations;
import java.util.Date;
import java.util.TimeZone;

public class UsmFailureDuringRecurrenceTest
extends ManagedAppointmentTest {
    private Appointment app;

    public UsmFailureDuringRecurrenceTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.app = this.generateYearlyAppointment();
        this.calendarManager.setTimezone(TimeZone.getTimeZone("UTC"));
    }

    public void testFailWhenTryingToMakeAChangeExceptionASeries() throws Exception {
        Changes changes = new Changes();
        changes.put(207, (Object)1);
        changes.put(209, (Object)3);
        changes.put(213, (Object)23);
        changes.put(214, (Object)3);
        changes.put(216, (Object)this.D("31/12/2025 00:00"));
        this.failTest(changes, "Incomplete recurring information: missing interval");
    }

    public void testShouldFailWhenTryingToMakeAChangeExceptionASeriesButDoesNot() throws Exception {
        Changes changes = new Changes();
        changes.put(207, (Object)1);
        changes.put(209, (Object)3);
        changes.put(213, (Object)23);
        changes.put(214, (Object)3);
        changes.put(216, (Object)this.D("31/12/2025 00:00"));
        changes.put(215, (Object)1);
        Expectations expectationsForSeries = new Expectations();
        expectationsForSeries.put(209, (Object)4);
        Expectations expectationsForException = new Expectations();
        expectationsForException.put(207, (Object)1);
        expectationsForException.put(209, (Object)0);
        this.succeedTest(changes, expectationsForSeries, expectationsForException);
    }

    public void testFailOnAChangeExceptionWithoutInterval() throws Exception {
        Changes changes = new Changes();
        changes.put(207, (Object)1);
        changes.put(201, (Object)this.D("31/12/2025 00:00"));
        Expectations expectationsForException = new Expectations(changes);
        expectationsForException.put(209, (Object)1);
        expectationsForException.put(213, null);
        expectationsForException.put(214, null);
        expectationsForException.put(216, null);
        expectationsForException.put(215, null);
        this.failTest(changes, "Incomplete recurring information: missing interval.");
    }

    public void testShouldAllowToCreateAChangeException() throws Exception {
        Date myDate = this.D("31.12.2025 00:00");
        Changes changes = new Changes();
        changes.put(207, (Object)1);
        changes.put(201, (Object)myDate);
        changes.put(215, (Object)1);
        Expectations expectationsForException = new Expectations();
        expectationsForException.put(207, (Object)1);
        expectationsForException.put(209, (Object)0);
        expectationsForException.put(216, null);
        expectationsForException.put(215, null);
        expectationsForException.put(214, null);
        expectationsForException.put(213, null);
        this.succeedTest(changes, null, expectationsForException);
    }

    public void testShouldFailWhenTryingToDeleteExceptionOnNormalAppointment() throws Exception {
        this.app = new Appointment();
        this.app.setParentFolderID(this.folder.getObjectID());
        this.app.setStartDate(this.D("31.12.2025 00:00"));
        this.app.setEndDate(this.D("31.12.2025 01:00"));
        this.calendarManager.insert(this.app);
        this.app.setRecurrencePosition(1);
        this.calendarManager.delete(this.app, false);
        UsmFailureDuringRecurrenceTest.assertTrue((String)"Should fail", (boolean)this.calendarManager.hasLastException());
    }

    private void succeedTest(Changes changes, Expectations expectationsForSeries, Expectations expectationsForException) throws OXException {
        this.calendarManager.insert(this.app);
        UsmFailureDuringRecurrenceTest.assertFalse((String)"Creation was expected to work", (boolean)this.calendarManager.hasLastException());
        Appointment update = new Appointment();
        update.setParentFolderID(this.app.getParentFolderID());
        update.setObjectID(this.app.getObjectID());
        update.setLastModified(this.app.getLastModified());
        changes.update((CommonObject)update);
        this.calendarManager.update(update);
        if (update.containsRecurrencePosition()) {
            UsmFailureDuringRecurrenceTest.assertFalse((String)"Appointment and change exception should have different IDs", (this.app.getObjectID() == update.getObjectID() ? 1 : 0) != 0);
        }
        UsmFailureDuringRecurrenceTest.assertFalse((String)"Update was expected to work", (boolean)this.calendarManager.hasLastException());
        if (expectationsForSeries != null) {
            Appointment actualSeries = this.calendarManager.get(this.app);
            UsmFailureDuringRecurrenceTest.assertFalse((String)"Getting the series was expected to work", (boolean)this.calendarManager.hasLastException());
            expectationsForSeries.verify("[series]", (CommonObject)actualSeries);
        }
        if (expectationsForException != null) {
            Appointment actualChangeException = this.calendarManager.get(update);
            UsmFailureDuringRecurrenceTest.assertFalse((String)"Getting the update was expected to work", (boolean)this.calendarManager.hasLastException());
            expectationsForException.verify("[change exception]", (CommonObject)actualChangeException);
        }
    }

    private void failTest(Changes changes, String errorCode) {
        this.calendarManager.insert(this.app);
        Appointment update = new Appointment();
        update.setParentFolderID(this.app.getParentFolderID());
        update.setObjectID(this.app.getObjectID());
        update.setLastModified(this.app.getLastModified());
        changes.update((CommonObject)update);
        this.calendarManager.update(update);
        UsmFailureDuringRecurrenceTest.assertTrue((String)"Was expected to fail", (boolean)this.calendarManager.hasLastException());
        Exception exception = this.calendarManager.getLastException();
        UsmFailureDuringRecurrenceTest.assertTrue((String)("Expected message was " + errorCode + ", but got: " + exception.getMessage()), (boolean)exception.getMessage().contains(errorCode));
    }
}

