/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.group.actions.SearchRequest;
import com.openexchange.ajax.group.actions.SearchResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.json.JSONException;
import org.junit.Test;

public class Bug33242Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private CalendarTestManager ctm2;
    private Appointment series;
    private Appointment single;
    private AJAXClient client1;
    private AJAXClient client2;
    private String groupParticipant;
    private Appointment exception;

    public Bug33242Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User3);
        this.ctm = new CalendarTestManager(this.client1);
        this.ctm2 = new CalendarTestManager(this.client2);
        this.groupParticipant = AJAXConfig.getProperty(AJAXConfig.Property.GROUP_PARTICIPANT);
        this.prepareSeries();
        this.prepareSingle();
    }

    private void prepareSeries() throws OXException, IOException, JSONException {
        int nextYear = Calendar.getInstance().get(1);
        this.series = new Appointment();
        this.series.setTitle("Bug 33242 Test");
        this.series.setStartDate(TimeTools.D("01.08." + nextYear + " 18:00"));
        this.series.setEndDate(TimeTools.D("01.08." + nextYear + " 19:00"));
        this.series.setRecurrenceType(1);
        this.series.setOccurrence(5);
        this.series.setInterval(1);
        UserParticipant userPart = new UserParticipant(this.client1.getValues().getUserId());
        GroupParticipant groupPart = this.getGroupParticipant(this.groupParticipant);
        this.series.setParticipants(new Participant[]{userPart, groupPart});
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.series.setIgnoreConflicts(true);
        this.ctm.insert(this.series);
        this.exception = this.ctm.createIdentifyingCopy(this.series);
        this.exception.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.exception.setNote("Hello World");
        this.exception.setRecurrencePosition(2);
        this.ctm.setFailOnError(true);
        this.ctm2.setFailOnError(true);
    }

    private void prepareSingle() throws OXException, IOException, JSONException {
        int nextYear = Calendar.getInstance().get(1);
        this.single = new Appointment();
        this.single.setTitle("Bug 33242 Test Single");
        this.single.setStartDate(TimeTools.D("06.08." + nextYear + " 18:00"));
        this.single.setEndDate(TimeTools.D("06.08." + nextYear + " 19:00"));
        UserParticipant userPart = new UserParticipant(this.client1.getValues().getUserId());
        GroupParticipant groupPart = this.getGroupParticipant(this.groupParticipant);
        this.single.setParticipants(new Participant[]{userPart, groupPart});
        this.single.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.single.setIgnoreConflicts(true);
        this.ctm.insert(this.single);
        this.ctm.setFailOnError(true);
        this.ctm2.setFailOnError(true);
    }

    private GroupParticipant getGroupParticipant(String groupParticipant) throws OXException, IOException, JSONException {
        SearchResponse response = this.getClient().execute(new SearchRequest(groupParticipant));
        Group[] group = response.getGroups();
        int groupParticipantId = group[0].getIdentifier();
        GroupParticipant gpart = new GroupParticipant(groupParticipantId);
        return gpart;
    }

    @Test
    public void testDeleteByCreator() throws Exception {
        this.exception.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.ctm.delete(this.exception);
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Appointment creatorAppointment = this.ctm.get(this.series);
        this.series.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        Appointment groupMemberAppointment = this.ctm2.get(this.series);
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Bug33242Test.assertNotNull((Object)creatorAppointment.getDeleteException());
        Bug33242Test.assertNotNull((Object)groupMemberAppointment.getDeleteException());
        Bug33242Test.assertSame((Object)creatorAppointment.getDeleteException().length, (Object)1);
        Bug33242Test.assertSame((Object)groupMemberAppointment.getDeleteException().length, (Object)1);
        Bug33242Test.assertNull((Object)creatorAppointment.getChangeException());
        Bug33242Test.assertNull((Object)groupMemberAppointment.getChangeException());
    }

    @Test
    public void testDeleteByGroupMember() throws Exception {
        this.exception.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        this.ctm2.delete(this.exception);
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Appointment creatorAppointment = this.ctm.get(this.series);
        this.series.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        Appointment groupMemberAppointment = this.ctm2.get(this.series);
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Bug33242Test.assertNotNull((Object)creatorAppointment.getChangeException());
        Bug33242Test.assertNotNull((Object)groupMemberAppointment.getChangeException());
        Bug33242Test.assertSame((Object)creatorAppointment.getChangeException().length, (Object)1);
        Bug33242Test.assertSame((Object)groupMemberAppointment.getChangeException().length, (Object)1);
        Bug33242Test.assertNull((Object)creatorAppointment.getDeleteException());
        Bug33242Test.assertNull((Object)groupMemberAppointment.getDeleteException());
        List<Appointment> checkAppointment = this.ctm.getChangeExceptions(this.client1.getValues().getPrivateAppointmentFolder(), this.series.getObjectID(), Appointment.ALL_COLUMNS);
        Bug33242Test.assertNotNull(checkAppointment);
        Bug33242Test.assertSame((Object)checkAppointment.size(), (Object)1);
        boolean found = false;
        for (Participant p : checkAppointment.get(0).getParticipants()) {
            if (p.getIdentifier() != this.client1.getValues().getUserId()) continue;
            found = true;
        }
        Bug33242Test.assertTrue((String)"The creator is missing in the Participant list, but should be present", (boolean)found);
    }

    @Test
    public void testDeleteByCreaterWithUpdate() throws Exception {
        this.exception.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.ctm.update(this.exception);
        this.ctm.delete(this.exception);
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Appointment creatorAppointment = this.ctm.get(this.series);
        this.series.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        Appointment groupMemberAppointment = this.ctm2.get(this.series);
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Bug33242Test.assertNotNull((Object)creatorAppointment.getDeleteException());
        Bug33242Test.assertNotNull((Object)groupMemberAppointment.getDeleteException());
        Bug33242Test.assertSame((Object)creatorAppointment.getDeleteException().length, (Object)1);
        Bug33242Test.assertSame((Object)groupMemberAppointment.getDeleteException().length, (Object)1);
        Bug33242Test.assertNull((Object)creatorAppointment.getChangeException());
        Bug33242Test.assertNull((Object)groupMemberAppointment.getChangeException());
    }

    @Test
    public void testDeleteByGroupMemberWithUpdate() throws Exception {
        this.exception.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        this.ctm2.update(this.exception);
        this.ctm2.delete(this.exception);
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Appointment creatorAppointment = this.ctm.get(this.series);
        this.series.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        Appointment groupMemberAppointment = this.ctm2.get(this.series);
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        Bug33242Test.assertNotNull((Object)creatorAppointment.getChangeException());
        Bug33242Test.assertNotNull((Object)groupMemberAppointment.getChangeException());
        Bug33242Test.assertSame((Object)creatorAppointment.getChangeException().length, (Object)1);
        Bug33242Test.assertSame((Object)groupMemberAppointment.getChangeException().length, (Object)1);
        Bug33242Test.assertNull((Object)creatorAppointment.getDeleteException());
        Bug33242Test.assertNull((Object)groupMemberAppointment.getDeleteException());
        Appointment copy = this.ctm.createIdentifyingCopy(this.series);
        copy.setRecurrencePosition(2);
        Appointment checkAppointment = this.ctm.get(copy);
        Bug33242Test.assertNotNull((Object)checkAppointment);
        boolean found = false;
        for (UserParticipant up : checkAppointment.getUsers()) {
            if (up.getIdentifier() != this.client1.getValues().getUserId()) continue;
            found = true;
        }
        Bug33242Test.assertTrue((boolean)found);
    }

    @Test
    public void testDeleteByGroupMemberSingle() throws Exception {
        this.single.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        this.ctm2.delete(this.single);
    }

    @Test
    public void testDeleteByCreaterSingle() throws Exception {
        this.single.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.ctm.delete(this.single);
    }

    @Override
    public void tearDown() throws Exception {
        this.series.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.exception.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.single.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.ctm.cleanUp();
        this.ctm2.cleanUp();
        super.tearDown();
    }
}

