/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;

public class Bug13826Test
extends AbstractAJAXSession {
    private int userId;
    private int sourceFolderId;
    private int targetFolderId;
    private int currentFolder;
    private FolderObject folder;
    private Appointment appointment;
    private Appointment updateAppointment;
    private Date lastModified;

    public Bug13826Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userId = this.getClient().getValues().getUserId();
        this.sourceFolderId = this.getClient().getValues().getPrivateAppointmentFolder();
        OCLPermission ocl = Create.ocl(this.userId, false, true, 128, 128, 128, 128);
        this.folder = Create.folder(this.sourceFolderId, "Folder to test bug 13826" + System.currentTimeMillis(), 2, 1, ocl);
        CommonInsertResponse response = this.getClient().execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.targetFolderId = this.folder.getObjectID();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Test Bug 13826");
        this.appointment.setStartDate(new Date(TimeTools.getHour(0, this.getClient().getValues().getTimeZone())));
        this.appointment.setEndDate(new Date(TimeTools.getHour(1, this.getClient().getValues().getTimeZone())));
        this.appointment.setParticipants(ParticipantTools.createParticipants(this.userId));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(5);
        this.appointment.setIgnoreConflicts(true);
        InsertRequest request = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.getClient().execute(request);
        insertResponse.fillObject((DataObject)this.appointment);
        this.setCurrentValues(this.appointment);
        this.updateAppointment = new Appointment();
        this.updateAppointment.setObjectID(this.appointment.getObjectID());
        this.updateAppointment.setLastModified(this.appointment.getLastModified());
        this.updateAppointment.setParentFolderID(this.targetFolderId);
        this.updateAppointment.setRecurrenceType(1);
        this.updateAppointment.setInterval(1);
        this.updateAppointment.setOccurrence(5);
    }

    public void testBug13826() throws Exception {
        UpdateRequest update = new UpdateRequest(this.sourceFolderId, this.updateAppointment, this.getClient().getValues().getTimeZone(), false);
        UpdateResponse updateResponse = this.getClient().execute(update);
        if (!updateResponse.hasError()) {
            this.lastModified = updateResponse.getTimestamp();
            this.currentFolder = this.updateAppointment.getParentFolderID();
            Bug13826Test.fail((String)"Expected error.");
        } else {
            Bug13826Test.assertTrue((String)"Wrong error message", (boolean)updateResponse.getException().similarTo(OXCalendarExceptionCodes.RECURRING_FOLDER_MOVE.create()));
        }
        Appointment loadedAppointment = this.getClient().execute(new GetRequest(this.sourceFolderId, this.appointment.getObjectID(), true)).getAppointment(this.getClient().getValues().getTimeZone());
        this.setCurrentValues(loadedAppointment);
        GetResponse getResponse = this.getClient().execute(new GetRequest(this.targetFolderId, this.appointment.getObjectID(), false));
        if (!getResponse.hasError()) {
            loadedAppointment = getResponse.getAppointment(this.getClient().getValues().getTimeZone());
            Bug13826Test.fail((String)"Expected error.");
        }
        this.setCurrentValues(loadedAppointment);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.appointment != null && this.lastModified != null) {
            this.appointment.setLastModified(this.lastModified);
            this.getClient().execute(new com.openexchange.ajax.appointment.action.DeleteRequest(this.appointment.getObjectID(), this.currentFolder, this.lastModified));
        }
        this.getClient().execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.folder.getObjectID(), this.folder.getLastModified()));
        super.tearDown();
    }

    private void setCurrentValues(Appointment appointment) {
        if (appointment != null && appointment.getParentFolderID() != 0) {
            this.currentFolder = appointment.getParentFolderID();
        }
        if (appointment != null && appointment.getLastModified() != null) {
            this.lastModified = appointment.getLastModified();
        }
    }
}

