/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.webdav.digest;

import com.openexchange.config.ConfigurationService;
import com.openexchange.crypto.CryptoService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserAttributeAccess;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.util.UUIDs;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.webdav.digest.Authorization;
import com.openexchange.webdav.WebdavExceptionCode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class DigestUtility {
    private static final DigestUtility instance = new DigestUtility();
    private final String nonceKey = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
    private final MessageDigest md5Digest;
    private static final Pattern PATTERN_DIGEST_LIST;

    public static DigestUtility getInstance() {
        return instance;
    }

    private DigestUtility() {
        try {
            this.md5Digest = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No MD5 algorithm found", e);
        }
    }

    public String generateServerDigest(HttpServletRequest req, String password) {
        return this.generateServerDigest(req.getHeader("Authorization"), req.getMethod(), password);
    }

    private String generateServerDigest(String auth, String method, String password) {
        if (auth == null || !auth.startsWith("Digest ") || method == null || password == null) {
            return null;
        }
        Authorization localAuthorization = this.parseDigestAuthorization(auth);
        if (localAuthorization == null) {
            return null;
        }
        StringBuilder tmp = new StringBuilder(128);
        String firstDigest = this.digest2HexString(this.md5Digest.digest(tmp.append(localAuthorization.user).append(':').append(localAuthorization.realm).append(':').append(password).toString().getBytes()));
        tmp.setLength(0);
        String secondDigest = this.digest2HexString(this.md5Digest.digest(tmp.append(method).append(':').append(localAuthorization.uri).toString().getBytes()));
        tmp.setLength(0);
        if ("auth".equals(localAuthorization.qop)) {
            tmp.append(firstDigest).append(':').append(localAuthorization.nOnce).append(':').append(localAuthorization.nc).append(':').append(localAuthorization.cnonce).append(':').append(localAuthorization.qop).append(':').append(secondDigest);
        } else {
            tmp.append(firstDigest).append(':').append(localAuthorization.nOnce).append(':').append(secondDigest);
        }
        return this.digest2HexString(this.md5Digest.digest(tmp.toString().getBytes()));
    }

    public String digest2HexString(byte[] digest) {
        StringBuilder digestString = new StringBuilder(32);
        for (byte b : digest) {
            digestString.append(Integer.toHexString((b & 0xF0) >> 4));
            digestString.append(Integer.toHexString(b & 0xF));
        }
        return digestString.toString();
    }

    public String generateNOnce(HttpServletRequest req) {
        long currentTime = System.currentTimeMillis();
        byte[] buffer = this.md5Digest.digest((req.getRemoteAddr() + ':' + currentTime + ':' + this.nonceKey).getBytes());
        return this.digest2HexString(buffer);
    }

    private static Map<String, String> auth2map(String auth) {
        Matcher m = PATTERN_DIGEST_LIST.matcher(auth);
        if (!m.find()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        do {
            map.put(m.group(1).toLowerCase(Locale.ENGLISH), m.group(2));
        } while (m.find());
        return map;
    }

    public Authorization parseDigestAuthorization(String authorization) {
        if (null == authorization) {
            return null;
        }
        Map<String, String> map = DigestUtility.auth2map(authorization.startsWith("Digest ") ? authorization.substring(7).trim() : authorization.trim());
        Authorization ret = new Authorization();
        String tmp = map.get("username");
        if (null != tmp) {
            ret.user = tmp;
        }
        if (null != (tmp = map.get("realm"))) {
            ret.realm = tmp;
        }
        if (null != (tmp = map.get("nonce"))) {
            ret.nOnce = tmp;
        }
        if (null != (tmp = map.get("nc"))) {
            ret.nc = tmp;
        }
        if (null != (tmp = map.get("cnonce"))) {
            ret.cnonce = tmp;
        }
        if (null != (tmp = map.get("qop"))) {
            ret.qop = tmp;
        }
        if (null != (tmp = map.get("uri"))) {
            ret.uri = tmp;
        }
        if (null != (tmp = map.get("response"))) {
            ret.response = tmp;
        }
        if (null != (tmp = map.get("algorithm"))) {
            ret.algorithm = tmp;
        }
        return ret;
    }

    public String getPasswordByUserName(String userName) throws OXException {
        int userId;
        if (null == userName) {
            return null;
        }
        String[] splitted = this.split(userName);
        ContextStorage contextStorage = ContextStorage.getInstance();
        int ctxId = contextStorage.getContextId(splitted[0]);
        if (-1 == ctxId) {
            throw WebdavExceptionCode.RESOLVING_USER_NAME_FAILED.create(userName);
        }
        Context ctx = contextStorage.getContext(ctxId);
        UserStorage userStorage = UserStorage.getInstance();
        try {
            userId = userStorage.getUserId(splitted[1], ctx);
        }
        catch (OXException e) {
            throw WebdavExceptionCode.RESOLVING_USER_NAME_FAILED.create(userName);
        }
        User user = userStorage.getUser(userId, ctx);
        String passCrypt = UserAttributeAccess.getDefaultInstance().getAttribute("passcrypt", user, null);
        ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
        CryptoService cryptoService = serviceRegistry.getService(CryptoService.class, true);
        String key = serviceRegistry.getService(ConfigurationService.class).getProperty("com.openexchange.passcrypt.key");
        return cryptoService.decrypt(passCrypt, key);
    }

    private String[] split(String loginInfo) {
        return this.split(loginInfo, '@');
    }

    private String[] split(String loginInfo, char separator) {
        int pos = loginInfo.lastIndexOf(separator);
        String[] splitted = -1 == pos ? new String[]{"defaultcontext", loginInfo} : new String[]{loginInfo.substring(pos + 1), loginInfo.substring(0, pos)};
        return splitted;
    }

    static {
        String paramNameRegex = "([\\p{ASCII}&&[^=\"\\s;]]+)";
        String tokenRegex = "(?:[^\"][\\S&&[^\\s,;:\\\\\"/\\[\\]?()<>@]]*)";
        String quotedStringRegex = "(?:\"(?:(?:\\\\\\\")|[^\"])+?\")";
        PATTERN_DIGEST_LIST = Pattern.compile("(?:\\s*,\\s*|\\s+)([\\p{ASCII}&&[^=\"\\s;]]+)(?: *= *((?:[^\"][\\S&&[^\\s,;:\\\\\"/\\[\\]?()<>@]]*)|(?:\"(?:(?:\\\\\\\")|[^\"])+?\")))?");
    }
}

