/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.old.OldParamDefinition;
import com.openexchange.tools.versit.old.OldPropertyDefinition;
import com.openexchange.tools.versit.old.OldScanner;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class OldGeoPropertyDefinition
extends OldPropertyDefinition {
    private static Pattern FloatPattern = Pattern.compile("[ \t\r\n]*[-+]?\\d+([\\.,]\\d+)?[ \t\r\n]*");
    private static final DecimalFormat Format = new DecimalFormat("0.################");

    public OldGeoPropertyDefinition(String[] paramNames, OldParamDefinition[] params) {
        super(paramNames, params);
    }

    @Override
    protected Object parseValue(Property property, OldScanner s, byte[] value, String charset) throws IOException {
        StringScanner ss = new StringScanner(s, new String(value, charset));
        ArrayList<Double> geo = new ArrayList<Double>();
        String str = ss.regex(FloatPattern);
        if (str == null) {
            throw new VersitException(s, "Latitude expected");
        }
        str = str.replace(",", ".");
        geo.add(Double.valueOf(str.trim()));
        if (ss.peek != 44 && ss.peek != 59) {
            throw new IOException("Geographic position expected");
        }
        ss.read();
        str = ss.regex(FloatPattern);
        if (str == null) {
            throw new VersitException(s, "Latitude expected");
        }
        str = str.replace(",", ".");
        geo.add(Double.valueOf(str.trim()));
        return geo;
    }

    @Override
    protected String writeValue(Property property) {
        ArrayList geo = (ArrayList)property.getValue();
        return Format.format((Double)geo.get(0)) + ';' + Format.format((Double)geo.get(1));
    }
}

