/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.converter;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.contact.internal.mapping.ContactMapper;
import com.openexchange.contact.internal.mapping.ContactMapping;
import com.openexchange.contact.internal.mapping.StringMapping;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.contact.ContactConfig;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.ImageTypeDetector;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.encoding.Base64;
import com.openexchange.tools.images.ImageTransformationService;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.images.TransformedImage;
import com.openexchange.tools.io.IOUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.ParameterValue;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.ConverterException;
import com.openexchange.tools.versit.converter.ConverterPrivacyException;
import com.openexchange.tools.versit.values.DateTimeValue;
import com.openexchange.tools.versit.values.DurationValue;
import com.openexchange.tools.versit.values.RecurrenceValue;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.FileTypeMap;
import javax.imageio.ImageIO;
import javax.mail.internet.AddressException;
import javax.mail.internet.idn.IDNA;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OXContainerConverter {
    private static final String P_OPEN_XCHANGE_CTYPE = "X-OPEN-XCHANGE-CTYPE";
    private static final String P_ORGANIZER = "ORGANIZER";
    private static final String P_TLX = "TLX";
    private static final String P_EMAIL = "EMAIL";
    private static final String PARAM_VOICE = "voice";
    private static final String P_TEL = "TEL";
    private static final String PARAM_WORK = "work";
    private static final String PARAM_HOME = "home";
    private static final String PARAM_OTHER = "dom";
    private static final String P_TYPE = "TYPE";
    private static final String P_DESCRIPTION = "DESCRIPTION";
    private static final String P_RRULE = "RRULE";
    private static final String P_CATEGORIES = "CATEGORIES";
    private static final String P_ATTENDEE = "ATTENDEE";
    private static final String P_DTSTART = "DTSTART";
    private static final String P_SUMMARY = "SUMMARY";
    private static final String P_COMPLETED = "COMPLETED";
    private static final String P_CLASS = "CLASS";
    private static final Logger LOG;
    private static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    private static final String CTYPE_CONTACT = "contact";
    private static final String CTYPE_DISTRIBUTION_LIST = "dlist";
    private static final String atdomain;
    private final Context ctx;
    private final TimeZone timezone;
    private final String organizerMailAddress;
    private final Session optSession;
    private boolean sendUTC = true;
    private boolean sendFloating;
    private boolean addDisplayName4DList;
    private boolean skipOxCTypeAttribute;
    private static final BitSet PRINTABLE_CHARS;

    public OXContainerConverter(TimeZone timezone, String organizerMailAddress) {
        this.timezone = timezone;
        this.organizerMailAddress = organizerMailAddress;
        this.ctx = null;
        this.optSession = null;
    }

    public OXContainerConverter(Session session) throws ConverterException, OXException {
        if (session instanceof ServerSession) {
            this.ctx = ((ServerSession)session).getContext();
        } else {
            try {
                this.ctx = ContextStorage.getStorageContext(session.getContextId());
            }
            catch (OXException e) {
                throw new ConverterException(e);
            }
        }
        this.timezone = TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(session.getUserId(), this.ctx).getTimeZone());
        this.organizerMailAddress = null;
        this.optSession = session;
    }

    public OXContainerConverter(Session session, Context ctx) throws OXException {
        this.ctx = ctx;
        this.timezone = TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(session.getUserId(), ctx).getTimeZone());
        this.organizerMailAddress = null;
        this.optSession = session;
    }

    public OXContainerConverter(Context ctx, TimeZone tz) {
        this.ctx = ctx;
        this.timezone = tz;
        this.organizerMailAddress = null;
        this.optSession = null;
    }

    public void close() {
        LOG.trace("OXContainerConverter.close()");
    }

    public boolean isSendFloating() {
        return this.sendFloating;
    }

    public void setSendFloating(boolean sendFloating) {
        this.sendFloating = sendFloating;
    }

    public boolean isAddDisplayName4DList() {
        return this.addDisplayName4DList;
    }

    public void setAddDisplayName4DList(boolean addDisplayName4DList) {
        this.addDisplayName4DList = addDisplayName4DList;
    }

    public boolean isSkipOxCTypeAttribute() {
        return this.skipOxCTypeAttribute;
    }

    public void setSkipOxCTypeAttribute(boolean skipOxCTypeAttribute) {
        this.skipOxCTypeAttribute = skipOxCTypeAttribute;
    }

    public boolean isSendUTC() {
        return this.sendUTC;
    }

    public void setSendUTC(boolean sendUTC) {
        this.sendUTC = sendUTC;
    }

    public Task convertTask(VersitObject object) throws ConverterException {
        if (null == object) {
            return null;
        }
        try {
            Task taskContainer = new Task();
            OXContainerConverter.PrivacyProperty(taskContainer, object, P_CLASS, 101);
            this.DateTimeProperty(taskContainer, object, P_COMPLETED, 315);
            OXContainerConverter.IntegerProperty(taskContainer, object, "PERCENT-COMPLETE", 301);
            Property property = object.getProperty("PRIORITY");
            if (property != null) {
                int priority = (Integer)property.getValue();
                int[] priorities = new int[]{3, 3, 3, 3, 2, 1, 1, 1, 1};
                if (priority >= 1 && priority <= 9) {
                    taskContainer.setPriority(priorities[priority - 1]);
                } else if (priority != 0) {
                    throw new ConverterException("Invalid priority");
                }
            }
            if ((property = object.getProperty("STATUS")) != null) {
                String status = ((String)property.getValue()).toUpperCase();
                if ("NEEDS-ACTION".equals(status)) {
                    taskContainer.setStatus(1);
                } else if ("IN-PROCESS".equals(status)) {
                    taskContainer.setStatus(2);
                } else if (P_COMPLETED.equals(status)) {
                    taskContainer.setStatus(3);
                } else if ("CANCELLED".equals(status)) {
                    taskContainer.setStatus(5);
                } else {
                    throw new ConverterException("Unknown status: \"" + status + "\"");
                }
            }
            OXContainerConverter.StringProperty(taskContainer, object, P_SUMMARY, 200);
            if (!this.DateTimeProperty(taskContainer, object, "DUE", 202)) {
                OXContainerConverter.DurationProperty(taskContainer, object, "DURATION", P_DTSTART, 202);
            }
            int count = object.getPropertyCount();
            StringBuilder cats = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                property = object.getProperty(i);
                if (P_ATTENDEE.equals(property.name)) {
                    this.AttendeeProperty(taskContainer, property);
                    continue;
                }
                if (P_CATEGORIES.equals(property.name)) {
                    ArrayList al = (ArrayList)property.getValue();
                    int size = al.size();
                    Iterator j = al.iterator();
                    for (int k = 0; k < size; ++k) {
                        cats.append(j.next());
                        cats.append(',');
                    }
                    continue;
                }
                if (!P_RRULE.equals(property.name)) continue;
                OXContainerConverter.RecurrenceProperty(taskContainer, property, object.getProperty(P_DTSTART));
            }
            if (cats.length() != 0) {
                cats.deleteCharAt(cats.length() - 1);
                taskContainer.setCategories(cats.toString());
            }
            OXContainerConverter.StringProperty(taskContainer, object, P_DESCRIPTION, 203);
            OXContainerConverter.AddAlarms(taskContainer, object);
            return taskContainer;
        }
        catch (Exception e) {
            LOG.error(e.toString());
            throw new ConverterException(e);
        }
    }

    public CalendarDataObject convertAppointment(VersitObject object) throws ConverterException {
        if (null == object) {
            return null;
        }
        CalendarDataObject appContainer = new CalendarDataObject();
        OXContainerConverter.PrivacyProperty(appContainer, object, P_CLASS, 101);
        OXContainerConverter.StringProperty(appContainer, object, P_DESCRIPTION, 203);
        Property property = object.getProperty(P_DTSTART);
        if (property != null) {
            DateTimeValue date = (DateTimeValue)property.getValue();
            if (date.isFloating) {
                date.calendar.setTimeZone(this.timezone);
            }
            date.calendar.set(13, 0);
            date.calendar.set(14, 0);
            appContainer.setStartDate(date.calendar.getTime());
            appContainer.setFullTime(!date.hasTime);
        }
        OXContainerConverter.StringProperty(appContainer, object, "LOCATION", 400);
        OXContainerConverter.StringProperty(appContainer, object, P_SUMMARY, 200);
        property = object.getProperty("TRANSP");
        if (property != null) {
            String transp = ((String)property.getValue()).toUpperCase();
            if ("OPAQUE".equals(transp)) {
                appContainer.setShownAs(1);
            } else if ("TRANSPARENT".equals(transp)) {
                appContainer.setShownAs(4);
            } else {
                throw new ConverterException("Invalid transparency");
            }
        }
        if (!this.DateTimeProperty(appContainer, object, "DTEND", 202) && !OXContainerConverter.DurationProperty(appContainer, object, "DURATION", P_DTSTART, 202)) {
            this.DateTimeProperty(appContainer, object, "DSTART", 202);
        }
        StringBuilder cats = new StringBuilder();
        ArrayList exdates = new ArrayList();
        int count = object.getPropertyCount();
        for (int i = 0; i < count; ++i) {
            int k;
            Iterator j;
            int size;
            ArrayList al;
            property = object.getProperty(i);
            if (P_ATTENDEE.equals(property.name)) {
                this.AttendeeProperty(appContainer, property);
                continue;
            }
            if (P_CATEGORIES.equals(property.name)) {
                al = (ArrayList)property.getValue();
                size = al.size();
                j = al.iterator();
                for (k = 0; k < size; ++k) {
                    cats.append(j.next());
                    cats.append(',');
                }
                continue;
            }
            if ("EXDATE".equals(property.name)) {
                exdates.addAll((ArrayList)property.getValue());
                continue;
            }
            if ("RESOURCES".equals(property.name)) {
                al = (ArrayList)property.getValue();
                size = al.size();
                j = al.iterator();
                for (k = 0; k < size; ++k) {
                    ResourceParticipant p = new ResourceParticipant();
                    p.setDisplayName((String)j.next());
                    appContainer.addParticipant(p);
                }
                continue;
            }
            if (!P_RRULE.equals(property.name)) continue;
            OXContainerConverter.RecurrenceProperty(appContainer, property, object.getProperty(P_DTSTART));
        }
        if (cats.length() != 0) {
            cats.deleteCharAt(cats.length() - 1);
            appContainer.setCategories(cats.toString());
        }
        if (!exdates.isEmpty()) {
            Date[] dates = new Date[exdates.size()];
            for (int i = 0; i < dates.length; ++i) {
                dates[i] = ((DateTimeValue)exdates.get((int)i)).calendar.getTime();
            }
            appContainer.setDeleteExceptions(dates);
        }
        OXContainerConverter.AddAlarms(appContainer, object);
        return appContainer;
    }

    public Contact convertContact(VersitObject object) throws ConverterException {
        if (null == object) {
            return null;
        }
        Contact contactContainer = new Contact();
        OXContainerConverter.StringProperty(contactContainer, object, "X-PHONETIC-FIRST-NAME", 616);
        OXContainerConverter.StringProperty(contactContainer, object, "X-PHONETIC-LAST-NAME", 617);
        OXContainerConverter.StringProperty(contactContainer, object, "FN", 500);
        Property property = object.getProperty("N");
        if (property != null) {
            ArrayList N = (ArrayList)property.getValue();
            this.fillArrayUpTo(N, 5);
            OXContainerConverter.ListValue(contactContainer, 502, N.get(0), " ");
            OXContainerConverter.ListValue(contactContainer, 501, N.get(1), " ");
            OXContainerConverter.ListValue(contactContainer, 503, N.get(2), " ");
            OXContainerConverter.ListValue(contactContainer, 505, N.get(3), " ");
            OXContainerConverter.ListValue(contactContainer, 504, N.get(4), " ");
        }
        OXContainerConverter.StringFromListProperty(contactContainer, object, "NICKNAME", 515);
        property = object.getProperty("PHOTO");
        if (property != null) {
            Parameter uriParam = property.getParameter("URI");
            if (uriParam == null) {
                Parameter type;
                String value;
                Object propertyValue = property.getValue();
                if (propertyValue instanceof byte[]) {
                    byte[] imageData = (byte[])propertyValue;
                    Rectangle clipRect = OXContainerConverter.extractClipRect(property.getParameter("X-ABCROP-RECTANGLE"));
                    if (null != clipRect) {
                        String type2;
                        String formatName = "JPEG";
                        Parameter typeParameter = property.getParameter(P_TYPE);
                        if (null != typeParameter && 1 == typeParameter.getValueCount() && null != (type2 = typeParameter.getValue(0).getText()) && 0 < type2.length()) {
                            formatName = type2;
                        }
                        try {
                            imageData = this.doABCrop(imageData, clipRect, formatName);
                        }
                        catch (IOException e) {
                            LOG.error("error cropping image, falling back to uncropped image.", (Throwable)e);
                        }
                        catch (OXException e) {
                            LOG.error("error cropping image, falling back to uncropped image.", (Throwable)e);
                        }
                    }
                    contactContainer.setImage1(imageData);
                    value = null;
                } else if (propertyValue instanceof URI) {
                    OXContainerConverter.loadImageFromURL(contactContainer, propertyValue.toString());
                    value = null;
                } else {
                    value = propertyValue.toString();
                    if (value != null) {
                        try {
                            URL url = new URL(value);
                            OXContainerConverter.loadImageFromURL(contactContainer, url);
                            value = null;
                        }
                        catch (MalformedURLException e) {
                            LOG.trace("", (Throwable)e);
                        }
                    }
                }
                if (value != null) {
                    try {
                        contactContainer.setImage1(value.getBytes(CHARSET_ISO_8859_1));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error("Image could not be set", (Throwable)e);
                    }
                }
                if ((type = property.getParameter(P_TYPE)) != null && type.getValueCount() == 1) {
                    String stype = type.getValue(0).getText().toLowerCase();
                    if (!stype.startsWith("image/")) {
                        stype = "image/" + stype;
                    }
                    contactContainer.setImageContentType(stype);
                } else if (propertyValue instanceof byte[]) {
                    contactContainer.setImageContentType(ImageTypeDetector.getMimeType((byte[])propertyValue));
                }
            } else if (uriParam.getValueCount() == 1) {
                OXContainerConverter.loadImageFromURL(contactContainer, uriParam.getValue(0).getText());
            }
        }
        this.DateTimeProperty(contactContainer, object, "BDAY", 511);
        OXContainerConverter.StringProperty(contactContainer, object, "TITLE", 514);
        OXContainerConverter.StringProperty(contactContainer, object, "ROLE", 520);
        property = object.getProperty("ORG");
        if (property != null) {
            ArrayList elements = (ArrayList)property.getValue();
            if (elements.size() < 1) {
                throw new ConverterException("Invalid property ORG");
            }
            contactContainer.setCompany((String)elements.get(0));
            int last = elements.size() - 1;
            if (last > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append(elements.get(1));
                for (int i = 2; i < last; ++i) {
                    sb.append(',');
                    sb.append(elements.get(i));
                }
                contactContainer.setBranches(sb.toString());
            }
            if (elements.size() >= 2) {
                contactContainer.setDepartment((String)elements.get(last));
            }
        }
        OXContainerConverter.StringProperty(contactContainer, object, "NOTE", 518);
        OXContainerConverter.StringProperty(contactContainer, object, "URL", 558);
        OXContainerConverter.StringProperty(contactContainer, object, "UID", 223);
        ArrayList<String> cats = new ArrayList<String>();
        boolean dlist = false;
        Property oxCtype = object.getProperty(P_OPEN_XCHANGE_CTYPE);
        if (oxCtype != null && CTYPE_DISTRIBUTION_LIST.equalsIgnoreCase(oxCtype.getValue().toString())) {
            dlist = true;
            contactContainer.setMarkAsDistributionlist(true);
        }
        int count = object.getPropertyCount();
        block14: for (int i = 0; i < count; ++i) {
            Object value;
            property = object.getProperty(i);
            if ("ADR".equals(property.name)) {
                boolean isHome = false;
                boolean isWork = false;
                boolean isOther = true;
                Parameter type = property.getParameter(P_TYPE);
                if (type != null) {
                    isOther = false;
                    for (int j = 0; j < type.getValueCount(); ++j) {
                        String value2 = type.getValue(j).getText();
                        isHome |= PARAM_HOME.equalsIgnoreCase(value2);
                        isWork |= PARAM_WORK.equalsIgnoreCase(value2);
                        isOther |= PARAM_OTHER.equalsIgnoreCase(value2);
                    }
                }
                ArrayList A = (ArrayList)property.getValue();
                this.fillArrayUpTo(A, 7);
                if (A == null) {
                    throw new ConverterException("Invalid property ADR");
                }
                if (isWork) {
                    OXContainerConverter.ListValue(contactContainer, 523, A.get(2), "\n");
                    OXContainerConverter.ListValue(contactContainer, 526, A.get(3), "\n");
                    OXContainerConverter.ListValue(contactContainer, 527, A.get(4), "\n");
                    OXContainerConverter.ListValue(contactContainer, 525, A.get(5), "\n");
                    OXContainerConverter.ListValue(contactContainer, 528, A.get(6), "\n");
                }
                if (isHome) {
                    OXContainerConverter.ListValue(contactContainer, 506, A.get(2), "\n");
                    OXContainerConverter.ListValue(contactContainer, 508, A.get(3), "\n");
                    OXContainerConverter.ListValue(contactContainer, 509, A.get(4), "\n");
                    OXContainerConverter.ListValue(contactContainer, 507, A.get(5), "\n");
                    OXContainerConverter.ListValue(contactContainer, 510, A.get(6), "\n");
                }
                if (!isOther) continue;
                OXContainerConverter.ListValue(contactContainer, 538, A.get(2), "\n");
                OXContainerConverter.ListValue(contactContainer, 539, A.get(3), "\n");
                OXContainerConverter.ListValue(contactContainer, 598, A.get(4), "\n");
                OXContainerConverter.ListValue(contactContainer, 540, A.get(5), "\n");
                OXContainerConverter.ListValue(contactContainer, 541, A.get(6), "\n");
                continue;
            }
            if ("IMPP".equals(property.name)) {
                value = property.getValue().toString();
                if (null != value) {
                    try {
                        value = URLDecoder.decode((String)value, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.debug("Error decoding IMPP value", (Throwable)e);
                    }
                }
                Parameter type = property.getParameter(P_TYPE);
                boolean set = false;
                if (null != type) {
                    for (int j = 0; j < type.getValueCount() && !set; ++j) {
                        String typeValue = type.getValue(j).getText();
                        if (PARAM_HOME.equalsIgnoreCase(typeValue)) {
                            contactContainer.setInstantMessenger2((String)value);
                            set = true;
                            continue;
                        }
                        if (!PARAM_WORK.equalsIgnoreCase(typeValue)) continue;
                        contactContainer.setInstantMessenger1((String)value);
                        set = true;
                    }
                }
                if (set) continue;
                if (!contactContainer.containsInstantMessenger2()) {
                    contactContainer.setInstantMessenger2((String)value);
                    continue;
                }
                if (contactContainer.containsInstantMessenger1()) continue;
                contactContainer.setInstantMessenger1((String)value);
                continue;
            }
            if (P_EMAIL.equals(property.name)) {
                ParameterValue parameterValue;
                Parameter type;
                boolean isProperEmailAddress;
                value = property.getValue().toString();
                String personal = null;
                boolean bl = isProperEmailAddress = value != null && ((String)value).length() > 0;
                if (isProperEmailAddress) {
                    try {
                        QuotedInternetAddress address = new QuotedInternetAddress((String)value);
                        address.validate();
                        value = address.getIDNAddress();
                        personal = address.getPersonal();
                    }
                    catch (AddressException e) {
                        isProperEmailAddress = false;
                    }
                }
                if (isProperEmailAddress) {
                    if (dlist) {
                        try {
                            DistributionListEntryObject[] distributionList = contactContainer.getDistributionList();
                            if (null == distributionList) {
                                distributionList = new DistributionListEntryObject[1];
                            } else {
                                DistributionListEntryObject[] newDistributionList = new DistributionListEntryObject[distributionList.length + 1];
                                System.arraycopy(distributionList, 0, newDistributionList, 0, distributionList.length);
                                distributionList = newDistributionList;
                            }
                            DistributionListEntryObject newEntry = new DistributionListEntryObject();
                            if (this.addDisplayName4DList) {
                                Parameter displayNameParameter = property.getParameter("FN");
                                if (null != displayNameParameter) {
                                    newEntry.setDisplayname(OXContainerConverter.decodeQP(displayNameParameter.getValue(0).getText()));
                                }
                            } else {
                                newEntry.setDisplayname((String)(null == personal ? value : personal));
                            }
                            newEntry.setEmailaddress((String)value);
                            distributionList[distributionList.length - 1] = newEntry;
                            contactContainer.setDistributionList(distributionList);
                            continue;
                        }
                        catch (OXException e) {
                            throw new ConverterException(e);
                        }
                    }
                    type = property.getParameter(P_TYPE);
                    int set = 0;
                    if (null != type) {
                        for (int j = 0; j < type.getValueCount() && 0 == set; ++j) {
                            String typeValue = type.getValue(j).getText();
                            if (PARAM_HOME.equalsIgnoreCase(typeValue)) {
                                if (contactContainer.containsEmail2()) {
                                    if (!contactContainer.containsEmail1()) {
                                        contactContainer.setEmail1(contactContainer.getEmail2());
                                    } else if (!contactContainer.containsEmail3()) {
                                        contactContainer.setEmail3(contactContainer.getEmail2());
                                    } else {
                                        LOG.debug("Can only save one 'home' email address, going to overwrite existing value.");
                                    }
                                }
                                contactContainer.setEmail2((String)value);
                                set = 2;
                                continue;
                            }
                            if (PARAM_WORK.equalsIgnoreCase(typeValue)) {
                                if (contactContainer.containsEmail1()) {
                                    if (!contactContainer.containsEmail2()) {
                                        contactContainer.setEmail2(contactContainer.getEmail1());
                                    } else if (!contactContainer.containsEmail3()) {
                                        contactContainer.setEmail3(contactContainer.getEmail1());
                                    } else {
                                        LOG.debug("Can only save one 'work' email address, going to overwrite existing value.");
                                    }
                                }
                                contactContainer.setEmail1((String)value);
                                set = 1;
                                continue;
                            }
                            if (!"other".equalsIgnoreCase(typeValue)) continue;
                            if (contactContainer.containsEmail3()) {
                                if (!contactContainer.containsEmail1()) {
                                    contactContainer.setEmail1(contactContainer.getEmail3());
                                } else if (!contactContainer.containsEmail2()) {
                                    contactContainer.setEmail2(contactContainer.getEmail3());
                                } else {
                                    LOG.debug("Can only save one 'other' email address, going to overwrite existing value.");
                                }
                            }
                            contactContainer.setEmail3((String)value);
                            set = 3;
                        }
                    }
                    if (0 == set) {
                        if (!contactContainer.containsEmail1()) {
                            contactContainer.setEmail1((String)value);
                            set = 1;
                        } else if (!contactContainer.containsEmail2()) {
                            contactContainer.setEmail2((String)value);
                            set = 2;
                        } else if (!contactContainer.containsEmail3()) {
                            contactContainer.setEmail3((String)value);
                            set = 3;
                        }
                    }
                    if (false >= set || null == type) continue;
                    for (int j = 0; j < type.getValueCount(); ++j) {
                        if (!"pref".equalsIgnoreCase(type.getValue(j).getText())) continue;
                        contactContainer.setDefaultAddress(set);
                        continue block14;
                    }
                    continue;
                }
                type = property.getParameter(P_TYPE);
                if (type == null || (parameterValue = type.getValue(0)) == null || parameterValue.getText() == null || !P_TLX.equals(parameterValue.getText())) continue;
                contactContainer.setTelephoneTelex(property.getValue().toString());
                continue;
            }
            if (P_CATEGORIES.equals(property.name)) {
                value = property.getValue();
                if (value == null) continue;
                if (value instanceof ArrayList) {
                    cats.addAll((ArrayList)value);
                    continue;
                }
                if (value instanceof String) {
                    cats.addAll(Arrays.asList(value.toString().split(" *, *")));
                    continue;
                }
                LOG.error("Unexpected class: {}", (Object)value.getClass().getName());
                continue;
            }
            if (!P_CLASS.equals(property.name) || !"CONFIDENTIAL".equalsIgnoreCase(property.getValue().toString()) && !"PRIVATE".equalsIgnoreCase(property.getValue().toString())) continue;
            contactContainer.setPrivateFlag(true);
        }
        OXContainerConverter.ListValue(contactContainer, 100, cats, ",");
        OXContainerConverter.applyTelephoneNumbers(contactContainer, object);
        return contactContainer;
    }

    private void fillArrayUpTo(ArrayList<?> a, int limit) {
        if (a == null) {
            a = new ArrayList();
        }
        for (int i = a.size(); i < limit; ++i) {
            a.add(null);
        }
    }

    private static Rectangle extractClipRect(Parameter cropParameter) {
        if (null != cropParameter && 0 < cropParameter.getValueCount()) {
            Pattern clipRectPattern = Pattern.compile("ABClipRect_1&([-+]?\\d+?)&([-+]?\\d+?)&([-+]?\\d+?)&([-+]?\\d+?)&");
            for (int i = 0; i < cropParameter.getValueCount(); ++i) {
                String text = cropParameter.getValue(i).getText();
                Matcher matcher = clipRectPattern.matcher(text);
                if (!matcher.find()) continue;
                try {
                    int offsetLeft = Integer.parseInt(matcher.group(1));
                    int offsetBottom = Integer.parseInt(matcher.group(2));
                    int targetWidth = Integer.parseInt(matcher.group(3));
                    int targetHeight = Integer.parseInt(matcher.group(4));
                    return new Rectangle(offsetLeft, offsetBottom, targetWidth, targetHeight);
                }
                catch (NumberFormatException e) {
                    LOG.warn("unable to parse clipping rectangle from {}", (Object)text, (Object)e);
                }
            }
        }
        return null;
    }

    private static Parameter getABCropRectangle(TransformedImage transformedImage) {
        Parameter parameter = new Parameter("X-ABCROP-RECTANGLE");
        StringBuilder StringBuilder2 = new StringBuilder(64);
        StringBuilder2.append("ABClipRect_1&");
        int width = transformedImage.getWidth();
        int height = transformedImage.getHeight();
        if (width < height) {
            StringBuilder2.append('-').append((height - width) / 2).append("&0&").append(height).append('&').append(height);
        } else if (width > height) {
            StringBuilder2.append("0&-").append((width - height) / 2).append('&').append(width).append('&').append(width);
        } else {
            StringBuilder2.append("0&0&").append(width).append('&').append(height);
        }
        if (null != transformedImage.getMD5()) {
            StringBuilder2.append('&').append(Base64.encode(transformedImage.getMD5()));
        }
        parameter.addValue(new ParameterValue(StringBuilder2.toString()));
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doABCrop(byte[] imageBytes, Rectangle clipRect, String formatName) throws IOException, OXException {
        byte[] byArray;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(imageBytes);
            BufferedImage sourceImage = ImageIO.read(inputStream);
            ImageTransformationService imageService = ServerServiceRegistry.getInstance().getService(ImageTransformationService.class, true);
            String source = null == this.optSession ? null : this.optSession.getSessionID();
            byArray = imageService.transfom(sourceImage, (Object)source).crop(clipRect.x * -1, clipRect.height + clipRect.y - sourceImage.getHeight(), clipRect.width, clipRect.height).getBytes(formatName);
        }
        catch (Throwable throwable) {
            Streams.close(inputStream);
            throw throwable;
        }
        Streams.close((Closeable)inputStream);
        return byArray;
    }

    private TransformedImage scaleImageIfNeeded(byte[] imageBytes, int maxWidth, int maxHeight, String formatName) throws IOException, OXException {
        String source;
        ImageTransformationService imageService = ServerServiceRegistry.getInstance().getService(ImageTransformationService.class, true);
        String string = source = null == this.optSession ? null : this.optSession.getSessionID();
        if (0 < maxWidth || 0 < maxHeight) {
            try {
                return imageService.transfom(imageBytes, (Object)source).scale(maxWidth, maxHeight, ScaleType.CONTAIN).getTransformedImage(formatName);
            }
            catch (IllegalArgumentException e) {
                throw AjaxExceptionCodes.BAD_REQUEST_CUSTOM.create(e, e.getMessage());
            }
        }
        return imageService.transfom(imageBytes, (Object)source).getTransformedImage(formatName);
    }

    private TransformedImage scaleImageIfNeeded(byte[] source, String formatName) throws IOException, OXException {
        if (null != source) {
            int maxWidth = -1;
            int maxHeight = -1;
            ConfigurationService configService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class, true);
            String value = configService.getProperty("com.openexchange.contact.scaleVCardImages", "");
            if (null != value && 0 < value.length()) {
                int idx = value.indexOf(120);
                if (1 > idx) {
                    throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create(value);
                }
                try {
                    maxWidth = Integer.parseInt(value.substring(0, idx));
                    maxHeight = Integer.parseInt(value.substring(idx + 1));
                }
                catch (NumberFormatException e) {
                    throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create(e, value);
                }
            }
            return this.scaleImageIfNeeded(source, maxWidth, maxHeight, formatName);
        }
        return null;
    }

    public static void loadImageFromURL(Contact contact, String url) throws ConverterException {
        try {
            OXContainerConverter.loadImageFromURL(contact, new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ConverterException("Image URL is not wellformed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadImageFromURL(Contact contact, URL url) throws ConverterException {
        String mimeType = null;
        byte[] bytes = null;
        try {
            URLConnection urlCon = url.openConnection();
            urlCon.setConnectTimeout(2500);
            urlCon.setReadTimeout(2500);
            urlCon.connect();
            mimeType = urlCon.getContentType();
            InputStream in = urlCon.getInputStream();
            try {
                UnsynchronizedByteArrayOutputStream buffer = new UnsynchronizedByteArrayOutputStream(in.available());
                IOUtils.transfer(in, (OutputStream)buffer);
                bytes = buffer.toByteArray();
                long maxSize = ContactConfig.getInstance().getMaxImageSize();
                if (maxSize > 0L && (long)bytes.length > maxSize) {
                    ConverterException e = new ConverterException("Contact image is " + bytes.length + " bytes large and limit is " + maxSize + " bytes. Image is therefore ignored.");
                    LOG.warn("", (Throwable)e);
                    bytes = null;
                }
            }
            finally {
                IOUtils.closeStreamStuff(in);
            }
        }
        catch (SocketTimeoutException e) {
            throw new ConverterException("Timeout reading \"" + url.toString() + "\"", e);
        }
        catch (IOException e) {
            throw new ConverterException("IO problem while reading \"" + url.toString() + "\"", e);
        }
        if (mimeType == null && "application/octet-stream".equals(mimeType = ImageTypeDetector.getMimeType(bytes))) {
            mimeType = OXContainerConverter.getMimeType(url.toString());
        }
        if (bytes != null && OXContainerConverter.isValidImage(bytes)) {
            contact.setImage1(bytes);
            contact.setImageContentType(mimeType);
        }
    }

    private static void applyTelephoneNumbers(Contact target, VersitObject source) {
        List<Property> properties = source.getProperties(P_TEL);
        if (null == properties) {
            return;
        }
        for (Property property : properties) {
            Parameter typeParameter = property.getParameter(P_TYPE);
            boolean preferred = OXContainerConverter.containsValue("pref", typeParameter);
            String value = String.valueOf(property.getValue());
            if (OXContainerConverter.containsValue("pager", typeParameter) && OXContainerConverter.setProperty(target, value, preferred, ContactField.TELEPHONE_PAGER, ContactField.TELEPHONE_OTHER) || OXContainerConverter.containsValue("textphone", typeParameter) && OXContainerConverter.setProperty(target, value, preferred, ContactField.TELEPHONE_TTYTDD, ContactField.TELEPHONE_OTHER) || OXContainerConverter.containsValue("car", typeParameter) && OXContainerConverter.setProperty(target, value, preferred, ContactField.TELEPHONE_CAR, ContactField.TELEPHONE_OTHER) || OXContainerConverter.containsValue("isdn", typeParameter) && OXContainerConverter.setProperty(target, value, preferred, ContactField.TELEPHONE_ISDN, ContactField.TELEPHONE_OTHER) || OXContainerConverter.containsValue("cell", typeParameter) && OXContainerConverter.setProperty(target, value, preferred, ContactField.CELLULAR_TELEPHONE1, ContactField.CELLULAR_TELEPHONE2, ContactField.TELEPHONE_OTHER)) continue;
            boolean home = OXContainerConverter.containsValue(PARAM_HOME, typeParameter);
            boolean business = OXContainerConverter.containsValue(PARAM_WORK, typeParameter);
            boolean other = OXContainerConverter.containsValue(PARAM_OTHER, typeParameter);
            if (!(OXContainerConverter.containsValue(PARAM_VOICE, typeParameter) && (business && OXContainerConverter.setProperty(target, value, preferred, ContactField.TELEPHONE_BUSINESS1, ContactField.TELEPHONE_BUSINESS2, ContactField.TELEPHONE_COMPANY, ContactField.TELEPHONE_OTHER) || home && OXContainerConverter.setProperty(target, value, preferred, ContactField.TELEPHONE_HOME1, ContactField.TELEPHONE_HOME2, ContactField.TELEPHONE_OTHER) || other && OXContainerConverter.setProperty(target, value, preferred, ContactField.TELEPHONE_OTHER) || OXContainerConverter.setProperty(target, value, preferred, ContactField.TELEPHONE_BUSINESS1, ContactField.TELEPHONE_BUSINESS2, ContactField.TELEPHONE_COMPANY, ContactField.TELEPHONE_HOME1, ContactField.TELEPHONE_HOME2, ContactField.TELEPHONE_OTHER)) || !OXContainerConverter.containsValue("fax", typeParameter) || business && OXContainerConverter.setProperty(target, value, preferred, ContactField.FAX_BUSINESS, ContactField.FAX_OTHER) || home && OXContainerConverter.setProperty(target, value, preferred, ContactField.FAX_HOME, ContactField.FAX_OTHER) || other && OXContainerConverter.setProperty(target, value, preferred, ContactField.FAX_OTHER)) && !OXContainerConverter.setProperty(target, value, preferred, ContactField.FAX_BUSINESS, ContactField.FAX_HOME, ContactField.FAX_OTHER)) continue;
        }
    }

    private static boolean setProperty(Contact target, String value, boolean preferred, ContactField ... possibleFields) {
        for (int i = 0; i < possibleFields.length; ++i) {
            try {
                ContactMapping<? extends Object> genericMapping = ContactMapper.getInstance().get(possibleFields[i]);
                if (null == genericMapping || !StringMapping.class.isInstance(genericMapping)) continue;
                StringMapping mapping = (StringMapping)genericMapping;
                if (!mapping.isSet(target)) {
                    mapping.set(target, value);
                    return true;
                }
                if (!preferred) continue;
                String previousValue = (String)mapping.get(target);
                mapping.set(target, value);
                value = previousValue;
                continue;
            }
            catch (OXException e) {
                LOG.warn("Error setting {} to {}", (Object)possibleFields[i], (Object)value);
            }
        }
        return false;
    }

    private static boolean containsValue(String value, Parameter parameter) {
        if (null != parameter && 0 < parameter.getValueCount()) {
            for (int i = 0; i < parameter.getValueCount(); ++i) {
                ParameterValue parameterValue = parameter.getValue(i);
                if (null == parameterValue || !value.equalsIgnoreCase(parameterValue.getText())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean IntegerProperty(CommonObject containerObj, VersitObject object, String VersitName, int fieldNumber) throws ConverterException {
        try {
            Property property = object.getProperty(VersitName);
            if (property == null) {
                return false;
            }
            if (property.getValue() instanceof Integer) {
                Integer val = (Integer)property.getValue();
                containerObj.set(fieldNumber, val);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private static boolean StringProperty(CommonObject containerObj, VersitObject object, String VersitName, int fieldNumber) throws ConverterException {
        try {
            Property property = object.getProperty(VersitName);
            if (property == null) {
                return false;
            }
            containerObj.set(fieldNumber, property.getValue().toString());
            return true;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private static boolean StringFromListProperty(CommonObject containerObj, VersitObject object, String VersitName, int fieldNumber) throws ConverterException {
        try {
            Property property = object.getProperty(VersitName);
            if (property == null) {
                return false;
            }
            if (property.getValue() instanceof String) {
                return OXContainerConverter.StringProperty(containerObj, object, VersitName, fieldNumber);
            }
            List args = (List)property.getValue();
            containerObj.set(fieldNumber, Strings.join((Collection)args, (String)", "));
            return true;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private static boolean PrivacyProperty(CalendarObject containerObj, VersitObject object, String VersitName, int fieldNumber) throws ConverterException {
        try {
            Property property = object.getProperty(VersitName);
            if (property == null) {
                return false;
            }
            String privacy = (String)property.getValue();
            boolean isPrivate = false;
            if ("PRIVATE".equals(privacy)) {
                isPrivate = true;
            }
            if ("CONFIDENTIAL".equals(privacy)) {
                throw new ConverterPrivacyException();
            }
            containerObj.set(fieldNumber, isPrivate);
            return false;
        }
        catch (ConverterPrivacyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private boolean DateTimeProperty(CommonObject containerObj, VersitObject object, String VersitName, int fieldNumber) throws ConverterException {
        try {
            Property property = object.getProperty(VersitName);
            if (property == null) {
                return false;
            }
            DateTimeValue date = (DateTimeValue)property.getValue();
            if (date.isFloating) {
                date.calendar.setTimeZone(this.timezone);
            }
            date.calendar.set(13, 0);
            date.calendar.set(14, 0);
            containerObj.set(fieldNumber, date.calendar.getTime());
            return true;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private static boolean DurationProperty(CommonObject containerObj, VersitObject object, String DurationName, String StartName, int fieldNumber) throws ConverterException {
        try {
            Property property = object.getProperty(DurationName);
            if (property == null) {
                return false;
            }
            DurationValue dur = (DurationValue)property.getValue();
            property = object.getProperty(StartName);
            if (property == null) {
                throw new ConverterException("Duration without start is not supported.");
            }
            Calendar cal = (Calendar)((DateTimeValue)property.getValue()).calendar.clone();
            cal.add(3, dur.Negative ? -dur.Weeks : dur.Weeks);
            cal.add(5, dur.Negative ? -dur.Days : dur.Days);
            cal.add(10, dur.Negative ? -dur.Hours : dur.Hours);
            cal.add(12, dur.Negative ? -dur.Minutes : dur.Minutes);
            cal.add(13, dur.Negative ? -dur.Seconds : dur.Seconds);
            containerObj.set(fieldNumber, cal.getTime());
            return true;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private void AttendeeProperty(CalendarObject calContainerObj, Property property) throws ConverterException {
        try {
            Comparable<Participant> participant;
            String mail = ((URI)property.getValue()).getSchemeSpecificPart();
            if (this.isInternalUser(mail)) {
                participant = new UserParticipant(this.getInternalUser(mail).getId());
            } else {
                participant = new ExternalUserParticipant(mail);
                participant.setDisplayName(mail);
            }
            calContainerObj.addParticipant((Participant)((Object)participant));
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    public boolean isInternalUser(String mail) {
        try {
            User uo = UserStorage.getInstance().searchUser(mail, this.ctx);
            return uo != null;
        }
        catch (OXException e) {
            return false;
        }
    }

    public User getInternalUser(String mail) throws OXException {
        return UserStorage.getInstance().searchUser(mail, this.ctx);
    }

    private static void RecurrenceProperty(CalendarObject calContainerObj, Property property, Property start) throws ConverterException {
        RecurrenceValue recur = (RecurrenceValue)property.getValue();
        if (start == null) {
            throw new ConverterException("RRULE without DTSTART");
        }
        Calendar cal = ((DateTimeValue)start.getValue()).calendar;
        int[] recurTypes = new int[]{0, 0, 0, 1, 2, 3, 4};
        calContainerObj.setRecurrenceType(recurTypes[recur.Freq]);
        if (recur.Until != null) {
            calContainerObj.setUntil(recur.Until.calendar.getTime());
        }
        if (recur.Count != -1) {
            calContainerObj.setOccurrence(recur.Count);
        }
        calContainerObj.setInterval(recur.Interval);
        switch (recur.Freq) {
            case 6: {
                int month;
                if (recur.ByMonth.length > 0) {
                    if (recur.ByMonth.length > 1) {
                        throw new ConverterException("Multiple months of the year are not supported.");
                    }
                    month = recur.ByMonth[0] - 1 + 0;
                } else {
                    month = cal.get(2);
                }
                calContainerObj.setMonth(month);
            }
            case 5: {
                if (recur.ByMonthDay.length > 0) {
                    if (recur.ByDay.size() != 0) {
                        throw new ConverterException("Simultaneous day in month and weekday in month are not supported.");
                    }
                    if (recur.ByMonthDay.length > 1) {
                        throw new ConverterException("Multiple days of the month are not supported.");
                    }
                    int dayOfMonth = recur.ByMonthDay[0];
                    if (dayOfMonth <= 0) {
                        throw new ConverterException("Counting days from end of the month is not supported.");
                    }
                    calContainerObj.setDayInMonth(dayOfMonth);
                    break;
                }
                if (recur.ByDay.size() > 0) {
                    int days = 0;
                    int week = 0;
                    int size = recur.ByDay.size();
                    Iterator<RecurrenceValue.Weekday> j = recur.ByDay.iterator();
                    for (int k = 0; k < size; ++k) {
                        RecurrenceValue.Weekday wd = j.next();
                        days |= 1 << wd.day - 1;
                        if (week != 0 && week != wd.week) {
                            throw new ConverterException("Multiple weeks of month are not supported.");
                        }
                        week = wd.week;
                        if (week >= 0) continue;
                        if (week == -1) {
                            week = 5;
                            continue;
                        }
                        throw new ConverterException("Only the last week of a month is supported. Counting from the end of the month above the first is not supported.");
                    }
                    calContainerObj.setDays(days);
                    calContainerObj.setDayInMonth(week);
                    break;
                }
                calContainerObj.setDayInMonth(cal.get(5));
                break;
            }
            case 3: 
            case 4: {
                int days = 0;
                int size = recur.ByDay.size();
                Iterator<RecurrenceValue.Weekday> j = recur.ByDay.iterator();
                for (int k = 0; k < size; ++k) {
                    days |= 1 << j.next().day - 1;
                }
                if (days == 0) {
                    days = 1 << cal.get(7);
                }
                calContainerObj.setDays(days);
                break;
            }
            default: {
                throw new ConverterException("Unknown Recurrence Property: " + recur.Freq);
            }
        }
    }

    private static void AddAlarms(CalendarObject calContainerObj, VersitObject object) throws ConverterException {
        int count = object.getChildCount();
        for (int i = 0; i < count; ++i) {
            int time;
            Object trigger;
            VersitObject alarm = object.getChild(i);
            Property property = alarm.getProperty("ACTION");
            if (property == null || !property.getValue().toString().equalsIgnoreCase("DISPLAY") || (property = alarm.getProperty("TRIGGER")) == null) continue;
            if (property.getValue() instanceof DurationValue) {
                trigger = (DurationValue)property.getValue();
                if (((DurationValue)trigger).Months != 0 || ((DurationValue)trigger).Years != 0) {
                    throw new ConverterException("Irregular durations not supported");
                }
                time = ((DurationValue)trigger).Minutes + (((DurationValue)trigger).Hours + (((DurationValue)trigger).Days + 7 * ((DurationValue)trigger).Weeks) * 24) * 60;
                if (((DurationValue)trigger).Negative) {
                    time = -time;
                }
                time = -time;
            } else {
                trigger = (DateTimeValue)property.getValue();
                property = object.getProperty(P_DTSTART);
                if (property == null) {
                    throw new ConverterException("VALARM without DTSTART not supported");
                }
                time = (int)(((DateTimeValue)property.getValue()).calendar.getTimeInMillis() - ((DateTimeValue)trigger).calendar.getTimeInMillis());
            }
            if (calContainerObj instanceof Appointment) {
                Appointment appObj = (Appointment)calContainerObj;
                appObj.setAlarm(time);
                appObj.setAlarmFlag(true);
                continue;
            }
            if (!(calContainerObj instanceof Task)) continue;
            Task taskObj = (Task)calContainerObj;
            taskObj.setAlarm(new Date(taskObj.getStartDate().getTime() - (long)(time * 60 * 1000)));
            taskObj.setAlarmFlag(true);
        }
    }

    private static void ListValue(CommonObject containerObj, int fieldNumber, Object list, String separator) throws ConverterException {
        try {
            ArrayList al = (ArrayList)list;
            if (al == null || al.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            Object val = al.get(0);
            if (val != null) {
                sb.append(val);
            }
            int count = al.size();
            for (int i = 1; i < count; ++i) {
                sb.append(separator);
                val = al.get(i);
                if (val == null) continue;
                sb.append(val);
            }
            containerObj.set(fieldNumber, sb.toString());
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private static void ComplexProperty(CommonObject containerObj, int[] phones, int[] index, Object value) throws ConverterException {
        try {
            if (index[0] >= phones.length) {
                return;
            }
            int n = index[0];
            index[0] = n + 1;
            containerObj.set(phones[n], value);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    public VersitObject convertTask(Task task) throws ConverterException {
        if (null == task) {
            return null;
        }
        VersitObject object = new VersitObject("VTODO");
        OXContainerConverter.addProperty(object, P_CLASS, "PUBLIC");
        this.addDateTime(object, P_COMPLETED, task.getDateCompleted());
        this.addDateTime(object, "CREATED", task.getCreationDate());
        OXContainerConverter.addProperty(object, P_DESCRIPTION, task.getNote());
        this.addDateTime(object, "DTSTAMP", new Date());
        this.addWeirdTaskDate(object, P_DTSTART, task.getStartDate());
        this.addDateTime(object, "LAST-MODIFIED", task.getLastModified());
        if (this.organizerMailAddress != null) {
            this.addAddress(object, P_ORGANIZER, this.organizerMailAddress);
        } else {
            this.addAddress(object, P_ORGANIZER, task.getCreatedBy());
        }
        OXContainerConverter.addProperty(object, "PERCENT-COMPLETE", task.getPercentComplete());
        int[] priorities = new int[]{9, 5, 1};
        int priority = task.getPriority();
        String[] statuses = new String[]{"NEEDS-ACTION", "IN-PROCESS", P_COMPLETED, "NEEDS-ACTION", "CANCELLED"};
        int status = task.getStatus();
        OXContainerConverter.addProperty(object, P_SUMMARY, task.getTitle());
        OXContainerConverter.addProperty(object, "UID", task.getObjectID() + atdomain);
        this.addWeirdTaskDate(object, "DUE", task.getEndDate());
        if (task.containsParticipants()) {
            int length = task.getParticipants().length;
            ArrayIterator i = new ArrayIterator(task.getParticipants());
            for (int k = 0; k < length; ++k) {
                Participant p = (Participant)i.next();
                if (p.getType() != 1) continue;
                this.addAddress(object, P_ATTENDEE, p.getEmailAddress());
            }
        }
        ArrayList<String> categories = new ArrayList<String>();
        if (task.getCategories() != null) {
            StringTokenizer tokenizer = new StringTokenizer(task.getCategories(), ",");
            while (tokenizer.hasMoreTokens()) {
                categories.add(tokenizer.nextToken());
            }
        }
        OXContainerConverter.addProperty(object, P_CATEGORIES, categories);
        OXContainerConverter.addRecurrence(object, P_RRULE, task);
        return object;
    }

    public VersitObject convertAppointment(Appointment app) throws ConverterException {
        String cat_str;
        if (null == app) {
            return null;
        }
        OXContainerConverter.modifyRecurring(app);
        VersitObject object = new VersitObject("VEVENT");
        OXContainerConverter.addProperty(object, P_CLASS, "PUBLIC");
        this.addDateTime(object, "CREATED", app.getCreationDate());
        OXContainerConverter.addProperty(object, P_DESCRIPTION, app.getNote());
        if (app.getFullTime()) {
            this.addWeirdTaskDate(object, P_DTSTART, app.getStartDate());
        } else {
            this.addDateTime(object, P_DTSTART, app.getStartDate());
        }
        this.addDateTime(object, "LAST-MODIFIED", app.getLastModified());
        OXContainerConverter.addProperty(object, "LOCATION", app.getLocation());
        if (this.organizerMailAddress == null) {
            this.addAddress(object, P_ORGANIZER, app.getCreatedBy());
        } else {
            this.addAddress(object, P_ORGANIZER, this.organizerMailAddress);
        }
        this.addDateTime(object, "DTSTAMP", new Date());
        OXContainerConverter.addProperty(object, P_SUMMARY, app.getTitle());
        OXContainerConverter.addProperty(object, "TRANSP", app.getShownAs() == 4 ? "TRANSPARENT" : "OPAQUE");
        OXContainerConverter.addProperty(object, "UID", app.getObjectID() + atdomain);
        if (app.getFullTime()) {
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).setTimeZone(this.timezone);
            cal.setTime(app.getEndDate());
            ((Calendar)cal).add(11, -24);
            Date end = cal.getTime();
            if (end.after(app.getStartDate())) {
                this.addWeirdTaskDate(object, "DTEND", end);
            }
        } else {
            this.addDateTime(object, "DTEND", app.getEndDate());
        }
        ArrayIterator i = null;
        if (app.containsParticipants()) {
            int length = app.getParticipants().length;
            i = new ArrayIterator(app.getParticipants());
            for (int k = 0; k < length; ++k) {
                Participant p = (Participant)i.next();
                if (p.getType() != 1) continue;
                this.addAddress(object, P_ATTENDEE, p.getEmailAddress());
            }
        }
        if ((cat_str = app.getCategories()) != null) {
            ArrayList<String> categories = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(cat_str, ",");
            while (tokenizer.hasMoreTokens()) {
                categories.add(tokenizer.nextToken());
            }
            OXContainerConverter.addProperty(object, P_CATEGORIES, categories);
        }
        ArrayList<DateTimeValue> exlist = new ArrayList<DateTimeValue>();
        this.addExceptions(exlist, app.getDeleteException());
        this.addExceptions(exlist, app.getChangeException());
        if (!exlist.isEmpty()) {
            OXContainerConverter.addProperty(object, "EXDATE", exlist);
        }
        ArrayList<String> resources = new ArrayList<String>();
        if (app.containsParticipants()) {
            int length = app.getParticipants().length;
            i = new ArrayIterator(app.getParticipants());
            for (int k = 0; k < length; ++k) {
                Participant p = (Participant)i.next();
                if (p.getType() != 3) continue;
                resources.add(String.valueOf(p.getIdentifier()));
            }
            if (!resources.isEmpty()) {
                OXContainerConverter.addProperty(object, "RESOURCES", resources);
            }
        }
        OXContainerConverter.addRecurrence(object, P_RRULE, app);
        return object;
    }

    private static void modifyRecurring(Appointment app) throws ConverterException {
        if (app.getRecurrenceType() != 0) {
            RecurringResultsInterface result;
            try {
                CalendarCollectionService calColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
                result = calColl.calculateFirstRecurring(app);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                throw new ConverterException(e);
            }
            if (result.size() == 1) {
                app.setStartDate(new Date(result.getRecurringResult(0).getStart()));
                app.setEndDate(new Date(result.getRecurringResult(0).getEnd()));
            } else {
                throw new ConverterException("Unable to calculate first occurence of an appointment.");
            }
        }
    }

    public VersitObject convertContact(Contact contact, String version2) throws ConverterException {
        if (null == contact) {
            return null;
        }
        VersitObject object = new VersitObject("VCARD");
        OXContainerConverter.addProperty(object, "VERSION", version2);
        OXContainerConverter.addProperty(object, "PRODID", "OPEN-XCHANGE");
        OXContainerConverter.addProperty(object, "FN", contact.getDisplayName());
        OXContainerConverter.addProperty(object, "X-PHONETIC-FIRST-NAME", contact.getYomiFirstName());
        OXContainerConverter.addProperty(object, "X-PHONETIC-LAST-NAME", contact.getYomiLastName());
        ArrayList<ArrayList<Object>> n = new ArrayList<ArrayList<Object>>();
        n.add(this.makeList(contact.getSurName()));
        n.add(this.makeList(contact.getGivenName()));
        n.add(OXContainerConverter.getList(contact.getMiddleName(), ' '));
        n.add(OXContainerConverter.getList(contact.getTitle(), ' '));
        n.add(OXContainerConverter.getList(contact.getSuffix(), ' '));
        OXContainerConverter.addProperty(object, "N", n);
        OXContainerConverter.addProperty(object, "NICKNAME", OXContainerConverter.getList(contact.getNickname(), ','));
        if (!contact.containsMarkAsDistributionlist() || !contact.getMarkAsDistribtuionlist()) {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            if (!this.skipOxCTypeAttribute) {
                OXContainerConverter.addProperty(object, P_OPEN_XCHANGE_CTYPE, CTYPE_CONTACT);
            }
            if (contact.getImage1() != null) {
                byte[] imageData = contact.getImage1();
                try {
                    OXContainerConverter.addProperty(object, "PHOTO", "VALUE", new String[]{"URI"}, new URI(new String(imageData, Charsets.ISO_8859_1)));
                }
                catch (UnsupportedCharsetException e2) {
                    LOG.error(e2.toString());
                    throw new ConverterException(e2);
                }
                catch (URISyntaxException e) {
                    Parameter type = new Parameter(P_TYPE);
                    String mimeType = contact.getImageContentType();
                    String param = mimeType == null ? "JPEG" : (mimeType.indexOf(47) != -1 ? mimeType.substring(mimeType.indexOf(47) + 1).toUpperCase() : mimeType.toUpperCase());
                    type.addValue(new ParameterValue(param));
                    TransformedImage transformedImage = null;
                    try {
                        transformedImage = this.scaleImageIfNeeded(imageData, contact.getImageContentType());
                    }
                    catch (IOException x) {
                        LOG.error("error scaling image, falling back to unscaled image.", (Throwable)x);
                    }
                    catch (OXException x) {
                        LOG.error("error scaling image, falling back to unscaled image.", (Throwable)x);
                    }
                    catch (RuntimeException x) {
                        LOG.error("error scaling image, falling back to unscaled image.", (Throwable)x);
                    }
                    if (null != transformedImage) {
                        Property photoProperty = OXContainerConverter.addProperty(object, "PHOTO", "ENCODING", new String[]{"B"}, transformedImage.getImageData());
                        photoProperty.addParameter(type);
                        photoProperty.addParameter(OXContainerConverter.getABCropRectangle(transformedImage));
                    }
                    OXContainerConverter.addProperty(object, "PHOTO", "ENCODING", new String[]{"B"}, imageData).addParameter(type);
                }
            }
            String s = null;
            OXContainerConverter.addDate(object, "BDAY", contact.getBirthday(), false);
            this.addADR(object, contact, new String[]{PARAM_WORK}, 523, 526, 527, 525, 528);
            this.addADR(object, contact, new String[]{PARAM_HOME}, 506, 508, 509, 507, 510);
            this.addADR(object, contact, new String[]{PARAM_OTHER}, 538, 539, 598, 540, 541);
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{PARAM_WORK, PARAM_VOICE, "pref"}, contact.getTelephoneBusiness1());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{PARAM_WORK, PARAM_VOICE}, contact.getTelephoneBusiness2());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{PARAM_WORK, "fax"}, contact.getFaxBusiness());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{"car", PARAM_VOICE}, contact.getTelephoneCar());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{PARAM_HOME, PARAM_VOICE, "pref"}, contact.getTelephoneHome1());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{PARAM_HOME, PARAM_VOICE}, contact.getTelephoneHome2());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{PARAM_HOME, "fax"}, contact.getFaxHome());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{"cell", PARAM_VOICE, "pref"}, contact.getCellularTelephone1());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{"cell", PARAM_VOICE}, contact.getCellularTelephone2());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{PARAM_OTHER, PARAM_VOICE}, contact.getTelephoneOther());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{PARAM_OTHER, "fax"}, contact.getFaxOther());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{"isdn"}, contact.getTelephoneISDN());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{"pager"}, contact.getTelephonePager());
            OXContainerConverter.addProperty(object, P_TEL, P_TYPE, new String[]{"textphone"}, contact.getTelephoneTTYTTD());
            if (1 == contact.getDefaultAddress()) {
                String[] stringArray4 = new String[3];
                stringArray4[0] = "INTERNET";
                stringArray4[1] = PARAM_WORK;
                stringArray3 = stringArray4;
                stringArray4[2] = "pref";
            } else {
                String[] stringArray5 = new String[2];
                stringArray5[0] = "INTERNET";
                stringArray3 = stringArray5;
                stringArray5[1] = PARAM_WORK;
            }
            OXContainerConverter.addProperty(object, P_EMAIL, P_TYPE, stringArray3, contact.getEmail1());
            if (2 == contact.getDefaultAddress()) {
                String[] stringArray6 = new String[3];
                stringArray6[0] = "INTERNET";
                stringArray6[1] = PARAM_HOME;
                stringArray2 = stringArray6;
                stringArray6[2] = "pref";
            } else {
                String[] stringArray7 = new String[2];
                stringArray7[0] = "INTERNET";
                stringArray2 = stringArray7;
                stringArray7[1] = PARAM_HOME;
            }
            OXContainerConverter.addProperty(object, P_EMAIL, P_TYPE, stringArray2, contact.getEmail2());
            if (3 == contact.getDefaultAddress()) {
                String[] stringArray8 = new String[3];
                stringArray8[0] = "INTERNET";
                stringArray8[1] = "pref";
                stringArray = stringArray8;
                stringArray8[2] = "other";
            } else {
                String[] stringArray9 = new String[2];
                stringArray9[0] = "INTERNET";
                stringArray = stringArray9;
                stringArray9[1] = "other";
            }
            OXContainerConverter.addProperty(object, P_EMAIL, P_TYPE, stringArray, contact.getEmail3());
            OXContainerConverter.addProperty(object, "TITLE", contact.getProfession());
            OXContainerConverter.addProperty(object, "ROLE", contact.getPosition());
            ArrayList<String> list = new ArrayList<String>();
            s = contact.getCompany();
            list.add(s);
            boolean set = s != null;
            s = contact.getBranches();
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s, ",");
                set |= st.hasMoreTokens();
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
            }
            set |= (s = contact.getDepartment()) != null;
            if (s != null) {
                list.add(s);
            }
            if (set) {
                OXContainerConverter.addProperty(object, "ORG", list);
            }
        } else {
            DistributionListEntryObject[] distributionList;
            if (!this.skipOxCTypeAttribute) {
                OXContainerConverter.addProperty(object, P_OPEN_XCHANGE_CTYPE, CTYPE_DISTRIBUTION_LIST);
            }
            if (null != (distributionList = contact.getDistributionList()) && 0 < distributionList.length) {
                for (DistributionListEntryObject distributionListEntry : distributionList) {
                    String displayName;
                    String address = distributionListEntry.getEmailaddress();
                    if (address == null) continue;
                    Property property = new Property(P_EMAIL);
                    property.setValue(address);
                    Parameter parameter = new Parameter(P_TYPE);
                    parameter.addValue(new ParameterValue("INTERNET"));
                    property.addParameter(parameter);
                    if (this.addDisplayName4DList && null != (displayName = distributionListEntry.getDisplayname())) {
                        Parameter parameter2 = new Parameter("FN");
                        parameter2.addValue(new ParameterValue(OXContainerConverter.encodeQP(displayName)));
                        property.addParameter(parameter2);
                    }
                    object.addProperty(property);
                }
            }
        }
        if (null != contact.getCategories() && 0 < contact.getCategories().length()) {
            ArrayList<String> categories = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(contact.getCategories(), ",");
            while (tokenizer.hasMoreTokens()) {
                categories.add(tokenizer.nextToken());
            }
            if (0 < categories.size()) {
                OXContainerConverter.addProperty(object, P_CATEGORIES, categories);
            }
        }
        OXContainerConverter.addProperty(object, "NOTE", contact.getNote());
        this.addDateTime(object, "REV", contact.getLastModified());
        OXContainerConverter.addProperty(object, "URL", contact.getURL());
        OXContainerConverter.addProperty(object, "UID", contact.getUid());
        OXContainerConverter.addProperty(object, "IMPP", P_TYPE, new String[]{PARAM_WORK}, contact.getInstantMessenger1());
        OXContainerConverter.addProperty(object, "IMPP", P_TYPE, new String[]{PARAM_HOME}, contact.getInstantMessenger2());
        return object;
    }

    private void addADR(VersitObject object, Contact contactContainer, String[] type, int street, int city, int state, int postalCode, int country) throws ConverterException {
        try {
            String streetValue = this.getStreet(street, contactContainer);
            String cityValue = this.getCity(city, contactContainer);
            String stateValue = this.getState(state, contactContainer);
            String postalCodeValue = this.getPostalCode(postalCode, contactContainer);
            String countryValue = this.getCountry(country, contactContainer);
            if (null != streetValue || null != cityValue || null != stateValue || null != postalCodeValue || null != countryValue) {
                ArrayList<ArrayList<Object>> adr = new ArrayList<ArrayList<Object>>(7);
                adr.add(null);
                adr.add(null);
                adr.add(this.makeList(streetValue));
                adr.add(this.makeList(cityValue));
                adr.add(this.makeList(stateValue));
                adr.add(this.makeList(postalCodeValue));
                adr.add(this.makeList(countryValue));
                OXContainerConverter.addProperty(object, "ADR", P_TYPE, type, adr);
            }
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private String getStreet(int id, Contact contactContainer) throws Exception {
        switch (id) {
            case 523: {
                return contactContainer.getStreetBusiness();
            }
            case 506: {
                return contactContainer.getStreetHome();
            }
            case 538: {
                return contactContainer.getStreetOther();
            }
        }
        throw new Exception("Unknown street constant " + id);
    }

    private String getCity(int id, Contact contactContainer) throws Exception {
        switch (id) {
            case 526: {
                return contactContainer.getCityBusiness();
            }
            case 508: {
                return contactContainer.getCityHome();
            }
            case 539: {
                return contactContainer.getCityOther();
            }
        }
        throw new Exception("Unknown city constant " + id);
    }

    private String getState(int id, Contact contactContainer) throws Exception {
        switch (id) {
            case 527: {
                return contactContainer.getStateBusiness();
            }
            case 509: {
                return contactContainer.getStateHome();
            }
            case 598: {
                return contactContainer.getStateOther();
            }
        }
        throw new Exception("Unknown state constant " + id);
    }

    private String getCountry(int id, Contact contactContainer) throws Exception {
        switch (id) {
            case 528: {
                return contactContainer.getCountryBusiness();
            }
            case 510: {
                return contactContainer.getCountryHome();
            }
            case 541: {
                return contactContainer.getCountryOther();
            }
        }
        throw new Exception("Unknown country constant " + id);
    }

    private String getPostalCode(int id, Contact contactContainer) throws Exception {
        switch (id) {
            case 525: {
                return contactContainer.getPostalCodeBusiness();
            }
            case 507: {
                return contactContainer.getPostalCodeHome();
            }
            case 540: {
                return contactContainer.getPostalCodeOther();
            }
        }
        throw new Exception("Unknown postal code constant " + id);
    }

    private static void addProperty(VersitObject object, String name, Object value) {
        if (value == null) {
            return;
        }
        Property property = new Property(name);
        property.setValue(value);
        object.addProperty(property);
    }

    private static Property addProperty(VersitObject object, String name, String paramName, String[] param, Object value) {
        if (value == null) {
            return null;
        }
        Property property = new Property(name);
        if (param != null && param.length > 0) {
            Parameter parameter = new Parameter(paramName);
            for (int i = 0; i < param.length; ++i) {
                parameter.addValue(new ParameterValue(param[i]));
            }
            property.addParameter(parameter);
        }
        property.setValue(value);
        object.addProperty(property);
        return property;
    }

    private void addDateTime(VersitObject object, String name, Date value) {
        if (value == null) {
            return;
        }
        DateTimeValue dt = new DateTimeValue();
        dt.calendar.setTimeZone(this.sendUTC ? DateTimeValue.GMT : this.timezone);
        dt.calendar.setTime(value);
        dt.isUTC = this.sendUTC;
        dt.isFloating = this.sendFloating;
        Property property = new Property(name);
        property.setValue(dt);
        object.addProperty(property);
    }

    private static void addDate(VersitObject object, String name, Date value, boolean setValue) {
        if (value == null) {
            return;
        }
        DateTimeValue dt = new DateTimeValue();
        dt.calendar.setTimeInMillis(value.getTime());
        dt.hasTime = false;
        Property property = new Property(name);
        if (setValue) {
            Parameter parameter = new Parameter("VALUE");
            parameter.addValue(new ParameterValue("DATE"));
            property.addParameter(parameter);
        }
        property.setValue(dt);
        object.addProperty(property);
    }

    private void addWeirdTaskDate(VersitObject object, String name, Date value) {
        if (value == null) {
            return;
        }
        DateTimeValue dt = new DateTimeValue();
        dt.calendar.setTimeZone(this.timezone);
        dt.calendar.setTime(value);
        dt.hasTime = false;
        dt.isFloating = true;
        dt.isUTC = false;
        Property property = new Property(name);
        Parameter parameter = new Parameter("VALUE");
        parameter.addValue(new ParameterValue("DATE"));
        property.addParameter(parameter);
        property.setValue(dt);
        object.addProperty(property);
    }

    private void addExceptions(ArrayList<DateTimeValue> list, Date[] exceptions) {
        if (exceptions == null) {
            return;
        }
        for (int i = 0; i < exceptions.length; ++i) {
            DateTimeValue dtv = new DateTimeValue();
            dtv.calendar.setTime(exceptions[i]);
            dtv.hasTime = false;
            list.add(dtv);
        }
    }

    private void addAddress(VersitObject object, String name, String address) throws ConverterException {
        block4: {
            try {
                Property property = new Property(name);
                if (address == null) break block4;
                try {
                    property.setValue(new URI("mailto:" + address));
                }
                catch (URISyntaxException e) {
                    ConverterException ce = new ConverterException(e.getMessage());
                    ce.initCause(e);
                    throw ce;
                }
                object.addProperty(property);
            }
            catch (Exception e) {
                LOG.error(e.toString());
                throw new ConverterException(e);
            }
        }
    }

    private void addAddress(VersitObject object, String name, int userId) throws ConverterException {
        block5: {
            try {
                User userObj = UserStorage.getInstance().getUser(userId, this.ctx);
                if (userObj == null) {
                    return;
                }
                Property property = new Property(name);
                String address = userObj.getMail();
                if (address == null) break block5;
                try {
                    property.setValue(new URI("mailto:" + IDNA.toACE((String)address)));
                }
                catch (URISyntaxException e) {
                    ConverterException ce = new ConverterException(e.getMessage());
                    ce.initCause(e);
                    throw ce;
                }
                object.addProperty(property);
            }
            catch (Exception e) {
                LOG.error(e.toString());
                throw new ConverterException(e);
            }
        }
    }

    private static void addRecurrence(VersitObject object, String name, CalendarObject oxobject) {
        if (oxobject.getRecurrenceType() != 0) {
            int interval;
            RecurrenceValue recur = new RecurrenceValue();
            Date until = oxobject.getUntil();
            if (until != null) {
                recur.Until = new DateTimeValue();
                recur.Until.calendar.setTime(until);
            }
            if ((interval = oxobject.getInterval()) != 1) {
                recur.Interval = interval;
            }
            int type = oxobject.getRecurrenceType();
            switch (oxobject.getRecurrenceType()) {
                case 4: {
                    int[] byMonth = new int[]{oxobject.getMonth() - 0 + 1};
                    recur.ByMonth = byMonth;
                }
                case 3: {
                    int monthDay = oxobject.getDayInMonth();
                    int mdays = oxobject.getDays();
                    if (mdays == 0) {
                        int[] byMonthDay = new int[]{monthDay};
                        recur.ByMonthDay = byMonthDay;
                        break;
                    }
                    for (int i = 0; i < 7; ++i) {
                        if ((mdays & 1 << i) == 0) continue;
                        recur.ByDay.add(new RecurrenceValue.Weekday(monthDay, 1 + i));
                    }
                    break;
                }
                case 2: {
                    int days = oxobject.getDays();
                    for (int i = 0; i < 7; ++i) {
                        if ((days & 1 << i) == 0) continue;
                        recur.ByDay.add(new RecurrenceValue.Weekday(0, 1 + i));
                    }
                    break;
                }
            }
            int[] freqs = new int[]{3, 4, 5, 6};
            recur.Freq = freqs[type - 1];
            OXContainerConverter.addProperty(object, name, recur);
        }
    }

    private ArrayList<Object> makeList(Object element) {
        ArrayList<Object> retval = new ArrayList<Object>(1);
        retval.add(element);
        return retval;
    }

    private static ArrayList<String> getList(Object val, char separator) {
        if (val == null) {
            return null;
        }
        String values = (String)val;
        ArrayList<String> retval = new ArrayList<String>();
        int start = 0;
        int length = values.length();
        for (int end = 0; end < length; ++end) {
            if (values.charAt(end) != separator) continue;
            retval.add(values.substring(start, end));
            start = end + 1;
        }
        retval.add(values.substring(start));
        return retval;
    }

    public static VersitObject newCalendar(String version2) {
        VersitObject object = new VersitObject("VCALENDAR");
        Property property = new Property("VERSION");
        property.setValue(version2);
        object.addProperty(property);
        property = new Property("PRODID");
        property.setValue("OPEN-XCHANGE");
        object.addProperty(property);
        return object;
    }

    private static String getMimeType(String filename) {
        return FileTypeMap.getDefaultFileTypeMap().getContentType(filename);
    }

    private static boolean isValidImage(byte[] data) {
        BufferedImage bimg = null;
        try {
            bimg = ImageIO.read((InputStream)new UnsynchronizedByteArrayInputStream(data));
        }
        catch (Exception e) {
            return false;
        }
        return bimg != null;
    }

    private static String encodeQP(String string) throws ConverterException {
        try {
            return Charsets.toAsciiString((byte[])QuotedPrintableCodec.encodeQuotedPrintable((BitSet)PRINTABLE_CHARS, (byte[])string.getBytes(Charsets.UTF_8))).replaceAll("=", "%");
        }
        catch (UnsupportedCharsetException e) {
            throw new ConverterException(e);
        }
    }

    private static String decodeQP(String string) throws ConverterException {
        try {
            return new String(QuotedPrintableCodec.decodeQuotedPrintable((byte[])Charsets.toAsciiBytes((String)string.replaceAll("%", "="))), Charsets.UTF_8);
        }
        catch (DecoderException e) {
            throw new ConverterException(e);
        }
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger(OXContainerConverter.class);
        String domain = "localhost";
        try {
            domain = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("", (Throwable)e);
        }
        atdomain = '@' + domain;
        PRINTABLE_CHARS = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            PRINTABLE_CHARS.set(i);
        }
    }

    private static class ArrayIterator
    implements Iterator<Object> {
        private final int size;
        private int cursor;
        private final Object array;

        public ArrayIterator(Object array) {
            Class<?> type = array.getClass();
            if (!type.isArray()) {
                throw new IllegalArgumentException("Invalid type: " + type);
            }
            this.array = array;
            this.size = Array.getLength(array);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.size;
        }

        @Override
        public Object next() {
            if (this.cursor < this.size) {
                return Array.get(this.array, this.cursor++);
            }
            throw new NoSuchElementException("No next element present in underlying array");
        }
    }
}

