/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit.impl;

import com.openexchange.tools.servlet.ratelimit.Rate;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class RateImpl
implements Rate {
    private final AtomicLong lastLogStamp = new AtomicLong(0L);
    private int permits;
    private long timeInMillis;
    private final Deque<Long> callHistory = new LinkedList<Long>();
    private boolean deprecated = false;

    public RateImpl(int permits, int timeLength, TimeUnit timeUnit) {
        this.permits = permits;
        this.timeInMillis = timeUnit.toMillis(timeLength);
    }

    private void cleanOld(long now) {
        Long first;
        long threshold = now - this.timeInMillis;
        while ((first = this.callHistory.peekFirst()) != null && first <= threshold) {
            this.callHistory.pollFirst();
        }
    }

    private long callTime(long now) {
        long call;
        long lastStart;
        this.cleanOld(now);
        int size = this.callHistory.size();
        if (size < this.permits) {
            return now;
        }
        long firstPeriodCall = lastStart = this.callHistory.peekLast() - this.timeInMillis;
        int count = 0;
        Iterator<Long> i = this.callHistory.descendingIterator();
        while (i.hasNext() && (call = i.next().longValue()) >= lastStart) {
            ++count;
            firstPeriodCall = call;
        }
        return count < this.permits ? firstPeriodCall + 1L : firstPeriodCall + this.timeInMillis + 1L;
    }

    @Override
    public AtomicLong getLastLogStamp() {
        return this.lastLogStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lastAccessTime() {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            Long last = this.callHistory.peekLast();
            return null == last ? Long.MIN_VALUE : last;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeprecated() {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            return this.deprecated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markDeprecatedIfElapsed(long threshold) {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            Long last = this.callHistory.peekLast();
            if (null != last && last > threshold) {
                return false;
            }
            this.deprecated = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rate.Result consume(long now) {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            if (this.deprecated) {
                return Rate.Result.DEPRECATED;
            }
            long callTime = this.callTime(now);
            this.callHistory.offerLast(callTime);
            return callTime - now <= 0L ? Rate.Result.SUCCESS : Rate.Result.FAILED;
        }
    }

    @Override
    public int getPermits() {
        return this.permits;
    }

    @Override
    public long getTimeInMillis() {
        return this.timeInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermits(int permits) {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            this.permits = permits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeInMillis(long timeInMillis) {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            this.timeInMillis = timeInMillis;
        }
    }

    public static void main(String[] args) {
        int i;
        RateImpl rate = new RateImpl(5, 5, TimeUnit.SECONDS);
        long callTime = System.currentTimeMillis();
        for (i = 0; i < 6; ++i) {
            System.out.println((Object)rate.consume(callTime));
            callTime += 100L;
        }
        System.out.println("-------------------------");
        callTime += 6000L;
        for (i = 0; i < 6; ++i) {
            System.out.println((Object)rate.consume(callTime));
            callTime += 100L;
        }
        System.out.println("-------------------------");
    }
}

