/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.conf;

import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

@Deprecated
public abstract class AbstractConfig {
    private Properties props;

    protected AbstractConfig() {
    }

    protected final boolean containsPropertyInternal(String key) {
        return this.props == null ? false : this.props.containsKey(key);
    }

    protected final String getPropertyInternal(String key) {
        return this.getPropertyInternal(key, null);
    }

    protected final String getPropertyInternal(String key, String def) {
        return this.props == null ? null : this.props.getProperty(key, def);
    }

    protected final boolean getBooleanInternal(String key) {
        return this.getBooleanInternal(key, null);
    }

    protected final boolean getBooleanInternal(String key, boolean def) {
        return this.getBooleanInternal(key, Boolean.valueOf(def).toString());
    }

    protected final boolean getBooleanInternal(String key, String def) {
        String value = this.getPropertyInternal(key);
        if (null == value) {
            value = def;
        }
        return Boolean.parseBoolean(value);
    }

    protected final Iterator<String> keyIterator() {
        final Iterator<Object> iter = this.props.keySet().iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public String next() {
                return (String)iter.next();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    protected final boolean isPropertiesLoadInternal() {
        return this.props != null;
    }

    protected abstract String getPropertyFileName() throws OXException;

    protected final void loadPropertiesInternal() throws OXException {
        this.loadPropertiesInternal(this.getPropertyFileName());
    }

    protected final void loadPropertiesInternal(String propFileName) throws OXException {
        if (null == propFileName) {
            throw ConfigurationExceptionCodes.NO_FILENAME.create();
        }
        File propFile = new File(propFileName);
        if (!propFile.exists()) {
            throw ConfigurationExceptionCodes.FILE_NOT_FOUND.create(propFile.getAbsoluteFile());
        }
        if (!propFile.canRead()) {
            throw ConfigurationExceptionCodes.NOT_READABLE.create(propFile.getAbsoluteFile());
        }
        this.loadProperties(propFile);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void loadProperties(File propFile) throws OXException {
        this.props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            this.props.load(fis);
        }
        catch (FileNotFoundException e) {
            try {
                throw ConfigurationExceptionCodes.FILE_NOT_FOUND.create(propFile.getAbsolutePath(), e);
                catch (IOException e2) {
                    throw ConfigurationExceptionCodes.READ_ERROR.create(propFile.getAbsolutePath(), e2);
                }
            }
            catch (Throwable throwable) {
                Streams.close(fis);
                throw throwable;
            }
        }
        Streams.close((Closeable)fis);
    }

    protected final void clearProperties() {
        this.props = null;
    }
}

