/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.threader;

import com.openexchange.java.Strings;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MessageHeaders;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ThreadableMapping {
    private final Map<String, List<MailMessage>> refsMap;
    private final Map<String, List<MailMessage>> messageIdMap;

    private static MessageKey keyFor(MailMessage mailMessage) {
        if (null == mailMessage) {
            return null;
        }
        return new MessageKey(mailMessage.getMailId(), mailMessage.getFolder());
    }

    public ThreadableMapping(int capacity) {
        this.refsMap = new HashMap<String, List<MailMessage>>(capacity << 1, 0.9f);
        this.messageIdMap = new HashMap<String, List<MailMessage>>(capacity, 0.9f);
    }

    public boolean checkFor(Iterable<MailMessage> toCheck, List<MailMessage> thread) {
        boolean changed = false;
        HashSet<String> existingMessageIds = new HashSet<String>(thread.size());
        for (MailMessage mailMessage : thread) {
            existingMessageIds.add(mailMessage.getMessageId());
        }
        HashSet<MessageKey> processed = new HashSet<MessageKey>(thread.size());
        for (MailMessage mail : toCheck) {
            String[] sReferences;
            List<MailMessage> referencees;
            String messageId = mail.getMessageId();
            if (null != messageId && null != (referencees = this.refsMap.get(messageId))) {
                for (MailMessage candidate : referencees) {
                    if (existingMessageIds.contains(candidate.getMessageId()) || !processed.add(ThreadableMapping.keyFor(candidate))) continue;
                    thread.add(candidate);
                    changed = true;
                }
            }
            if (null == (sReferences = mail.getReferences())) continue;
            for (String sReference : sReferences) {
                List<MailMessage> references = this.messageIdMap.get(sReference);
                if (null == references) continue;
                for (MailMessage candidate : references) {
                    if (existingMessageIds.contains(candidate.getMessageId()) || !processed.add(ThreadableMapping.keyFor(candidate))) continue;
                    thread.add(candidate);
                    changed = true;
                }
            }
        }
        return changed;
    }

    public Set<MailMessage> getRefs(String messageId) {
        List<MailMessage> list = this.refsMap.get(messageId);
        return list == null ? Collections.emptySet() : new LinkedHashSet<MailMessage>(list);
    }

    public Set<MailMessage> getMessageId(String messageId) {
        List<MailMessage> list = this.messageIdMap.get(messageId);
        return list == null ? Collections.emptySet() : new LinkedHashSet<MailMessage>(list);
    }

    public ThreadableMapping initWith(List<MailMessage> mails) {
        ThreadableMapping.fill(mails, this.messageIdMap, this.refsMap);
        return this;
    }

    private static void fill(List<MailMessage> mails, Map<String, List<MailMessage>> messageIdMap, Map<String, List<MailMessage>> refsMap) {
        String hdrMessageId = MessageHeaders.HDR_MESSAGE_ID;
        for (MailMessage current : mails) {
            String messageId;
            String[] refs = current.getReferences();
            if (null != refs) {
                for (String reference : refs) {
                    if (Strings.isEmpty((String)reference)) continue;
                    List<MailMessage> list = refsMap.get(reference);
                    if (null == list) {
                        list = new LinkedList<MailMessage>();
                        refsMap.put(reference, list);
                    }
                    list.add(current);
                }
            }
            if (Strings.isEmpty((String)(messageId = current.getFirstHeader(hdrMessageId)))) continue;
            List<MailMessage> list = messageIdMap.get(messageId);
            if (null == list) {
                list = new LinkedList<MailMessage>();
                messageIdMap.put(messageId, list);
            }
            list.add(current);
        }
    }

    private static final class MessageKey {
        final String fullName;
        final String id;
        final int hash;

        MessageKey(String id, String fullName) {
            this.id = id;
            this.fullName = fullName;
            int prime = 31;
            int result = 1;
            result = 31 * result + (fullName == null ? 0 : fullName.hashCode());
            this.hash = result = 31 * result + (id == null ? 0 : id.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MessageKey)) {
                return false;
            }
            MessageKey other = (MessageKey)obj;
            if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

