/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.osgi;

import com.openexchange.capabilities.CapabilityChecker;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.exception.OXException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class MailCapabilityServiceTracker
implements ServiceTrackerCustomizer<CapabilityService, CapabilityService> {
    private static final String MSISDN = "msisdn";
    private final BundleContext context;
    private volatile ServiceRegistration<CapabilityChecker> registration;

    public MailCapabilityServiceTracker(BundleContext context) {
        this.context = context;
    }

    public CapabilityService addingService(ServiceReference<CapabilityService> reference) {
        CapabilityService service = (CapabilityService)this.context.getService(reference);
        CapabilityChecker checker = new CapabilityChecker(){

            public boolean isEnabled(String capability, Session ses) throws OXException {
                if (MailCapabilityServiceTracker.MSISDN.equals(capability)) {
                    if (ServerSessionAdapter.valueOf(ses).isAnonymous()) {
                        return false;
                    }
                    return MailProperties.getInstance().isSupportMsisdnAddresses();
                }
                return true;
            }
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("capabilities", MSISDN);
        this.registration = this.context.registerService(CapabilityChecker.class, (Object)checker, properties);
        service.declareCapability(MSISDN);
        return service;
    }

    public void modifiedService(ServiceReference<CapabilityService> reference, CapabilityService service) {
    }

    public void removedService(ServiceReference<CapabilityService> reference, CapabilityService service) {
        ServiceRegistration<CapabilityChecker> registration = this.registration;
        if (null != registration) {
            registration.unregister();
            this.registration = null;
        }
        this.context.ungetService(reference);
    }
}

