/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.converters;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.ExtendedMimeMessage;
import com.openexchange.mail.mime.FullnameFolder;
import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.DataHandlerWrapper;
import com.openexchange.mail.mime.converters.FileBackedMimeMessage;
import com.openexchange.mail.mime.converters.HeaderContentHandler;
import com.openexchange.mail.mime.converters.HeaderOutputStream;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.dataobjects.MimeMailPart;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.util.MessageRemovedIOException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.UIDFolder;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;
import javax.mail.util.SharedFileInputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.MimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeMessageConverter {
    private static final Logger LOG = LoggerFactory.getLogger(MimeMessageConverter.class);
    private static final EnumSet<MailField> ENUM_SET_FULL = EnumSet.complementOf(EnumSet.of(MailField.BODY, MailField.FULL, MailField.ACCOUNT_NAME));
    private static final String CONTENT_TYPE = MessageHeaders.HDR_CONTENT_TYPE;
    private static final String STR_EMPTY = "";
    public static final int BEHAVIOR_CLONE = 1;
    public static final int BEHAVIOR_STREAM2FILE = 2;
    private static final String X_ORIGINAL_HEADERS = "x-original-headers";
    private static final EnumMap<MailField, MailMessageFieldFiller> FILLER_MAP_EXT = new EnumMap(MailField.class);
    private static final EnumMap<MailField, ExistenceChecker> CHECKER_MAP;
    private static final EnumMap<MailField, MailMessageFieldFiller> FILLER_MAP;
    private static final String MULTI_PRIMTYPE = "multipart/";
    private static final String MULTI_SUBTYPE_MIXED = "MIXED";
    private static final String MULTI_SUBTYPE_ALTERNATIVE = "ALTERNATIVE";
    private static final String ENC_BASE64 = "base64";
    private static final String[] EMPTY_STRS;
    private static final int DEFAULT_MESSAGE_SIZE = 8192;
    private static volatile Boolean enableMime4j;
    private static final Pattern PATTERN_PARSE_HEADER;

    private MimeMessageConverter() {
    }

    public static Part convertMailPart(MailPart mailPart) throws OXException {
        try {
            if (mailPart instanceof MailMessage) {
                return MimeMessageConverter.convertMailMessage((MailMessage)mailPart);
            }
            ThresholdFileHolder sink = new ThresholdFileHolder();
            mailPart.writeTo(sink.asOutputStream());
            File tempFile = sink.getTempFile();
            if (null == tempFile) {
                return new MimeBodyPart((InputStream)Streams.newByteArrayInputStream((byte[])sink.toByteArray()));
            }
            return new MimeBodyPart((InputStream)new SharedFileInputStream(tempFile));
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static Message[] convertMailMessages(MailMessage[] mails) throws OXException {
        return MimeMessageConverter.convertMailMessages(mails, true);
    }

    public static Message[] convertMailMessages(MailMessage[] mails, boolean clone) throws OXException {
        if (null == mails) {
            return null;
        }
        Message[] retval = new Message[mails.length];
        for (int i = 0; i < retval.length; ++i) {
            if (null == mails[i]) continue;
            retval[i] = MimeMessageConverter.convertMailMessage(mails[i], clone);
        }
        return retval;
    }

    public static Message[] convertMailMessages(MailMessage[] mails, int behavior) throws OXException {
        if (null == mails) {
            return null;
        }
        Message[] retval = new Message[mails.length];
        for (int i = 0; i < retval.length; ++i) {
            if (null == mails[i]) continue;
            retval[i] = MimeMessageConverter.convertMailMessage(mails[i], behavior);
        }
        return retval;
    }

    public static Message convertMailMessage(MailMessage mail) throws OXException {
        return MimeMessageConverter.convertMailMessage(mail, true);
    }

    public static Message convertMailMessage(MailMessage mail, boolean clone) throws OXException {
        return MimeMessageConverter.convertMailMessage(mail, clone ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message convertMailMessage(MailMessage mail, int behavior) throws OXException {
        if (mail instanceof ComposedMailMessage) {
            return MimeMessageConverter.convertComposedMailMessage((ComposedMailMessage)mail);
        }
        try {
            Object mimeMessage;
            boolean stream2file;
            boolean clone = (behavior & 1) > 0;
            boolean bl = stream2file = (behavior & 2) > 0;
            if (!clone && mail instanceof MimeMailMessage) {
                mimeMessage = ((MimeMailMessage)mail).getMimeMessage();
            } else {
                ManagedFileManagement fileManagement;
                if (!stream2file || null == (fileManagement = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class))) {
                    ThresholdFileHolder sink = null;
                    boolean closeSink = true;
                    try {
                        sink = new ThresholdFileHolder();
                        mail.writeTo(sink.asOutputStream());
                        File tempFile = sink.getTempFile();
                        mimeMessage = null == tempFile ? new MimeMessage(MimeDefaultSession.getDefaultSession(), sink.getStream()) : new FileBackedMimeMessage(MimeDefaultSession.getDefaultSession(), tempFile);
                        mimeMessage.removeHeader(X_ORIGINAL_HEADERS);
                        closeSink = false;
                    }
                    finally {
                        if (closeSink && null != sink) {
                            sink.close();
                        }
                    }
                }
                File file = MimeMessageConverter.checkForFile(mail);
                boolean deleteOnError = false;
                try {
                    if (null == file) {
                        deleteOnError = true;
                        File newTempFile = fileManagement.newTempFile();
                        MimeMessageConverter.writeToFile(mail, newTempFile);
                        file = newTempFile;
                    }
                    mimeMessage = new ManagedMimeMessage(MimeDefaultSession.getDefaultSession(), file, mail.getReceivedDateDirect());
                    mimeMessage.removeHeader(X_ORIGINAL_HEADERS);
                    deleteOnError = false;
                }
                finally {
                    if (deleteOnError && null != file) {
                        file.delete();
                    }
                }
            }
            if (mail.containsFlags()) {
                MimeMessageConverter.parseMimeFlags(mail.getFlags(), (Message)mimeMessage);
            }
            Flags flags = null;
            if (mail.containsColorLabel()) {
                flags = new Flags();
                flags.add(MailMessage.getColorLabelStringValue(mail.getColorLabel()));
            }
            if (mail.containsUserFlags()) {
                String[] userFlags;
                if (null == flags) {
                    flags = new Flags();
                }
                for (String userFlag : userFlags = mail.getUserFlags()) {
                    flags.add(userFlag);
                }
            }
            if (null != flags) {
                mimeMessage.setFlags(flags, true);
            }
            return mimeMessage;
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(MailMessage mail, File tempFile) throws IOException, OXException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
            mail.writeTo(out);
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            throw throwable;
        }
        Streams.close((Closeable)out);
    }

    private static File checkForFile(MailMessage mail) {
        MimeMessage mimeMessage;
        if (mail instanceof MimeMailMessage && (mimeMessage = ((MimeMailMessage)mail).getMimeMessage()) instanceof ManagedMimeMessage) {
            return ((ManagedMimeMessage)mimeMessage).getFile();
        }
        return null;
    }

    public static Message convertComposedMailMessage(ComposedMailMessage composedMail) throws OXException {
        try {
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession());
            MimeMessageFiller filler = new MimeMessageFiller(composedMail.getSession(), composedMail.getContext());
            filler.setAccountId(composedMail.getAccountId());
            composedMail.setFiller(filler);
            filler.setMessageHeaders(composedMail, mimeMessage);
            filler.setCommonHeaders(mimeMessage);
            filler.fillMailBody(composedMail, mimeMessage, ComposeType.NEW);
            MimeMessageConverter.saveChanges(mimeMessage);
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static MailMessage fillComposedMailMessage(ComposedMailMessage composedMail) throws OXException {
        try {
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession());
            MimeMessageFiller filler = new MimeMessageFiller(composedMail.getSession(), composedMail.getContext());
            filler.setAccountId(composedMail.getAccountId());
            composedMail.setFiller(filler);
            filler.setMessageHeaders(composedMail, mimeMessage);
            filler.setCommonHeaders(mimeMessage);
            filler.fillMailBody(composedMail, mimeMessage, ComposeType.NEW);
            MimeMessageConverter.saveChanges(mimeMessage);
            return MimeMessageConverter.convertMessage(mimeMessage);
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static Multipart multipartFor(MimeMessage message) throws OXException {
        return MimeMessageConverter.multipartFor(message, MimeMessageConverter.getContentType((Part)message));
    }

    public static Multipart multipartFor(MimeMessage message, ContentType contentType) throws OXException {
        return MimeMessageConverter.multipartFor(message, contentType, true);
    }

    private static Multipart multipartFor(MimeMessage message, ContentType contentType, boolean reparse) throws OXException {
        try {
            return MimeMessageConverter.multipartFor(message.getContent(), contentType);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (ParseException e) {
            if (!reparse) {
                throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
            }
            try {
                String sContentType = message.getHeader(CONTENT_TYPE, null);
                message.setHeader(CONTENT_TYPE, new ContentType(sContentType).toString(true));
                MimeMessageConverter.saveChanges(message);
            }
            catch (Exception x) {
                LoggerFactory.getLogger(MimeFilter.class).debug("Content-Type cannot be sanitized.", (Throwable)x);
                throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
            }
            return MimeMessageConverter.multipartFor(message, contentType, false);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static ContentType getContentType(Part part) throws OXException {
        try {
            String[] tmp = part.getHeader(CONTENT_TYPE);
            return tmp != null && tmp.length > 0 ? new ContentType(tmp[0]) : new ContentType("text/plain; charset=us-ascii");
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static Multipart multipartFor(Object content, ContentType contentType) throws OXException {
        if (null == content) {
            return null;
        }
        if (content instanceof Multipart) {
            return (Multipart)content;
        }
        if (content instanceof InputStream) {
            try {
                return new MimeMultipart((DataSource)new MessageDataSource((InputStream)content, contentType));
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException(e);
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
        if (content instanceof String) {
            try {
                return new MimeMultipart((DataSource)new MessageDataSource((InputStream)Streams.newByteArrayInputStream((byte[])((String)content).getBytes(Charsets.ISO_8859_1)), contentType));
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException(e);
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
        throw MailExceptionCode.MESSAGING_ERROR.create("Content is not of type javax.mail.Multipart, but " + content.getClass().getName());
    }

    public static void saveChanges(MimeMessage mimeMessage, String hostName) throws OXException {
        try {
            String messageId;
            String name = "Message-ID";
            String prevMessageId = mimeMessage.getHeader(name, null);
            MimeMessageConverter.saveChanges(mimeMessage);
            if (null != prevMessageId) {
                mimeMessage.setHeader(name, prevMessageId);
            } else if (null != hostName && null != (messageId = mimeMessage.getHeader(name, null))) {
                int pos = messageId.indexOf(64);
                if (pos > 0) {
                    StringBuilder mid = new StringBuilder(messageId.substring(0, pos + 1)).append(hostName);
                    if (messageId.charAt(0) == '<') {
                        mid.append('>');
                    }
                    mimeMessage.setHeader(name, mid.toString());
                } else {
                    mimeMessage.setHeader(name, messageId + hostName);
                }
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static void saveChanges(MimeMessage mimeMessage) throws OXException {
        MimeMessageConverter.saveChanges(mimeMessage, true);
    }

    private static void saveChanges(MimeMessage mimeMessage, boolean trySanitizeMultipart) throws OXException {
        block8: {
            if (null == mimeMessage) {
                return;
            }
            try {
                try {
                    mimeMessage.saveChanges();
                }
                catch (ParseException e) {
                    MimeMessageConverter.sanitizeContentTypeHeaders((Part)mimeMessage, new ContentType());
                    mimeMessage.saveChanges();
                }
                catch (MessagingException e) {
                    if (!trySanitizeMultipart) {
                        throw MimeMailException.handleMessagingException(e);
                    }
                    String msg = MimeMessageConverter.toLowerCase(e.getMessage());
                    if (null != msg && msg.startsWith("mime part of type \"multipart/")) {
                        MimeMessageConverter.sanitizeMultipartContent((MimePart)mimeMessage);
                        MimeMessageConverter.saveChanges(mimeMessage, false);
                        break block8;
                    }
                    throw MimeMailException.handleMessagingException(e);
                }
            }
            catch (MessagingException e) {
                throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static boolean sanitizeMultipartContent(MimePart part) throws OXException {
        try {
            String sContentType = MimeMessageConverter.toLowerCase(part.getHeader("Content-Type", null));
            if (null != sContentType && sContentType.startsWith(MULTI_PRIMTYPE)) {
                Object o = part.getContent();
                if (o instanceof MimeMultipart) {
                    MimeMultipart multipart = (MimeMultipart)o;
                    int count = multipart.getCount();
                    for (int i = 0; i < count; ++i) {
                        if (MimeMessageConverter.sanitizeMultipartContent((MimePart)multipart.getBodyPart(i))) continue;
                        return false;
                    }
                    return true;
                }
                if (o instanceof InputStream) {
                    MimeMultipart multipart = new MimeMultipart((DataSource)new MessageDataSource((InputStream)o, sContentType));
                    part.setContent((Multipart)multipart);
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static void sanitizeContentTypeHeaders(Part part, ContentType sanitizer) throws OXException {
        DataHandler dh;
        try {
            dh = part.getDataHandler();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        if (dh == null) {
            return;
        }
        try {
            Object o;
            String type = dh.getContentType();
            sanitizer.setContentType(type);
            try {
                new javax.mail.internet.ContentType(type);
            }
            catch (ParseException e) {
                String cts = sanitizer.toString(true);
                try {
                    new javax.mail.internet.ContentType(cts);
                }
                catch (ParseException pe) {
                    throw MailExceptionCode.INVALID_CONTENT_TYPE.create(e, type);
                }
                part.setDataHandler((DataHandler)new DataHandlerWrapper(dh, cts));
                part.setHeader("Content-Type", cts);
            }
            if (sanitizer.startsWith(MULTI_PRIMTYPE) && (o = dh.getContent()) instanceof MimeMultipart) {
                MimeMultipart mm = (MimeMultipart)o;
                int count = mm.getCount();
                for (int i = 0; i < count; ++i) {
                    MimeMessageConverter.sanitizeContentTypeHeaders((Part)mm.getBodyPart(i), sanitizer);
                }
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static void parseMimeFlags(int flags, Message msg) throws MessagingException {
        Flags flagsObj = new Flags();
        if ((flags & 1) > 0) {
            flagsObj.add(Flags.Flag.ANSWERED);
        }
        if ((flags & 2) > 0) {
            flagsObj.add(Flags.Flag.DELETED);
        }
        if ((flags & 4) > 0) {
            flagsObj.add(Flags.Flag.DRAFT);
        }
        if ((flags & 8) > 0) {
            flagsObj.add(Flags.Flag.FLAGGED);
        }
        if ((flags & 0x10) > 0) {
            flagsObj.add(Flags.Flag.RECENT);
        }
        if ((flags & 0x20) > 0) {
            flagsObj.add(Flags.Flag.SEEN);
        }
        if ((flags & 0x40) > 0) {
            flagsObj.add(Flags.Flag.USER);
        }
        if ((flags & 0x100) > 0) {
            flagsObj.add("$Forwarded");
        }
        if ((flags & 0x200) > 0) {
            flagsObj.add("$MDNSent");
        }
        msg.setFlags(flagsObj, true);
    }

    public static MailMessage[] convertMessages(Message[] msgs, MailField[] fields) throws OXException {
        return MimeMessageConverter.convertMessages(msgs, fields, null, false);
    }

    public static MailMessage[] convertMessages(Message[] msgs, MailField[] fields, String[] headerNames, boolean includeBody) throws OXException {
        try {
            ArrayList<MailMessageFieldFiller> tmp = new ArrayList<MailMessageFieldFiller>(Arrays.asList(MimeMessageConverter.createFieldFillers(fields)));
            if (null != headerNames) {
                for (String headerName : headerNames) {
                    tmp.add(new HeaderFieldFiller(headerName));
                }
            }
            MailMessageFieldFiller[] fillers = tmp.toArray(new MailMessageFieldFiller[tmp.size()]);
            MailMessage[] mails = new MimeMailMessage[msgs.length];
            for (int i = 0; i < mails.length; ++i) {
                if (null == msgs[i]) continue;
                mails[i] = includeBody ? new MimeMailMessage((MimeMessage)msgs[i]) : new MimeMailMessage();
                MimeMessageConverter.fillMessage(fillers, mails[i], msgs[i]);
            }
            return mails;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    public static MailMessage[] convertMessages(Message[] msgs, Folder folder, MailField[] fields, boolean includeBody) throws OXException {
        try {
            MailMessageFieldFiller[] fillers = MimeMessageConverter.createFieldFillers(folder, fields);
            MailMessage[] mails = new MimeMailMessage[msgs.length];
            for (int i = 0; i < mails.length; ++i) {
                if (null == msgs[i]) continue;
                mails[i] = includeBody ? new MimeMailMessage((MimeMessage)msgs[i]) : new MimeMailMessage();
                MimeMessageConverter.fillMessage(fillers, mails[i], msgs[i]);
            }
            return mails;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    private static void fillMessage(MailMessageFieldFiller[] fillers, MailMessage mailMessage, Message msg) throws OXException, MessagingException {
        for (MailMessageFieldFiller filler : fillers) {
            if (null == filler) continue;
            filler.fillField(mailMessage, msg);
        }
    }

    private static MailMessageFieldFiller[] createFieldFillers(MailField[] fields) throws OXException {
        List<MailField> list = Arrays.asList(fields);
        EnumSet<MailField> fieldSet = list.isEmpty() ? EnumSet.noneOf(MailField.class) : EnumSet.copyOf(list);
        MailField[] arr = fieldSet.contains((Object)MailField.FULL) ? ENUM_SET_FULL.toArray(new MailField[ENUM_SET_FULL.size()]) : fields;
        MailMessageFieldFiller[] fillers = new MailMessageFieldFiller[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            MailField field = arr[i];
            MailMessageFieldFiller filler = FILLER_MAP_EXT.get((Object)field);
            if (filler == null) {
                if (MailField.BODY.equals((Object)field) || MailField.FULL.equals((Object)field) || MailField.ACCOUNT_NAME.equals((Object)field)) {
                    LOG.debug("Ignoring mail field {}", (Object)field);
                    fillers[i] = null;
                    continue;
                }
                throw MailExceptionCode.INVALID_FIELD.create(field.toString());
            }
            fillers[i] = filler;
        }
        return fillers;
    }

    public static void checkFieldExistence(MailMessage[] mails, MailField[] fields) {
        if (null == mails) {
            return;
        }
        for (MailField field : fields) {
            ExistenceChecker checker = CHECKER_MAP.get((Object)field);
            if (null == checker) continue;
            checker.check(mails);
        }
    }

    private static MailMessageFieldFiller[] createFieldFillers(Folder folder, MailField[] fields) throws OXException {
        List<MailField> list = Arrays.asList(fields);
        EnumSet<MailField> fieldSet = list.isEmpty() ? EnumSet.noneOf(MailField.class) : EnumSet.copyOf(list);
        MailField[] arr = fieldSet.contains((Object)MailField.FULL) ? ENUM_SET_FULL.toArray(new MailField[ENUM_SET_FULL.size()]) : fields;
        MailMessageFieldFiller[] fillers = new MailMessageFieldFiller[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            MailField field = arr[i];
            MailMessageFieldFiller filler = FILLER_MAP.get((Object)field);
            if (filler == null) {
                if (MailField.ID.equals((Object)field)) {
                    fillers[i] = new ExtendedMailMessageFieldFiller(folder){

                        @Override
                        public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                            if (this.folder instanceof UIDFolder) {
                                mailMessage.setMailId(Long.toString(((UIDFolder)this.folder).getUID(msg)));
                            } else if (this.folder instanceof FullnameFolder) {
                                mailMessage.setMailId(((FullnameFolder)this.folder).getUID(msg));
                            } else if (this.folder instanceof POP3Folder) {
                                mailMessage.setMailId(((POP3Folder)this.folder).getUID(msg));
                            }
                        }
                    };
                    continue;
                }
                if (MailField.FOLDER_ID.equals((Object)field)) {
                    fillers[i] = new ExtendedMailMessageFieldFiller(folder){

                        @Override
                        public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                            mailMessage.setFolder(this.folder.getFullName());
                        }
                    };
                    continue;
                }
                if (MailField.BODY.equals((Object)field) || MailField.FULL.equals((Object)field) || MailField.ACCOUNT_NAME.equals((Object)field)) {
                    LOG.debug("Ignoring mail field {}", (Object)field);
                    fillers[i] = null;
                    continue;
                }
                throw MailExceptionCode.INVALID_FIELD.create(field.toString());
            }
            fillers[i] = filler;
        }
        return fillers;
    }

    public static MailMessage newMailMessage() {
        return new MimeMailMessage();
    }

    public static MailMessage convertMessage(InputStream in) throws OXException {
        try {
            return MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), in));
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static MailMessage convertMessage(byte[] asciiBytes) throws OXException {
        try {
            return MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(asciiBytes)));
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static MailMessage convertMessage(MimeMessage msg) throws OXException {
        return MimeMessageConverter.convertMessage(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailMessage convertMessage(MimeMessage msg, boolean considerFolder) throws OXException {
        MimeMailMessage mail = new MimeMailMessage(msg);
        try {
            Folder f;
            MimeMessageConverter.parseFlags(msg.getFlags(), mail);
            if (!mail.containsColorLabel()) {
                mail.setColorLabel(0);
            }
            if (considerFolder && (f = msg.getFolder()) != null) {
                boolean openFolder;
                mail.setFolder(f.getFullName());
                boolean bl = openFolder = !f.isOpen();
                if (openFolder) {
                    f.open(1);
                }
                try {
                    if (f instanceof UIDFolder) {
                        mail.setMailId(Long.toString(((UIDFolder)f).getUID((Message)msg)));
                    } else if (f instanceof FullnameFolder) {
                        mail.setMailId(((FullnameFolder)f).getUID((Message)msg));
                    } else if (f instanceof POP3Folder) {
                        mail.setMailId(((POP3Folder)f).getUID((Message)msg));
                    }
                }
                finally {
                    if (openFolder) {
                        f.close(false);
                    }
                }
                mail.setUnreadMessages(f.getUnreadMessageCount());
            }
            MimeMessageConverter.setHeaders((Part)msg, mail);
            mail.addFrom(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_FROM, mail));
            mail.addTo(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_TO, mail));
            mail.addCc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_CC, mail));
            mail.addBcc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_BCC, mail));
            mail.addReplyTo(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_REPLY_TO, mail));
            Object tmp = mail.getHeader(CONTENT_TYPE);
            if (tmp != null && ((String[])tmp).length > 0) {
                mail.setContentType(MimeMessageUtility.decodeMultiEncodedHeader(tmp[0]));
            } else {
                mail.setContentType("text/plain; charset=us-ascii");
            }
            ContentType ct = mail.getContentType();
            if (ct.startsWith(MULTI_PRIMTYPE)) {
                if (MULTI_SUBTYPE_MIXED.equalsIgnoreCase(ct.getSubType())) {
                    mail.setHasAttachment(true);
                } else if (MULTI_SUBTYPE_ALTERNATIVE.equalsIgnoreCase(ct.getSubType())) {
                    mail.setHasAttachment(mail.getEnclosedCount() > 2);
                } else {
                    Object content = null;
                    try {
                        content = msg.getContent();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (null == content) {
                        mail.setHasAttachment(false);
                    } else {
                        try {
                            mail.setHasAttachment(MimeMessageUtility.hasAttachments(mail, ct.getSubType()));
                        }
                        catch (OXException e) {
                            if (!MailExceptionCode.MESSAGING_ERROR.equals(e)) {
                                throw e;
                            }
                            LOG.debug("Parsing message's multipart/* content to check for file attachments caused a messaging error.\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.", (Throwable)e);
                            mail.setHasAttachment(ct.startsWith("multipart/mixed"));
                        }
                        catch (ClassCastException e) {
                            LOG.debug("Message's Content-Type indicates to be multipart/* but its content is not an instance of javax.mail.Multipart but {}.\nIn case if IMAP it is due to a wrong BODYSTRUCTURE returned by IMAP server.\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.", (Object)content.getClass().getName());
                            mail.setHasAttachment(ct.startsWith("multipart/mixed"));
                        }
                        catch (MessagingException e) {
                            LOG.debug("Parsing message's multipart/* content to check for file attachments caused a messaging error: {}.\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.", (Object)e.getMessage());
                            mail.setHasAttachment(ct.startsWith("multipart/mixed"));
                        }
                    }
                }
            } else {
                mail.setHasAttachment(false);
            }
            tmp = mail.getHeader(MessageHeaders.HDR_CONTENT_ID);
            if (tmp != null && ((String[])tmp).length > 0) {
                mail.setContentId(tmp[0]);
            } else {
                mail.setContentId(null);
            }
            tmp = mail.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, null);
            if (tmp != null && ((String)tmp).length() > 0) {
                mail.setContentDisposition(MimeMessageUtility.decodeMultiEncodedHeader((String)tmp));
            } else {
                mail.setContentDisposition((String)null);
            }
            String dispNot = mail.getHeader(MessageHeaders.HDR_DISP_NOT_TO, null);
            if (dispNot == null) {
                mail.setDispositionNotification(null);
            } else {
                InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                mail.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
            }
            String msgrefStr = mail.getHeader(MessageHeaders.HDR_X_OXMSGREF, null);
            if (msgrefStr == null) {
                mail.setMsgref(null);
            } else {
                mail.setMsgref(new MailPath(msgrefStr));
                mail.removeHeader(MessageHeaders.HDR_X_OXMSGREF);
                try {
                    msg.removeHeader(MessageHeaders.HDR_X_OXMSGREF);
                }
                catch (Exception e) {
                    LOG.debug(STR_EMPTY, (Throwable)e);
                }
            }
            mail.setFileName(MimeMessageUtility.getFileName(mail));
            String importance = mail.getFirstHeader(MessageHeaders.HDR_IMPORTANCE);
            if (null != importance) {
                MimeMessageConverter.parseImportance(importance, mail);
            } else {
                MimeMessageConverter.parsePriority(mail.getFirstHeader(MessageHeaders.HDR_X_PRIORITY), mail);
            }
            Date receivedDate = msg.getReceivedDate();
            if (receivedDate == null) {
                mail.setReceivedDate(null);
            } else {
                mail.setReceivedDate(receivedDate);
            }
            mail.setSentDate(MimeMessageConverter.getSentDate(mail));
            try {
                mail.setSize(msg.getSize());
            }
            catch (Exception e) {
                LOG.debug("Message's size could not be obtained.", (Throwable)e);
                mail.setSize(-1L);
            }
            mail.setSubject(MimeMessageConverter.getSubject(mail));
            mail.setThreadLevel(0);
            return mail;
        }
        catch (MessageRemovedException e) {
            String mailId;
            String[] sa = MimeMessageConverter.getFolderAndIdSafe(msg);
            String folder = null == sa ? null : sa[0];
            String string = mailId = null == sa ? null : sa[1];
            if (null != folder && null != mailId) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(e, mailId, folder);
            }
            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getFolderAndIdSafe(MimeMessage msg) {
        block12: {
            try {
                boolean openFolder;
                Folder f = msg.getFolder();
                if (f == null) break block12;
                String[] ret = new String[2];
                ret[0] = f.getFullName();
                boolean bl = openFolder = !f.isOpen();
                if (openFolder) {
                    f.open(1);
                }
                try {
                    if (f instanceof UIDFolder) {
                        ret[1] = Long.toString(((UIDFolder)f).getUID((Message)msg));
                    } else if (f instanceof FullnameFolder) {
                        ret[1] = ((FullnameFolder)f).getUID((Message)msg);
                    } else if (f instanceof POP3Folder) {
                        ret[1] = ((POP3Folder)f).getUID((Message)msg);
                    }
                }
                finally {
                    if (openFolder) {
                        f.close(false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static MailMessage convertMessage(byte[] asciiBytes, String uid, String fullname, char separator, MailField[] fields) throws OXException {
        try {
            return MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(asciiBytes)), uid, fullname, separator, fields);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static MailMessage convertMessage(MimeMessage msg, String uid, String fullname, char separator, MailField[] fields) throws OXException {
        MailFields set = new MailFields(fields);
        if (set.contains(MailField.FULL)) {
            MailMessage mail = MimeMessageConverter.convertMessage(msg);
            mail.setMailId(uid);
            mail.setFolder(fullname);
            return mail;
        }
        try {
            MailMessageFieldFiller[] fillers = MimeMessageConverter.createFieldFillers(new FullnameFolder(fullname, separator, uid), fields);
            MimeMailMessage mail = set.contains(MailField.BODY) ? new MimeMailMessage(msg) : new MimeMailMessage();
            MimeMessageConverter.fillMessage(fillers, mail, (Message)msg);
            return mail;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    public static MailPart convertPart(byte[] asciiBytes) throws OXException {
        try {
            return MimeMessageConverter.convertPart((Part)new MimeBodyPart((InputStream)new UnsynchronizedByteArrayInputStream(asciiBytes)), false);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static MailPart convertPart(Part part) throws OXException {
        return MimeMessageConverter.convertPart(part, true);
    }

    public static MailPart convertPart(Part part, boolean enforeSize) throws OXException {
        try {
            int size;
            String[] msgrefStr;
            String[] tmp;
            MimeMailPart mailPart = new MimeMailPart(part);
            MimeMessageConverter.setHeaders(part, mailPart);
            String[] contentTypeHdr = mailPart.getHeader(CONTENT_TYPE);
            if (null != contentTypeHdr && contentTypeHdr.length > 0) {
                mailPart.setContentType(MimeMessageUtility.decodeMultiEncodedHeader(contentTypeHdr[0]));
            }
            if ((tmp = mailPart.getHeader(MessageHeaders.HDR_CONTENT_ID)) != null && tmp.length > 0) {
                mailPart.setContentId(tmp[0]);
            }
            if ((tmp = mailPart.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION)) != null && tmp.length > 0) {
                mailPart.setContentDisposition(MimeMessageUtility.decodeMultiEncodedHeader(tmp[0]));
            }
            if ((msgrefStr = mailPart.getHeader(MessageHeaders.HDR_X_OXMSGREF)) != null && msgrefStr.length > 0) {
                mailPart.setMsgref(new MailPath(msgrefStr[0]));
                mailPart.removeHeader(MessageHeaders.HDR_X_OXMSGREF);
                try {
                    part.removeHeader(MessageHeaders.HDR_X_OXMSGREF);
                }
                catch (Exception e) {
                    LOG.debug(STR_EMPTY, (Throwable)e);
                }
            } else {
                mailPart.setMsgref(null);
            }
            mailPart.setFileName(MimeMessageUtility.getFileName(mailPart));
            try {
                size = part.getSize();
            }
            catch (Exception e) {
                size = -1;
            }
            if (size == -1 && enforeSize) {
                String tansferEnc = mailPart.getHeader(MessageHeaders.HDR_CONTENT_TRANSFER_ENC, null);
                try {
                    size = MimeMessageConverter.estimateSize(part.getInputStream(), tansferEnc);
                }
                catch (IOException e) {
                    try {
                        if (part instanceof MimeBodyPart) {
                            size = MimeMessageConverter.estimateSize(((MimeBodyPart)part).getRawInputStream(), tansferEnc);
                        } else if (part instanceof MimeMessage) {
                            size = MimeMessageConverter.estimateSize(((MimeMessage)part).getRawInputStream(), tansferEnc);
                        } else {
                            LOG.warn("{}'s size cannot be determined", (Object)part.getClass().getCanonicalName(), (Object)e);
                        }
                    }
                    catch (IOException e1) {
                        LOG.warn("{}'s size cannot be determined", (Object)part.getClass().getCanonicalName(), (Object)e1);
                    }
                    catch (MessagingException e1) {
                        LOG.warn("{}'s size cannot be determined", (Object)part.getClass().getCanonicalName(), (Object)e1);
                    }
                }
            }
            mailPart.setSize(size);
            return mailPart;
        }
        catch (MessageRemovedException e) {
            String mailId;
            String[] sa = part instanceof MimeMessage ? MimeMessageConverter.getFolderAndIdSafe((MimeMessage)part) : null;
            String folder = null == sa ? null : sa[0];
            String string = mailId = null == sa ? null : sa[1];
            if (null != folder && null != mailId) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(e, mailId, folder);
            }
            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    public static Flags convertMailFlags(int flags) {
        Flags flagsObj = new Flags();
        if ((flags & 1) == 1) {
            flagsObj.add(Flags.Flag.ANSWERED);
        }
        if ((flags & 2) == 2) {
            flagsObj.add(Flags.Flag.DELETED);
        }
        if ((flags & 4) == 4) {
            flagsObj.add(Flags.Flag.DRAFT);
        }
        if ((flags & 8) == 8) {
            flagsObj.add(Flags.Flag.FLAGGED);
        }
        if ((flags & 0x10) == 16) {
            flagsObj.add(Flags.Flag.RECENT);
        }
        if ((flags & 0x20) == 32) {
            flagsObj.add(Flags.Flag.SEEN);
        }
        if ((flags & 0x40) == 64) {
            flagsObj.add(Flags.Flag.USER);
        }
        return flagsObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int estimateSize(InputStream in, String tansferEnc) throws IOException {
        try {
            if (ENC_BASE64.equalsIgnoreCase(tansferEnc)) {
                int n = (int)((double)in.available() * 0.65);
                return n;
            }
            int n = in.available();
            return n;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public static void parseFlags(Flags flags, MailMessage mailMessage) throws OXException {
        String[] userFlags;
        int retval = 0;
        if (flags.contains(Flags.Flag.ANSWERED)) {
            retval |= 1;
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            retval |= 2;
        }
        if (flags.contains(Flags.Flag.DRAFT)) {
            retval |= 4;
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            retval |= 8;
        }
        if (flags.contains(Flags.Flag.RECENT)) {
            retval |= 0x10;
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            retval |= 0x20;
        }
        if (flags.contains(Flags.Flag.USER)) {
            retval |= 0x40;
        }
        if ((userFlags = flags.getUserFlags()) != null) {
            mailMessage.addUserFlags(EMPTY_STRS);
            for (String userFlag : userFlags) {
                if (MailMessage.isColorLabel(userFlag)) {
                    mailMessage.setColorLabel(MailMessage.getColorLabelIntValue(userFlag));
                    continue;
                }
                if ("$Forwarded".equalsIgnoreCase(userFlag)) {
                    retval |= 0x100;
                    continue;
                }
                if ("$MDNSent".equalsIgnoreCase(userFlag)) {
                    retval |= 0x200;
                    continue;
                }
                mailMessage.addUserFlag(userFlag);
            }
        }
        mailMessage.setFlags(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean useMime4j() {
        Boolean tmp = enableMime4j;
        if (null != tmp) return tmp;
        Class<MimeMessageConverter> clazz = MimeMessageConverter.class;
        synchronized (MimeMessageConverter.class) {
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            enableMime4j = tmp = Boolean.valueOf(null == service ? false : service.getBoolProperty("com.openexchange.mail.mime.enableMime4j", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static void setHeaders(Part part, MailPart mailPart) throws OXException {
        HeaderCollection headers;
        block24: {
            headers = null;
            try {
                headers = new HeaderCollection(128);
                if (MimeMessageConverter.useMime4j() && part instanceof IMAPMessage) {
                    HeaderContentHandler handler = new HeaderContentHandler(headers);
                    MimeConfig config = new MimeConfig();
                    config.setMaxLineLen(-1);
                    config.setMaxHeaderLen(-1);
                    config.setMaxHeaderCount(-1);
                    MimeStreamParser parser = new MimeStreamParser(config);
                    parser.setContentHandler((ContentHandler)handler);
                    try {
                        HeaderOutputStream out = new HeaderOutputStream();
                        part.writeTo((OutputStream)out);
                        UnsynchronizedByteArrayInputStream in = new UnsynchronizedByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        out = null;
                        parser.parse((InputStream)in);
                        break block24;
                    }
                    catch (IOException e1) {
                        LOG.warn("Unable to parse headers. Assuming no headers...", (Throwable)e1);
                        headers = new HeaderCollection(0);
                        break block24;
                    }
                    catch (MimeException e1) {
                        if (!((Object)((Object)HeaderContentHandler.END_HEADER_EXCEPTION)).equals((Object)e1)) {
                            throw new MessagingException(e1.getMessage(), (Exception)((Object)e1));
                        }
                        break block24;
                    }
                }
                Enumeration e = part.getAllHeaders();
                while (e.hasMoreElements()) {
                    Header h = (Header)e.nextElement();
                    String value = h.getValue();
                    if (value == null || MimeMessageConverter.isEmpty(value)) {
                        headers.addHeader(h.getName(), STR_EMPTY);
                        continue;
                    }
                    headers.addHeader(h.getName(), MimeMessageUtility.unfold(value));
                }
            }
            catch (MessageRemovedException e) {
                String mailId;
                String[] sa = part instanceof MimeMessage ? MimeMessageConverter.getFolderAndIdSafe((MimeMessage)part) : null;
                String folder = null == sa ? null : sa[0];
                String string = mailId = null == sa ? null : sa[1];
                if (null != folder && null != mailId) {
                    throw MailExceptionCode.MAIL_NOT_FOUND.create(e, mailId, folder);
                }
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            catch (MessagingException e) {
                LOG.debug("JavaMail API failed to load part's headers. Using own routine.", (Throwable)e);
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
                try {
                    part.writeTo((OutputStream)out);
                    headers = MimeMessageConverter.loadHeaders(new String(out.toByteArray(), Charsets.ISO_8859_1));
                }
                catch (MessageRemovedIOException e2) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e2, new Object[0]);
                }
                catch (IOException e2) {
                    LOG.warn("Unable to parse headers. Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
                catch (MessageRemovedException e2) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e2, new Object[0]);
                }
                catch (MessagingException e2) {
                    LOG.warn("Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
                catch (RuntimeException e2) {
                    LOG.warn("Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
            }
            catch (RuntimeException e) {
                LOG.debug("JavaMail API failed to load part's headers. Using own routine.", (Throwable)e);
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
                try {
                    part.writeTo((OutputStream)out);
                    headers = MimeMessageConverter.loadHeaders(new String(out.toByteArray(), Charsets.ISO_8859_1));
                }
                catch (MessageRemovedIOException e2) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e2, new Object[0]);
                }
                catch (IOException e2) {
                    LOG.warn("Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
                catch (MessageRemovedException e2) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e2, new Object[0]);
                }
                catch (MessagingException e2) {
                    LOG.warn("Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
                catch (RuntimeException e2) {
                    LOG.warn("Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
            }
        }
        mailPart.addHeaders(headers);
    }

    public static HeaderCollection loadHeaders(InputStream inputStream) throws IOException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
        byte[] bbuf = new byte[8192];
        int read = -1;
        while ((read = inputStream.read(bbuf, 0, bbuf.length)) > 0) {
            out.write(bbuf, 0, read);
        }
        return MimeMessageConverter.loadHeaders(out.toByteArray());
    }

    public static HeaderCollection loadHeaders(byte[] bytes) {
        return MimeMessageConverter.loadHeaders(new String(bytes, Charsets.ISO_8859_1));
    }

    public static HeaderCollection loadHeaders(String messageSrc) {
        int i;
        int len = messageSrc.length();
        block0: for (i = 0; i < len; ++i) {
            char c = messageSrc.charAt(i);
            int prevPos = i;
            int count = 0;
            while (c == '\r' || c == '\n') {
                if (c == '\n' && ++count >= 2) {
                    i = prevPos;
                    break block0;
                }
                if (++i >= len) {
                    i = prevPos;
                    break block0;
                }
                c = messageSrc.charAt(i);
            }
        }
        Matcher m = PATTERN_PARSE_HEADER.matcher(MimeMessageUtility.unfold(messageSrc.substring(0, i)));
        HeaderCollection headers = new HeaderCollection();
        while (m.find()) {
            String value = m.group(2);
            if (value == null || MimeMessageConverter.isEmpty(value)) {
                headers.addHeader(m.group(1), STR_EMPTY);
                continue;
            }
            headers.addHeader(m.group(1), value);
        }
        return headers;
    }

    private static boolean isEmpty(String value) {
        int length = value.length();
        boolean empty = true;
        for (int i = 0; empty && i < length; ++i) {
            char c = value.charAt(i);
            empty = c == ' ' || c == '\t';
        }
        return empty;
    }

    public static String getSubject(Message message) throws MessagingException {
        String[] valueArr = message.getHeader(MessageHeaders.HDR_SUBJECT);
        if (null == valueArr || valueArr.length == 0) {
            return null;
        }
        return MimeMessageUtility.decodeEnvelopeSubject(valueArr[0]);
    }

    public static String getSubject(MailMessage message) {
        String[] valueArr = message.getHeader(MessageHeaders.HDR_SUBJECT);
        if (null == valueArr || valueArr.length == 0) {
            return null;
        }
        return MimeMessageUtility.decodeEnvelopeSubject(valueArr[0]);
    }

    public static String getStringHeader(String name, Message message) throws MessagingException {
        return MimeMessageConverter.getStringHeader(name, message, '\u0000');
    }

    public static String getStringHeader(String name, MailMessage message) {
        return MimeMessageConverter.getStringHeader(name, message, '\u0000');
    }

    public static String getStringHeader(String name, Message message, char delimiter) throws MessagingException {
        String values;
        String[] valueArr = message.getHeader(name);
        if (null == valueArr || valueArr.length == 0) {
            return null;
        }
        if ('\u0000' != delimiter && valueArr.length > 1) {
            StringBuilder sb = new StringBuilder(valueArr[0]);
            for (int i = 1; i < valueArr.length; ++i) {
                sb.append(delimiter).append(valueArr[i]);
            }
            values = sb.toString();
        } else {
            values = valueArr[0];
        }
        return MimeMessageUtility.decodeMultiEncodedHeader(values);
    }

    public static String getStringHeader(String name, MailMessage message, char delimiter) {
        String values;
        String[] valueArr = message.getHeader(name);
        if (null == valueArr || valueArr.length == 0) {
            return null;
        }
        if ('\u0000' != delimiter && valueArr.length > 1) {
            StringBuilder sb = new StringBuilder(valueArr[0]);
            for (int i = 1; i < valueArr.length; ++i) {
                sb.append(delimiter).append(valueArr[i]);
            }
            values = sb.toString();
        } else {
            values = valueArr[0];
        }
        return MimeMessageUtility.decodeMultiEncodedHeader(values);
    }

    public static InternetAddress[] getAddressHeader(String name, Message message) throws MessagingException {
        String addresses;
        String[] addressArray = message.getHeader(name);
        if (null == addressArray || addressArray.length == 0) {
            return null;
        }
        if (addressArray.length > 1) {
            StringBuilder sb = new StringBuilder(addressArray[0]);
            for (int i = 1; i < addressArray.length; ++i) {
                sb.append(',').append(addressArray[i]);
            }
            addresses = sb.toString();
        } else {
            addresses = addressArray[0];
        }
        try {
            return QuotedInternetAddress.parseHeader(addresses, true);
        }
        catch (AddressException e) {
            return MimeMessageConverter.getAddressHeaderNonStrict(addresses, addressArray);
        }
    }

    public static InternetAddress[] getAddressHeader(String name, MailMessage message) {
        String addresses;
        String[] addressArray = message.getHeader(name);
        if (null == addressArray || addressArray.length == 0) {
            return null;
        }
        if (addressArray.length > 1) {
            StringBuilder sb = new StringBuilder(addressArray[0]);
            for (int i = 1; i < addressArray.length; ++i) {
                sb.append(',').append(addressArray[i]);
            }
            addresses = sb.toString();
        } else {
            addresses = addressArray[0];
        }
        try {
            return QuotedInternetAddress.parseHeader(addresses, true);
        }
        catch (AddressException e) {
            return MimeMessageConverter.getAddressHeaderNonStrict(addresses, addressArray);
        }
    }

    private static InternetAddress[] getAddressHeaderNonStrict(String addressStrings, String[] addressArray) {
        try {
            InternetAddress[] addresses = QuotedInternetAddress.parseHeader(addressStrings, false);
            ArrayList<InternetAddress> addressList = new ArrayList<InternetAddress>(addresses.length);
            for (InternetAddress internetAddress : addresses) {
                try {
                    addressList.add(new QuotedInternetAddress(internetAddress.toString()));
                }
                catch (AddressException e) {
                    addressList.add(internetAddress);
                }
            }
            return addressList.toArray(new InternetAddress[addressList.size()]);
        }
        catch (AddressException e) {
            LOG.debug("Internet addresses could not be properly parsed. Using plain addresses' string representation instead.", (Throwable)e);
            return MimeMessageConverter.getAddressesOnParseError(addressArray);
        }
    }

    public static InternetAddress[] getAddressHeader(String addresses) {
        try {
            return QuotedInternetAddress.parseHeader(addresses, true);
        }
        catch (AddressException e) {
            LOG.debug("Internet addresses could not be properly parsed. Using plain addresses' string representation instead.", (Throwable)e);
            return new InternetAddress[]{new PlainTextAddress(addresses)};
        }
    }

    private static InternetAddress[] getAddressesOnParseError(String[] addrs) {
        InternetAddress[] retval = new InternetAddress[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            retval[i] = new PlainTextAddress(addrs[i]);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getSentDate(MailPart part) {
        String s = part.getHeader("Date", null);
        if (s != null) {
            try {
                MailDateFormat mailDateFormat;
                MailDateFormat mailDateFormat2 = mailDateFormat = MimeMessageUtility.getDefaultMailDateFormat();
                synchronized (mailDateFormat2) {
                    return mailDateFormat.parse(s);
                }
            }
            catch (java.text.ParseException pex) {
                return null;
            }
        }
        return null;
    }

    public static void parsePriority(String priorityStr, MailMessage mailMessage) {
        mailMessage.setPriority(MimeMessageConverter.parsePriority(priorityStr));
    }

    public static void parseImportance(String importance, MailMessage mailMessage) {
        mailMessage.setPriority(MimeMessageConverter.parseImportance(importance));
    }

    public static int parsePriority(String priorityStr) {
        int priority = 3;
        if (null != priorityStr) {
            String[] tmp = priorityStr.split(" +");
            try {
                priority = Integer.parseInt(tmp[0]);
            }
            catch (NumberFormatException nfe) {
                LOG.debug("Assuming priority NORMAL due to strange X-Priority header: {}", (Object)priorityStr);
                priority = 3;
            }
        }
        return priority;
    }

    public static int parseImportance(String importance) {
        int priority = 3;
        if (null != importance) {
            String imp = importance.trim();
            if ("Low".equalsIgnoreCase(imp)) {
                priority = 5;
            } else if ("Medium".equalsIgnoreCase(imp) || "Normal".equalsIgnoreCase(imp)) {
                priority = 3;
            } else if ("High".equalsIgnoreCase(imp)) {
                priority = 1;
            } else {
                LOG.debug("Assuming priority NORMAL due to strange Importance header: {}", (Object)importance);
                priority = 3;
            }
        }
        return priority;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    static {
        final Logger logger = LOG;
        CHECKER_MAP = new EnumMap(MailField.class);
        final InternetAddress empty = null;
        CHECKER_MAP.put(MailField.FROM, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsFrom()) continue;
                    mailMessage.addFrom(empty);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsFrom()) continue;
                    mailMessage.addFrom(empty);
                }
            }
        });
        CHECKER_MAP.put(MailField.TO, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsTo()) continue;
                    mailMessage.addTo(empty);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsTo()) continue;
                    mailMessage.addTo(empty);
                }
            }
        });
        CHECKER_MAP.put(MailField.CC, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsCc()) continue;
                    mailMessage.addCc(empty);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsCc()) continue;
                    mailMessage.addCc(empty);
                }
            }
        });
        CHECKER_MAP.put(MailField.BCC, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsBcc()) continue;
                    mailMessage.addBcc(empty);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsBcc()) continue;
                    mailMessage.addBcc(empty);
                }
            }
        });
        CHECKER_MAP.put(MailField.SUBJECT, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsSubject()) continue;
                    mailMessage.setSubject(null);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsSubject()) continue;
                    mailMessage.setSubject(null);
                }
            }
        });
        CHECKER_MAP.put(MailField.SENT_DATE, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsSentDate()) continue;
                    mailMessage.setSentDate(null);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsSentDate()) continue;
                    mailMessage.setSentDate(null);
                }
            }
        });
        CHECKER_MAP.put(MailField.DISPOSITION_NOTIFICATION_TO, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsDispositionNotification()) continue;
                    mailMessage.setDispositionNotification(null);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsDispositionNotification()) continue;
                    mailMessage.setDispositionNotification(null);
                }
            }
        });
        CHECKER_MAP.put(MailField.PRIORITY, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsPriority()) continue;
                    mailMessage.setPriority(3);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsPriority()) continue;
                    mailMessage.setPriority(3);
                }
            }
        });
        CHECKER_MAP.put(MailField.THREAD_LEVEL, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsThreadLevel()) continue;
                    mailMessage.setThreadLevel(0);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsThreadLevel()) continue;
                    mailMessage.setThreadLevel(0);
                }
            }
        });
        FILLER_MAP_EXT.put(MailField.HEADERS, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] references;
                int j;
                ExtendedMimeMessage extMimeMessage = (ExtendedMimeMessage)msg;
                mailMessage.addFrom(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_FROM, (Message)extMimeMessage));
                mailMessage.addTo(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_TO, (Message)extMimeMessage));
                mailMessage.addCc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_CC, (Message)extMimeMessage));
                mailMessage.addBcc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_BCC, (Message)extMimeMessage));
                mailMessage.addReplyTo(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_REPLY_TO, (Message)extMimeMessage));
                String dispNot = extMimeMessage.getHeader(MessageHeaders.HDR_DISP_NOT_TO, null);
                if (dispNot == null) {
                    mailMessage.setDispositionNotification(null);
                } else {
                    InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                    mailMessage.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
                }
                mailMessage.setSubject(MimeMessageConverter.getSubject(msg));
                mailMessage.setSentDate(extMimeMessage.getSentDate());
                mailMessage.setPriority(extMimeMessage.getPriority());
                String messageId = extMimeMessage.getHeader(MessageHeaders.HDR_MESSAGE_ID, null);
                if (null != messageId) {
                    mailMessage.addHeader(MessageHeaders.HDR_MESSAGE_ID, messageId);
                }
                StringBuilder sb = new StringBuilder(128);
                String[] inReplyTo = extMimeMessage.getHeader(MessageHeaders.HDR_IN_REPLY_TO);
                if (null != inReplyTo) {
                    sb.append(inReplyTo[0]);
                    for (j = 1; j < inReplyTo.length; ++j) {
                        sb.append(", ").append(inReplyTo[j]);
                    }
                    mailMessage.addHeader(MessageHeaders.HDR_IN_REPLY_TO, sb.toString());
                    sb.setLength(0);
                }
                if (null != (references = extMimeMessage.getHeader(MessageHeaders.HDR_REFERENCES))) {
                    sb.append(references[0]);
                    for (j = 1; j < references.length; ++j) {
                        sb.append(", ").append(references[j]);
                    }
                    mailMessage.addHeader(MessageHeaders.HDR_REFERENCES, sb.toString());
                    sb.setLength(0);
                }
                Enumeration e = msg.getNonMatchingHeaders(ALREADY_INSERTED_HEADERS);
                while (e.hasMoreElements()) {
                    Header h = (Header)e.nextElement();
                    try {
                        mailMessage.addHeader(h.getName(), h.getValue());
                    }
                    catch (Exception exc) {
                        logger.warn(MimeMessageConverter.STR_EMPTY, (Throwable)exc);
                    }
                }
            }
        });
        FILLER_MAP_EXT.put(MailField.ID, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setMailId(Long.toString(((ExtendedMimeMessage)msg).getUid()));
            }
        });
        FILLER_MAP_EXT.put(MailField.FOLDER_ID, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setFolder(((ExtendedMimeMessage)msg).getFullname());
            }
        });
        FILLER_MAP_EXT.put(MailField.CONTENT_TYPE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws OXException, MessagingException {
                try {
                    mailMessage.setContentType(((ExtendedMimeMessage)msg).getContentType());
                }
                catch (OXException e) {
                    LOG1.error(MimeMessageConverter.STR_EMPTY, (Throwable)e);
                }
                mailMessage.setHasAttachment(((ExtendedMimeMessage)msg).hasAttachment());
            }
        });
        FILLER_MAP_EXT.put(MailField.FROM, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addFrom(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_FROM, msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.TO, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addTo(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_TO, msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.CC, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addCc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_CC, msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.BCC, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addBcc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_BCC, msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.SUBJECT, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSubject(MimeMessageConverter.getSubject(msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.SIZE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSize(((ExtendedMimeMessage)msg).getSize());
            }
        });
        FILLER_MAP_EXT.put(MailField.SENT_DATE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSentDate(((ExtendedMimeMessage)msg).getSentDate());
            }
        });
        FILLER_MAP_EXT.put(MailField.RECEIVED_DATE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setReceivedDate(((ExtendedMimeMessage)msg).getReceivedDate());
            }
        });
        FILLER_MAP_EXT.put(MailField.FLAGS, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                MimeMessageConverter.parseFlags(((ExtendedMimeMessage)msg).getFlags(), mailMessage);
            }
        });
        FILLER_MAP_EXT.put(MailField.THREAD_LEVEL, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setThreadLevel(((ExtendedMimeMessage)msg).getThreadLevel());
            }
        });
        FILLER_MAP_EXT.put(MailField.DISPOSITION_NOTIFICATION_TO, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] val = ((ExtendedMimeMessage)msg).getHeader(MessageHeaders.HDR_DISP_NOT_TO);
                if (val != null && val.length > 0) {
                    String dispNot = val[0];
                    if (dispNot == null) {
                        mailMessage.setDispositionNotification(null);
                    } else {
                        InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                        mailMessage.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
                    }
                } else {
                    mailMessage.setDispositionNotification(null);
                }
            }
        });
        FILLER_MAP_EXT.put(MailField.PRIORITY, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] val = ((ExtendedMimeMessage)msg).getHeader(MessageHeaders.HDR_IMPORTANCE);
                if (val != null && val.length > 0) {
                    MimeMessageConverter.parseImportance(val[0], mailMessage);
                } else {
                    val = ((ExtendedMimeMessage)msg).getHeader(MessageHeaders.HDR_X_PRIORITY);
                    if (val != null && val.length > 0) {
                        MimeMessageConverter.parsePriority(val[0], mailMessage);
                    } else {
                        mailMessage.setPriority(3);
                    }
                }
            }
        });
        FILLER_MAP_EXT.put(MailField.COLOR_LABEL, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                MimeMessageConverter.parseFlags(((ExtendedMimeMessage)msg).getFlags(), mailMessage);
                if (!mailMessage.containsColorLabel()) {
                    mailMessage.setColorLabel(0);
                }
            }
        });
        FILLER_MAP = new EnumMap(MailField.class);
        logger = LOG;
        FILLER_MAP.put(MailField.HEADERS, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] references;
                String[] messageId;
                mailMessage.addFrom(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_FROM, msg));
                mailMessage.addTo(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_TO, msg));
                mailMessage.addCc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_CC, msg));
                mailMessage.addBcc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_BCC, msg));
                mailMessage.addReplyTo(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_REPLY_TO, msg));
                String[] addrStr = msg.getHeader(MessageHeaders.HDR_DISP_NOT_TO);
                if (null != addrStr && addrStr.length > 0) {
                    String dispNot = addrStr[0];
                    if (dispNot == null) {
                        mailMessage.setDispositionNotification(null);
                    } else {
                        InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                        mailMessage.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
                    }
                } else {
                    mailMessage.setDispositionNotification(null);
                }
                mailMessage.setSubject(MimeMessageConverter.getSubject(msg));
                mailMessage.setSentDate(msg.getSentDate());
                String[] importance = msg.getHeader(MessageHeaders.HDR_IMPORTANCE);
                if (null != importance) {
                    MimeMessageConverter.parseImportance(importance[0], mailMessage);
                }
                if (!mailMessage.containsPriority()) {
                    String[] xPriority = msg.getHeader(MessageHeaders.HDR_X_PRIORITY);
                    if (null == xPriority) {
                        mailMessage.setPriority(3);
                    } else {
                        MimeMessageConverter.parsePriority(xPriority[0], mailMessage);
                    }
                }
                if (null != (messageId = msg.getHeader(MessageHeaders.HDR_MESSAGE_ID))) {
                    mailMessage.addHeader(MessageHeaders.HDR_MESSAGE_ID, messageId[0]);
                }
                StringBuilder sb = new StringBuilder(128);
                String[] inReplyTo = msg.getHeader(MessageHeaders.HDR_IN_REPLY_TO);
                if (null != inReplyTo) {
                    sb.append(inReplyTo[0]);
                    for (int j = 1; j < inReplyTo.length; ++j) {
                        sb.append(", ").append(inReplyTo[j]);
                    }
                    mailMessage.addHeader(MessageHeaders.HDR_IN_REPLY_TO, sb.toString());
                    sb.setLength(0);
                }
                if (null != (references = msg.getHeader(MessageHeaders.HDR_REFERENCES))) {
                    sb.append(references[0]);
                    for (int j = 1; j < references.length; ++j) {
                        sb.append(", ").append(references[j]);
                    }
                    mailMessage.addHeader(MessageHeaders.HDR_REFERENCES, sb.toString());
                    sb.setLength(0);
                }
                Enumeration e = msg.getNonMatchingHeaders(ALREADY_INSERTED_HEADERS);
                while (e.hasMoreElements()) {
                    Header h = (Header)e.nextElement();
                    try {
                        mailMessage.addHeader(h.getName(), h.getValue());
                    }
                    catch (Exception exc) {
                        logger.warn(MimeMessageConverter.STR_EMPTY, (Throwable)exc);
                    }
                }
            }
        });
        FILLER_MAP.put(MailField.CONTENT_TYPE, new MailMessageFieldFiller(){
            private final String multipart = "multipart";
            private final String mixed = "mixed";

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                ContentType ct = null;
                try {
                    String[] tmp = msg.getHeader(CONTENT_TYPE);
                    ct = tmp != null && tmp.length > 0 ? new ContentType(tmp[0]) : new ContentType("text/plain; charset=us-ascii");
                }
                catch (OXException e) {
                    LOG1.error(MessageFormat.format("Invalid content type: {0}", msg.getContentType()), (Throwable)e);
                    try {
                        ct = new ContentType("text/plain; charset=us-ascii");
                    }
                    catch (OXException e1) {
                        LOG1.error(MimeMessageConverter.STR_EMPTY, (Throwable)e1);
                        return;
                    }
                }
                mailMessage.setContentType(ct);
                if (msg instanceof ExtendedMimeMessage) {
                    mailMessage.setHasAttachment(((ExtendedMimeMessage)msg).hasAttachment());
                } else {
                    try {
                        mailMessage.setHasAttachment(ct.startsWith("multipart") && ("mixed".equalsIgnoreCase(ct.getSubType()) || MimeMessageUtility.hasAttachments((Multipart)msg.getContent(), ct.getSubType())));
                    }
                    catch (ClassCastException e) {
                        LOG1.debug(new StringBuilder(256).append("Message's Content-Type indicates to be multipart/* but its content is not an instance of javax.mail.Multipart but ").append(e.getMessage()).append(".\nIn case if IMAP it is due to a wrong BODYSTRUCTURE returned by IMAP server.\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.").toString());
                        mailMessage.setHasAttachment(ct.startsWith("multipart/mixed"));
                    }
                    catch (MessagingException e) {
                        LOG1.debug(new StringBuilder(256).append("Parsing message's multipart/* content to check for file attachments caused a messaging error: ").append(e.getMessage()).append(".\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.").toString());
                        mailMessage.setHasAttachment(ct.startsWith("multipart/mixed"));
                    }
                    catch (IOException e) {
                        if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                        }
                        throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                    }
                }
            }
        });
        FILLER_MAP.put(MailField.FROM, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addFrom(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_FROM, msg));
            }
        });
        FILLER_MAP.put(MailField.TO, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addTo(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_TO, msg));
            }
        });
        FILLER_MAP.put(MailField.CC, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addCc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_CC, msg));
            }
        });
        FILLER_MAP.put(MailField.BCC, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addBcc(MimeMessageConverter.getAddressHeader(MessageHeaders.HDR_BCC, msg));
            }
        });
        FILLER_MAP.put(MailField.SUBJECT, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSubject(MimeMessageConverter.getSubject(msg));
            }
        });
        FILLER_MAP.put(MailField.SIZE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSize(msg.getSize());
            }
        });
        FILLER_MAP.put(MailField.SENT_DATE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSentDate(msg.getSentDate());
            }
        });
        FILLER_MAP.put(MailField.RECEIVED_DATE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setReceivedDate(msg.getReceivedDate());
            }
        });
        FILLER_MAP.put(MailField.FLAGS, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                MimeMessageConverter.parseFlags(msg.getFlags(), mailMessage);
            }
        });
        FILLER_MAP.put(MailField.THREAD_LEVEL, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setThreadLevel(0);
            }
        });
        FILLER_MAP.put(MailField.DISPOSITION_NOTIFICATION_TO, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] val = msg.getHeader(MessageHeaders.HDR_DISP_NOT_TO);
                if (val != null && val.length > 0) {
                    String dispNot = val[0];
                    if (dispNot == null) {
                        mailMessage.setDispositionNotification(null);
                    } else {
                        InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                        mailMessage.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
                    }
                } else {
                    mailMessage.setDispositionNotification(null);
                }
            }
        });
        FILLER_MAP.put(MailField.PRIORITY, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] val = ((ExtendedMimeMessage)msg).getHeader(MessageHeaders.HDR_IMPORTANCE);
                if (val != null && val.length > 0) {
                    MimeMessageConverter.parseImportance(val[0], mailMessage);
                } else {
                    val = ((ExtendedMimeMessage)msg).getHeader(MessageHeaders.HDR_X_PRIORITY);
                    if (val != null && val.length > 0) {
                        MimeMessageConverter.parsePriority(val[0], mailMessage);
                    } else {
                        mailMessage.setPriority(3);
                    }
                }
            }
        });
        FILLER_MAP.put(MailField.COLOR_LABEL, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                MimeMessageConverter.parseFlags(msg.getFlags(), mailMessage);
                if (!mailMessage.containsColorLabel()) {
                    mailMessage.setColorLabel(0);
                }
            }
        });
        EMPTY_STRS = new String[0];
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                enableMime4j = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        PATTERN_PARSE_HEADER = Pattern.compile("(\\S+):\\p{Blank}?(.*)(?:(?:\r?\n)|(?:$))");
    }

    private static abstract class ExtendedMailMessageFieldFiller
    implements MailMessageFieldFiller {
        final Folder folder;

        public ExtendedMailMessageFieldFiller(Folder folder) {
            this.folder = folder;
        }
    }

    private static final class HeaderFieldFiller
    implements MailMessageFieldFiller {
        private final String headerName;

        HeaderFieldFiller(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
            String[] header = msg.getHeader(this.headerName);
            if (null == header || 0 == header.length) {
                return;
            }
            for (String value : header) {
                mailMessage.addHeader(this.headerName, MimeMessageUtility.checkNonAscii(value));
            }
        }
    }

    private static interface MailMessageFieldFiller {
        public static final String[] NON_MATCHING_HEADERS = new String[]{MessageHeaders.HDR_FROM, MessageHeaders.HDR_TO, MessageHeaders.HDR_CC, MessageHeaders.HDR_BCC, MessageHeaders.HDR_DISP_NOT_TO, MessageHeaders.HDR_REPLY_TO, MessageHeaders.HDR_SUBJECT, MessageHeaders.HDR_DATE, MessageHeaders.HDR_IMPORTANCE, MessageHeaders.HDR_X_PRIORITY, MessageHeaders.HDR_MESSAGE_ID, MessageHeaders.HDR_IN_REPLY_TO, MessageHeaders.HDR_REFERENCES, MessageHeaders.HDR_X_OX_VCARD, MessageHeaders.HDR_X_OX_NOTIFICATION};
        public static final String[] ALREADY_INSERTED_HEADERS = new String[]{MessageHeaders.HDR_MESSAGE_ID, MessageHeaders.HDR_IN_REPLY_TO, MessageHeaders.HDR_REFERENCES};
        public static final Logger LOG1 = LoggerFactory.getLogger(MailMessageFieldFiller.class);

        public void fillField(MailMessage var1, Message var2) throws MessagingException, OXException;
    }

    private static interface ExistenceChecker {
        public void check(MailMessage ... var1);

        public void check(Collection<MailMessage> var1);
    }
}

