/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import org.json.JSONException;
import org.json.JSONObject;

public final class ReceiptAckAction
extends AbstractMailAction {
    public ReceiptAckAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            String uid;
            String folderPath;
            JSONObject bodyObj = (JSONObject)req.getRequest().requireData();
            String string = folderPath = bodyObj.has("folder") ? bodyObj.getString("folder") : null;
            if (null == folderPath) {
                throw MailExceptionCode.MISSING_PARAM.create("folder");
            }
            String string2 = uid = bodyObj.has("id") ? bodyObj.getString("id") : null;
            if (null == uid) {
                throw MailExceptionCode.MISSING_PARAM.create("id");
            }
            String fromAddr = bodyObj.hasAndNotNull(MailJSONField.FROM.getKey()) ? bodyObj.getString(MailJSONField.FROM.getKey()) : null;
            MailServletInterface mailInterface = this.getMailInterface(req);
            mailInterface.sendReceiptAck(folderPath, uid, fromAddr);
            return ReceiptAckAction.getJSONNullResult();
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

