/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.conversion;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.image.ImageUtility;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import java.io.InputStream;

public final class InlineImageDataSource
implements ImageDataSource {
    private static final InlineImageDataSource INSTANCE = new InlineImageDataSource();
    private static final long EXPIRES = 1572480000000L;
    private static final String[] ARGS = new String[]{"com.openexchange.mail.conversion.fullname", "com.openexchange.mail.conversion.mailid", "com.openexchange.mail.conversion.cid"};
    private static final Class<?>[] TYPES = new Class[]{InputStream.class};
    private static final String REGISTRATION_NAME = "com.openexchange.mail.image";
    private static final String ALIAS = "/mail/picture";

    public static InlineImageDataSource getInstance() {
        return INSTANCE;
    }

    private InlineImageDataSource() {
    }

    private MailPart getImagePart(int accountId, String fullname, String mailId, String cid, Session session) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect();
            MailPart mailPart = this.loadImagePart(fullname, mailId, cid, mailAccess);
            return mailPart;
        }
        catch (OXException e) {
            if (null != mailAccess && MimeMessageUtility.shouldRetry(e)) {
                mailAccess = MailAccess.reconnect(mailAccess);
                MailPart mailPart = this.loadImagePart(fullname, mailId, cid, mailAccess);
                return mailPart;
            }
            throw e;
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }

    private MailPart loadImagePart(String fullname, String mailId, String cid, MailAccess<?, ?> mailAccess) throws OXException {
        MailPart imagePart = mailAccess.getMessageStorage().getImageAttachment(fullname, mailId, cid);
        if (null == imagePart) {
            return null;
        }
        imagePart.loadContent();
        return imagePart;
    }

    @Override
    public String generateUrl(ImageLocation imageLocation, Session session) {
        StringBuilder sb = new StringBuilder(64);
        ImageUtility.startImageUrl(imageLocation, session, this, true, sb);
        return sb.toString();
    }

    @Override
    public DataArguments generateDataArgumentsFrom(ImageLocation imageLocation) {
        DataArguments dataArguments = new DataArguments(3);
        dataArguments.put(ARGS[0], imageLocation.getFolder());
        dataArguments.put(ARGS[1], imageLocation.getId());
        dataArguments.put(ARGS[2], imageLocation.getImageId());
        return dataArguments;
    }

    @Override
    public ImageLocation parseUrl(String url) {
        return ImageUtility.parseImageLocationFrom(url);
    }

    @Override
    public ImageLocation parseRequest(AJAXRequestData requestData) {
        return ImageUtility.parseImageLocationFrom(requestData);
    }

    @Override
    public long getExpires() {
        return 1572480000000L;
    }

    @Override
    public String getETag(ImageLocation imageLocation, Session session) {
        int delim = 35;
        StringBuilder builder = new StringBuilder(128);
        builder.append('#').append(imageLocation.getFolder());
        builder.append('#').append(imageLocation.getId());
        builder.append('#').append(imageLocation.getImageId());
        builder.append('#');
        return ImageUtility.getMD5(builder.toString(), "hex");
    }

    public String[] getRequiredArguments() {
        return ARGS;
    }

    public Class<?>[] getTypes() {
        return TYPES;
    }

    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        String byFileName;
        if (!InputStream.class.equals(type)) {
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{type.getName()});
        }
        String fullnameArgument = dataArguments.get(ARGS[0]);
        if (null == fullnameArgument) {
            throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[0]});
        }
        FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(fullnameArgument);
        String fullname = arg.getFullname();
        String mailId = dataArguments.get(ARGS[1]);
        if (null == mailId) {
            throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[1]});
        }
        String cid = dataArguments.get(ARGS[2]);
        if (null == cid) {
            throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[2]});
        }
        MailPart mailPart = this.getImagePart(arg.getAccountId(), fullname, mailId, cid, session);
        if (null == mailPart) {
            throw MailExceptionCode.IMAGE_ATTACHMENT_NOT_FOUND.create(cid, mailId, fullname);
        }
        ContentType contentType = mailPart.getContentType();
        if (contentType == null) {
            throw DataExceptionCodes.ERROR.create(new Object[]{"Missing header 'Content-Type' in requested mail part"});
        }
        String fileName = mailPart.getFileName();
        if (!contentType.isMimeType("image/*")) {
            if (null == fileName) {
                if (!contentType.startsWith("application/octet-stream")) {
                    throw DataExceptionCodes.ERROR.create(new Object[]{"Requested mail part is not an image: " + contentType.getBaseType()});
                }
            } else {
                byFileName = MimeType2ExtMap.getContentType(fileName);
                if (ContentType.isMimeType(byFileName, "image/*")) {
                    contentType.setBaseType(byFileName);
                } else if (!contentType.isMimeType("application/octet-stream")) {
                    throw DataExceptionCodes.ERROR.create(new Object[]{"Requested mail part is not an image: " + contentType.getBaseType()});
                }
            }
        } else if (null != fileName && ContentType.isMimeType(byFileName = MimeType2ExtMap.getContentType(fileName), "image/*") && !contentType.startsWith(byFileName)) {
            contentType.setBaseType(byFileName);
        }
        DataProperties properties = new DataProperties(8);
        properties.put("com.openexchange.conversion.folderId", fullnameArgument);
        properties.put("com.openexchange.conversion.id", mailId);
        properties.put("com.openexchange.conversion.content-type", contentType.getBaseType());
        String charset = contentType.getCharsetParameter();
        if (charset != null) {
            properties.put("com.openexchange.conversion.charset", charset);
        }
        properties.put("com.openexchange.conversion.size", Long.toString(mailPart.getSize()));
        properties.put("com.openexchange.conversion.name", fileName);
        return new SimpleData((Object)mailPart.getInputStream(), properties);
    }

    @Override
    public String getRegistrationName() {
        return REGISTRATION_NAME;
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }
}

