/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal.format;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Strings;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.format.LoginFormatter;
import com.openexchange.session.Session;

public final class DefaultLoginFormatter
implements LoginFormatter {
    private static final DefaultLoginFormatter INSTANCE = new DefaultLoginFormatter();

    public static DefaultLoginFormatter getInstance() {
        return INSTANCE;
    }

    private DefaultLoginFormatter() {
    }

    @Override
    public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
        Session session;
        User user;
        sb.append("Login:");
        sb.append(Strings.abbreviate((String)request.getLogin(), (int)256));
        sb.append(" IP:");
        sb.append(request.getClientIP());
        sb.append(" AuthID:");
        sb.append(request.getAuthId());
        sb.append(" Agent:");
        sb.append(request.getUserAgent());
        sb.append(" Client:");
        sb.append(request.getClient());
        sb.append('(');
        sb.append(request.getVersion());
        sb.append(") Interface:");
        sb.append(request.getInterface().toString());
        Context ctx = result.getContext();
        if (null != ctx) {
            sb.append(" Context:");
            sb.append(ctx.getContextId());
            sb.append('(');
            sb.append(Strings.join((Object[])ctx.getLoginInfo(), (String)","));
            sb.append(')');
        }
        if (null != (user = result.getUser())) {
            sb.append(" User:");
            sb.append(user.getId());
            sb.append('(');
            sb.append(user.getLoginInfo());
            sb.append(')');
        }
        if (null == (session = result.getSession())) {
            sb.append(" No session created.");
        } else {
            sb.append(" Session:");
            sb.append(session.getSessionID());
            sb.append(" Random:");
            sb.append(session.getRandomToken());
            sb.append(" Transient:");
            sb.append(session.isTransient());
        }
    }

    @Override
    public void formatLogout(LoginResult result, StringBuilder sb) {
        sb.append("Logout ");
        Context ctx = result.getContext();
        sb.append(" Context:");
        sb.append(ctx.getContextId());
        sb.append('(');
        sb.append(Strings.join((Object[])ctx.getLoginInfo(), (String)","));
        sb.append(')');
        User user = result.getUser();
        sb.append(" User:");
        sb.append(user.getId());
        sb.append('(');
        sb.append(user.getLoginInfo());
        sb.append(')');
        Session session = result.getSession();
        sb.append(" Session:");
        sb.append(session.getSessionID());
    }
}

