/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.AbstractFormatDateReplacement;
import com.openexchange.tools.TimeZoneUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class EndDateReplacement
extends AbstractFormatDateReplacement {
    public EndDateReplacement(Date endDate, boolean fulltime, boolean isTask) {
        this(endDate, fulltime, isTask, null, null);
    }

    public EndDateReplacement(Date endDate, boolean fulltime, boolean isTask, Locale locale, TimeZone timeZone) {
        super(EndDateReplacement.correctDayOfMonth(endDate, fulltime, isTask), !fulltime, isTask ? "Due date: %1$s" : "End date: %1$s", locale, timeZone);
        this.fallback = isTask ? "No due date" : "No end date";
    }

    private static Date correctDayOfMonth(Date endDate, boolean fulltime, boolean isTask) {
        if (!fulltime || null == endDate || isTask) {
            return endDate;
        }
        Calendar calendar2 = Calendar.getInstance(TimeZoneUtils.getTimeZone("UTC"));
        calendar2.setTime(endDate);
        calendar2.add(5, -1);
        return calendar2.getTime();
    }

    @Override
    public TemplateToken getToken() {
        return TemplateToken.END;
    }
}

