/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.userconfiguration.MutableUserConfiguration;
import com.openexchange.groupware.userconfiguration.Permission;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8277899698366715803L;
    private static final transient Logger LOG = LoggerFactory.getLogger(UserConfiguration.class);
    public static final int WEBMAIL = 1;
    public static final int CALENDAR = 2;
    public static final int CONTACTS = 4;
    public static final int TASKS = 8;
    public static final int INFOSTORE = 16;
    private static final int PROJECTS = 32;
    private static final int FORUM = 64;
    private static final int PINBOARD_WRITE_ACCESS = 128;
    public static final int WEBDAV_XML = 256;
    public static final int WEBDAV = 512;
    public static final int ICAL = 1024;
    public static final int VCARD = 2048;
    private static final int RSS_BOOKMARKS = 4096;
    private static final int RSS_PORTAL = 8192;
    public static final int MOBILITY = 16384;
    public static final int EDIT_PUBLIC_FOLDERS = 32768;
    public static final int READ_CREATE_SHARED_FOLDERS = 65536;
    public static final int DELEGATE_TASKS = 131072;
    public static final int EDIT_GROUP = 262144;
    public static final int EDIT_RESOURCE = 524288;
    public static final int EDIT_PASSWORD = 0x100000;
    public static final int COLLECT_EMAIL_ADDRESSES = 0x200000;
    public static final int MULTIPLE_MAIL_ACCOUNTS = 0x400000;
    public static final int SUBSCRIPTION = 0x800000;
    public static final int PUBLICATION = 0x1000000;
    public static final int ACTIVE_SYNC = 0x2000000;
    public static final int USM = 0x4000000;
    public static final int OLOX20 = 0x8000000;
    public static final int DENIED_PORTAL = 0x10000000;
    public static final int CALDAV = 0x20000000;
    public static final int CARDDAV = 0x40000000;
    protected Set<String> capabilities;
    protected final int userId;
    protected int[] groups;
    protected final Context ctx;

    public UserConfiguration(Set<String> capabilities, int userId, int[] groups, Context ctx) {
        this.capabilities = capabilities;
        this.userId = userId;
        if (null == groups) {
            this.groups = null;
        } else {
            this.groups = new int[groups.length];
            System.arraycopy(groups, 0, this.groups, 0, groups.length);
        }
        this.ctx = ctx;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof UserConfiguration)) {
            return false;
        }
        UserConfiguration uc = (UserConfiguration)other;
        if (this.userId != uc.userId || !((Object)this.getExtendedPermissions()).equals(uc.getExtendedPermissions())) {
            return false;
        }
        if (null != this.groups) {
            if (null == uc.groups) {
                return false;
            }
            Arrays.sort(this.groups);
            Arrays.sort(uc.groups);
            if (!Arrays.equals(this.groups, uc.groups)) {
                return false;
            }
        }
        if (null != uc.groups) {
            return false;
        }
        if (null != this.ctx) {
            if (null == uc.ctx) {
                return false;
            }
            return this.ctx.getContextId() == uc.ctx.getContextId();
        }
        return null == uc.ctx;
    }

    public MutableUserConfiguration getMutable() {
        int[] groupCopy = new int[this.groups.length];
        System.arraycopy(this.groups, 0, groupCopy, 0, this.groups.length);
        return new MutableUserConfiguration(new HashSet<String>(this.capabilities), this.userId, groupCopy, this.ctx);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.userId;
        for (String p : this.capabilities) {
            hash = 31 * hash + p.hashCode();
        }
        if (null != this.groups) {
            Arrays.sort(this.groups);
            for (int group : this.groups) {
                hash = 31 * hash + group;
            }
        }
        if (null != this.ctx) {
            hash = 31 * hash + this.ctx.getContextId();
        }
        return hash;
    }

    public UserConfiguration clone() {
        try {
            UserConfiguration clone = (UserConfiguration)super.clone();
            if (this.groups != null) {
                clone.groups = new int[this.groups.length];
                System.arraycopy(this.groups, 0, clone.groups, 0, this.groups.length);
            }
            clone.capabilities = this.capabilities;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error("", (Throwable)e);
            throw new InternalError(e.getMessage());
        }
    }

    public int getPermissionBits() {
        return UserPermissionBits.getPermissionBits(this.capabilities);
    }

    public boolean hasWebMail() {
        return this.hasPermission(1);
    }

    public boolean hasCalendar() {
        return this.hasPermission(2);
    }

    public boolean hasContact() {
        return this.hasPermission(4);
    }

    public boolean hasTask() {
        return this.hasPermission(8);
    }

    public boolean hasInfostore() {
        return this.hasPermission(16);
    }

    public boolean hasWebDAVXML() {
        return this.hasPermission(256);
    }

    public boolean hasWebDAV() {
        return this.hasPermission(512);
    }

    public boolean hasICal() {
        return this.hasPermission(1024);
    }

    public boolean hasVCard() {
        return this.hasPermission(2048);
    }

    public boolean hasSyncML() {
        return this.hasPermission(16384);
    }

    public boolean hasPIM() {
        return this.hasCalendar() && this.hasContact() && this.hasTask();
    }

    public boolean hasTeamView() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasFreeBusy() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasConflictHandling() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasParticipantsDialog() {
        return this.hasConflictHandling();
    }

    public boolean hasGroupware() {
        return this.hasFullSharedFolderAccess() || this.hasFullPublicFolderAccess();
    }

    public boolean hasPortal() {
        return !this.hasPermission(0x10000000);
    }

    public int[] getAccessibleModules() {
        TIntArrayList array = new TIntArrayList(10);
        if (this.hasTask()) {
            array.add(1);
        }
        if (this.hasCalendar()) {
            array.add(2);
        }
        if (this.hasContact()) {
            array.add(3);
        }
        array.add(4);
        array.add(5);
        if (this.hasWebMail()) {
            array.add(7);
        }
        if (this.hasInfostore()) {
            array.add(8);
        }
        array.add(13);
        array.add(14);
        return array.toArray();
    }

    public boolean hasModuleAccess(int module) {
        return Arrays.binarySearch(this.getAccessibleModules(), module) >= 0;
    }

    public boolean hasFullPublicFolderAccess() {
        return this.hasPermission(32768);
    }

    public boolean hasFullSharedFolderAccess() {
        return this.hasPermission(65536);
    }

    public boolean canDelegateTasks() {
        return this.hasPermission(131072);
    }

    public boolean isCollectEmailAddresses() {
        return this.hasPermission(0x200000);
    }

    public boolean isMultipleMailAccounts() {
        return this.hasPermission(0x400000);
    }

    public boolean isSubscription() {
        return this.hasPermission(0x800000);
    }

    public boolean isPublication() {
        return this.hasPermission(0x1000000);
    }

    public boolean hasActiveSync() {
        return this.hasPermission(0x2000000);
    }

    public boolean hasUSM() {
        return this.hasPermission(0x4000000);
    }

    public boolean hasOLOX20() {
        return this.hasPermission(0x8000000);
    }

    public boolean isEditGroup() {
        return this.hasPermission(262144);
    }

    public boolean isEditResource() {
        return this.hasPermission(524288);
    }

    public boolean isEditPassword() {
        return this.hasPermission(0x100000);
    }

    public boolean hasPermission(int permissionBit) {
        if (0 == permissionBit) {
            return true;
        }
        for (Permission p : Permission.byBits(permissionBit)) {
            if (this.capabilities.contains(UserConfiguration.toLowerCase(p.name()))) continue;
            return false;
        }
        return true;
    }

    public boolean hasPermission(Permission permission) {
        if (null == permission) {
            return false;
        }
        return this.capabilities.contains(UserConfiguration.toLowerCase(permission.name()));
    }

    public boolean hasPermission(String name) {
        return this.getExtendedPermissions().contains(UserConfiguration.toLowerCase(name));
    }

    public int getUserId() {
        return this.userId;
    }

    public int[] getGroups() {
        if (null == this.groups) {
            return null;
        }
        int[] clone = new int[this.groups.length];
        System.arraycopy(this.groups, 0, clone, 0, clone.length);
        return clone;
    }

    public Context getContext() {
        return this.ctx;
    }

    public String toString() {
        return new StringBuilder(32).append("UserConfiguration_").append(this.userId).append('@').append(this.capabilities.toString()).toString();
    }

    public Set<String> getExtendedPermissions() {
        return this.capabilities;
    }

    public UserPermissionBits getUserPermissionBits() {
        return new UserPermissionBits(this.getPermissionBits(), this.userId, this.ctx.getContextId()).setGroups(this.groups);
    }

    static String toLowerCase(CharSequence chars) {
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

