/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class TasksAddUidColumnTask
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        ProgressState progress = params.getProgressState();
        Connection con = Database.getNoTimeout(ctxId, true);
        try {
            DBUtils.startTransaction(con);
            progress.setTotal(TasksAddUidColumnTask.getTotalRows(con));
            if (!Tools.columnExists(con, "task", "uid")) {
                Tools.addColumns(con, "task", new Column("uid", "VARCHAR(255)"));
                TasksAddUidColumnTask.fillUIDs(con, "task", progress);
                Tools.modifyColumns(con, "task", new Column("uid", "VARCHAR(255) NOT NULL"));
            }
            if (!Tools.columnExists(con, "del_task", "uid")) {
                Tools.addColumns(con, "del_task", new Column("uid", "VARCHAR(255)"));
                TasksAddUidColumnTask.fillUIDs(con, "del_task", progress);
                Tools.modifyColumns(con, "del_task", new Column("uid", "VARCHAR(255) NOT NULL"));
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillUIDs(Connection con, String table, ProgressState progress) throws SQLException {
        Statement stmt1 = null;
        ResultSet result = null;
        PreparedStatement stmt2 = null;
        try {
            stmt1 = con.createStatement();
            result = stmt1.executeQuery("SELECT cid,id FROM " + table);
            stmt2 = con.prepareStatement("UPDATE " + table + " SET uid=? WHERE cid=? AND id=?");
            while (result.next()) {
                int cid = result.getInt(1);
                int id = result.getInt(2);
                stmt2.setString(1, UUID.randomUUID().toString());
                stmt2.setInt(2, cid);
                stmt2.setInt(3, id);
                stmt2.addBatch();
                progress.incrementState();
            }
            stmt2.executeBatch();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt1);
            DBUtils.closeSQLStuff(stmt2);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt1);
        DBUtils.closeSQLStuff(stmt2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getTotalRows(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(id) FROM task UNION SELECT COUNT(id) FROM del_task");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return rows;
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

