/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.MailAccountCreateTablesTask;
import com.openexchange.groupware.update.tasks.POP3CreateTableTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public final class DropFKTaskv2
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{MailAccountCreateTablesTask.class.getName(), POP3CreateTableTask.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        boolean modified = false;
        Connection con = null;
        boolean rollback = false;
        try {
            con = dbService.getForUpdateTask(cid);
            con.setAutoCommit(false);
            rollback = true;
            List<String> tables = Arrays.asList("pop3_storage_deleted", "pop3_storage_ids", "user_mail_account_properties", "user_mail_account", "user_transport_account_properties", "user_transport_account");
            for (String table : tables) {
                modified |= this.handleTable(table, con);
            }
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            if (modified) {
                dbService.backForUpdateTask(cid, con);
            } else {
                dbService.backForUpdateTaskAfterReading(cid, con);
            }
        }
        con = dbService.getForUpdateTask(cid);
        modified = false;
        try {
            modified = this.dropForeignKeySafe("pop3_storage_deleted_ibfk_1", "pop3_storage_deleted", con);
        }
        finally {
            if (modified) {
                dbService.backForUpdateTask(cid, con);
            } else {
                dbService.backForUpdateTaskAfterReading(cid, con);
            }
        }
        con = dbService.getForUpdateTask(cid);
        modified = false;
        try {
            modified = this.dropForeignKeySafe("pop3_storage_deleted_ibfk_2", "pop3_storage_deleted", con);
        }
        finally {
            if (modified) {
                dbService.backForUpdateTask(cid, con);
            } else {
                dbService.backForUpdateTaskAfterReading(cid, con);
            }
        }
        con = dbService.getForUpdateTask(cid);
        modified = false;
        try {
            modified = this.dropForeignKeySafe("pop3_storage_ids_ibfk_1", "pop3_storage_ids", con);
        }
        finally {
            if (modified) {
                dbService.backForUpdateTask(cid, con);
            } else {
                dbService.backForUpdateTaskAfterReading(cid, con);
            }
        }
        con = dbService.getForUpdateTask(cid);
        modified = false;
        try {
            modified = this.dropForeignKeySafe("pop3_storage_ids_ibfk_2", "pop3_storage_ids", con);
        }
        finally {
            if (modified) {
                dbService.backForUpdateTask(cid, con);
            } else {
                dbService.backForUpdateTaskAfterReading(cid, con);
            }
        }
        con = dbService.getForUpdateTask(cid);
        modified = false;
        try {
            modified = this.enlargeVarcharColumn("uid", 1024, "prg_dates", con);
        }
        finally {
            if (modified) {
                dbService.backForUpdateTask(cid, con);
            } else {
                dbService.backForUpdateTaskAfterReading(cid, con);
            }
        }
        con = dbService.getForUpdateTask(cid);
        modified = false;
        try {
            modified = this.enlargeVarcharColumn("uid", 1024, "del_dates", con);
        }
        finally {
            if (modified) {
                dbService.backForUpdateTask(cid, con);
            } else {
                dbService.backForUpdateTaskAfterReading(cid, con);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean enlargeVarcharColumn(String colName, int newSize, String tableName, Connection con) throws OXException {
        ResultSet rsColumns;
        block6: {
            boolean bl;
            rsColumns = null;
            boolean doAlterTable = false;
            try {
                DatabaseMetaData meta = con.getMetaData();
                rsColumns = meta.getColumns(null, null, tableName, null);
                while (rsColumns.next()) {
                    String columnName = rsColumns.getString("COLUMN_NAME");
                    if (!colName.equals(columnName)) continue;
                    int size = rsColumns.getInt("COLUMN_SIZE");
                    if (size >= newSize) break;
                    doAlterTable = true;
                    break;
                }
                Databases.closeSQLStuff((ResultSet)rsColumns);
                rsColumns = null;
                if (!doAlterTable) break block6;
                Tools.modifyColumns(con, tableName, new Column(colName, "VARCHAR(" + newSize + ")"));
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw UpdateExceptionCodes.OTHER_PROBLEM.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Databases.closeSQLStuff(rsColumns);
                    throw throwable;
                }
            }
            Databases.closeSQLStuff((ResultSet)rsColumns);
            return bl;
        }
        Databases.closeSQLStuff((ResultSet)rsColumns);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleTable(String table, Connection con) throws SQLException {
        List<String> keyNames = Tools.allForeignKey(con, table);
        PreparedStatement stmt = null;
        boolean modified = false;
        for (String keyName : keyNames) {
            try {
                stmt = con.prepareStatement("ALTER TABLE " + table + " DROP FOREIGN KEY " + keyName);
                modified |= stmt.executeUpdate() > 0;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(null, stmt);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropForeignKeySafe(String foreignKeyName, String table, Connection con) {
        boolean modified = false;
        try {
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement("ALTER TABLE " + table + " DROP FOREIGN KEY " + foreignKeyName);
                modified = stmt.executeUpdate() > 0;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(null, stmt);
        }
        catch (Exception e) {
            // empty catch block
        }
        return modified;
    }
}

