/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.mapping;

import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TargetDuration
implements Mapper<Long> {
    public static final TargetDuration SINGLETON = new TargetDuration();

    protected TargetDuration() {
    }

    @Override
    public int getId() {
        return 308;
    }

    @Override
    public boolean isSet(Task task) {
        return task.containsTargetDuration();
    }

    @Override
    public String getDBColumnName() {
        return "target_duration";
    }

    @Override
    public String getDisplayName() {
        return "Estimated duration";
    }

    @Override
    public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
        if (null == task.getTargetDuration()) {
            stmt.setNull(pos, -5);
        } else {
            stmt.setLong(pos, Autoboxing.l((Long)task.getTargetDuration()));
        }
    }

    @Override
    public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
        long targetDuration = result.getLong(pos);
        if (!result.wasNull()) {
            task.setTargetDuration(Autoboxing.L((long)targetDuration));
        }
    }

    @Override
    public boolean equals(Task task1, Task task2) {
        if (task1.getTargetDuration() == null) {
            return task2.getTargetDuration() == null;
        }
        if (task2.getTargetDuration() == null) {
            return task1.getTargetDuration() == null;
        }
        return task1.getTargetDuration().equals(task2.getTargetDuration());
    }

    @Override
    public Long get(Task task) {
        return task.getTargetDuration();
    }

    @Override
    public void set(Task task, Long value) {
        task.setTargetDuration(value);
    }
}

