/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.database;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.database.RemoveUselessExternalParticipants;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class RemoveUselessExternalParticipantsV2
extends UpdateTaskAdapter {
    private final DatabaseService service;

    public RemoveUselessExternalParticipantsV2(DatabaseService service) {
        this.service = service;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{RemoveUselessExternalParticipants.class.getName()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND, WorkingLevel.SCHEMA);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        Connection con = this.service.getForUpdateTask(contextID);
        try {
            DBUtils.startTransaction(con);
            Tools.dropTable(con, "del_task_eparticipant");
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            this.service.backForUpdateTask(contextID, con);
        }
    }
}

