/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Reminder;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.TaskQuotaProvider;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.quota.Quota;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InsertData {
    private static final Logger LOG = LoggerFactory.getLogger(InsertData.class);
    private static final AtomicReference<TaskQuotaProvider> QUOTA_PROVIDER_REF = new AtomicReference();
    private final Context ctx;
    private final User user;
    private final UserPermissionBits permissionBits;
    private final FolderObject folder;
    private final Task task;
    private Set<TaskParticipant> parts;
    private Set<Folder> folders;
    private static final TaskStorage storage = TaskStorage.getInstance();
    private static final ParticipantStorage partStor = ParticipantStorage.getInstance();
    private static final FolderStorage foldStor = FolderStorage.getInstance();

    InsertData(Context ctx, User user, UserPermissionBits permissionBits, FolderObject folder, Task task) {
        this.ctx = ctx;
        this.user = user;
        this.permissionBits = permissionBits;
        this.folder = folder;
        this.task = task;
    }

    public static void setQuotaProvider(TaskQuotaProvider quotaProvider) {
        QUOTA_PROVIDER_REF.set(quotaProvider);
    }

    void prepare(Session session) throws OXException {
        this.parts = TaskLogic.createParticipants(this.ctx, this.task.getParticipants());
        TaskLogic.checkNewTask(this.task, this.user.getId(), this.permissionBits, this.parts);
        Permission.checkCreate(this.ctx, this.user, this.permissionBits, this.folder);
        int folderId = this.folder.getObjectID();
        if (this.task.getPrivateFlag() && (Tools.isFolderPublic(this.folder) || Tools.isFolderShared(this.folder, this.user))) {
            throw TaskExceptionCode.PRIVATE_FLAG.create(Autoboxing.I((int)folderId));
        }
        if (Tools.isFolderPublic(this.folder)) {
            this.folders = TaskLogic.createFolderMapping(folderId, this.task.getCreatedBy(), InternalParticipant.EMPTY_INTERNAL);
        } else {
            Tools.fillStandardFolders(this.ctx, ParticipantStorage.extractInternal(this.parts));
            int creator = this.user.getId();
            if (Tools.isFolderShared(this.folder, this.user)) {
                creator = this.folder.getCreator();
            }
            this.folders = TaskLogic.createFolderMapping(folderId, creator, ParticipantStorage.extractInternal(this.parts));
        }
        TaskQuotaProvider quotaProvider = QUOTA_PROVIDER_REF.get();
        if (quotaProvider == null) {
            LOG.warn("No TaskQuotaProvider was set, a task will be created without quota check!");
        } else {
            Quota amountQuota = quotaProvider.getAmountQuota(session);
            long limit = amountQuota.getLimit();
            long usage = amountQuota.getUsage();
            if (limit > 0L && usage >= limit) {
                throw QuotaExceptionCodes.QUOTA_EXCEEDED_TASKS.create(new Object[]{usage, limit});
            }
        }
    }

    void doInsert() throws OXException {
        InsertData.insertTask(this.ctx, this.task, this.parts, this.folders);
    }

    void createReminder() throws OXException {
        if (this.task.containsAlarm()) {
            Reminder.createReminder(this.ctx, this.task);
        }
    }

    void sentEvent(Session session) throws OXException {
        this.task.setUsers(TaskLogic.createUserParticipants(this.parts));
        new EventClient(session).create(this.task, this.folder);
    }

    static void insertTask(Context ctx, Task task, Set<TaskParticipant> participants, Set<Folder> folders2) throws OXException {
        Connection con = DBPool.pickupWriteable(ctx);
        try {
            con.setAutoCommit(false);
            int taskId = IDGenerator.getId(ctx, 4, con);
            task.setObjectID(taskId);
            storage.insertTask(ctx, con, task, StorageType.ACTIVE);
            if (participants.size() != 0) {
                partStor.insertParticipants(ctx, con, taskId, participants, StorageType.ACTIVE);
            }
            foldStor.insertFolder(ctx, con, taskId, folders2, StorageType.ACTIVE);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw TaskExceptionCode.INSERT_FAILED.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
            DBPool.closeWriterSilent(ctx, con);
        }
    }
}

