/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.folder;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Infostore
implements PreferencesItemService {
    protected static final Logger LOG = LoggerFactory.getLogger(Infostore.class);
    private static final String DEFAULT_ID = "0";

    @Override
    public String[] getPath() {
        return new String[]{"folder", "infostore"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasInfostore();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                if (InfostoreFacades.isInfoStoreAvailable()) {
                    setting.setSingleValue(new OXFolderAccess(ctx).getDefaultFolder(user.getId(), 8).getObjectID());
                    return;
                }
                FileStorageAccountManagerLookupService lookupService = ServerServiceRegistry.getInstance().getService(FileStorageAccountManagerLookupService.class);
                if (null == lookupService) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{FileStorageAccountManagerLookupService.class.getName()});
                }
                try {
                    FileStorageAccountManager defaultAccountManager = lookupService.getAccountManager(Infostore.DEFAULT_ID, session);
                    if (null != defaultAccountManager) {
                        FileStorageAccount defaultAccount = defaultAccountManager.getAccount(Infostore.DEFAULT_ID, session);
                        FileStorageService fileStorageService = defaultAccount.getFileStorageService();
                        FileStorageAccountAccess accountAccess = fileStorageService.getAccountAccess(Infostore.DEFAULT_ID, session);
                        accountAccess.connect();
                        try {
                            FileStorageFolder personalFolder = accountAccess.getFolderAccess().getPersonalFolder();
                            setting.setSingleValue(new FolderID(fileStorageService.getId(), defaultAccount.getId(), personalFolder.getId()).toUniqueID());
                            return;
                        }
                        finally {
                            accountAccess.close();
                        }
                    }
                }
                catch (OXException e) {
                    LOG.error("Infostore default folder could not be applied to user configuration.", (Throwable)e);
                }
                setting.setSingleValue(new OXFolderAccess(ctx).getDefaultFolder(user.getId(), 8).getObjectID());
            }
        };
    }
}

