/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.damienmiller.BCrypt;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.CachingUserStorage;
import com.openexchange.groupware.ldap.RdbUserStorage;
import com.openexchange.groupware.ldap.UnixCrypt;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserTools;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserStorage {
    private static final Logger LOG = LoggerFactory.getLogger(UserStorage.class);
    private static volatile UserStorage instance;
    public static final int SEARCH_LOGIN_NAME = 1;
    public static final int SEARCH_DISPLAY_NAME = 2;
    private static final Map<String, PasswordCheck> CHECKERS;

    protected UserStorage() {
    }

    public abstract int getUserId(String var1, Context var2) throws OXException;

    public User getUser(int userId, int contextId) throws OXException {
        return this.getUser(userId, ContextStorage.getInstance().getContext(contextId));
    }

    public abstract User getUser(int var1, Context var2) throws OXException;

    public abstract User loadIfAbsent(int var1, Context var2, Connection var3) throws OXException;

    public abstract User getUser(Context var1, int var2, Connection var3) throws OXException;

    public abstract User[] getUser(Context var1, int[] var2) throws OXException;

    public abstract User[] getUser(Context var1) throws OXException;

    public final void updateUser(User user, Context context) throws OXException {
        this.updateUserInternal(user, context);
        CacheFolderStorage.dropUserEntries(user.getId(), context.getContextId());
    }

    protected abstract void updateUserInternal(User var1, Context var2) throws OXException;

    public abstract String getUserAttribute(String var1, int var2, Context var3) throws OXException;

    public abstract void setUserAttribute(String var1, String var2, int var3, Context var4) throws OXException;

    public abstract void setAttribute(String var1, String var2, int var3, Context var4) throws OXException;

    public abstract User searchUser(String var1, Context var2) throws OXException;

    public abstract User searchUser(String var1, Context var2, boolean var3) throws OXException;

    public abstract User[] searchUserByMailLogin(String var1, Context var2) throws OXException;

    public abstract User[] searchUserByName(String var1, Context var2, int var3) throws OXException;

    public abstract int[] listAllUser(Context var1) throws OXException;

    public abstract int[] resolveIMAPLogin(String var1, Context var2) throws OXException;

    protected abstract void startInternal() throws OXException;

    protected abstract void stopInternal() throws OXException;

    public abstract int[] listModifiedUser(Date var1, Context var2) throws OXException;

    public abstract void invalidateUser(Context var1, int var2) throws OXException;

    public abstract int createUser(Context var1, User var2) throws OXException;

    public abstract int createUser(Connection var1, Context var2, User var3) throws OXException;

    public final void invalidateUser(Context ctx, int[] userIds) throws OXException {
        for (int member : userIds) {
            this.invalidateUser(ctx, member);
        }
    }

    public static final boolean authenticate(User user, String password) throws OXException {
        PasswordCheck check = CHECKERS.get(user.getPasswordMech());
        return null == check ? false : check.checkPassword(password, user.getUserPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void start() throws OXException {
        UserStorage tmp = instance;
        if (null != tmp) return;
        Class<UserStorage> clazz = UserStorage.class;
        synchronized (UserStorage.class) {
            tmp = instance;
            if (null != tmp) return;
            tmp = new CachingUserStorage(new RdbUserStorage());
            tmp.startInternal();
            instance = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void stop() throws OXException {
        UserStorage tmp = instance;
        if (null == tmp) return;
        Class<UserStorage> clazz = UserStorage.class;
        synchronized (UserStorage.class) {
            tmp = instance;
            if (null == tmp) return;
            tmp.stopInternal();
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserStorage getInstance() {
        UserStorage tmp = instance;
        if (null != tmp) return tmp;
        Class<UserStorage> clazz = UserStorage.class;
        synchronized (UserStorage.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            try {
                tmp = new CachingUserStorage(new RdbUserStorage());
                tmp.startInternal();
                instance = tmp;
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
            return tmp;
        }
    }

    @Deprecated
    public static User getStorageUser(int uid, Context context) throws OXException {
        return UserStorage.getInstance().getUser(uid, context);
    }

    @Deprecated
    public static User getStorageUser(int uid, int contextId) throws OXException {
        return UserStorage.getInstance().getUser(uid, ContextStorage.getStorageContext(contextId));
    }

    @Deprecated
    public static User getStorageUser(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getStorageUser(session.getUserId(), session.getContextId());
    }

    static {
        HashMap<String, PasswordCheck> m = new HashMap<String, PasswordCheck>(3);
        m.put("{CRYPT}", new PasswordCheck(){

            @Override
            public boolean checkPassword(String candidate, String userHash) throws OXException {
                return UnixCrypt.matches(userHash, candidate);
            }
        });
        m.put("{SHA}", new PasswordCheck(){

            @Override
            public boolean checkPassword(String candidate, String userHash) throws OXException {
                return UserTools.hashPassword(candidate).equals(userHash);
            }
        });
        m.put("{BCRYPT}", new PasswordCheck(){

            @Override
            public boolean checkPassword(String candidate, String userHash) throws OXException {
                return BCrypt.checkpw((String)candidate, (String)userHash);
            }
        });
        CHECKERS = Collections.unmodifiableMap(m);
    }

    private static interface PasswordCheck {
        public boolean checkPassword(String var1, String var2) throws OXException;
    }
}

