/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.AttributeValue;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserAttribute;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.util.UUIDs;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.passwordchange.PasswordMechanism;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.user.internal.mapping.UserField;
import com.openexchange.user.internal.mapping.UserMapper;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbUserStorage
extends UserStorage {
    private static final Logger LOG = LoggerFactory.getLogger(RdbUserStorage.class);
    private static final String SELECT_ALL_USER = "SELECT id,userPassword,mailEnabled,imapServer,imapLogin,smtpServer,mailDomain,shadowLastChange,mail,timeZone,preferredLanguage,passwordMech,contactId FROM user WHERE user.cid=?";
    private static final String SELECT_USER = "SELECT id,userPassword,mailEnabled,imapServer,imapLogin,smtpServer,mailDomain,shadowLastChange,mail,timeZone,preferredLanguage,passwordMech,contactId FROM user WHERE user.cid=? AND id IN (";
    private static final String SELECT_ATTRS = "SELECT id,uuid,name,value FROM user_attribute WHERE cid=? AND id IN (";
    private static final String SELECT_CONTACT = "SELECT intfield01,field03,field02,field01 FROM prg_contacts WHERE cid=? AND intfield01 IN (";
    private static final String SELECT_ID = "SELECT id FROM login2user WHERE cid=? AND uid=?";
    private static final String SELECT_LOGIN = "SELECT id,uid FROM login2user where cid=? AND id IN (";
    private static final String SELECT_IMAPLOGIN = "SELECT id FROM user WHERE cid=? AND imapLogin=?";
    private static final String SQL_UPDATE_PASSWORD = "UPDATE user SET userPassword = ?, shadowLastChange = ? WHERE cid = ? AND id = ?";
    private static final String INSERT_USER = "INSERT INTO user (cid, id, imapServer, imapLogin, mail, mailDomain, mailEnabled, preferredLanguage, shadowLastChange, smtpServer, timeZone, userPassword, contactId, passwordMech, uidNumber, gidNumber, homeDirectory, loginShell) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_ATTRIBUTES = "INSERT INTO user_attribute (cid, id, name, value, uuid) VALUES (?, ?, ?, ?, ?)";
    private static final String INSERT_LOGIN_INFO = "INSERT INTO login2user (cid, id, uid) VALUES (?, ?, ?)";
    private static final UserMapper MAPPER = new UserMapper();

    @Override
    public int getUserId(String uid, Context context) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (OXException e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("USR");
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        int userId = -1;
        try {
            stmt = con.prepareStatement(SELECT_ID);
            stmt.setInt(1, context.getContextId());
            stmt.setString(2, uid);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw LdapExceptionCode.USER_NOT_FOUND.create(uid, Autoboxing.I((int)context.getContextId())).setPrefix("USR");
            }
            userId = result.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return userId;
    }

    @Override
    public int createUser(Connection con, Context context, User user) throws OXException {
        int n;
        PreparedStatement stmt = null;
        try {
            int userId = IDGenerator.getId(context, 130, con);
            stmt = con.prepareStatement(INSERT_USER);
            int i = 1;
            stmt.setInt(i++, context.getContextId());
            stmt.setInt(i++, userId);
            RdbUserStorage.setStringOrNull(i++, stmt, user.getImapServer());
            RdbUserStorage.setStringOrNull(i++, stmt, user.getImapLogin());
            RdbUserStorage.setStringOrNull(i++, stmt, user.getMail());
            RdbUserStorage.setStringOrNull(i++, stmt, user.getMailDomain());
            stmt.setInt(i++, 1);
            RdbUserStorage.setStringOrNull(i++, stmt, user.getPreferredLanguage());
            stmt.setInt(i++, user.getShadowLastChange());
            RdbUserStorage.setStringOrNull(i++, stmt, user.getSmtpServer());
            RdbUserStorage.setStringOrNull(i++, stmt, user.getTimeZone());
            RdbUserStorage.setStringOrNull(i++, stmt, user.getUserPassword());
            stmt.setInt(i++, user.getContactId());
            RdbUserStorage.setStringOrNull(i++, stmt, user.getPasswordMech());
            stmt.setInt(i++, 0);
            stmt.setInt(i++, 0);
            RdbUserStorage.setStringOrNull(i++, stmt, "/home/" + user.getGivenName());
            RdbUserStorage.setStringOrNull(i++, stmt, "/bin/bash");
            stmt.executeUpdate();
            RdbUserStorage.writeLoginInfo(con, user, context, userId);
            RdbUserStorage.writeUserAttributes(con, user, context, userId);
            n = userId;
        }
        catch (SQLException e) {
            try {
                throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLoginInfo(Connection con, User user, Context context, int userId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(INSERT_LOGIN_INFO);
            stmt.setInt(1, context.getContextId());
            stmt.setInt(2, userId);
            stmt.setString(3, user.getLoginInfo());
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeUserAttributes(Connection con, User user, Context context, int userId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(INSERT_ATTRIBUTES);
            Map<String, Set<String>> attributes = user.getAttributes();
            for (String key : attributes.keySet()) {
                Set<String> valueSet = attributes.get(key);
                for (String value : valueSet) {
                    stmt.setInt(1, context.getContextId());
                    stmt.setInt(2, userId);
                    stmt.setString(3, key);
                    stmt.setString(4, value);
                    stmt.setBytes(5, UUIDs.toByteArray((UUID)UUID.randomUUID()));
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createUser(Context context, User user) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
            int n = this.createUser(con, context, user);
            return n;
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    private static void setStringOrNull(int parameter, PreparedStatement stmt, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(parameter, 12);
        } else {
            stmt.setString(parameter, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(int userId, Context context) throws OXException {
        Connection con = DBPool.pickup(context);
        try {
            User user = RdbUserStorage.getUser(context, con, new int[]{userId})[0];
            return user;
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    @Override
    public User loadIfAbsent(int userId, Context ctx, Connection con) throws OXException {
        return RdbUserStorage.getUser(ctx, con, new int[]{userId})[0];
    }

    @Override
    public User getUser(Context ctx, int userId, Connection con) throws OXException {
        return RdbUserStorage.getUser(ctx, con, new int[]{userId})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static User[] getUser(Context ctx, Connection con, int[] userIds) throws OXException {
        int length = userIds.length;
        if (0 == length) {
            return new User[0];
        }
        TIntObjectHashMap users = new TIntObjectHashMap(length);
        try {
            for (int i = 0; i < userIds.length; i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int[] currentUserIds = Arrays.extract((int[])userIds, (int)i, (int)1000);
                    stmt = con.prepareStatement(DBUtils.getIN(SELECT_USER, currentUserIds.length));
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    for (int userId : currentUserIds) {
                        stmt.setInt(pos++, userId);
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        UserImpl user = new UserImpl();
                        pos = 1;
                        user.setId(result.getInt(pos++));
                        user.setUserPassword(result.getString(pos++));
                        user.setMailEnabled(result.getBoolean(pos++));
                        user.setImapServer(result.getString(pos++));
                        user.setImapLogin(result.getString(pos++));
                        user.setSmtpServer(result.getString(pos++));
                        user.setMailDomain(result.getString(pos++));
                        user.setShadowLastChange(result.getInt(pos++));
                        if (result.wasNull()) {
                            user.setShadowLastChange(-1);
                        }
                        user.setMail(result.getString(pos++));
                        user.setTimeZone(result.getString(pos++));
                        user.setPreferredLanguage(result.getString(pos++));
                        user.setPasswordMech(result.getString(pos++));
                        user.setContactId(result.getInt(pos++));
                        users.put(user.getId(), (Object)user);
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.LOAD_FAILED.create(e, e.getMessage());
        }
        for (int userId : userIds) {
            if (users.containsKey(userId)) continue;
            throw UserExceptionCode.USER_NOT_FOUND.create(Autoboxing.I((int)userId), Autoboxing.I((int)ctx.getContextId()));
        }
        RdbUserStorage.loadLoginInfo(ctx, con, (TIntObjectMap<UserImpl>)users);
        RdbUserStorage.loadContact(ctx, con, (TIntObjectMap<UserImpl>)users);
        RdbUserStorage.loadGroups(ctx, con, (TIntObjectMap<UserImpl>)users);
        RdbUserStorage.loadAttributes(ctx.getContextId(), con, (TIntObjectMap<UserImpl>)users, false);
        User[] retval = new User[users.size()];
        for (int i = 0; i < length; ++i) {
            retval[i] = (User)users.get(userIds[i]);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User[] getUser(Context ctx) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            User[] userArray = RdbUserStorage.getUser(ctx, con, RdbUserStorage.listAllUser(ctx, con));
            return userArray;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User[] getUser(Context ctx, int[] userIds) throws OXException {
        if (0 == userIds.length) {
            return new User[0];
        }
        Connection con = DBPool.pickup(ctx);
        try {
            User[] userArray = RdbUserStorage.getUser(ctx, con, userIds);
            return userArray;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLoginInfo(Context context, Connection con, TIntObjectMap<UserImpl> users) throws OXException {
        try {
            TIntIterator iter = users.keySet().iterator();
            for (int i = 0; i < users.size(); i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int length = Arrays.determineRealSize((int)users.size(), (int)i, (int)1000);
                    stmt = con.prepareStatement(DBUtils.getIN(SELECT_LOGIN, length));
                    int pos = 1;
                    stmt.setInt(pos++, context.getContextId());
                    for (int j = 0; j < length; ++j) {
                        stmt.setInt(pos++, iter.next());
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        ((UserImpl)users.get(result.getInt(1))).setLoginInfo(result.getString(2));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadContact(Context ctx, Connection con, TIntObjectMap<UserImpl> users) throws OXException {
        try {
            Iterator iter = users.valueCollection().iterator();
            for (int i = 0; i < users.size(); i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int length = Arrays.determineRealSize((int)users.size(), (int)i, (int)1000);
                    stmt = con.prepareStatement(DBUtils.getIN(SELECT_CONTACT, length));
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    TIntObjectHashMap userByContactId = new TIntObjectHashMap(length, 1.0f);
                    for (int j = 0; j < length; ++j) {
                        UserImpl user = (UserImpl)iter.next();
                        stmt.setInt(pos++, user.getContactId());
                        userByContactId.put(user.getContactId(), (Object)user);
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        pos = 1;
                        UserImpl user = (UserImpl)userByContactId.get(result.getInt(pos++));
                        user.setGivenName(result.getString(pos++));
                        user.setSurname(result.getString(pos++));
                        user.setDisplayName(result.getString(pos++));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadGroups(Context context, Connection con, TIntObjectMap<UserImpl> users) throws OXException {
        TIntObjectHashMap tmp = new TIntObjectHashMap(users.size(), 1.0f);
        for (UserImpl user : users.valueCollection()) {
            TIntArrayList userGroups = new TIntArrayList();
            userGroups.add(0);
            tmp.put(user.getId(), (Object)userGroups);
        }
        try {
            TIntIterator iter = users.keySet().iterator();
            for (int i = 0; i < users.size(); i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int length = Arrays.determineRealSize((int)users.size(), (int)i, (int)1000);
                    String sql = DBUtils.getIN("SELECT member,id FROM groups_member WHERE cid=? AND member IN (", length);
                    stmt = con.prepareStatement(sql);
                    int pos = 1;
                    stmt.setInt(pos++, context.getContextId());
                    for (int j = 0; j < length; ++j) {
                        stmt.setInt(pos++, iter.next());
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        ((TIntList)tmp.get(result.getInt(1))).add(result.getInt(2));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        for (UserImpl user : users.valueCollection()) {
            user.setGroups(((TIntList)tmp.get(user.getId())).toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAttributes(int contextId, Connection con, TIntObjectMap<UserImpl> users, boolean lockRows) throws OXException {
        if (lockRows && users.size() != 1) {
            throw UserExceptionCode.LOCKING_NOT_ALLOWED.create(Autoboxing.I((int)users.size()));
        }
        TIntObjectHashMap usersAttrs = new TIntObjectHashMap();
        try {
            TIntIterator iter = users.keySet().iterator();
            for (int i = 0; i < users.size(); i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int length = Arrays.determineRealSize((int)users.size(), (int)i, (int)1000);
                    String sql = DBUtils.getIN(SELECT_ATTRS, length);
                    if (lockRows) {
                        sql = sql + " FOR UPDATE";
                    }
                    stmt = con.prepareStatement(sql);
                    int pos = 1;
                    stmt.setInt(pos++, contextId);
                    for (int j = 0; j < length; ++j) {
                        int userId = iter.next();
                        stmt.setInt(pos++, userId);
                        usersAttrs.put(userId, new HashMap());
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        String name;
                        Map attrs = (Map)usersAttrs.get(result.getInt(1));
                        UserAttribute attribute = (UserAttribute)attrs.get(name = result.getString(3));
                        if (null == attribute) {
                            attribute = new UserAttribute(name);
                            attrs.put(name, attribute);
                        }
                        byte[] bytes = result.getBytes(2);
                        UUID uuid = result.wasNull() ? null : UUIDs.toUUID((byte[])bytes);
                        attribute.addValue(new AttributeValue(result.getString(4), uuid));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        for (UserImpl user : users.valueCollection()) {
            Map attrs = (Map)usersAttrs.get(user.getId());
            UserAttribute aliases = (UserAttribute)attrs.get("alias");
            if (aliases == null) {
                user.setAliases(new String[0]);
            } else {
                ArrayList<String> tmp = new ArrayList<String>(aliases.size());
                for (String alias : aliases.getStringValues()) {
                    try {
                        tmp.add(new QuotedInternetAddress(alias, false).toUnicodeString());
                    }
                    catch (Exception e) {
                        tmp.add(alias);
                    }
                }
                user.setAliases(tmp.toArray(new String[tmp.size()]));
            }
            user.setAttributesInternal(attrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void updateUserInternal(User user, Context context) throws OXException {
        int contextId = context.getContextId();
        int userId = user.getId();
        String password = user.getUserPassword();
        String mech = user.getPasswordMech();
        int shadowLastChanged = user.getShadowLastChange();
        try {
            DBUtils.TransactionRollbackCondition condition = new DBUtils.TransactionRollbackCondition(3);
            do {
                Connection con;
                try {
                    con = DBPool.pickupWriteable(context);
                }
                catch (OXException e) {
                    throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("USR");
                }
                condition.resetTransactionRollbackException();
                boolean rollback = false;
                try {
                    int pos;
                    DBUtils.startTransaction(con);
                    rollback = true;
                    Enum[] fields = (UserField[])MAPPER.getAssignedFields(user);
                    if (fields.length > 0) {
                        PreparedStatement stmt = null;
                        try {
                            String sql = "UPDATE user SET " + MAPPER.getAssignments(fields) + " WHERE cid=? AND id=?";
                            stmt = con.prepareStatement(sql);
                            MAPPER.setParameters(stmt, user, fields);
                            pos = 1 + fields.length;
                            stmt.setInt(pos++, contextId);
                            stmt.setInt(pos++, userId);
                            stmt.execute();
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(stmt);
                            throw throwable;
                        }
                        DBUtils.closeSQLStuff(stmt);
                    }
                    if (null != user.getAttributes()) {
                        RdbUserStorage.updateAttributes(context, user, con);
                    }
                    if (null != password && null != mech) {
                        String encodedPassword = null;
                        PreparedStatement stmt = null;
                        try {
                            encodedPassword = PasswordMechanism.getEncodedPassword(mech, password);
                            stmt = con.prepareStatement(SQL_UPDATE_PASSWORD);
                            pos = 1;
                            stmt.setString(pos++, encodedPassword);
                            stmt.setInt(pos++, shadowLastChanged);
                            stmt.setInt(pos++, contextId);
                            stmt.setInt(pos++, userId);
                            stmt.execute();
                        }
                        catch (UnsupportedEncodingException e) {
                            try {
                                throw new SQLException(e.toString());
                                catch (NoSuchAlgorithmException e2) {
                                    throw new SQLException(e2.toString());
                                }
                            }
                            catch (Throwable throwable) {
                                DBUtils.closeSQLStuff(stmt);
                                throw throwable;
                            }
                        }
                        DBUtils.closeSQLStuff(stmt);
                    }
                    con.commit();
                    rollback = false;
                }
                catch (SQLException e) {
                    if (condition.isFailedTransactionRollback(e)) continue;
                    throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                }
                finally {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.autocommit(con);
                    DBPool.closeWriterSilent(context, con);
                }
            } while (condition.checkRetry());
            return;
        }
        catch (SQLException e) {
            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
        }
    }

    @Override
    public void setUserAttribute(String name, String value, int userId, Context context) throws OXException {
        if (null == name) {
            throw LdapExceptionCode.UNEXPECTED_ERROR.create("Attribute name is null.").setPrefix("USR");
        }
        String attrName = "attr_" + name;
        this.setAttribute(attrName, value, userId, context);
    }

    @Override
    public void setAttribute(String name, String value, int userId, Context context) throws OXException {
        PreparedStatement stmt;
        Connection con;
        block8: {
            if (null == name) {
                throw LdapExceptionCode.UNEXPECTED_ERROR.create("Attribute name is null.").setPrefix("USR");
            }
            con = null;
            stmt = null;
            try {
                con = DBPool.pickupWriteable(context);
                if (value == null) {
                    stmt = con.prepareStatement("DELETE FROM user_attribute WHERE cid = ? AND id = ? AND name = ?");
                    stmt.setInt(1, context.getContextId());
                    stmt.setInt(2, userId);
                    stmt.setString(3, name);
                    stmt.executeUpdate();
                    break block8;
                }
                RdbUserStorage.insertOrUpdateAttribute(name, value, userId, context, con);
            }
            catch (SQLException e) {
                try {
                    throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                }
                catch (Throwable throwable) {
                    Databases.closeSQLStuff(stmt);
                    if (con != null) {
                        DBPool.closeWriterSilent(context, con);
                    }
                    throw throwable;
                }
            }
        }
        Databases.closeSQLStuff((Statement)stmt);
        if (con != null) {
            DBPool.closeWriterSilent(context, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void insertOrUpdateAttribute(String name, String value, int userId, Context context, Connection con) throws OXException {
        int contextId = context.getContextId();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Databases.startTransaction((Connection)con);
            stmt = con.prepareStatement("SELECT uuid FROM user_attribute WHERE cid=? AND id=? AND name=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, name);
            rs = stmt.executeQuery();
            LinkedList<UUID> toUpdate = new LinkedList<UUID>();
            while (rs.next()) {
                toUpdate.add(UUIDs.toUUID((byte[])rs.getBytes(1)));
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            if (toUpdate.isEmpty()) {
                stmt = con.prepareStatement("INSERT INTO user_attribute (cid,id,name,value,uuid) VALUES (?,?,?,?,?)");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                stmt.setString(3, name);
                stmt.setString(4, value);
                stmt.setBytes(5, UUIDs.toByteArray((UUID)UUID.randomUUID()));
                stmt.executeUpdate();
            } else {
                int[] updateCounts;
                stmt = con.prepareStatement("UPDATE user_attribute SET value=?,uuid=? WHERE cid=? AND id=? AND name=? AND uuid=?");
                for (UUID uuid : toUpdate) {
                    stmt.setString(1, value);
                    stmt.setBytes(2, UUIDs.toByteArray((UUID)UUID.randomUUID()));
                    stmt.setInt(3, contextId);
                    stmt.setInt(4, userId);
                    stmt.setString(5, name);
                    stmt.setBytes(6, UUIDs.toByteArray((UUID)uuid));
                    stmt.addBatch();
                }
                for (int updateCount : updateCounts = stmt.executeBatch()) {
                    if (updateCount == 1) continue;
                    LOG.error("Concurrent modification of attribute '{}' for user {} in context {}. New value '{}' could not be set.", new Object[]{name, Autoboxing.I((int)userId), Autoboxing.I((int)contextId), value});
                    throw UserExceptionCode.CONCURRENT_ATTRIBUTES_UPDATE.create(Autoboxing.I((int)contextId), Autoboxing.I((int)userId));
                }
            }
            con.commit();
        }
        catch (SQLException e) {
            try {
                Databases.rollback((Connection)con);
                throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
                catch (OXException e2) {
                    Databases.rollback((Connection)con);
                    throw e2;
                }
                catch (RuntimeException e3) {
                    Databases.rollback((Connection)con);
                    throw UserExceptionCode.SQL_ERROR.create(e3, e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(stmt);
                Databases.autocommit((Connection)con);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((Statement)stmt);
        Databases.autocommit((Connection)con);
    }

    @Override
    public String getUserAttribute(String name, int userId, Context context) throws OXException {
        if (null == name) {
            throw LdapExceptionCode.UNEXPECTED_ERROR.create("Attribute name is null.").setPrefix("USR");
        }
        Connection con = DBPool.pickup(context);
        try {
            String attrName = "attr_" + name;
            String string = RdbUserStorage.getAttribute(context.getContextId(), con, userId, attrName);
            return string;
        }
        catch (SQLException e) {
            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
        }
        catch (Exception e) {
            throw LdapExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage()).setPrefix("USR");
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAttribute(int contextId, Connection con, int userId, String name) throws SQLException {
        String string;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT value FROM user_attribute WHERE cid=? AND id=? AND name=?");
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setString(pos, name);
            rs = stmt.executeQuery();
            string = rs.next() ? rs.getString(1) : null;
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return string;
    }

    private static void updateAttributes(Context ctx, User user, Connection con) throws SQLException, OXException {
        int contextId = ctx.getContextId();
        int userId = user.getId();
        TIntObjectMap<UserImpl> loadMap = RdbUserStorage.createSingleUserMap(userId);
        RdbUserStorage.loadAttributes(ctx.getContextId(), con, loadMap, true);
        Map<String, UserAttribute> oldAttributes = ((UserImpl)loadMap.get(userId)).getAttributesInternal();
        Map<String, UserAttribute> attributes = UserImpl.toInternal(user.getAttributes());
        RdbUserStorage.updateAttributes(contextId, userId, con, oldAttributes, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateAttributes(int contextId, int userId, Connection con, Map<String, UserAttribute> oldAttributes, Map<String, UserAttribute> attributes) throws SQLException, OXException {
        UUID uuid;
        boolean retval = false;
        HashMap<String, UserAttribute> added = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> removed = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> changed = new HashMap<String, UserAttribute>();
        RdbUserStorage.calculateDifferences(oldAttributes, attributes, added, removed, changed);
        PreparedStatement stmt = null;
        PreparedStatement stmt2 = null;
        if (!added.isEmpty()) {
            try {
                stmt = con.prepareStatement("INSERT INTO user_attribute (cid,id,name,value,uuid) VALUES (?,?,?,?,?)");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                int size = 0;
                for (Map.Entry entry : added.entrySet()) {
                    UserAttribute userAttribute = (UserAttribute)entry.getValue();
                    for (AttributeValue value : userAttribute.getValues()) {
                        stmt.setString(3, userAttribute.getName());
                        stmt.setString(4, value.getValue());
                        uuid = value.getUuid();
                        stmt.setBytes(5, UUIDs.toByteArray((UUID)(null == uuid ? UUID.randomUUID() : uuid)));
                        stmt.addBatch();
                        ++size;
                    }
                }
                int lines = 0;
                for (int mLine : stmt.executeBatch()) {
                    lines += mLine;
                }
                if (size != lines) {
                    OXException e = UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.create(Autoboxing.I((int)contextId), Autoboxing.I((int)userId));
                    LOG.error(String.format("Old: %1$s, New: %2$s, Added: %3$s, Removed: %4$s, Changed: %5$s.", oldAttributes, attributes, added, removed, changed), (Throwable)e);
                    throw e;
                }
                retval = true;
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
        boolean hasPrimaryKey = RdbUserStorage.hasPrimaryKey("user_attribute", con);
        if (!removed.isEmpty()) {
            try {
                stmt = con.prepareStatement("DELETE FROM user_attribute WHERE cid=? AND id=? AND name=? AND value=?");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                stmt2 = con.prepareStatement("DELETE FROM user_attribute WHERE cid=? AND uuid=?");
                stmt2.setInt(1, contextId);
                int size = 0;
                for (UserAttribute attribute : removed.values()) {
                    for (AttributeValue value : attribute.getValues()) {
                        uuid = value.getUuid();
                        if (hasPrimaryKey && null != uuid) {
                            stmt2.setBytes(2, UUIDs.toByteArray((UUID)uuid));
                            stmt2.addBatch();
                        } else {
                            stmt.setString(3, attribute.getName());
                            stmt.setString(4, value.getValue());
                            stmt.addBatch();
                        }
                        ++size;
                    }
                }
                int lines = 0;
                for (int mLine : stmt.executeBatch()) {
                    lines += mLine;
                }
                for (int mLine : stmt2.executeBatch()) {
                    lines += mLine;
                }
                if (size != lines) {
                    OXException e = UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.create(Autoboxing.I((int)contextId), Autoboxing.I((int)userId));
                    LOG.error(String.format("Old: %1$s, New: %2$s, Added: %3$s, Removed: %4$s, Changed: %5$s.", oldAttributes, attributes, added, removed, changed), (Throwable)e);
                    throw e;
                }
                retval = true;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.closeSQLStuff(stmt2);
                throw throwable;
            }
            DBUtils.closeSQLStuff(stmt);
            DBUtils.closeSQLStuff(stmt2);
        }
        if (!changed.isEmpty()) {
            try {
                int j;
                int[] mLines2;
                int[] mLines1;
                stmt = con.prepareStatement("UPDATE user_attribute SET value=? WHERE cid=? AND id=? AND name=? AND value=?");
                stmt.setInt(2, contextId);
                stmt.setInt(3, userId);
                stmt2 = con.prepareStatement("UPDATE user_attribute SET value=? WHERE cid=? AND uuid=?");
                stmt2.setInt(2, contextId);
                int size1 = 0;
                int size2 = 0;
                for (UserAttribute attribute : changed.values()) {
                    for (AttributeValue value : attribute.getValues()) {
                        UUID uuid2 = value.getUuid();
                        if (hasPrimaryKey && null != uuid2) {
                            stmt2.setString(1, value.getNewValue());
                            stmt2.setBytes(3, UUIDs.toByteArray((UUID)uuid2));
                            stmt2.addBatch();
                            ++size2;
                            continue;
                        }
                        stmt.setString(1, value.getNewValue());
                        stmt.setString(4, attribute.getName());
                        stmt.setString(5, value.getValue());
                        stmt.addBatch();
                        ++size1;
                    }
                }
                int lines1 = 0;
                for (int mLine : mLines1 = stmt.executeBatch()) {
                    lines1 += mLine;
                }
                int lines2 = 0;
                for (int mLine : mLines2 = stmt2.executeBatch()) {
                    lines2 += mLine;
                }
                if (size1 != lines1) {
                    boolean onlyLoginsFailed = true;
                    j = 0;
                    for (Map.Entry entry : changed.entrySet()) {
                        if (!((String)entry.getKey()).startsWith("client:") && mLines1[j] != 1) {
                            onlyLoginsFailed = false;
                            break;
                        }
                        ++j;
                    }
                    if (!onlyLoginsFailed) {
                        OXException e = UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.create(Autoboxing.I((int)contextId), Autoboxing.I((int)userId));
                        LOG.error("Old: {}, New: {}, Added: {}, Removed: {}, Changed: {}.", new Object[]{oldAttributes, attributes, added, removed, changed, e});
                        LOG.error("Expected lines: {} Updated lines: {}", (Object)size1, (Object)lines1);
                        TIntObjectMap<UserImpl> map = RdbUserStorage.createSingleUserMap(userId);
                        RdbUserStorage.loadAttributes(contextId, con, map, false);
                        for (int i : map.keys()) {
                            LOG.error("User {}: {}", (Object)i, ((UserImpl)map.get(i)).getAttributes());
                        }
                        throw e;
                    }
                }
                if (size2 != lines2) {
                    boolean onlyLoginsFailed = true;
                    j = 0;
                    for (Map.Entry entry : changed.entrySet()) {
                        if (!((String)entry.getKey()).startsWith("client:") && mLines2[j] != 1) {
                            onlyLoginsFailed = false;
                            break;
                        }
                        ++j;
                    }
                    if (!onlyLoginsFailed) {
                        OXException e = UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.create(Autoboxing.I((int)contextId), Autoboxing.I((int)userId));
                        LOG.error("Old: {}, New: {}, Added: {}, Removed: {}, Changed: {}.", new Object[]{oldAttributes, attributes, added, removed, changed, e});
                        LOG.error("Expected lines: {} Updated lines: {}", (Object)size2, (Object)lines2);
                        TIntObjectMap<UserImpl> map = RdbUserStorage.createSingleUserMap(userId);
                        RdbUserStorage.loadAttributes(contextId, con, map, false);
                        for (int i : map.keys()) {
                            LOG.error("User {}: {}", (Object)i, ((UserImpl)map.get(i)).getAttributes());
                        }
                        throw e;
                    }
                }
                retval = true;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.closeSQLStuff(stmt2);
                throw throwable;
            }
            DBUtils.closeSQLStuff(stmt);
            DBUtils.closeSQLStuff(stmt2);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasPrimaryKey(String table, Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet primaryKeys = metaData.getPrimaryKeys(null, null, table);
        try {
            boolean bl = primaryKeys.next();
            return bl;
        }
        finally {
            DBUtils.closeSQLStuff(primaryKeys);
        }
    }

    private static TIntObjectMap<UserImpl> createSingleUserMap(int userId) {
        UserImpl load = new UserImpl();
        load.setId(userId);
        TIntObjectHashMap loadMap = new TIntObjectHashMap(1);
        loadMap.put(userId, (Object)load);
        return loadMap;
    }

    static void calculateDifferences(Map<String, UserAttribute> oldAttributes, Map<String, UserAttribute> newAttributes, Map<String, UserAttribute> added, Map<String, UserAttribute> removed, Map<String, UserAttribute> changed) {
        added.putAll(newAttributes);
        for (String key : oldAttributes.keySet()) {
            added.remove(key);
        }
        removed.putAll(oldAttributes);
        for (String key : newAttributes.keySet()) {
            removed.remove(key);
        }
        for (String key : newAttributes.keySet()) {
            if (!oldAttributes.containsKey(key)) continue;
            RdbUserStorage.compareValues(key, oldAttributes.get(key), newAttributes.get(key), added, removed, changed);
        }
    }

    private static void compareValues(String name, UserAttribute oldSet, UserAttribute newSet, Map<String, UserAttribute> added, Map<String, UserAttribute> removed, Map<String, UserAttribute> changed) {
        HashSet<String> addedValues = new HashSet<String>(newSet.getStringValues());
        HashSet<String> removedValues = new HashSet<String>(oldSet.getStringValues());
        addedValues.removeAll(oldSet.getStringValues());
        removedValues.removeAll(newSet.getStringValues());
        Iterator addedIter = addedValues.iterator();
        Iterator removedIter = removedValues.iterator();
        while (addedIter.hasNext() && removedIter.hasNext()) {
            UserAttribute attribute = changed.get(name);
            if (null == attribute) {
                attribute = new UserAttribute(name);
                changed.put(name, attribute);
            }
            AttributeValue value = oldSet.getValue((String)removedIter.next());
            attribute.addValue(new AttributeValue(value, (String)addedIter.next()));
        }
        while (addedIter.hasNext()) {
            RdbUserStorage.add(added, name, new AttributeValue((String)addedIter.next()));
        }
        while (removedIter.hasNext()) {
            RdbUserStorage.add(removed, name, oldSet.getValue((String)removedIter.next()));
        }
    }

    private static void add(Map<String, UserAttribute> attributes, String name, AttributeValue value) {
        UserAttribute values = attributes.get(name);
        if (null == values) {
            values = new UserAttribute(name);
            attributes.put(name, values);
        }
        values.addValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User[] searchUserByName(String name, Context context, int searchType) throws OXException {
        if (0 == searchType) {
            return new User[0];
        }
        Connection con = DBPool.pickup(context);
        try {
            TIntHashSet userIds;
            block22: {
                boolean searchDisplayName;
                boolean searchLoginName;
                ResultSet result;
                PreparedStatement stmt;
                int contextId;
                String pattern;
                block23: {
                    pattern = StringCollection.prepareForSearch(name, false, true);
                    contextId = context.getContextId();
                    userIds = new TIntHashSet();
                    stmt = null;
                    result = null;
                    searchLoginName = (searchType & 1) > 0;
                    boolean bl = searchDisplayName = (searchType & 2) > 0;
                    if (!searchDisplayName || !searchLoginName) break block23;
                    try {
                        stmt = con.prepareStatement("SELECT con.userid FROM prg_contacts con JOIN login2user lu ON con.userid = lu.id AND con.cid = lu.cid WHERE con.cid = ? AND (lu.uid LIKE ? OR con.field01 LIKE ?)");
                        stmt.setInt(1, contextId);
                        stmt.setString(2, pattern);
                        stmt.setString(3, pattern);
                        result = stmt.executeQuery();
                        while (result.next()) {
                            userIds.add(result.getInt(1));
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(result, stmt);
                            throw throwable;
                        }
                    }
                    DBUtils.closeSQLStuff(result, stmt);
                    break block22;
                }
                if (searchLoginName) {
                    try {
                        stmt = con.prepareStatement("SELECT id FROM login2user WHERE cid=? AND uid LIKE ?");
                        stmt.setInt(1, contextId);
                        stmt.setString(2, pattern);
                        result = stmt.executeQuery();
                        while (result.next()) {
                            userIds.add(result.getInt(1));
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(result, stmt);
                            throw throwable;
                        }
                    }
                    DBUtils.closeSQLStuff(result, stmt);
                }
                if (searchDisplayName) {
                    try {
                        stmt = con.prepareStatement("SELECT userid FROM prg_contacts WHERE cid=? AND fid=? AND userid IS NOT NULL AND field01 LIKE ?");
                        stmt.setInt(1, contextId);
                        stmt.setInt(2, 6);
                        stmt.setString(3, pattern);
                        result = stmt.executeQuery();
                        while (result.next()) {
                            userIds.add(result.getInt(1));
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(result, stmt);
                            throw throwable;
                        }
                    }
                    DBUtils.closeSQLStuff(result, stmt);
                }
            }
            User[] userArray = this.getUser(context, userIds.toArray());
            return userArray;
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    @Override
    public User searchUser(String email, Context context) throws OXException {
        return this.searchUser(email, context, true);
    }

    /*
     * Loose catch block
     */
    @Override
    public User searchUser(String email, Context context, boolean considerAliases) throws OXException {
        String sql = "SELECT id FROM user WHERE cid=? AND mail LIKE ?";
        Connection con = DBPool.pickup(context);
        try {
            String pattern = StringCollection.prepareForSearch(email, false, true);
            PreparedStatement stmt = null;
            ResultSet result = null;
            int userId = -1;
            try {
                stmt = con.prepareStatement(sql);
                stmt.setInt(1, context.getContextId());
                stmt.setString(2, pattern);
                result = stmt.executeQuery();
                if (result.next()) {
                    userId = result.getInt(1);
                }
            }
            catch (SQLException e) {
                try {
                    throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(result, stmt);
            try {
                if (userId == -1 && considerAliases) {
                    sql = "SELECT id FROM user_attribute WHERE cid=? AND name=? AND value LIKE ?";
                    stmt = con.prepareStatement(sql);
                    int pos = 1;
                    stmt.setInt(pos++, context.getContextId());
                    stmt.setString(pos++, "alias");
                    stmt.setString(pos++, pattern);
                    result = stmt.executeQuery();
                    if (result.next()) {
                        userId = result.getInt(1);
                    }
                }
                if (userId == -1) {
                    throw LdapExceptionCode.NO_USER_BY_MAIL.create(email).setPrefix("USR");
                }
                User pos = RdbUserStorage.getUser(context, con, new int[]{userId})[0];
                return pos;
            }
            catch (SQLException e) {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
            }
            finally {
                DBUtils.closeSQLStuff(result, stmt);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    @Override
    public User[] searchUserByMailLogin(String login, Context context) throws OXException {
        User[] userArray;
        String sql = "SELECT id FROM user WHERE cid=? AND imapLogin LIKE ?";
        Connection con = DBPool.pickup(context);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            String pattern = StringCollection.prepareForSearch(login, false, true);
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, context.getContextId());
            stmt.setString(2, pattern);
            result = stmt.executeQuery();
            TIntHashSet userIds = new TIntHashSet();
            while (result.next()) {
                userIds.add(result.getInt(1));
            }
            userArray = this.getUser(context, userIds.toArray());
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return userArray;
    }

    @Override
    public int[] listModifiedUser(Date modifiedSince, Context context) throws OXException {
        int[] users;
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("USR");
        }
        String sql = "SELECT id FROM user LEFT JOIN prg_contacts ON (user.cid=prg_contacts.cid AND user.contactId=prg_contacts.intfield01) WHERE cid=? AND changing_date>=?";
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM user LEFT JOIN prg_contacts ON (user.cid=prg_contacts.cid AND user.contactId=prg_contacts.intfield01) WHERE cid=? AND changing_date>=?");
            stmt.setInt(1, context.getContextId());
            stmt.setTimestamp(2, new Timestamp(modifiedSince.getTime()));
            result = stmt.executeQuery();
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            while (result.next()) {
                tmp.add(Autoboxing.I((int)result.getInt(1)));
            }
            users = new int[tmp.size()];
            for (int i = 0; i < users.length; ++i) {
                users[i] = (Integer)tmp.get(i);
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] listAllUser(Context context) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw UserExceptionCode.NO_CONNECTION.create(e, new Object[0]);
        }
        try {
            int[] nArray = RdbUserStorage.listAllUser(context, con);
            return nArray;
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    private static int[] listAllUser(Context ctx, Connection con) throws OXException {
        int[] users;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM user WHERE user.cid=?");
            stmt.setInt(1, ctx.getContextId());
            result = stmt.executeQuery();
            TIntArrayList tmp = new TIntArrayList();
            while (result.next()) {
                tmp.add(result.getInt(1));
            }
            users = tmp.toArray();
        }
        catch (SQLException e) {
            try {
                throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return users;
    }

    @Override
    public int[] resolveIMAPLogin(String imapLogin, Context context) throws OXException {
        int[] users;
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw UserExceptionCode.NO_CONNECTION.create(e, new Object[0]);
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT_IMAPLOGIN);
            int cid = context.getContextId();
            stmt.setInt(1, cid);
            stmt.setString(2, imapLogin);
            result = stmt.executeQuery();
            TIntArrayList sia = new TIntArrayList(4);
            if (result.next()) {
                do {
                    sia.add(result.getInt(1));
                } while (result.next());
            } else {
                throw UserExceptionCode.USER_NOT_FOUND.create(imapLogin, Autoboxing.I((int)cid));
            }
            users = sia.toArray();
        }
        catch (SQLException e) {
            try {
                throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return users;
    }

    @Override
    public void invalidateUser(Context ctx, int userId) {
    }

    @Override
    protected void startInternal() {
    }

    @Override
    protected void stopInternal() {
    }
}

