/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.java.Strings;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tools {
    private static final Pattern IS_NUMBERED_WITH_EXTENSION = Pattern.compile("\\(\\d+\\)\\.");
    private static final Pattern IS_NUMBERED = Pattern.compile("\\(\\d+\\)$");

    public static Set<String> getEnhancedWildcards(Set<String> fileNames) {
        HashSet<String> possibleWildcards = new HashSet<String>(fileNames.size());
        for (String filename : fileNames) {
            if (Strings.isEmpty((String)filename)) continue;
            StringBuilder stringBuilder = new StringBuilder(filename);
            Matcher matcher = IS_NUMBERED_WITH_EXTENSION.matcher(filename);
            if (matcher.find()) {
                stringBuilder.replace(matcher.start(), matcher.end() - 1, "(%)");
                possibleWildcards.add(stringBuilder.toString());
                continue;
            }
            matcher = IS_NUMBERED.matcher(filename);
            if (matcher.find()) {
                stringBuilder.replace(matcher.start(), matcher.end(), "(%)");
                possibleWildcards.add(stringBuilder.toString());
                continue;
            }
            int index = filename.lastIndexOf(46);
            if (0 >= index) {
                index = filename.length();
            }
            stringBuilder.insert(index, " (%)");
            possibleWildcards.add(stringBuilder.toString());
        }
        return possibleWildcards;
    }

    private Tools() {
    }
}

