/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contexts.impl;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.contexts.impl.ContextExtended;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbContextStorage
extends ContextStorage {
    private static final String SELECT_CONTEXT = "SELECT name,enabled,filestore_id,filestore_name,filestore_login,filestore_passwd,quota_max FROM context WHERE cid=?";
    private static final String RESOLVE_CONTEXT = "SELECT cid FROM login2context WHERE login_info=?";
    private static final String GET_MAILADMIN = "SELECT user FROM user_setting_admin WHERE cid=?";
    private static final String GET_LOGININFOS = "SELECT login_info FROM login2context WHERE cid=?";

    @Override
    public int getContextId(String loginInfo) throws OXException {
        Connection con;
        try {
            con = DBPool.pickup();
        }
        catch (OXException e) {
            throw ContextExceptionCodes.NO_CONNECTION.create(e, new Object[0]);
        }
        int contextId = -1;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(RESOLVE_CONTEXT);
            stmt.setString(1, loginInfo);
            result = stmt.executeQuery();
            if (result.next()) {
                contextId = result.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw ContextExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(con);
        return contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getAdmin(Context ctx) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            int n = RdbContextStorage.getAdmin(con, ctx.getContextId());
            return n;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    public static final int getAdmin(Connection con, int ctxId) throws OXException {
        int identifier = -1;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(GET_MAILADMIN);
            stmt.setInt(1, ctxId);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw ContextExceptionCodes.NO_MAILADMIN.create(ctxId);
            }
            identifier = result.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw ContextExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return identifier;
    }

    private String[] getLoginInfos(Context ctx) throws OXException {
        Connection con = DBPool.pickup();
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<String> loginInfo = new ArrayList<String>();
        try {
            stmt = con.prepareStatement(GET_LOGININFOS);
            stmt.setInt(1, ctx.getContextId());
            result = stmt.executeQuery();
            while (result.next()) {
                loginInfo.add(result.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw ContextExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(con);
        return loginInfo.toArray(new String[loginInfo.size()]);
    }

    @Override
    public ContextExtended loadContext(int contextId) throws OXException {
        ContextImpl context = this.loadContextData(contextId);
        context.setLoginInfo(this.getLoginInfos(context));
        context.setMailadmin(RdbContextStorage.getAdmin(context));
        this.loadAttributes(context);
        return context;
    }

    /*
     * Loose catch block
     */
    private void loadAttributes(ContextImpl ctx) throws OXException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            con = DBPool.pickup(ctx);
            stmt = con.prepareStatement("SELECT name, value FROM contextAttribute WHERE cid = ?");
            stmt.setInt(1, ctx.getContextId());
            result = stmt.executeQuery();
            while (result.next()) {
                String name = result.getString(1);
                String value = result.getString(2);
                ctx.addAttribute(name, value);
            }
        }
        catch (SQLException e) {
            block11: {
                if (Tools.tableExists(con, "contextAttribute")) break block11;
                DBUtils.closeSQLStuff(result, stmt);
                if (null != con) {
                    DBPool.closeReaderSilent(ctx, con);
                }
                return;
            }
            try {
                block13: {
                    break block13;
                    {
                        catch (SQLException e1) {
                            // empty catch block
                        }
                    }
                }
                throw ContextExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                if (null != con) {
                    DBPool.closeReaderSilent(ctx, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        if (null != con) {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextImpl loadContextData(int contextId) throws OXException {
        Connection con = DBPool.pickup();
        try {
            ContextImpl contextImpl = this.loadContextData(con, contextId);
            return contextImpl;
        }
        finally {
            DBPool.closeReaderSilent(con);
        }
    }

    public ContextImpl loadContextData(Connection con, int contextId) throws OXException {
        ContextImpl context = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT_CONTEXT);
            stmt.setInt(1, contextId);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw ContextExceptionCodes.NOT_FOUND.create(Autoboxing.I((int)contextId));
            }
            context = new ContextImpl(contextId);
            int pos = 1;
            context.setName(result.getString(pos++));
            context.setEnabled(result.getBoolean(pos++));
            context.setFilestoreId(result.getInt(pos++));
            context.setFilestoreName(result.getString(pos++));
            String[] auth = new String[]{result.getString(pos++), result.getString(pos++)};
            context.setFilestoreAuth(auth);
            context.setFileStorageQuota(result.getLong(pos++));
        }
        catch (SQLException e) {
            try {
                throw ContextExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return context;
    }

    @Override
    public List<Integer> getAllContextIds() throws OXException {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        Connection con = DBPool.pickup();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT cid FROM context");
            result = stmt.executeQuery();
            while (result.next()) {
                retval.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw ContextExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(con);
        return retval;
    }

    @Override
    public List<Integer> getAllContextIdsForFilestore(int filestoreId) throws OXException {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        Connection con = DBPool.pickup();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT cid FROM context WHERE filestore_id = ?");
            stmt.setInt(1, filestoreId);
            result = stmt.executeQuery();
            while (result.next()) {
                retval.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw ContextExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(con);
        return retval;
    }

    @Override
    protected void shutDown() {
    }

    @Override
    protected void startUp() {
    }

    @Override
    public void setAttribute(String name, String value, int contextId) throws OXException {
        PreparedStatement stmt;
        Connection con;
        DatabaseService dbService;
        block8: {
            if (null == name) {
                throw LdapExceptionCode.UNEXPECTED_ERROR.create("Attribute name is null.").setPrefix("CTX");
            }
            dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            con = null;
            stmt = null;
            try {
                con = dbService.getWritable(contextId);
                if (value == null) {
                    stmt = con.prepareStatement("DELETE FROM contextAttribute WHERE cid = ? AND name = ?");
                    stmt.setInt(1, contextId);
                    stmt.setString(2, name);
                    stmt.executeUpdate();
                    break block8;
                }
                RdbContextStorage.insertOrUpdateAttribute(name, value, contextId, con);
            }
            catch (SQLException e) {
                try {
                    throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("CTX");
                }
                catch (Throwable throwable) {
                    Databases.closeSQLStuff(stmt);
                    if (con != null) {
                        dbService.backWritable(contextId, con);
                    }
                    throw throwable;
                }
            }
        }
        Databases.closeSQLStuff((Statement)stmt);
        if (con != null) {
            dbService.backWritable(contextId, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void insertOrUpdateAttribute(String name, String newValue, int contextId, Connection con) throws OXException {
        PreparedStatement stmt;
        block11: {
            stmt = null;
            ResultSet rs = null;
            boolean rollback = false;
            try {
                Databases.startTransaction((Connection)con);
                rollback = true;
                stmt = con.prepareStatement("SELECT value FROM contextAttribute WHERE cid=? AND name=?");
                stmt.setInt(1, contextId);
                stmt.setString(2, name);
                rs = stmt.executeQuery();
                LinkedList<String> toUpdate = new LinkedList<String>();
                while (rs.next()) {
                    toUpdate.add(rs.getString(1));
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                if (toUpdate.isEmpty()) {
                    stmt = con.prepareStatement("INSERT INTO contextAttribute (cid,name,value) VALUES (?,?,?)");
                    stmt.setInt(1, contextId);
                    stmt.setString(2, name);
                    stmt.setString(3, newValue);
                    stmt.executeUpdate();
                } else {
                    int[] updateCounts;
                    stmt = con.prepareStatement("UPDATE contextAttribute SET value=? WHERE cid=? AND name=? AND value=?");
                    for (String oldValue : toUpdate) {
                        stmt.setString(1, newValue);
                        stmt.setInt(2, contextId);
                        stmt.setString(3, name);
                        stmt.setString(4, oldValue);
                        stmt.addBatch();
                    }
                    for (int updateCount : updateCounts = stmt.executeBatch()) {
                        if (updateCount == 1) continue;
                        Logger logger = LoggerFactory.getLogger(RdbContextStorage.class);
                        logger.error("Concurrent modification of attribute '{}' for context {}. New value '{}' could not be set.", new Object[]{name, Autoboxing.I((int)contextId), newValue});
                        throw ContextExceptionCodes.CONCURRENT_ATTRIBUTES_UPDATE.create(Autoboxing.I((int)contextId));
                    }
                }
                con.commit();
                rollback = false;
                if (!rollback) break block11;
            }
            catch (SQLException e) {
                try {
                    throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw UserExceptionCode.SQL_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.closeSQLStuff(stmt);
                    Databases.autocommit((Connection)con);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.closeSQLStuff((Statement)stmt);
        Databases.autocommit((Connection)con);
    }
}

