/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.AttachmentTimedResult;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.attach.impl.AttachmentListQueryAction;
import com.openexchange.groupware.attach.impl.AttachmentQueryCatalog;
import com.openexchange.groupware.attach.impl.AttachmentQuotaProvider;
import com.openexchange.groupware.attach.impl.CreateAttachmentAction;
import com.openexchange.groupware.attach.impl.DeleteAttachmentAction;
import com.openexchange.groupware.attach.impl.FireAttachedEventAction;
import com.openexchange.groupware.attach.impl.FireDetachedEventAction;
import com.openexchange.groupware.attach.impl.UpdateAttachmentAction;
import com.openexchange.groupware.attach.util.GetSwitch;
import com.openexchange.groupware.attach.util.SetSwitch;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.data.Check;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.DeltaImpl;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.quota.Quota;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.file.SaveFileAction;
import com.openexchange.tools.file.external.QuotaFileStorageExceptionCodes;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tx.Undoable;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.activation.FileTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentBaseImpl
extends DBService
implements AttachmentBase {
    private static final FetchMode fetchMode = FetchMode.PREFETCH;
    private static final AtomicReference<AttachmentQuotaProvider> QUOTA_PROVIDER_REF = new AtomicReference();
    static final Logger LOG = LoggerFactory.getLogger(AttachmentBaseImpl.class);
    private static final AttachmentQueryCatalog QUERIES = new AttachmentQueryCatalog();
    private final ThreadLocal<Context> contextHolder = new ThreadLocal();
    private final ThreadLocal<List<String>> fileIdRemoveList = new ThreadLocal();
    private final TIntObjectMap<List<AttachmentListener>> moduleListeners = new TIntObjectHashMap();
    private final TIntObjectMap<List<AttachmentAuthorization>> moduleAuthorizors = new TIntObjectHashMap();

    public AttachmentBaseImpl() {
    }

    public AttachmentBaseImpl(DBProvider provider) {
        super(provider);
    }

    public static void setQuotaProvider(AttachmentQuotaProvider quotaProvider) {
        QUOTA_PROVIDER_REF.set(quotaProvider);
    }

    @Override
    public long attachToObject(AttachmentMetadata attachment, InputStream data, Session session, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        String fileId;
        boolean newAttachment;
        this.checkMayAttach(ServerSessionAdapter.valueOf(session, ctx, user, userConfig), attachment.getModuleId(), attachment.getFolderId(), attachment.getAttachedId());
        this.checkCharacters(attachment);
        this.contextHolder.set(ctx);
        boolean bl = newAttachment = attachment.getId() == 0 || attachment.getId() == 0;
        if (newAttachment) {
            AttachmentQuotaProvider quotaProvider = QUOTA_PROVIDER_REF.get();
            if (quotaProvider == null) {
                LOG.warn("AttachmentQuotaProvider is not available, an attachment will be created without quota check!");
            } else {
                Quota amountQuota = quotaProvider.getAmountQuota(session);
                long limit = amountQuota.getLimit();
                long usage = amountQuota.getUsage();
                if (limit > 0L && amountQuota.getUsage() >= limit) {
                    throw QuotaExceptionCodes.QUOTA_EXCEEDED_ATTACHMENTS.create(new Object[]{usage, limit});
                }
            }
        }
        this.initDefaultFields(attachment, ctx, user);
        if (!newAttachment && data != null) {
            List<String> remove = this.getFiles(new int[]{attachment.getId()}, ctx);
            this.fileIdRemoveList.get().addAll(remove);
        }
        if (data != null) {
            try {
                fileId = this.saveFile(data, attachment, ctx);
            }
            catch (OXException e) {
                if (QuotaFileStorageExceptionCodes.STORE_FULL.getNumber() == e.getCode()) {
                    throw AttachmentExceptionCodes.OVER_LIMIT.create(e, new Object[0]);
                }
                throw AttachmentExceptionCodes.SAVE_FAILED.create(e, new Object[0]);
            }
        } else {
            if (newAttachment) {
                throw AttachmentExceptionCodes.FILE_MISSING.create();
            }
            fileId = this.findFileId(attachment.getId(), ctx);
        }
        attachment.setFileId(fileId);
        return this.save(attachment, newAttachment, session, ctx, user, userConfig);
    }

    @Override
    public long detachFromObject(int folderId, int objectId, int moduleId, int[] ids, Session session, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        this.checkMayDetach(ServerSessionAdapter.valueOf(session, ctx, user, userConfig), moduleId, folderId, objectId);
        if (ids.length == 0) {
            return System.currentTimeMillis();
        }
        this.contextHolder.set(ctx);
        List<String> files = this.getFiles(ids, ctx);
        long ts = this.removeAttachments(folderId, objectId, moduleId, ids, session, ctx, user, userConfig);
        this.fileIdRemoveList.get().addAll(files);
        return ts;
    }

    @Override
    public AttachmentMetadata getAttachment(Session session, int folderId, int objectId, int moduleId, int id, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        this.checkMayReadAttachments(ServerSessionAdapter.valueOf(session, ctx, user, userConfig), moduleId, folderId, objectId);
        this.contextHolder.set(ctx);
        return this.loadAttachment(folderId, id, ctx);
    }

    @Override
    public InputStream getAttachedFile(Session session, int folderId, int objectId, int moduleId, int id, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        this.checkMayReadAttachments(ServerSessionAdapter.valueOf(session, ctx, user, userConfig), moduleId, folderId, objectId);
        this.contextHolder.set(ctx);
        return this.getFile(id, ctx);
    }

    @Override
    public SortedSet<String> getAttachmentFileStoreLocationsperContext(Context ctx) throws OXException {
        TreeSet<String> retval = new TreeSet<String>();
        Connection readCon = null;
        String selectfileid = "SELECT file_id FROM prg_attachment WHERE file_id is not null AND cid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement("SELECT file_id FROM prg_attachment WHERE file_id is not null AND cid=?");
            stmt.setInt(1, ctx.getContextId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                retval.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        return retval;
    }

    @Override
    public TimedResult<AttachmentMetadata> getAttachments(Session session, int folderId, int attachedId, int moduleId, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.getAttachments(session, folderId, attachedId, moduleId, QUERIES.getFields(), null, 1, ctx, user, userConfig);
    }

    @Override
    public TimedResult<AttachmentMetadata> getAttachments(Session session, int folderId, int attachedId, int moduleId, AttachmentField[] columns, AttachmentField sort, int order, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        String join;
        this.checkMayReadAttachments(ServerSessionAdapter.valueOf(session, ctx, user, userConfig), moduleId, folderId, attachedId);
        this.contextHolder.set(ctx);
        AttachmentField[] cols = this.addCreationDateAsNeeded(columns);
        StringBuilder select = new StringBuilder("SELECT  ");
        int pos = Arrays.binarySearch(cols, AttachmentField.FOLDER_ID_LITERAL, new Comparator<AttachmentField>(){

            @Override
            public int compare(AttachmentField o1, AttachmentField o2) {
                if (o1.getId() < o2.getId()) {
                    return -1;
                }
                if (o1.getId() == o2.getId()) {
                    return 0;
                }
                return 1;
            }
        });
        if (pos >= 0) {
            String folderField;
            QUERIES.appendColumnListWithPrefix(select, (AttachmentField[])Arrays.copyOfRange(cols, 0, pos, AttachmentField[].class), "pa");
            switch (moduleId) {
                case 1: {
                    join = " LEFT JOIN prg_dates AS aux ON (pa.cid = aux.cid AND pa.attached = aux.intfield01)";
                    folderField = "aux.fid";
                    break;
                }
                case 4: {
                    join = " LEFT JOIN task_folder AS aux ON (pa.cid = aux.cid AND pa.attached = aux.id)";
                    folderField = "aux.folder";
                    break;
                }
                case 7: {
                    join = " LEFT JOIN prg_contacts AS aux ON (pa.cid = aux.cid AND pa.attached = aux.intfield01)";
                    folderField = "aux.fid";
                    break;
                }
                case 137: {
                    join = " LEFT JOIN infostore AS aux ON (pa.cid = aux.cid AND pa.attached = aux.id)";
                    folderField = "aux.fid";
                    break;
                }
                default: {
                    join = "";
                    folderField = "";
                }
            }
            if (pos > 0) {
                select.append(",");
            }
            select.append(folderField);
            if (pos < cols.length) {
                select.append(",");
            }
            QUERIES.appendColumnListWithPrefix(select, (AttachmentField[])Arrays.copyOfRange(cols, pos + 1, cols.length, AttachmentField[].class), "pa");
        } else {
            QUERIES.appendColumnListWithPrefix(select, cols, "pa");
            join = "";
        }
        select.append(" FROM prg_attachment AS pa ");
        select.append(join);
        select.append(" WHERE pa.module = ? and pa.attached = ? and pa.cid = ? ");
        if (sort != null) {
            select.append(" ORDER BY ");
            select.append("pa.").append(sort.getName());
            if (order == -1) {
                select.append(" DESC");
            } else {
                select.append(" ASC");
            }
        }
        return new AttachmentTimedResult(new AttachmentIterator(select.toString(), cols, ctx, folderId, fetchMode, moduleId, attachedId, ctx.getContextId()));
    }

    @Override
    public TimedResult<AttachmentMetadata> getAttachments(Session session, int folderId, int attachedId, int moduleId, int[] idsToFetch, AttachmentField[] columns, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        this.checkMayReadAttachments(ServerSessionAdapter.valueOf(session, ctx, user, userConfig), moduleId, folderId, attachedId);
        this.contextHolder.set(ctx);
        AttachmentField[] cols = this.addCreationDateAsNeeded(columns);
        StringBuilder select = new StringBuilder("SELECT ");
        QUERIES.appendColumnList(select, cols);
        select.append(" FROM prg_attachment WHERE module = ? and attached = ? and cid = ? and id in (");
        select.append(this.join(idsToFetch));
        select.append(')');
        return new AttachmentTimedResult(new AttachmentIterator(select.toString(), cols, ctx, folderId, fetchMode, moduleId, attachedId, ctx.getContextId()));
    }

    @Override
    public Delta<AttachmentMetadata> getDelta(Session session, int folderId, int attachedId, int moduleId, long ts, boolean ignoreDeleted, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.getDelta(session, folderId, attachedId, moduleId, ts, ignoreDeleted, QUERIES.getFields(), null, 1, ctx, user, userConfig);
    }

    @Override
    public Delta<AttachmentMetadata> getDelta(Session session, int folderId, int attachedId, int moduleId, long ts, boolean ignoreDeleted, AttachmentField[] columns, AttachmentField sort, int order, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        this.checkMayReadAttachments(ServerSessionAdapter.valueOf(session, ctx, user, userConfig), moduleId, folderId, attachedId);
        this.contextHolder.set(ctx);
        AttachmentField[] cols = this.addCreationDateAsNeeded(columns);
        StringBuilder select = new StringBuilder("SELECT ");
        for (AttachmentField field : cols) {
            select.append(field.getName());
            select.append(',');
        }
        select.setLength(select.length() - 1);
        select.append(" FROM prg_attachment WHERE module = ? and attached = ? and cid = ? and creation_date > ?");
        if (sort != null) {
            select.append(" ORDER BY ");
            select.append(sort.getName());
            if (order == -1) {
                select.append(" DESC");
            } else {
                select.append(" ASC");
            }
        }
        AttachmentIterator newIterator = new AttachmentIterator(select.toString(), cols, ctx, folderId, fetchMode, moduleId, attachedId, ctx.getContextId(), ts);
        SearchIterator deletedIterator = SearchIteratorAdapter.emptyIterator();
        if (!ignoreDeleted) {
            deletedIterator = new AttachmentIterator("SELECT id FROM del_attachment WHERE module = ? and attached = ? and cid = ? and del_date > ?", new AttachmentField[]{AttachmentField.ID_LITERAL}, ctx, folderId, fetchMode, moduleId, attachedId, ctx.getContextId(), ts);
        }
        return new DeltaImpl((SearchIterator)newIterator, SearchIteratorAdapter.emptyIterator(), deletedIterator, System.currentTimeMillis());
    }

    @Override
    public void registerAttachmentListener(AttachmentListener listener, int moduleId) {
        this.getListeners(moduleId).add(listener);
    }

    @Override
    public void removeAttachmentListener(AttachmentListener listener, int moduleId) {
        this.getListeners(moduleId).remove(listener);
    }

    private AttachmentField[] addCreationDateAsNeeded(AttachmentField[] columns) {
        for (AttachmentField attachmentField : columns) {
            if (attachmentField != AttachmentField.CREATION_DATE_LITERAL) continue;
            return columns;
        }
        int i = 0;
        AttachmentField[] copy = new AttachmentField[columns.length + 1];
        for (AttachmentField attachmentField : columns) {
            copy[i++] = attachmentField;
        }
        copy[i] = AttachmentField.CREATION_DATE_LITERAL;
        return copy;
    }

    private long fireAttached(AttachmentMetadata m, User user, UserConfiguration userConfig, Session session, Context ctx) throws OXException {
        FireAttachedEventAction fireAttached = new FireAttachedEventAction();
        fireAttached.setAttachments(Collections.singletonList(m));
        fireAttached.setSession(session);
        fireAttached.setContext(ctx);
        fireAttached.setSource(this);
        fireAttached.setUser(user);
        fireAttached.setUserConfiguration(userConfig);
        fireAttached.setProvider(this);
        fireAttached.setAttachmentListeners(this.getListeners(m.getModuleId()));
        this.perform(fireAttached, false);
        return fireAttached.getTimestamp();
    }

    private long fireDetached(List<AttachmentMetadata> deleted, int module, User user, UserConfiguration userConfig, Session session, Context ctx) throws OXException {
        FireDetachedEventAction fireDetached = new FireDetachedEventAction();
        fireDetached.setAttachments(deleted);
        fireDetached.setSession(session);
        fireDetached.setContext(ctx);
        fireDetached.setSource(this);
        fireDetached.setUser(user);
        fireDetached.setUserConfiguration(userConfig);
        fireDetached.setProvider(this);
        fireDetached.setAttachmentListeners(this.getListeners(module));
        this.perform(fireDetached, false);
        return fireDetached.getTimestamp();
    }

    @Override
    public void addAuthorization(AttachmentAuthorization authz, int moduleId) {
        this.getAuthorizors(moduleId).add(authz);
    }

    @Override
    public void removeAuthorization(AttachmentAuthorization authz, int moduleId) {
        this.getAuthorizors(moduleId).remove(authz);
    }

    @Override
    public void deleteAll(Context context) throws OXException {
        try {
            this.removeFiles(context);
        }
        catch (OXException e) {
            throw AttachmentExceptionCodes.FILE_DELETE_FAILED.create(e, Autoboxing.I((int)context.getContextId()));
        }
        try {
            this.removeDatabaseEntries(context);
        }
        catch (SQLException e) {
            LOG.error("SQL Exception: ", (Throwable)e);
            throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatabaseEntries(Context context) throws OXException, SQLException {
        Connection writeCon = null;
        Statement stmt = null;
        try {
            writeCon = this.getWriteConnection(context);
            stmt = writeCon.prepareStatement("DELETE FROM prg_attachment WHERE cid = ?");
            stmt.setInt(1, context.getContextId());
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.error("Can't close statement", (Throwable)e);
                }
            }
            this.releaseWriteConnection(context, writeCon);
        }
    }

    private void removeFiles(Context context) throws OXException, OXException {
        QuotaFileStorage fs = this.getFileStorage(context);
        for (String fileId : this.getAttachmentFileStoreLocationsperContext(context)) {
            ((FileStorage)fs).deleteFile(fileId);
        }
    }

    private List<AttachmentAuthorization> getAuthorizors(int moduleId) {
        ArrayList authorizors = (ArrayList)this.moduleAuthorizors.get(moduleId);
        if (authorizors == null) {
            authorizors = new ArrayList();
            this.moduleAuthorizors.put(moduleId, authorizors);
        }
        return authorizors;
    }

    private void checkMayAttach(ServerSession session, int moduleId, int folderId, int objectId) throws OXException {
        for (AttachmentAuthorization authz : this.getAuthorizors(moduleId)) {
            authz.checkMayAttach(session, folderId, objectId);
        }
    }

    private void checkMayReadAttachments(ServerSession session, int moduleId, int folderId, int objectId) throws OXException {
        for (AttachmentAuthorization authz : this.getAuthorizors(moduleId)) {
            authz.checkMayReadAttachments(session, folderId, objectId);
        }
    }

    private void checkMayDetach(ServerSession session, int moduleId, int folderId, int objectId) throws OXException {
        for (AttachmentAuthorization authz : this.getAuthorizors(moduleId)) {
            authz.checkMayDetach(session, folderId, objectId);
        }
    }

    private List<AttachmentListener> getListeners(int moduleId) {
        ArrayList listener = (ArrayList)this.moduleListeners.get(moduleId);
        if (listener == null) {
            listener = new ArrayList();
            this.moduleListeners.put(moduleId, listener);
        }
        return listener;
    }

    private void initDefaultFields(AttachmentMetadata attachment, Context ctx, User user) throws OXException {
        attachment.setCreationDate(new Date());
        attachment.setCreatedBy(user.getId());
        if (attachment.getId() == 0) {
            Connection writeCon = null;
            boolean afterReading = true;
            try {
                int newId;
                writeCon = this.getWriteConnection(ctx);
                if (writeCon.getAutoCommit()) {
                    newId = IDGenerator.getId(ctx, 138);
                } else {
                    newId = IDGenerator.getId(ctx, 138, writeCon);
                    afterReading = false;
                }
                attachment.setId(newId);
            }
            catch (SQLException e) {
                throw AttachmentExceptionCodes.GENERATIING_ID_FAILED.create(e, new Object[0]);
            }
            finally {
                if (afterReading) {
                    this.releaseWriteConnectionAfterReading(ctx, writeCon);
                } else {
                    this.releaseWriteConnection(ctx, writeCon);
                }
            }
        }
        if (attachment.getFilename() != null && (attachment.getFileMIMEType() == null || attachment.getFileMIMEType().equals("application/unknown"))) {
            String mimetypes = FileTypeMap.getDefaultFileTypeMap().getContentType(attachment.getFilename());
            attachment.setFileMIMEType(mimetypes);
        }
    }

    private String saveFile(InputStream data, AttachmentMetadata attachment, Context ctx) throws OXException, OXException {
        SaveFileAction action = new SaveFileAction(this.getFileStorage(ctx), data, attachment.getFilesize(), false);
        action.perform();
        this.addUndoable((Undoable)action);
        attachment.setFilesize(action.getByteCount());
        return action.getFileStorageID();
    }

    private List<String> getFiles(int[] ids, Context ctx) throws OXException {
        ArrayList<String> files = new ArrayList<String>();
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder selectFileIds = new StringBuilder("SELECT file_id FROM prg_attachment WHERE id in (");
            selectFileIds.append(this.join(ids));
            selectFileIds.append(") AND cid = ?");
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(selectFileIds.toString());
            stmt.setInt(1, ctx.getContextId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                files.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                try {
                    this.rollbackDBTransaction();
                }
                catch (OXException x2) {
                    x2.log(LOG);
                }
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        return files;
    }

    private InputStream retrieveFile(String fileId, Context ctx) throws OXException {
        try {
            QuotaFileStorage fs = this.getFileStorage(ctx);
            return ((FileStorage)fs).getFile(fileId);
        }
        catch (OXException e) {
            throw AttachmentExceptionCodes.READ_FAILED.create(e, fileId);
        }
    }

    InputStream getFile(int id, Context ctx) throws OXException {
        String fileId = this.findFileId(id, ctx);
        return this.retrieveFile(fileId, ctx);
    }

    private String findFileId(int id, Context ctx) throws OXException {
        String string;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection readCon = null;
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(QUERIES.getSelectFileId());
            stmt.setInt(1, id);
            stmt.setInt(2, ctx.getContextId());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw AttachmentExceptionCodes.ATTACHMENT_NOT_FOUND.create();
            }
            string = rs.getString(1);
        }
        catch (SQLException e) {
            try {
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long removeAttachments(int folderId, int objectId, int moduleId, int[] ids, Session session, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        TimedResult<AttachmentMetadata> tr = this.getAttachments(session, folderId, objectId, moduleId, ids, QUERIES.getFields(), ctx, user, userConfig);
        boolean found = false;
        SearchIterator iter = null;
        ArrayList<AttachmentMetadata> recreate = new ArrayList<AttachmentMetadata>();
        try {
            iter = tr.results();
            while (iter.hasNext()) {
                found = true;
                AttachmentMetadata att = (AttachmentMetadata)iter.next();
                att.setFolderId(folderId);
                recreate.add(att);
            }
        }
        finally {
            if (null != iter) {
                try {
                    iter.close();
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
        if (!found) {
            return System.currentTimeMillis();
        }
        DeleteAttachmentAction delAction = new DeleteAttachmentAction();
        delAction.setAttachments(recreate);
        delAction.setContext(ctx);
        delAction.setProvider(this);
        delAction.setQueryCatalog(QUERIES);
        this.perform(delAction, true);
        return this.fireDetached(recreate, moduleId, user, userConfig, session, ctx);
    }

    @Override
    public int[] removeAttachment(String file_id, Context ctx) throws OXException {
        int[] retval = new int[2];
        long now = System.currentTimeMillis();
        Connection readCon = null;
        Connection writeCon = null;
        PreparedStatement stmt = null;
        StringBuilder rememberDel = null;
        ResultSet rs = null;
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement("SELECT id, attached, module FROM prg_attachment WHERE cid=? AND file_id=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setString(2, file_id);
            rs = stmt.executeQuery();
            rememberDel = new StringBuilder("INSERT INTO del_attachment (id, del_date, cid, attached, module) VALUES ");
            boolean found = false;
            if (rs.next()) {
                found = true;
                rememberDel.append('(');
                rememberDel.append(rs.getInt(1));
                rememberDel.append(',');
                rememberDel.append(now);
                rememberDel.append(',');
                rememberDel.append(ctx.getContextId());
                rememberDel.append(',');
                rememberDel.append(rs.getInt(2));
                rememberDel.append(',');
                rememberDel.append(rs.getInt(3));
                rememberDel.append(')');
            }
            if (!found) {
                throw AttachmentExceptionCodes.ATTACHMENT_WITH_FILEID_NOT_FOUND.create(file_id);
            }
        }
        catch (SQLException e) {
            try {
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                readCon = null;
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        readCon = null;
        try {
            writeCon = this.getWriteConnection(ctx);
            stmt = writeCon.prepareStatement(rememberDel.toString());
            retval[0] = stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("DELETE FROM prg_attachment WHERE cid=? AND file_id=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setString(2, file_id);
            retval[1] = stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
        }
        finally {
            this.close(stmt, null);
            this.releaseWriteConnection(ctx, writeCon);
        }
        return retval;
    }

    @Override
    public int modifyAttachment(String file_id, String new_file_id, String new_comment, String new_mime, Context ctx) throws OXException {
        int retval = -1;
        Connection writeCon = null;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String comment = null;
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement("SELECT comment FROM prg_attachment WHERE cid=? AND file_id=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setString(2, file_id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                comment = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                readCon = null;
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        readCon = null;
        comment = comment == null ? new_comment : comment.concat(new_comment);
        try {
            writeCon = this.getWriteConnection(ctx);
            stmt = writeCon.prepareStatement("UPDATE prg_attachment SET file_id=?, file_mimetype=?, comment=? WHERE cid=? AND file_id=?");
            stmt.setString(1, new_file_id);
            stmt.setString(2, new_mime);
            stmt.setString(3, comment);
            stmt.setInt(4, ctx.getContextId());
            stmt.setString(5, file_id);
            retval = stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
        }
        finally {
            this.close(stmt, null);
            this.releaseWriteConnection(ctx, readCon);
        }
        return retval;
    }

    private long save(AttachmentMetadata attachment, boolean newAttachment, Session session, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        AttachmentListQueryAction action = null;
        if (newAttachment) {
            CreateAttachmentAction createAction = new CreateAttachmentAction();
            createAction.setAttachments(Collections.singletonList(attachment));
            action = createAction;
        } else {
            AttachmentMetadata oldAttachment = this.loadAttachment(attachment.getFolderId(), attachment.getId(), ctx);
            UpdateAttachmentAction updateAction = new UpdateAttachmentAction();
            updateAction.setAttachments(Collections.singletonList(attachment));
            updateAction.setOldAttachments(Collections.singletonList(oldAttachment));
            action = updateAction;
        }
        action.setProvider(this);
        action.setContext(ctx);
        action.setQueryCatalog(QUERIES);
        this.perform(action, true);
        if (newAttachment) {
            return this.fireAttached(attachment, user, userConfig, session, ctx);
        }
        return System.currentTimeMillis();
    }

    private long countAttachmentsInContext(int contextId) throws OXException {
        long l;
        DatabaseService databaseService = ServerServiceRegistry.getServize(DatabaseService.class);
        if (null == databaseService) {
            throw ServiceExceptionCode.absentService(DatabaseService.class);
        }
        Connection con = databaseService.getReadOnly(contextId);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT count(id) FROM prg_attachment WHERE cid=?");
            stmt.setInt(1, contextId);
            rs = stmt.executeQuery();
            l = rs.next() ? rs.getLong(1) : 0L;
        }
        catch (SQLException e) {
            try {
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                databaseService.backReadOnly(contextId, con);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        databaseService.backReadOnly(contextId, con);
        return l;
    }

    private void checkCharacters(AttachmentMetadata attachment) throws OXException {
        StringBuilder errors = new StringBuilder();
        boolean invalid = false;
        GetSwitch get = new GetSwitch(attachment);
        for (AttachmentField field : AttachmentField.VALUES_ARRAY) {
            String error;
            Object value = field.doSwitch(get);
            if (null == value || !(value instanceof String) || null == (error = Check.containsInvalidChars((String)value))) continue;
            invalid = true;
            errors.append(field.getName()).append(' ').append(error).append('\n');
        }
        if (invalid) {
            throw AttachmentExceptionCodes.INVALID_CHARACTERS.create(errors.toString());
        }
    }

    private AttachmentMetadata loadAttachment(int folderId, int id, Context ctx) throws OXException {
        AttachmentMetadata attachmentMetadata;
        Connection readConnection = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            readConnection = this.getReadConnection(ctx);
            stmt = readConnection.prepareStatement(QUERIES.getSelectById());
            stmt.setInt(1, id);
            stmt.setInt(2, ctx.getContextId());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw AttachmentExceptionCodes.ATTACHMENT_NOT_FOUND.create();
            }
            attachmentMetadata = this.getFromResultSet(rs, folderId);
        }
        catch (SQLException e) {
            try {
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readConnection);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readConnection);
        return attachmentMetadata;
    }

    private AttachmentMetadata getFromResultSet(ResultSet rs, int folderId) throws SQLException {
        AttachmentImpl attachment = new AttachmentImpl();
        SetSwitch set = new SetSwitch(attachment);
        for (AttachmentField field : QUERIES.getFields()) {
            Object value = rs.getObject(field.getName());
            value = this.patchValue(value, field);
            set.setValue(value);
            field.doSwitch(set);
        }
        attachment.setFolderId(folderId);
        return attachment;
    }

    private boolean isDateField(AttachmentField field) {
        return field.equals(AttachmentField.CREATION_DATE_LITERAL);
    }

    private String join(int[] is) {
        StringBuilder b = new StringBuilder();
        for (int i : is) {
            b.append(i);
            b.append(',');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    Object patchValue(Object value, AttachmentField field) {
        if (value instanceof Long) {
            if (this.isDateField(field)) {
                return new Date((Long)value);
            }
            if (!field.equals(AttachmentField.FILE_SIZE_LITERAL)) {
                return ((Long)value).intValue();
            }
        }
        return value;
    }

    @Override
    public void commit() throws OXException {
        if (this.fileIdRemoveList.get().size() > 0) {
            try {
                QuotaFileStorage fs = this.getFileStorage(this.contextHolder.get());
                for (String fileId : this.fileIdRemoveList.get()) {
                    ((FileStorage)fs).deleteFile(fileId);
                }
            }
            catch (OXException e) {
                try {
                    this.rollback();
                }
                catch (OXException txe) {
                    e.log(LOG);
                }
                throw AttachmentExceptionCodes.FILE_DELETE_FAILED.create(e, Autoboxing.I((int)this.contextHolder.get().getContextId()));
            }
        }
    }

    @Override
    public void finish() throws OXException {
        this.fileIdRemoveList.set(null);
        this.contextHolder.set(null);
        super.finish();
    }

    @Override
    public void startTransaction() throws OXException {
        this.fileIdRemoveList.set(new ArrayList());
        this.contextHolder.set(null);
        super.startTransaction();
    }

    protected QuotaFileStorage getFileStorage(Context ctx) throws OXException, OXException {
        try {
            return QuotaFileStorage.getInstance(FilestoreStorage.createURI(ctx), ctx);
        }
        catch (OXException e) {
            throw AttachmentExceptionCodes.FILESTORE_DOWN.create(e, new Object[0]);
        }
    }

    @Override
    public Date getNewestCreationDate(Context ctx, int moduleId, int attachedId) throws OXException {
        return (Date)this.getNewestCreationDates(ctx, moduleId, new int[]{attachedId}).get(attachedId);
    }

    @Override
    public TIntObjectMap<Date> getNewestCreationDates(Context ctx, int moduleId, int[] attachedIds) throws OXException {
        TIntObjectHashMap tIntObjectHashMap;
        Connection con = this.getReadConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(DBUtils.getIN(QUERIES.getSelectNewestCreationDate(), attachedIds.length) + " GROUP BY attached");
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, moduleId);
            for (int attachedId : attachedIds) {
                stmt.setInt(pos++, attachedId);
            }
            result = stmt.executeQuery();
            TIntObjectHashMap retval = new TIntObjectHashMap();
            while (result.next()) {
                retval.put(result.getInt(1), (Object)new Date(result.getLong(2)));
            }
            tIntObjectHashMap = retval;
        }
        catch (SQLException e) {
            try {
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, result);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, result);
        this.releaseReadConnection(ctx, con);
        return tIntObjectHashMap;
    }

    public class AttachmentIterator
    implements SearchIterator<AttachmentMetadata> {
        private final String sql;
        private final AttachmentField[] columns;
        private boolean queried;
        private final Context ctx;
        private Connection readCon;
        private PreparedStatement stmt;
        private ResultSet rs;
        private Exception exception;
        private boolean initNext;
        private boolean hasNext;
        private final Object[] values;
        private final int folderId;
        private final FetchMode mode;
        private SearchIteratorAdapter<AttachmentMetadata> delegate;
        private final List<OXException> warnings = new ArrayList<OXException>(2);

        public AttachmentIterator(String sql, AttachmentField[] columns, Context ctx, int folderId, FetchMode mode, Object ... values) {
            this.sql = sql;
            this.columns = columns;
            this.ctx = ctx;
            this.values = values;
            this.folderId = folderId;
            this.mode = mode;
        }

        public boolean hasNext() throws OXException {
            SearchIteratorAdapter<AttachmentMetadata> delegate = this.delegate;
            if (delegate != null) {
                return delegate.hasNext();
            }
            try {
                if (!this.queried) {
                    this.queried = true;
                    this.query();
                    Exception exception = this.exception;
                    if (exception != null) {
                        if (exception instanceof OXException) {
                            throw (OXException)((Object)exception);
                        }
                        throw AttachmentExceptionCodes.SEARCH_PROBLEM.create(exception, new Object[0]);
                    }
                    delegate = this.delegate;
                    if (delegate != null) {
                        return delegate.hasNext();
                    }
                    this.initNext = true;
                }
                if (this.initNext) {
                    this.hasNext = null == this.rs ? false : this.rs.next();
                }
                this.initNext = false;
                return this.hasNext;
            }
            catch (SQLException e) {
                this.exception = e;
                return true;
            }
        }

        public AttachmentMetadata next() throws OXException {
            SearchIteratorAdapter<AttachmentMetadata> delegate = this.delegate;
            if (delegate != null) {
                return (AttachmentMetadata)delegate.next();
            }
            this.hasNext();
            Exception exception = this.exception;
            if (exception != null) {
                if (exception instanceof OXException) {
                    throw (OXException)((Object)exception);
                }
                throw AttachmentExceptionCodes.SEARCH_PROBLEM.create(exception, new Object[0]);
            }
            AttachmentMetadata m = this.nextFromResult(this.rs);
            this.initNext = true;
            return m;
        }

        private AttachmentMetadata nextFromResult(ResultSet rs) throws OXException {
            AttachmentImpl m = new AttachmentImpl();
            SetSwitch set = new SetSwitch(m);
            try {
                for (AttachmentField column : this.columns) {
                    Object value = column.equals(AttachmentField.FOLDER_ID_LITERAL) ? Integer.valueOf(this.folderId) : rs.getObject(column.getName());
                    value = AttachmentBaseImpl.this.patchValue(value, column);
                    set.setValue(value);
                    column.doSwitch(set);
                }
            }
            catch (SQLException e) {
                throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            return m;
        }

        public void close() throws OXException {
            if (this.delegate != null) {
                this.delegate.close();
                return;
            }
            DBUtils.closeSQLStuff(this.rs, this.stmt);
            if (null != this.readCon) {
                AttachmentBaseImpl.this.releaseReadConnection(this.ctx, this.readCon);
            }
        }

        public int size() {
            if (this.delegate != null) {
                return this.delegate.size();
            }
            return -1;
        }

        public boolean hasSize() {
            if (this.delegate != null) {
                return this.delegate.hasSize();
            }
            return false;
        }

        public void addWarning(OXException warning) {
            this.warnings.add(warning);
        }

        public OXException[] getWarnings() {
            return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        private void query() {
            try {
                this.readCon = AttachmentBaseImpl.this.getReadConnection(this.ctx);
                this.stmt = this.readCon.prepareStatement(this.sql);
                int i = 1;
                for (Object value : this.values) {
                    this.stmt.setObject(i++, value);
                }
                this.rs = this.stmt.executeQuery();
                if (this.mode.equals((Object)FetchMode.CLOSE_LATER)) {
                    return;
                }
                if (this.mode.equals((Object)FetchMode.CLOSE_IMMEDIATELY)) {
                    DBUtils.closeSQLStuff(this.stmt);
                    AttachmentBaseImpl.this.releaseReadConnection(this.ctx, this.readCon);
                    this.stmt = null;
                    this.readCon = null;
                } else if (this.mode.equals((Object)FetchMode.PREFETCH)) {
                    LinkedList<AttachmentMetadata> values = new LinkedList<AttachmentMetadata>();
                    while (this.rs.next()) {
                        values.add(this.nextFromResult(this.rs));
                    }
                    DBUtils.closeSQLStuff(this.rs, this.stmt);
                    AttachmentBaseImpl.this.releaseReadConnection(this.ctx, this.readCon);
                    this.stmt = null;
                    this.readCon = null;
                    this.rs = null;
                    this.delegate = new SearchIteratorAdapter(values.iterator());
                }
            }
            catch (SearchIteratorException e) {
                LOG.error(e.toString());
                this.exception = e;
            }
            catch (SQLException e) {
                LOG.error(e.toString());
                this.exception = e;
            }
            catch (OXException e) {
                LOG.error(e.toString());
                this.exception = e;
            }
        }
    }

    public static enum FetchMode {
        PREFETCH,
        CLOSE_LATER,
        CLOSE_IMMEDIATELY;

    }
}

