/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.sql;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.outlook.osgi.Services;
import com.openexchange.folderstorage.outlook.sql.Update;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

public final class Insert {
    private static final String SQL_INSERT = "INSERT INTO virtualTree (cid, tree, user, folderId, parentId, name, modifiedBy, lastModified, shadow) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_INSERT_PERM = "INSERT INTO virtualPermission (cid, tree, user, folderId, entity, groupFlag, fp, orp, owp, odp, adminFlag, system) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_INSERT_SUBS = "INSERT INTO virtualSubscription (cid, tree, user, folderId, subscribed) VALUES (?, ?, ?, ?, ?)";

    private Insert() {
    }

    public static void insertFolder(int cid, int tree, int user, Folder folder) throws OXException {
        DatabaseService databaseService = Services.getService(DatabaseService.class);
        Connection con = databaseService.getWritable(cid);
        try {
            con.setAutoCommit(false);
            Insert.insertFolder(cid, tree, user, folder, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    public static void insertFolder(int cid, int tree, int user, Folder folder, Connection con) throws OXException {
        if (null == con) {
            Insert.insertFolder(cid, tree, user, folder);
            return;
        }
        String folderId = folder.getID();
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_INSERT);
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos++, folderId);
            stmt.setString(pos++, folder.getParentID());
            stmt.setString(pos++, folder.getName());
            int modifiedBy = folder.getModifiedBy();
            if (modifiedBy == -1) {
                stmt.setNull(pos++, 4);
            } else {
                stmt.setInt(pos++, modifiedBy);
            }
            Date lastModified = folder.getLastModified();
            if (lastModified == null) {
                stmt.setNull(pos++, -5);
            } else {
                stmt.setLong(pos++, lastModified.getTime());
            }
            stmt.setString(pos, "");
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            if (Insert.isConstraintViolation(e) && e.getMessage().indexOf("Duplicate entry") >= 0) {
                Update.updateFolder(cid, tree, user, folder);
                return;
            }
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        Permission[] permissions = folder.getPermissions();
    }

    private static boolean isConstraintViolation(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        return null != sqlState && sqlState.startsWith("23");
    }
}

