/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.osgi;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import com.openexchange.ajax.customizer.folder.AdditionalFieldsUtils;
import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentTypeDiscoveryService;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.osgi.CacheFolderStorageActivator;
import com.openexchange.folderstorage.database.osgi.DatabaseFolderStorageActivator;
import com.openexchange.folderstorage.filestorage.osgi.FileStorageFolderStorageActivator;
import com.openexchange.folderstorage.internal.ContentTypeRegistry;
import com.openexchange.folderstorage.internal.FolderServiceImpl;
import com.openexchange.folderstorage.mail.osgi.MailFolderStorageActivator;
import com.openexchange.folderstorage.messaging.osgi.MessagingFolderStorageActivator;
import com.openexchange.folderstorage.osgi.FolderStorageTracker;
import com.openexchange.folderstorage.outlook.osgi.OutlookFolderStorageActivator;
import com.openexchange.folderstorage.virtual.osgi.VirtualFolderStorageActivator;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.tools.session.ServerSession;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderStorageActivator
implements BundleActivator {
    private volatile List<ServiceRegistration<?>> serviceRegistrations;
    private volatile List<ServiceTracker<?, ?>> serviceTrackers;
    private volatile List<BundleActivator> activators;

    /*
     * WARNING - void declaration
     */
    public void start(BundleContext context) throws Exception {
        Logger logger = LoggerFactory.getLogger(FolderStorageActivator.class);
        try {
            LinkedList serviceRegistrations = new LinkedList();
            this.serviceRegistrations = serviceRegistrations;
            serviceRegistrations.add(context.registerService(FolderService.class, (Object)new FolderServiceImpl(), null));
            serviceRegistrations.add(context.registerService(ContentTypeDiscoveryService.class, (Object)ContentTypeRegistry.getInstance(), null));
            serviceRegistrations.add(context.registerService(AdditionalFolderField.class, (Object)new DisplayNameFolderField(), null));
            LinkedList serviceTrackers = new LinkedList();
            this.serviceTrackers = serviceTrackers;
            serviceTrackers.add(new ServiceTracker(context, FolderStorage.class.getName(), (ServiceTrackerCustomizer)new FolderStorageTracker(context)));
            for (ServiceTracker serviceTracker : serviceTrackers) {
                serviceTracker.open();
            }
            LinkedList<BundleActivator> activators = new LinkedList<BundleActivator>();
            this.activators = activators;
            activators.add((BundleActivator)new DatabaseFolderStorageActivator());
            activators.add((BundleActivator)new MailFolderStorageActivator());
            activators.add((BundleActivator)new MessagingFolderStorageActivator());
            activators.add((BundleActivator)new FileStorageFolderStorageActivator());
            activators.add((BundleActivator)new CacheFolderStorageActivator());
            activators.add((BundleActivator)new OutlookFolderStorageActivator());
            activators.add((BundleActivator)new VirtualFolderStorageActivator());
            Object var6_8 = null;
            Iterator iter = activators.iterator();
            while (iter.hasNext()) {
                void var6_9;
                try {
                    if (FolderStorageActivator.isBundleResolved(context)) {
                        if (null != var6_9) {
                            FolderStorageActivator.logFailedStartup((BundleActivator)var6_9, logger);
                        }
                        return;
                    }
                }
                catch (IllegalStateException e) {
                    if (null != var6_9) {
                        FolderStorageActivator.logFailedStartup((BundleActivator)var6_9, logger);
                    }
                    return;
                }
                BundleActivator bundleActivator = (BundleActivator)iter.next();
                bundleActivator.start(context);
            }
            logger.info("Bundle \"com.openexchange.folderstorage\" successfully started!");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw e;
        }
    }

    private static boolean isBundleResolved(BundleContext context) {
        return 4 == context.getBundle().getState();
    }

    private static void logFailedStartup(BundleActivator activator, Logger logger) {
        logger.error("Failed start of folder storage bundle \"{}\"", (Object)activator.getClass().getName(), (Object)new Throwable());
    }

    public void stop(BundleContext context) throws Exception {
        Logger logger = LoggerFactory.getLogger(FolderStorageActivator.class);
        try {
            List<ServiceRegistration<?>> serviceRegistrations;
            List<ServiceTracker<?, ?>> serviceTrackers;
            List<BundleActivator> activators = this.activators;
            if (null != activators) {
                for (BundleActivator activator : activators) {
                    activator.stop(context);
                }
                activators.clear();
                this.activators = null;
            }
            if (null != (serviceTrackers = this.serviceTrackers)) {
                for (ServiceTracker<?, ?> serviceTracker : serviceTrackers) {
                    serviceTracker.close();
                }
                serviceTrackers.clear();
                this.serviceTrackers = null;
            }
            if (null != (serviceRegistrations = this.serviceRegistrations)) {
                for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                    serviceRegistration.unregister();
                }
                serviceRegistrations.clear();
                this.serviceRegistrations = null;
            }
            logger.info("Bundle \"com.openexchange.folderstorage\" successfully stopped!");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw e;
        }
    }

    private static final class DisplayNameFolderField
    implements AdditionalFolderField {
        private final ConcurrentMap<Key, String> cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1024L).weigher(Weighers.entrySingleton()).build();

        protected DisplayNameFolderField() {
        }

        @Override
        public Object renderJSON(Object value) {
            return value == null ? JSONObject.NULL : value;
        }

        @Override
        public Object getValue(FolderObject folder, ServerSession session) {
            int createdBy = folder.getCreatedBy();
            if (createdBy <= 0) {
                return JSONObject.NULL;
            }
            Context context = session.getContext();
            String displayName = (String)this.cache.get(Key.valueOf(createdBy, context.getContextId()));
            try {
                return null == displayName ? UserStorage.getInstance().getUser(createdBy, context).getDisplayName() : displayName;
            }
            catch (OXException e) {
                return null;
            }
        }

        @Override
        public String getColumnName() {
            return "com.openexchange.folderstorage.displayName";
        }

        @Override
        public int getColumnID() {
            return 3030;
        }

        @Override
        public List<Object> getValues(List<FolderObject> folder, ServerSession session) {
            return AdditionalFieldsUtils.bulk(this, folder, session);
        }
    }

    private static final class Key {
        private final int userId;
        private final int cid;
        private final int hash;

        public static Key valueOf(int userId, int cid) {
            return new Key(userId, cid);
        }

        public Key(int userId, int cid) {
            this.userId = userId;
            this.cid = cid;
            int prime = 31;
            int result = 1;
            result = 31 * result + cid;
            this.hash = result = 31 * result + userId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.cid != other.cid) {
                return false;
            }
            return this.userId == other.userId;
        }
    }
}

