/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.filestorage;

import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.filestorage.osgi.Services;
import com.openexchange.tools.id.IDMangler;
import java.util.List;

public final class FileStorageFolderType
implements FolderType {
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);
    private static final FileStorageFolderType instance = new FileStorageFolderType();

    public static FileStorageFolderType getInstance() {
        return instance;
    }

    private FileStorageFolderType() {
    }

    @Override
    public boolean servesTreeId(String treeId) {
        return FolderStorage.REAL_TREE_ID.equals(treeId);
    }

    @Override
    public boolean servesFolderId(String folderId) {
        if (null == folderId) {
            return false;
        }
        List components = IDMangler.unmangle((String)folderId);
        if (2 > components.size()) {
            return false;
        }
        String serviceID = new FolderID(folderId).getService();
        FileStorageServiceRegistry registry = Services.getService(FileStorageServiceRegistry.class);
        return null != registry && registry.containsFileStorageService(serviceID);
    }

    @Override
    public boolean servesParentId(String folderId) {
        if (null == folderId) {
            return false;
        }
        if (PRIVATE_FOLDER_ID.equals(folderId)) {
            return true;
        }
        return this.servesFolderId(folderId);
    }
}

