/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.concurrent.CallerRunsCompletionService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AfterReadAwareFolderStorage;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.RemoveAfterAccessFolder;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.cache.CacheFolderStorageRegistry;
import com.openexchange.folderstorage.cache.CacheFolderType;
import com.openexchange.folderstorage.cache.CacheServiceRegistry;
import com.openexchange.folderstorage.cache.CacheSortableId;
import com.openexchange.folderstorage.cache.memory.FolderMap;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.folderstorage.cache.service.FolderCacheInvalidationService;
import com.openexchange.folderstorage.database.DatabaseFolderType;
import com.openexchange.folderstorage.internal.StorageParametersImpl;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.internal.performers.ClearPerformer;
import com.openexchange.folderstorage.internal.performers.CreatePerformer;
import com.openexchange.folderstorage.internal.performers.DeletePerformer;
import com.openexchange.folderstorage.internal.performers.InstanceStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.PathPerformer;
import com.openexchange.folderstorage.internal.performers.SessionStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.StorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.UpdatePerformer;
import com.openexchange.folderstorage.internal.performers.UpdatesPerformer;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Strings;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.osgi.ServiceRegistry;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.session.Session;
import com.openexchange.threadpool.RefusedExecutionBehavior;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.AbortBehavior;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheFolderStorage
implements FolderStorage,
FolderCacheInvalidationService {
    protected static final Logger LOG = LoggerFactory.getLogger(CacheFolderStorage.class);
    private static final ThreadPools.ExpectedExceptionFactory<OXException> FACTORY = new ThreadPools.ExpectedExceptionFactory<OXException>(){

        public Class<OXException> getType() {
            return OXException.class;
        }

        public OXException newUnexpectedError(Throwable t) {
            return FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(t, t.getMessage());
        }
    };
    private static final CacheFolderStorage INSTANCE = new CacheFolderStorage();
    private static final String ROOT_ID = FolderStorage.ROOT_ID;
    private final String realTreeId = REAL_TREE_ID;
    private final CacheFolderStorageRegistry registry = CacheFolderStorageRegistry.getInstance();
    private volatile CacheService cacheService;
    private volatile Cache globalCache;
    protected static final Set<String> IGNORABLES = RemoveAfterAccessFolder.IGNORABLES;

    public static CacheFolderStorage getInstance() {
        return INSTANCE;
    }

    private CacheFolderStorage() {
    }

    public void clearAll() {
        Cache cache = this.globalCache;
        if (null != cache) {
            try {
                cache.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FolderMapManagement.getInstance().clear();
    }

    public void removeFromGlobalCache(String folderId, String treeId, int contextId) {
        Cache cache = this.globalCache;
        if (null != cache && Tools.isGlobalId(folderId)) {
            try {
                cache.removeFromGroup((Serializable)this.newCacheKey(folderId, treeId), Integer.toString(contextId));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public void clearCache(int userId, int contextId) {
        if (contextId <= 0) {
            return;
        }
        Cache cache = this.globalCache;
        if (null != cache) {
            cache.invalidateGroup(Integer.toString(contextId));
        }
        if (userId > 0) {
            CacheFolderStorage.dropUserEntries(userId, contextId);
        } else {
            FolderMapManagement.getInstance().dropFor(contextId);
        }
    }

    public void clear(Session session) {
        this.clearCache(session.getUserId(), session.getContextId());
    }

    public void onCacheAvailable() throws OXException {
        this.cacheService = (CacheService)CacheServiceRegistry.getServiceRegistry().getService(CacheService.class, true);
        this.globalCache = this.cacheService.getCache("GlobalFolderCache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheAbsent() throws OXException {
        CacheService service = this.cacheService;
        Cache cache = this.globalCache;
        if (cache != null) {
            try {
                cache.clear();
                if (null != service) {
                    service.freeCache("GlobalFolderCache");
                }
            }
            finally {
                this.globalCache = null;
            }
        }
        if (service != null) {
            this.cacheService = null;
        }
    }

    @Override
    public void checkConsistency(String treeId, final StorageParameters storageParameters) throws OXException {
        for (FolderStorage folderStorage : this.registry.getFolderStoragesForTreeID(treeId)) {
            boolean started = folderStorage.startTransaction(storageParameters, false);
            try {
                folderStorage.checkConsistency(treeId, storageParameters);
                if (!started) continue;
                folderStorage.commitTransaction(storageParameters);
                started = false;
            }
            catch (RuntimeException e) {
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            finally {
                if (started) {
                    folderStorage.rollback(storageParameters);
                }
            }
        }
        final String realTreeId = this.realTreeId;
        if (realTreeId.equals(treeId)) {
            try {
                final ServerSession session = ServerSessionAdapter.valueOf(storageParameters.getSession());
                final ServiceRegistry serviceRegistry = CacheServiceRegistry.getServiceRegistry();
                final ThreadPoolService threadPool = ThreadPools.getThreadPool();
                final RefusedExecutionBehavior behavior = AbortBehavior.getInstance();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            final StorageParameters params = CacheFolderStorage.newStorageParameters(storageParameters);
                            params.putParameter(MailFolderType.getInstance(), "__accessFast", Boolean.FALSE);
                            if (session.getUserPermissionBits().isMultipleMailAccounts()) {
                                MailAccountStorageService storageService = (MailAccountStorageService)serviceRegistry.getService(MailAccountStorageService.class, true);
                                MailAccount[] accounts = storageService.getUserMailAccounts(session.getUserId(), session.getContextId());
                                ArrayList<1> tasks2 = new ArrayList<1>(accounts.length);
                                for (MailAccount mailAccount : accounts) {
                                    String folderId;
                                    Folder rootFolder;
                                    int accountId = mailAccount.getId();
                                    if (accountId == 0 || IGNORABLES.contains(mailAccount.getMailProtocol()) || null != (rootFolder = CacheFolderStorage.this.getRefFromCache(realTreeId, folderId = MailFolderUtility.prepareFullname(accountId, "default"), params))) continue;
                                    Runnable mailAccountTask = new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                Folder rootFolder = CacheFolderStorage.this.loadFolder(realTreeId, folderId, StorageType.WORKING, params);
                                                CacheFolderStorage.this.putFolder(rootFolder, realTreeId, params, false);
                                                String[] subfolderIDs = rootFolder.getSubfolderIDs();
                                                if (null != subfolderIDs) {
                                                    for (String subfolderId : subfolderIDs) {
                                                        Folder folder = CacheFolderStorage.this.loadFolder(realTreeId, subfolderId, StorageType.WORKING, params);
                                                        CacheFolderStorage.this.putFolder(folder, realTreeId, params, false);
                                                    }
                                                }
                                            }
                                            catch (Exception e) {
                                                LOG.debug("", (Throwable)e);
                                            }
                                        }
                                    };
                                    tasks2.add(mailAccountTask);
                                }
                                if (!tasks2.isEmpty()) {
                                    for (Runnable runnable : tasks2) {
                                        threadPool.submit(ThreadPools.trackableTask((Runnable)runnable), behavior);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            LOG.debug("", (Throwable)e);
                        }
                    }
                };
                threadPool.submit(ThreadPools.trackableTask((Runnable)task), behavior);
            }
            catch (Exception e) {
                LOG.debug("", (Throwable)e);
            }
        }
    }

    protected static void checkOpenedStorage(FolderStorage checkMe, StorageParameters params, boolean modify, Collection<FolderStorage> openedStorages) throws OXException {
        if (openedStorages.contains(checkMe)) {
            return;
        }
        if (checkMe.startTransaction(params, modify)) {
            openedStorages.add(checkMe);
        }
    }

    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            storage.restore(treeId, folderId, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
            this.clear(storageParameters.getSession());
        }
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        String folderId = folder.getID();
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            Folder preparedFolder = storage.prepareFolder(treeId, folder, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
            if (preparedFolder.isCacheable() && preparedFolder.isGlobalID() != folder.isGlobalID()) {
                this.putFolder(preparedFolder, treeId, storageParameters, false);
            }
            Folder folder2 = preparedFolder;
            return folder2;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
        }
    }

    private PathPerformer newPathPerformer(StorageParameters storageParameters) throws OXException {
        Session session = storageParameters.getSession();
        if (null == session) {
            return new PathPerformer(storageParameters.getUser(), storageParameters.getContext(), null, this.registry);
        }
        return new PathPerformer(ServerSessionAdapter.valueOf(session), null, (FolderStorageDiscoverer)this.registry);
    }

    @Override
    public ContentType getDefaultContentType() {
        return null;
    }

    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        String treeId = folder.getTreeID();
        boolean created = false;
        Session session = storageParameters.getSession();
        int userId = storageParameters.getUserId();
        try {
            Folder parentFolder;
            CreatePerformer createPerformer = null == session ? new CreatePerformer(storageParameters.getUser(), storageParameters.getContext(), storageParameters.getDecorator(), this.registry) : new CreatePerformer(ServerSessionAdapter.valueOf(session), storageParameters.getDecorator(), (FolderStorageDiscoverer)this.registry);
            createPerformer.setCheck4Duplicates(false);
            String folderId = createPerformer.doCreate(folder);
            created = true;
            FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
            if (null == storage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
            }
            int contextId = storageParameters.getContextId();
            Folder createdFolder = null;
            try {
                createdFolder = this.loadFolder(this.realTreeId, folderId, StorageType.WORKING, true, storageParameters);
                if (createdFolder.isCacheable()) {
                    this.putFolder(createdFolder, this.realTreeId, storageParameters, false);
                }
            }
            catch (OXException e) {
                LOG.warn("Newly created folder could not be loaded from appropriate storage.", (Throwable)e);
            }
            FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
            Cache cache = this.globalCache;
            String sContextId = Integer.toString(contextId);
            LinkedList<CacheKey> keys = new LinkedList<CacheKey>();
            for (String tid : new String[]{treeId, this.realTreeId}) {
                if (Tools.isGlobalId(folder.getParentID())) {
                    keys.add(this.newCacheKey(folder.getParentID(), tid));
                }
                folderMapManagement.dropFor(folder.getParentID(), tid, userId, contextId, session);
            }
            if (null != cache && !keys.isEmpty()) {
                cache.removeFromGroup(keys, sContextId);
            }
            if (null != createdFolder && !createdFolder.getParentID().equals(folder.getParentID())) {
                keys.clear();
                for (String tid : new String[]{treeId, this.realTreeId}) {
                    if (Tools.isGlobalId(createdFolder.getParentID())) {
                        keys.add(this.newCacheKey(createdFolder.getParentID(), tid));
                    }
                    folderMapManagement.dropFor(createdFolder.getParentID(), tid, userId, contextId, session);
                }
                if (null != cache && !keys.isEmpty()) {
                    cache.removeFromGroup(keys, sContextId);
                }
            }
            if ((parentFolder = this.loadFolder(this.realTreeId, folder.getParentID(), StorageType.WORKING, true, storageParameters)).isCacheable()) {
                this.putFolder(parentFolder, this.realTreeId, storageParameters, true);
            }
            if (null != createdFolder && !createdFolder.getParentID().equals(folder.getParentID()) && (parentFolder = this.loadFolder(this.realTreeId, createdFolder.getParentID(), StorageType.WORKING, true, storageParameters)).isCacheable()) {
                this.putFolder(parentFolder, this.realTreeId, storageParameters, true);
            }
        }
        finally {
            if (!created) {
                this.removeSingleFromCache(Collections.singletonList(folder.getParentID()), treeId, userId, session, false);
            }
        }
    }

    public void putFolder(Folder folder, String treeId, StorageParameters storageParameters, boolean invalidate) throws OXException {
        if (folder.isGlobalID()) {
            this.globalCache.putInGroup((Serializable)this.newCacheKey(folder.getID(), treeId), Integer.toString(storageParameters.getContextId()), (Serializable)folder, invalidate);
        } else {
            CacheFolderStorage.getFolderMapFor(storageParameters.getSession()).put(treeId, folder, storageParameters.getSession());
        }
    }

    @Override
    public void invalidateSingle(String folderId, String treeId, Session session) throws OXException {
        this.removeFromCache(folderId, treeId, true, session);
    }

    @Override
    public void invalidate(String folderId, String treeId, boolean includeParents, Session session) throws OXException {
        this.removeFromCache(folderId, treeId, !includeParents, session);
    }

    public void removeFromCache(String id, String treeId, boolean singleOnly, Session session) throws OXException {
        this.removeFromCache(id, treeId, singleOnly, session, null);
    }

    public void removeFromCache(String id, String treeId, boolean singleOnly, Session session, List<String> folderPath) throws OXException {
        if (singleOnly) {
            this.removeSingleFromCache(Collections.singletonList(id), treeId, session.getUserId(), session, true);
        } else if (null != folderPath) {
            this.removeFromCache(id, treeId, session, null, folderPath);
        } else {
            this.removeFromCache(id, treeId, session, new PathPerformer(ServerSessionAdapter.valueOf(session), null, (FolderStorageDiscoverer)this.registry));
        }
    }

    private void removeFromCache(String id, String treeId, Session session, PathPerformer pathPerformer) throws OXException {
        this.removeFromCache(id, treeId, session, pathPerformer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(String id, String treeId, Session session, PathPerformer pathPerformer, List<String> folderPath) throws OXException {
        LinkedList<CacheKey> keys;
        List<String> ids;
        if (null == id) {
            return;
        }
        if (null == pathPerformer && null == folderPath) {
            return;
        }
        if (null != pathPerformer && null != folderPath) {
            return;
        }
        if (null != pathPerformer) {
            try {
                pathPerformer.getStorageParameters().setIgnoreCache(Boolean.TRUE);
                if (this.existsFolder(treeId, id, StorageType.WORKING, pathPerformer.getStorageParameters())) {
                    UserizedFolder[] path = pathPerformer.doPath(treeId, id, true);
                    ids = new ArrayList<String>(path.length);
                    for (UserizedFolder userizedFolder : path) {
                        ids.add(userizedFolder.getID());
                    }
                }
                ids = Collections.singletonList(id);
            }
            catch (Exception e) {
                Logger log = LoggerFactory.getLogger(CacheFolderStorage.class);
                log.debug("", (Throwable)e);
                try {
                    ids = new ArrayList<String>(Arrays.asList(pathPerformer.doForcePath(treeId, id, true)));
                }
                catch (Exception e1) {
                    log.debug("", (Throwable)e1);
                    ids = Collections.singletonList(id);
                }
            }
            finally {
                pathPerformer.getStorageParameters().setIgnoreCache(null);
            }
        } else {
            ids = folderPath;
        }
        int contextId = session.getContextId();
        int userId = session.getUserId();
        Cache cache = this.globalCache;
        FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
        if (this.realTreeId.equals(treeId)) {
            keys = new LinkedList<CacheKey>();
            for (String folderId : ids) {
                if (Tools.isGlobalId(folderId)) {
                    keys.add(this.newCacheKey(folderId, treeId));
                }
                folderMapManagement.dropFor(folderId, treeId, userId, contextId);
            }
            if (!keys.isEmpty()) {
                cache.removeFromGroup(keys, Integer.toString(contextId));
            }
        } else {
            keys = new LinkedList();
            for (String folderId : ids) {
                if (Tools.isGlobalId(folderId)) {
                    keys.add(this.newCacheKey(folderId, treeId));
                    keys.add(this.newCacheKey(folderId, this.realTreeId));
                }
                folderMapManagement.dropFor(folderId, treeId, userId, contextId);
                folderMapManagement.dropFor(folderId, this.realTreeId, userId, contextId);
            }
            if (!keys.isEmpty()) {
                cache.removeFromGroup(keys, Integer.toString(contextId));
            }
        }
    }

    public void removeSingleFromCache(List<String> ids, String treeId, int userId, Session session, boolean deleted) {
        this.removeSingleFromCache(ids, treeId, userId, session.getContextId(), deleted, session);
    }

    public void removeSingleFromCache(List<String> ids, String treeId, int optUserId, int contextId, boolean deleted, Session optSession) {
        this.removeSingleFromCache(ids, treeId, optUserId, contextId, deleted, false, optSession);
    }

    public void removeSingleFromCache(List<String> ids, String treeId, int optUserId, int contextId, boolean deleted, boolean userCacheOnly, Session optSession) {
        try {
            Cache cache;
            String sContextId = Integer.toString(contextId);
            Cache cache2 = cache = userCacheOnly ? null : this.globalCache;
            if (null == cache) {
                for (String tid : new HashSet<String>(Arrays.asList(treeId, this.realTreeId))) {
                    for (String id : ids) {
                        this.cleanseFromFolderManagement(optUserId, contextId, deleted, optSession, tid, id);
                    }
                }
            } else {
                LinkedList<CacheKey> keys = new LinkedList<CacheKey>();
                for (String tid : new HashSet<String>(Arrays.asList(treeId, this.realTreeId))) {
                    for (String id : ids) {
                        String parentID;
                        Folder cachedFolder;
                        CacheKey cacheKey = this.newCacheKey(id, tid);
                        if (deleted && null != (cachedFolder = (Folder)cache.getFromGroup((Serializable)cacheKey, sContextId)) && Tools.isGlobalId(parentID = cachedFolder.getParentID())) {
                            keys.add(this.newCacheKey(parentID, tid));
                        }
                        if (Tools.isGlobalId(id)) {
                            keys.add(cacheKey);
                        }
                        this.cleanseFromFolderManagement(optUserId, contextId, deleted, optSession, tid, id);
                    }
                }
                if (!keys.isEmpty()) {
                    cache.removeFromGroup(keys, sContextId);
                }
            }
        }
        catch (Exception x) {
            // empty catch block
        }
    }

    private void cleanseFromFolderManagement(int optUserId, int contextId, boolean deleted, Session optSession, String tid, String id) {
        String parentID;
        Folder cachedFolder;
        FolderMap folderMap;
        FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
        if (optUserId > 0 && null != (folderMap = folderMapManagement.optFor(optUserId, contextId)) && deleted && null != (cachedFolder = folderMap.get(id, tid, optSession)) && null != (parentID = cachedFolder.getParentID())) {
            folderMapManagement.dropFor(parentID, tid, optUserId, contextId, optSession);
        }
        folderMapManagement.dropFor(id, tid, optUserId, contextId, optSession);
    }

    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        int contextId = storageParameters.getContextId();
        int userId = storageParameters.getUserId();
        Session session = storageParameters.getSession();
        String sContextId = Integer.toString(contextId);
        Folder clearMe = this.getFolder(treeId, folderId, storageParameters);
        String[] subfolderIDs = this.loadAllSubfolders(treeId, clearMe, false, storageParameters);
        FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
        folderMapManagement.dropFor(folderId, treeId, userId, contextId, session);
        folderMapManagement.dropFor(folderId, this.realTreeId, userId, contextId, session);
        folderMapManagement.dropFor(clearMe.getParentID(), treeId, userId, contextId, session);
        folderMapManagement.dropFor(clearMe.getParentID(), this.realTreeId, userId, contextId, session);
        boolean cacheable = clearMe.isCacheable();
        if (cacheable) {
            if (Tools.isGlobalId(folderId)) {
                this.globalCache.removeFromGroup((Serializable)this.newCacheKey(folderId, treeId), sContextId);
            } else {
                FolderMapManagement.getInstance().dropFor(folderId, treeId, userId, contextId, session);
            }
        }
        this.removeSingleFromCache(Arrays.asList(subfolderIDs), treeId, userId, contextId, true, session);
        if (null == session) {
            new ClearPerformer(storageParameters.getUser(), storageParameters.getContext(), this.registry).doClear(treeId, folderId);
        } else {
            new ClearPerformer(ServerSessionAdapter.valueOf(session), this.registry).doClear(treeId, folderId);
        }
        try {
            Folder clearedFolder = this.loadFolder(this.realTreeId, folderId, StorageType.WORKING, true, storageParameters);
            if (clearedFolder.isCacheable()) {
                this.putFolder(clearedFolder, this.realTreeId, storageParameters, true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        contextId = storageParameters.getContextId();
        userId = storageParameters.getUserId();
        session = storageParameters.getSession();
        sContextId = Integer.toString(contextId);
        try {
            deleteMe = this.getFolder(treeId, folderId, storageParameters);
            subfolderIDs = this.loadAllSubfolders(treeId, deleteMe, false, storageParameters);
        }
        catch (OXException e) {
            if (Tools.isGlobalId(folderId)) {
                this.globalCache.removeFromGroup((Serializable)this.newCacheKey(folderId, treeId), sContextId);
            }
            FolderMapManagement.getInstance().dropFor(folderId, treeId, userId, contextId, session);
            return;
        }
        parentId = deleteMe.getParentID();
        if (!this.realTreeId.equals(treeId)) {
            parameters = CacheFolderStorage.newStorageParameters(storageParameters);
            folderStorage = this.registry.getFolderStorage(this.realTreeId, folderId);
            started = folderStorage.startTransaction(parameters, false);
            try {
                realParentId = folderStorage.getFolder(this.realTreeId, folderId, parameters).getParentID();
                if (!started) ** GOTO lbl32
                folderStorage.commitTransaction(parameters);
                started = false;
            }
            catch (RuntimeException e) {
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[0]);
            }
            finally {
                if (started) {
                    folderStorage.rollback(parameters);
                }
            }
        } else {
            realParentId = null;
        }
lbl32:
        // 3 sources

        folderMapManagement = FolderMapManagement.getInstance();
        folderMapManagement.dropFor(Arrays.asList(new String[]{folderId, parentId}), treeId, userId, contextId, session);
        if (!treeId.equals(this.realTreeId)) {
            fids = new ArrayList<String>(Arrays.asList(new String[]{folderId, parentId}));
            if (null != realParentId) {
                fids.add(realParentId);
            }
            folderMapManagement.dropFor(fids, this.realTreeId, userId, contextId, session);
        }
        keys = new LinkedList<CacheKey>();
        if (Tools.isGlobalId(folderId)) {
            keys.add(this.newCacheKey(folderId, treeId));
        }
        if (Tools.isGlobalId(parentId)) {
            keys.add(this.newCacheKey(parentId, treeId));
        }
        if (null != realParentId && !realParentId.equals(parentId) && Tools.isGlobalId(realParentId)) {
            keys.add(this.newCacheKey(realParentId, this.realTreeId));
        }
        if (!keys.isEmpty()) {
            this.globalCache.removeFromGroup(keys, sContextId);
        }
        this.registry.clearCaches(storageParameters.getUserId(), storageParameters.getContextId());
        this.removeSingleFromCache(Arrays.asList(subfolderIDs), treeId, userId, contextId, true, session);
        if (null == session) {
            new DeletePerformer(storageParameters.getUser(), storageParameters.getContext(), storageParameters.getDecorator(), this.registry).doDelete(treeId, folderId, storageParameters.getTimeStamp());
        } else {
            new DeletePerformer(ServerSessionAdapter.valueOf(session), storageParameters.getDecorator(), (FolderStorageDiscoverer)this.registry).doDelete(treeId, folderId, storageParameters.getTimeStamp());
        }
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        String folderId;
        FolderStorage storage = this.registry.getFolderStorageByContentType(treeId, contentType);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(treeId, contentType);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            folderId = storage.getDefaultFolderID(user, treeId, contentType, type, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
        }
        return folderId;
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        Type type;
        FolderStorage storage = this.registry.getFolderStorage(treeId, parentId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, parentId);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            type = storage.getTypeByParent(user, treeId, parentId, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
        }
        return type;
    }

    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            boolean containsForeignObjects = storage.containsForeignObjects(user, treeId, folderId, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
            boolean bl = containsForeignObjects;
            return bl;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
        }
    }

    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            boolean isEmpty = storage.isEmpty(treeId, folderId, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
            boolean bl = isEmpty;
            return bl;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
        }
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            storage.updateLastModified(lastModified, treeId, folderId, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
        }
        this.removeFromCache(folderId, treeId, storageParameters.getSession(), this.newPathPerformer(storageParameters));
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        Folder folder = this.getCloneFromCache(treeId, folderId, storageParameters);
        if (null != folder) {
            return folder;
        }
        folder = this.loadFolder(treeId, folderId, storageType, storageParameters);
        if (folder.isCacheable()) {
            this.putFolder(folder, treeId, storageParameters, false);
            return (Folder)folder.clone();
        }
        return folder;
    }

    private Folder getCloneFromCache(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        Folder folder = this.getRefFromCache(treeId, folderId, storageParameters);
        return null == folder ? null : (Folder)folder.clone();
    }

    protected Folder getRefFromCache(String treeId, String folderId, StorageParameters params) throws OXException {
        int contextId = params.getContextId();
        Folder folder = folderId.length() <= 0 || Strings.isDigit((char)folderId.charAt(0)) ? (Folder)this.globalCache.getFromGroup((Serializable)this.newCacheKey(folderId, treeId), Integer.toString(contextId)) : null;
        if (null != folder) {
            return folder;
        }
        FolderMap folderMap = CacheFolderStorage.optFolderMapFor(params);
        if (null != folderMap && null != (folder = folderMap.get(folderId, treeId, params.getSession()))) {
            if (folder instanceof RemoveAfterAccessFolder) {
                RemoveAfterAccessFolder raaf = (RemoveAfterAccessFolder)folder;
                int fUserId = raaf.getUserId();
                int fContextId = raaf.getContextId();
                if (fUserId >= 0 && params.getUserId() != fUserId || fContextId >= 0 && params.getContextId() != fContextId) {
                    return null;
                }
            }
            LOG.debug("Locally loaded folder {} from context {} for user {}", new Object[]{folderId, contextId, params.getUserId()});
            return folder;
        }
        return null;
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        int size = folderIds.size();
        Folder[] ret = new Folder[size];
        TObjectIntHashMap toLoad = new TObjectIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            String folderId = folderIds.get(i);
            Folder folder = this.getCloneFromCache(treeId, folderId, storageParameters);
            if (null == folder) {
                toLoad.put((Object)folderId, i);
                continue;
            }
            ret[i] = folder;
        }
        if (!toLoad.isEmpty()) {
            Map<String, Folder> fromStorage = this.loadFolders(treeId, Arrays.asList(toLoad.keys((Object[])new String[toLoad.size()])), storageType, storageParameters);
            for (Map.Entry<String, Folder> entry : fromStorage.entrySet()) {
                Folder folder = entry.getValue();
                int index = toLoad.get((Object)entry.getKey());
                if (folder.isCacheable()) {
                    this.putFolder(folder, treeId, storageParameters, false);
                    folder = (Folder)folder.clone();
                }
                ret[index] = folder;
            }
        }
        ArrayList<Folder> l = new ArrayList<Folder>(ret.length);
        for (Folder folder : ret) {
            if (null == folder) continue;
            l.add(folder);
        }
        return l;
    }

    @Override
    public FolderType getFolderType() {
        return CacheFolderType.getInstance();
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.HIGHEST;
    }

    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        FolderStorage folderStorage = this.registry.getFolderStorageByContentType(treeId, contentType);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(treeId, contentType);
        }
        boolean started = this.startTransaction(AfterReadAwareFolderStorage.Mode.WRITE_AFTER_READ, storageParameters, folderStorage);
        try {
            SortableId[] ret = folderStorage.getVisibleFolders(treeId, contentType, type, storageParameters);
            if (started) {
                folderStorage.commitTransaction(storageParameters);
                started = false;
            }
            SortableId[] sortableIdArray = ret;
            return sortableIdArray;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public SortableId[] getSubfolders(final String treeId, final String parentId, final StorageParameters storageParameters) throws OXException {
        parent = this.getFolder(treeId, parentId, storageParameters);
        v0 = subfolders = CacheFolderStorage.ROOT_ID.equals(parentId) != false ? null : parent.getSubfolderIDs();
        if (null != subfolders) {
            ret = new SortableId[subfolders.length];
            for (i = 0; i < ret.length; ++i) {
                ret[i] = new CacheSortableId(subfolders[i], i, null);
            }
            return ret;
        }
        neededStorages = this.registry.getFolderStoragesForParent(treeId, parentId);
        if (0 == neededStorages.length) {
            return new SortableId[0];
        }
        try {
            if (1 == neededStorages.length) {
                neededStorage = neededStorages[0];
                started = neededStorage.startTransaction(storageParameters, false);
                try {
                    allSubfolderIds = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, storageParameters));
                    if (!started) ** GOTO lbl55
                    neededStorage.commitTransaction(storageParameters);
                    started = false;
                }
                finally {
                    if (started) {
                        neededStorage.rollback(storageParameters);
                    }
                }
            } else {
                allSubfolderIds = new LinkedList<E>();
                completionService = new ThreadPoolCompletionService(ThreadPools.getThreadPool()).setTrackable(true);
                submittedTasks = 0;
                for (i = 1; i < neededStorages.length; ++i) {
                    neededStorage = neededStorages[i];
                    completionService.submit(new ThreadPools.TrackableCallable<List<SortableId>>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public List<SortableId> call() throws Exception {
                            StorageParameters newParameters = CacheFolderStorage.newStorageParameters(storageParameters);
                            boolean started = neededStorage.startTransaction(newParameters, false);
                            try {
                                List<SortableId> l = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, newParameters));
                                if (started) {
                                    neededStorage.commitTransaction(newParameters);
                                    started = false;
                                }
                                List<SortableId> list = l;
                                return list;
                            }
                            finally {
                                if (started) {
                                    neededStorage.rollback(newParameters);
                                }
                            }
                        }
                    });
                    ++submittedTasks;
                }
                neededStorage = neededStorages[0];
                started = neededStorage.startTransaction(storageParameters, false);
                try {
                    l = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, storageParameters));
                    if (started) {
                        neededStorage.commitTransaction(storageParameters);
                        started = false;
                    }
                    allSubfolderIds.addAll(l);
                }
                finally {
                    if (started) {
                        neededStorage.rollback(storageParameters);
                    }
                }
                results = ThreadPools.takeCompletionService((CompletionService)completionService, (int)submittedTasks, CacheFolderStorage.FACTORY);
                for (List result : results) {
                    allSubfolderIds.addAll(result);
                }
            }
lbl55:
            // 3 sources

            Collections.sort(allSubfolderIds);
            return allSubfolderIds.toArray(new SortableId[allSubfolderIds.size()]);
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[0];
    }

    @Override
    public void rollback(StorageParameters params) {
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        return false;
    }

    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        Folder f;
        Set<OXException> warnings;
        UpdatePerformer updatePerformer;
        String oldParentId;
        String treeId = folder.getTreeID();
        Session session = storageParameters.getSession();
        String oldFolderId = folder.getID();
        Folder storageVersion = this.getCloneFromCache(treeId, oldFolderId, storageParameters);
        if (null == storageVersion) {
            storageVersion = this.getFolder(treeId, oldFolderId, storageParameters);
        }
        boolean isMove = null != folder.getParentID();
        String string = oldParentId = isMove ? this.getFolder(treeId, oldFolderId, storageParameters).getParentID() : null;
        if (null == session) {
            updatePerformer = new UpdatePerformer(storageParameters.getUser(), storageParameters.getContext(), storageParameters.getDecorator(), this.registry);
            updatePerformer.setCheck4Duplicates(false);
            updatePerformer.doUpdate(folder, storageParameters.getTimeStamp());
            warnings = updatePerformer.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    storageParameters.addWarning(warning);
                }
            }
        } else {
            updatePerformer = new UpdatePerformer(ServerSessionAdapter.valueOf(session), storageParameters.getDecorator(), (FolderStorageDiscoverer)this.registry);
            updatePerformer.setCheck4Duplicates(false);
            updatePerformer.doUpdate(folder, storageParameters.getTimeStamp());
            warnings = updatePerformer.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    storageParameters.addWarning(warning);
                }
            }
        }
        String newFolderId = folder.getID();
        Folder updatedFolder = this.loadFolder(treeId, newFolderId, StorageType.WORKING, true, storageParameters);
        int userId = storageParameters.getUserId();
        int contextId = storageParameters.getContextId();
        FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
        List<String> ids = isMove ? Arrays.asList(oldFolderId, oldParentId, updatedFolder.getParentID()) : Arrays.asList(oldFolderId);
        folderMapManagement.dropFor(ids, treeId, userId, contextId, session);
        if (!treeId.equals(this.realTreeId)) {
            folderMapManagement.dropFor(ids, this.realTreeId, userId, contextId, session);
        }
        LinkedList<CacheKey> keys = new LinkedList<CacheKey>();
        if (Tools.isGlobalId(oldFolderId)) {
            keys.add(this.newCacheKey(oldFolderId, treeId));
        }
        if (isMove) {
            if (Tools.isGlobalId(oldParentId)) {
                keys.add(this.newCacheKey(oldParentId, treeId));
            }
            if (Tools.isGlobalId(updatedFolder.getParentID())) {
                keys.add(this.newCacheKey(updatedFolder.getParentID(), treeId));
            }
        }
        if (!treeId.equals(this.realTreeId)) {
            if (Tools.isGlobalId(oldFolderId)) {
                keys.add(this.newCacheKey(oldFolderId, this.realTreeId));
            }
            if (isMove) {
                if (Tools.isGlobalId(oldParentId)) {
                    keys.add(this.newCacheKey(oldParentId, this.realTreeId));
                }
                if (Tools.isGlobalId(updatedFolder.getParentID())) {
                    keys.add(this.newCacheKey(updatedFolder.getParentID(), this.realTreeId));
                }
            }
        }
        if (!keys.isEmpty()) {
            this.globalCache.removeFromGroup(keys, Integer.toString(contextId));
        }
        this.registry.clearCaches(storageParameters.getUserId(), storageParameters.getContextId());
        if (isMove) {
            f = this.loadFolder(this.realTreeId, newFolderId, StorageType.WORKING, true, storageParameters);
            if (f.isCacheable()) {
                this.putFolder(f, this.realTreeId, storageParameters, true);
            }
            if ((f = this.loadFolder(this.realTreeId, oldParentId, StorageType.WORKING, true, storageParameters)).isCacheable()) {
                this.putFolder(f, this.realTreeId, storageParameters, true);
            }
            if ((f = this.loadFolder(this.realTreeId, updatedFolder.getParentID(), StorageType.WORKING, true, storageParameters)).isCacheable()) {
                this.putFolder(f, this.realTreeId, storageParameters, true);
            }
        } else {
            f = this.loadFolder(this.realTreeId, newFolderId, StorageType.WORKING, true, storageParameters);
            if (f.isCacheable()) {
                this.putFolder(f, this.realTreeId, storageParameters, true);
            }
        }
        if (updatedFolder.isCacheable()) {
            this.putFolder(updatedFolder, treeId, storageParameters, true);
        }
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        return this.getChangedFolderIDs(0, treeId, timeStamp, includeContentTypes, storageParameters);
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        return this.getChangedFolderIDs(1, treeId, timeStamp, null, storageParameters);
    }

    private String[] getChangedFolderIDs(int index, String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        Session session = storageParameters.getSession();
        boolean ignoreDelete = index == 0;
        UserizedFolder[] folders2 = null == session ? new UpdatesPerformer(storageParameters.getUser(), storageParameters.getContext(), storageParameters.getDecorator(), this.registry).doUpdates(treeId, timeStamp, ignoreDelete, includeContentTypes)[index] : new UpdatesPerformer(ServerSessionAdapter.valueOf(session), storageParameters.getDecorator(), (FolderStorageDiscoverer)this.registry).doUpdates(treeId, timeStamp, ignoreDelete, includeContentTypes)[index];
        if (null == folders2 || folders2.length == 0) {
            return new String[0];
        }
        String[] ids = new String[folders2.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = folders2[i].getID();
        }
        return ids;
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = this.startTransaction(AfterReadAwareFolderStorage.Mode.WRITE_AFTER_READ, storageParameters, storage);
        try {
            boolean contains = storage.containsFolder(treeId, folderId, storageType, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
            boolean bl = contains;
            return bl;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
        }
    }

    private boolean startTransaction(AfterReadAwareFolderStorage.Mode mode, StorageParameters storageParameters, FolderStorage storage) throws OXException {
        if (storage instanceof AfterReadAwareFolderStorage) {
            return ((AfterReadAwareFolderStorage)storage).startTransaction(storageParameters, mode);
        }
        return storage.startTransaction(storageParameters, !AfterReadAwareFolderStorage.Mode.READ.equals((Object)mode));
    }

    private CacheKey newCacheKey(String folderId, String treeId) throws OXException {
        CacheService cacheService = this.cacheService;
        if (null == cacheService) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{CacheService.class.getSimpleName()});
        }
        return cacheService.newCacheKey(1, new String[]{treeId, folderId});
    }

    private boolean existsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            boolean exists = storage.containsFolder(treeId, folderId, storageType, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
                started = false;
            }
            boolean bl = exists;
            return bl;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (started) {
                storage.rollback(storageParameters);
            }
        }
    }

    public Folder loadFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        return this.loadFolder(treeId, folderId, storageType, false, storageParameters);
    }

    private Folder loadFolder(String treeId, String folderId, StorageType storageType, boolean readWrite, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = this.startTransaction(readWrite ? AfterReadAwareFolderStorage.Mode.WRITE_AFTER_READ : AfterReadAwareFolderStorage.Mode.READ, storageParameters, storage);
        boolean rollback = true;
        try {
            storageParameters.setIgnoreCache(readWrite);
            Folder folder = storage.getFolder(treeId, folderId, storageType, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
            }
            rollback = false;
            Folder folder2 = folder;
            return folder2;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            storageParameters.setIgnoreCache(null);
            if (started && rollback) {
                storage.rollback(storageParameters);
            }
        }
    }

    private String[] loadAllSubfolders(String treeId, Folder folder, boolean readWrite, StorageParameters storageParameters) throws OXException {
        HashSet<FolderStorage> openedStorages = new HashSet<FolderStorage>(2);
        HashSet<String> ids = new HashSet<String>(16);
        boolean rollback = true;
        try {
            String[] subfolderIds = folder.getSubfolderIDs();
            if (null == subfolderIds) {
                this.loadAllSubfolders(treeId, folder.getID(), readWrite, storageParameters, ids, openedStorages);
            } else {
                ids.addAll(Arrays.asList(subfolderIds));
                for (String subfolderId : subfolderIds) {
                    this.loadAllSubfolders(treeId, subfolderId, readWrite, storageParameters, ids, openedStorages);
                }
            }
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(storageParameters);
            }
            rollback = false;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                for (FolderStorage fs : openedStorages) {
                    fs.rollback(storageParameters);
                }
            }
        }
        return ids.toArray(new String[ids.size()]);
    }

    private void loadAllSubfolders(String treeId, String folderId, boolean readWrite, StorageParameters storageParameters, Set<String> ids, Set<FolderStorage> openedStorages) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        this.checkOpenedStorage(storage, readWrite, openedStorages, storageParameters);
        try {
            SortableId[] subfolders;
            for (SortableId sortableId : subfolders = storage.getSubfolders(treeId, folderId, storageParameters)) {
                String id = sortableId.getId();
                this.loadAllSubfolders(treeId, id, readWrite, storageParameters, ids, openedStorages);
                ids.add(id);
            }
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    protected void checkOpenedStorage(FolderStorage checkMe, boolean modify, Collection<FolderStorage> openedStorages, StorageParameters storageParameters) throws OXException {
        if (openedStorages.contains(checkMe)) {
            return;
        }
        if (checkMe.startTransaction(storageParameters, modify)) {
            openedStorages.add(checkMe);
        }
    }

    private Map<String, Folder> loadFolders(final String treeId, List<String> folderIds, final StorageType storageType, StorageParameters storageParameters) throws OXException {
        StorageParametersProvider paramsProvider;
        ThreadPoolCompletionService completionService;
        int size = folderIds.size();
        HashMap<FolderStorage, TIntList> map = new HashMap<FolderStorage, TIntList>(4);
        for (int i = 0; i < size; ++i) {
            String id = folderIds.get(i);
            FolderStorage tmp = this.registry.getFolderStorage(treeId, id);
            if (null == tmp) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
            }
            TIntList list = (TIntList)map.get(tmp);
            if (null == list) {
                list = new TIntArrayList();
                map.put(tmp, list);
            }
            list.add(i);
        }
        if (1 == map.size()) {
            completionService = new CallerRunsCompletionService();
            paramsProvider = new InstanceStorageParametersProvider(storageParameters);
        } else {
            completionService = new ThreadPoolCompletionService((ThreadPoolService)CacheServiceRegistry.getServiceRegistry().getService(ThreadPoolService.class, true)).setTrackable(true);
            Session session = storageParameters.getSession();
            paramsProvider = null == session ? new SessionStorageParametersProvider(storageParameters.getUser(), storageParameters.getContext()) : new SessionStorageParametersProvider((ServerSession)session);
        }
        final ConcurrentHashMap<String, Folder> ret = new ConcurrentHashMap<String, Folder>(size);
        int taskCount = 0;
        for (Map.Entry entry : map.entrySet()) {
            final FolderStorage fs = (FolderStorage)entry.getKey();
            int[] indexes = ((TIntList)entry.getValue()).toArray();
            final ArrayList<String> ids = new ArrayList<String>(indexes.length);
            for (int index : indexes) {
                ids.add(folderIds.get(index));
            }
            completionService.submit(new ThreadPools.TrackableCallable<Object>(){

                public Object call() throws Exception {
                    StorageParameters newParameters = paramsProvider.getStorageParameters();
                    boolean started = !DatabaseFolderType.getInstance().equals(fs.getFolderType()) && fs.startTransaction(newParameters, false);
                    try {
                        List<Folder> folders2 = fs.getFolders(treeId, ids, storageType, newParameters);
                        if (started) {
                            fs.commitTransaction(newParameters);
                            started = false;
                        }
                        for (Folder folder : folders2) {
                            ret.put(folder.getID(), folder);
                        }
                        Object var4_5 = null;
                        return var4_5;
                    }
                    catch (RuntimeException e) {
                        throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[0]);
                    }
                    finally {
                        if (started) {
                            fs.rollback(newParameters);
                        }
                    }
                }
            });
            ++taskCount;
        }
        ThreadPools.takeCompletionService((CompletionService)completionService, (int)taskCount, FACTORY);
        return ret;
    }

    static StorageParameters newStorageParameters(StorageParameters source) {
        Session session = source.getSession();
        if (null == session) {
            return new StorageParametersImpl(source.getUser(), source.getContext());
        }
        return new StorageParametersImpl((ServerSession)session, source.getUser(), source.getContext());
    }

    private static FolderMap getFolderMapFor(Session session) {
        return FolderMapManagement.getInstance().getFor(session);
    }

    private static FolderMap optFolderMapFor(StorageParameters parameters) {
        return FolderMapManagement.getInstance().optFor(parameters.getUserId(), parameters.getContextId());
    }

    public static void dropUserEntries(int userId, int contextId) {
        FolderMap folderMap = FolderMapManagement.getInstance().optFor(userId, contextId);
        if (null != folderMap) {
            folderMap.clear();
        }
    }
}

