/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.json.actions.GetAction;
import com.openexchange.filemanagement.json.actions.KeepaliveAction;
import com.openexchange.filemanagement.json.actions.NewAction;
import com.openexchange.filemanagement.json.actions.RangeAction;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="file", description="This module offers to store files in server's dedicated download directory for a configureable amount of time. The files are then accessible for further operations like inline images in (html) mails")
public class ManagedFileActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AJAXActionService> actions = new ConcurrentHashMap<String, AJAXActionService>(4);

    public ManagedFileActionFactory(ServiceLookup services) {
        this.actions.put("keepalive", new KeepaliveAction());
        this.actions.put("get", new GetAction());
        this.actions.put("new", new NewAction());
        this.actions.put("range", new RangeAction());
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }
}

