/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.container.ModifyableFileHolder;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewConst;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.java.InterruptibleInputStream;
import com.openexchange.java.Reference;
import com.openexchange.java.Streams;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.preview.ContentTypeChecker;
import com.openexchange.preview.Delegating;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.preview.RemoteInternalPreviewService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PreviewDocumentCallable
extends AbstractTask<PreviewDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewDocumentCallable.class);
    private final AJAXRequestData requestData;
    private final String previewLanguage;
    private final PreviewOutput previewOutput;
    private final ServerSession session;
    private volatile IFileHolder fileHolder;
    private volatile InterruptibleInputStream stream;
    private final PreviewService previewService;
    private final boolean respectLanguage;

    PreviewDocumentCallable(AJAXRequestResult result, AJAXRequestData requestData, PreviewOutput previewOutput, ServerSession session, PreviewService previewService, boolean respectLanguage) throws OXException {
        this.fileHolder = AbstractPreviewResultConverter.getFileHolderFromResult(result);
        this.requestData = requestData;
        this.previewLanguage = AbstractPreviewResultConverter.getUserLanguage(session);
        this.previewOutput = previewOutput;
        this.session = session;
        this.previewService = previewService;
        this.respectLanguage = respectLanguage;
    }

    public PreviewDocument call() throws Exception {
        try {
            InterruptibleInputStream stream1;
            IFileHolder fileHolder = this.fileHolder;
            InputStream in = fileHolder.getStream();
            if (0L == fileHolder.getLength()) {
                Streams.close((Closeable[])new Closeable[]{in, fileHolder});
                return PreviewConst.DEFAULT_PREVIEW_DOCUMENT;
            }
            Reference ref = new Reference();
            if (AbstractPreviewResultConverter.streamIsEof(in, (Reference<InputStream>)ref)) {
                Streams.close((Closeable[])new Closeable[]{in, fileHolder});
                return PreviewConst.DEFAULT_PREVIEW_DOCUMENT;
            }
            in = (InputStream)ref.getValue();
            this.stream = stream1 = new InterruptibleInputStream(in);
            PreviewService previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
            String mimeType = MimeType2ExtMap.getContentType(fileHolder.getName(), null);
            if (null == mimeType) {
                fileHolder = new ThresholdFileHolder().write((InputStream)this.stream).setContentInfo(fileHolder);
                mimeType = AJAXUtility.detectMimeType(fileHolder.getStream());
                this.fileHolder = fileHolder;
                this.stream = stream1 = new InterruptibleInputStream(fileHolder.getStream());
                LOG.debug("Determined MIME type for file {} by content: {}", (Object)fileHolder.getName(), (Object)mimeType);
            } else {
                LOG.debug("Determined MIME type for file {} by name: {}", (Object)fileHolder.getName(), (Object)mimeType);
            }
            fileHolder = new ModifyableFileHolder(fileHolder);
            ((ModifyableFileHolder)fileHolder).setContentType(mimeType);
            DataProperties dataProperties = new DataProperties(12);
            String mimeType2 = AbstractPreviewResultConverter.getContentType(fileHolder, previewService instanceof ContentTypeChecker ? (ContentTypeChecker)previewService : null);
            dataProperties.put("PreviewWidth", this.requestData.getParameter("width"));
            dataProperties.put("PreviewHeight", this.requestData.getParameter("height"));
            dataProperties.put("PreviewScaleType", this.requestData.getParameter("scaleType"));
            if (this.respectLanguage) {
                dataProperties.put("PreviewLanguage", this.previewLanguage);
            }
            dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
            dataProperties.put("com.openexchange.conversion.content-type", mimeType2);
            PreviewDocument previewDocument = previewService.getPreviewFor((Data)new SimpleData((Object)this.stream, dataProperties), this.previewOutput, (Session)this.session, 1);
            LOG.debug("Obtained preview for file {} with MIME type {} from {} for user {} in context {}", new Object[]{fileHolder.getName(), mimeType2, previewService.getClass().getSimpleName(), this.session.getUserId(), this.session.getContextId()});
            return previewDocument;
        }
        catch (RuntimeException rte) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)rte, new Object[]{rte.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() throws IOException {
        try {
            IFileHolder fileHolder = this.fileHolder;
            if (null != fileHolder) {
                fileHolder.close();
                this.fileHolder = null;
            }
        }
        finally {
            InterruptibleInputStream stream = this.stream;
            if (null != stream) {
                stream.interrupt();
                this.stream = null;
            }
        }
    }

    public long getAwaitThreshold(long defaultThreshold) {
        long timeToWaitMillis = 0L;
        String mimeType = MimeType2ExtMap.getContentType(this.fileHolder.getName(), null);
        PreviewService candidate = null;
        if (null != mimeType && this.previewService instanceof Delegating) {
            try {
                candidate = ((Delegating)this.previewService).getBestFitOrDelegate(mimeType, this.previewOutput);
            }
            catch (OXException e) {
                LOG.info("Failed to find delegate for mime-type {} and preview output {}", (Object)mimeType, (Object)this.previewOutput);
            }
            if (candidate instanceof RemoteInternalPreviewService) {
                timeToWaitMillis = ((RemoteInternalPreviewService)candidate).getTimeToWaitMillis();
            }
        }
        return timeToWaitMillis == 0L ? defaultThreshold : timeToWaitMillis;
    }
}

