/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionServletInterceptor;
import com.openexchange.ajax.SessionServletInterceptorRegistry;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.util.UUIDs;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.login.internal.LoginResultImpl;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.servlet.http.Authorization;
import com.openexchange.tools.servlet.http.Tools;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HTTPAuthLogin
implements LoginRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPAuthLogin.class);
    private final LoginConfiguration conf;

    public HTTPAuthLogin(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doAuthHeaderLogin(req, resp);
        }
        catch (OXException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            resp.addHeader("WWW-Authenticate", "NEGOTIATE");
            resp.addHeader("WWW-Authenticate", "Basic realm=\"Open-Xchange\"");
            resp.sendError(401, e.getMessage());
        }
    }

    private void doAuthHeaderLogin(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        LoginResult loginResult = this.tryAutologin(req, resp);
        if (null == loginResult) {
            String version2;
            Authorization.Credentials creds;
            String auth = req.getHeader("authorization");
            if (null == auth) {
                resp.addHeader("WWW-Authenticate", "NEGOTIATE");
                resp.addHeader("WWW-Authenticate", "Basic realm=\"Open-Xchange\"");
                resp.sendError(401, "Authorization Required!");
                return;
            }
            if (!Authorization.checkForAuthorizationHeader(auth)) {
                throw LoginExceptionCodes.UNKNOWN_HTTP_AUTHORIZATION.create(new Object[]{""});
            }
            if (Authorization.checkForBasicAuthorization(auth)) {
                creds = Authorization.decode(auth);
                version2 = this.conf.getClientVersion();
            } else if (Authorization.checkForKerberosAuthorization(auth)) {
                creds = new Authorization.Credentials("kerberos", "");
                version2 = "Kerberos";
            } else {
                throw LoginExceptionCodes.UNKNOWN_HTTP_AUTHORIZATION.create(new Object[]{""});
            }
            String client = LoginTools.parseClient(req, false, this.conf.getDefaultClient());
            String clientIP = LoginTools.parseClientIP(req);
            String userAgent = LoginTools.parseUserAgent(req);
            Map<String, List<String>> headers = Tools.copyHeaders(req);
            Cookie[] cookies = Tools.getCookieFromHeader(req);
            String httpSessionId = req.getSession(true).getId();
            LoginRequestImpl request = new LoginRequestImpl(creds.getLogin(), creds.getPassword(), clientIP, userAgent, UUIDs.getUnformattedString((UUID)UUID.randomUUID()), client, version2, HashCalculator.getInstance().getHash(req, userAgent, client), Interface.HTTP_JSON, headers, cookies, Tools.considerSecure(req, this.conf.isCookieForceHTTPS()), req.getServerName(), req.getServerPort(), httpSessionId);
            HashMap<String, Object> properties = new HashMap<String, Object>(1);
            String capabilities = req.getParameter("capabilities");
            if (null != capabilities) {
                properties.put("client.capabilities", capabilities);
            }
            loginResult = LoginPerformer.getInstance().doLogin(request, properties);
        }
        Session session = loginResult.getSession();
        Tools.disableCaching(resp);
        LoginServlet.writeSecretCookie(req, resp, session, session.getHash(), req.isSecure(), req.getServerName(), this.conf);
        LoginServlet.addHeadersAndCookies(loginResult, resp);
        resp.sendRedirect(LoginTools.generateRedirectURL(null, this.conf.getHttpAuthAutoLogin(), session.getSessionID(), this.conf.getUiWebPath()));
    }

    private LoginResult tryAutologin(HttpServletRequest request, HttpServletResponse resp) throws OXException {
        javax.servlet.http.Cookie[] cookies = request.getCookies();
        if (!Boolean.valueOf(this.conf.getHttpAuthAutoLogin()).booleanValue() || null == cookies || 0 == cookies.length) {
            return null;
        }
        String sessionID = null;
        String secret = null;
        String hash = HashCalculator.getInstance().getHash(request, LoginTools.parseUserAgent(request), LoginTools.parseClient(request, false, this.conf.getDefaultClient()));
        String sessionCookieName = LoginServlet.SESSION_PREFIX + hash;
        String secretCookieName = LoginServlet.SECRET_PREFIX + hash;
        for (int i = 0; i < cookies.length && (null == sessionID || null == secret); ++i) {
            String name = cookies[i].getName();
            if (name.startsWith(sessionCookieName)) {
                sessionID = cookies[i].getValue();
                continue;
            }
            if (!name.startsWith(secretCookieName)) continue;
            secret = cookies[i].getValue();
        }
        if (null == sessionID || null == secret) {
            return null;
        }
        SessiondService sessiond = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        Session session = sessiond.getSession(sessionID);
        if (null == session || !session.getSecret().equals(secret)) {
            return null;
        }
        String remoteAddress = request.getRemoteAddr();
        if (this.conf.isIpCheck()) {
            SessionUtility.checkIP(true, this.conf.getRanges(), session, remoteAddress, this.conf.getIpCheckWhitelist());
        }
        LoginTools.updateIPAddress(this.conf, remoteAddress, session);
        Context context = ContextStorage.getInstance().getContext(session.getContextId());
        User user = UserStorage.getInstance().getUser(session.getUserId(), context);
        if (!context.isEnabled() || !user.isMailEnabled()) {
            throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
        }
        for (SessionServletInterceptor interceptor : SessionServletInterceptorRegistry.getInstance().getInterceptors()) {
            try {
                interceptor.intercept(session);
            }
            catch (OXException e) {
                sessiond.removeSession(sessionID);
                SessionUtility.removeOXCookies(request, resp, Arrays.asList(LoginServlet.SESSION_PREFIX + hash));
                return null;
            }
        }
        return new LoginResultImpl(session, context, user);
    }
}

