/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.login.internal.LoginResultImpl;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.servlet.http.Tools;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormLogin
implements LoginRequestHandler {
    private final LoginConfiguration conf;

    public FormLogin(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doFormLogin(req, resp);
        }
        catch (OXException e) {
            String errorPage = this.conf.getErrorPageTemplate().replace("ERROR_MESSAGE", e.getMessage());
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write(errorPage);
        }
    }

    private void doFormLogin(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        LoginResult result;
        Cookie[] cookies;
        Map<String, List<String>> headers;
        LoginRequestImpl request = LoginTools.parseLogin(req, "login", true, this.conf.getDefaultClient(), this.conf.isCookieForceHTTPS(), this.conf.isDisableTrimLogin(), !this.conf.isFormLoginWithoutAuthId());
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        String capabilities = req.getParameter("capabilities");
        if (null != capabilities) {
            properties.put("client.capabilities", capabilities);
        }
        if ((headers = request.getHeaders()) != null) {
            properties.put("headers", headers);
        }
        if (null != (cookies = request.getCookies())) {
            properties.put("cookies", cookies);
        }
        if (null == (result = this.reAuthenticate(this.tryAutologin(req, resp), request.getLogin(), request.getPassword(), properties))) {
            result = LoginPerformer.getInstance().doLogin(request, properties);
        }
        Session session = result.getSession();
        User user = result.getUser();
        Tools.disableCaching(resp);
        LoginServlet.writeSecretCookie(req, resp, session, session.getHash(), req.isSecure(), req.getServerName(), this.conf);
        LoginServlet.addHeadersAndCookies(result, resp);
        resp.sendRedirect(FormLogin.generateRedirectURL(req.getParameter("uiWebPath"), req.getParameter("autologin"), session, user.getPreferredLanguage(), this.conf.getUiWebPath()));
    }

    private LoginResult reAuthenticate(LoginResult autoLoginResult, String login, String password, Map<String, Object> properties) throws OXException {
        User user;
        Authenticated authenticated;
        Context context;
        if (null != autoLoginResult && (context = LoginPerformer.findContext((authenticated = Authentication.login(login, password, properties)).getContextInfo())).getContextId() == autoLoginResult.getContext().getContextId() && context.getContextId() == autoLoginResult.getSession().getContextId() && (user = LoginPerformer.findUser(context, authenticated.getUserInfo())).getId() == autoLoginResult.getUser().getId() && user.getId() == autoLoginResult.getSession().getUserId()) {
            return autoLoginResult;
        }
        return null;
    }

    private LoginResult tryAutologin(HttpServletRequest request, HttpServletResponse response) throws OXException {
        javax.servlet.http.Cookie[] cookies = request.getCookies();
        if (this.conf.isSessiondAutoLogin() && null != cookies && 0 < cookies.length) {
            Session session;
            String sessionID = null;
            String secret = null;
            String hash = HashCalculator.getInstance().getHash(request);
            String sessionCookieName = LoginServlet.SESSION_PREFIX + hash;
            String secretCookieName = LoginServlet.SECRET_PREFIX + hash;
            for (int i = 0; i < cookies.length && (null == sessionID || null == secret); ++i) {
                String name = cookies[i].getName();
                if (name.startsWith(sessionCookieName)) {
                    sessionID = cookies[i].getValue();
                    continue;
                }
                if (!name.startsWith(secretCookieName)) continue;
                secret = cookies[i].getValue();
            }
            if (null != sessionID && null != secret && null != (session = ServerServiceRegistry.getInstance().getService(SessiondService.class).getSession(sessionID)) && session.getSecret().equals(secret)) {
                String remoteAddress = request.getRemoteAddr();
                if (this.conf.isIpCheck()) {
                    try {
                        SessionUtility.checkIP(true, this.conf.getRanges(), session, remoteAddress, this.conf.getIpCheckWhitelist());
                    }
                    catch (OXException e) {
                        if (SessionExceptionCodes.WRONG_CLIENT_IP.equals(e)) {
                            SessionUtility.removeOXCookies(request, response, Collections.singletonList(sessionCookieName));
                            LoginPerformer.getInstance().doLogout(sessionID);
                            return null;
                        }
                        throw e;
                    }
                }
                LoginTools.updateIPAddress(this.conf, remoteAddress, session);
                Context context = ContextStorage.getInstance().getContext(session.getContextId());
                User user = UserStorage.getInstance().getUser(session.getUserId(), context);
                if (!context.isEnabled() || !user.isMailEnabled()) {
                    throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
                }
                return new LoginResultImpl(session, context, user);
            }
        }
        return null;
    }

    private static String generateRedirectURL(String uiWebPathParam, String shouldStore, Session session, String language, String uiWebPath) {
        String retval = uiWebPathParam;
        if (null == retval) {
            retval = uiWebPath;
        }
        retval = retval.replaceAll("[\n\r]", "");
        retval = LoginTools.addFragmentParameter(retval, "session", session.getSessionID());
        retval = LoginTools.addFragmentParameter(retval, "user", session.getLogin());
        retval = LoginTools.addFragmentParameter(retval, "user_id", Integer.toString(session.getUserId()));
        retval = LoginTools.addFragmentParameter(retval, "context_id", String.valueOf(session.getContextId()));
        retval = LoginTools.addFragmentParameter(retval, "language", language);
        if (shouldStore != null) {
            retval = LoginTools.addFragmentParameter(retval, "store", shouldStore);
        }
        return retval;
    }
}

