/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.ConfigMenu;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.Send;
import com.openexchange.ajax.login.AutoLogin;
import com.openexchange.ajax.login.FormLogin;
import com.openexchange.ajax.login.HTTPAuthLogin;
import com.openexchange.ajax.login.HasAutoLogin;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.Login;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.ajax.login.OAuthLogin;
import com.openexchange.ajax.login.RampUp;
import com.openexchange.ajax.login.RedeemToken;
import com.openexchange.ajax.login.TokenLogin;
import com.openexchange.ajax.login.Tokens;
import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.Header;
import com.openexchange.config.ConfigTools;
import com.openexchange.configuration.ClientWhitelist;
import com.openexchange.configuration.CookieHashSource;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.login.ConfigurationProperty;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.IPRange;
import com.openexchange.tools.io.IOTools;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Cookies;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.servlet.ratelimit.RateLimitedException;
import com.openexchange.tools.session.ServerSession;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends AJAXServlet {
    private static final long serialVersionUID = 7680745138705836499L;
    protected static final Logger LOG = LoggerFactory.getLogger(LoginServlet.class);
    public static final String SERVLET_PATH_APPENDIX = "login";
    protected static final Set<LogProperties.Name> LOG_PROPERTIES;
    public static final String SESSION_PREFIX;
    public static final String SECRET_PREFIX;
    public static final String PUBLIC_SESSION_PREFIX;
    public static final String ACTION_FORMLOGIN = "formlogin";
    public static final String ACTION_TOKENLOGIN = "tokenLogin";
    public static final String ACTION_TOKENS = "tokens";
    public static final String ACTION_REDEEM_TOKEN = "redeemToken";
    public static final String ACTION_CHANGEIP;
    private static final AtomicReference<Set<LoginRampUpService>> RAMP_UP_REF;
    static final AtomicReference<LoginConfiguration> confReference;
    private final Map<String, LoginRequestHandler> handlerMap = new ConcurrentHashMap<String, LoginRequestHandler>(16);
    private static final String ERROR_PAGE_TEMPLATE = "<html>\n<script type=\"text/javascript\">\n// Display normal HTML for 5 seconds, then redirect via referrer.\nsetTimeout(redirect,5000);\nfunction redirect(){\n var referrer=document.referrer;\n var redirect_url;\n // If referrer already contains failed parameter, we don't add a 2nd one.\n if(referrer.indexOf(\"login=failed\")>=0){\n  redirect_url=referrer;\n }else{\n  // Check if referrer contains multiple parameter\n  if(referrer.indexOf(\"?\")<0){\n   redirect_url=referrer+\"?login=failed\";\n  }else{\n   redirect_url=referrer+\"&login=failed\";\n  }\n }\n // Redirect to referrer\n window.location.href=redirect_url;\n}\n</script>\n<body>\n<h1>ERROR_MESSAGE</h1>\n</body>\n</html>\n";

    public static void setRampUpServices(Set<LoginRampUpService> services) {
        RAMP_UP_REF.set(services);
    }

    public static LoginConfiguration getLoginConfiguration() {
        return confReference.get();
    }

    public static String getPublicSessionCookieName(HttpServletRequest req) {
        return PUBLIC_SESSION_PREFIX + HashCalculator.getInstance().getUserAgentHash(req);
    }

    public LoginServlet() {
        this.handlerMap.put("store", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    LoginServlet.this.doStore(req, resp);
                }
                catch (OXException e) {
                    LoginServlet.logAndSendException(resp, e);
                }
                catch (JSONException e) {
                    LoginServlet.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        this.handlerMap.put("refreshSecret", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    LoginServlet.this.doRefreshSecret(req, resp);
                }
                catch (OXException e) {
                    LoginServlet.logAndSendException(resp, e);
                }
                catch (JSONException e) {
                    LoginServlet.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        this.handlerMap.put("logout", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String sessionId = req.getParameter("session");
                if (sessionId == null) {
                    resp.sendError(400);
                    return;
                }
                try {
                    Session session = LoginPerformer.getInstance().lookupSession(sessionId);
                    if (session != null) {
                        LoginConfiguration conf = confReference.get();
                        SessionUtility.checkIP(conf.isIpCheck(), conf.getRanges(), session, req.getRemoteAddr(), conf.getIpCheckWhitelist());
                        String secret = SessionUtility.extractSecret(conf.getHashSource(), req, session.getHash(), session.getClient());
                        if (secret == null || !session.getSecret().equals(secret)) {
                            LOG.info("Status code 403 (FORBIDDEN): Missing or non-matching secret.");
                            resp.sendError(403);
                            return;
                        }
                        LoginPerformer.getInstance().doLogout(sessionId);
                        SessionUtility.removeOXCookies(session.getHash(), req, resp);
                        SessionUtility.removeJSESSIONID(req, resp);
                    }
                }
                catch (OXException e) {
                    LOG.error("Logout failed", (Throwable)e);
                }
            }
        });
        this.handlerMap.put("redirect", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String hash;
                Session session;
                LoginConfiguration conf = confReference.get();
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String randomToken = null;
                if (conf.isRandomTokenEnabled()) {
                    randomToken = req.getParameter("random");
                }
                if (randomToken == null) {
                    String msg = "Random token is disable (as per default since considered as insecure). See \"com.openexchange.ajax.login.randomToken\" in 'login.properties' file.";
                    LOG.warn("Random token is disable (as per default since considered as insecure). See \"com.openexchange.ajax.login.randomToken\" in 'login.properties' file.", new Throwable("Random token is disable (as per default since considered as insecure). See \"com.openexchange.ajax.login.randomToken\" in 'login.properties' file."));
                    resp.sendError(400);
                    return;
                }
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                if (sessiondService == null) {
                    OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                    LOG.error("", (Throwable)se);
                    resp.sendError(403);
                    return;
                }
                if (conf.isInsecure()) {
                    if (conf.isRedirectIPChangeAllowed()) {
                        session = sessiondService.getSessionByRandomToken(randomToken, req.getRemoteAddr());
                    } else {
                        String newIP;
                        String oldIP;
                        session = sessiondService.getSessionByRandomToken(randomToken);
                        if (null != session && (null == (oldIP = session.getLocalIp()) || SessionUtility.isWhitelistedFromIPCheck(oldIP, conf.getRanges())) && !(newIP = req.getRemoteAddr()).equals(oldIP)) {
                            LOG.info("Changing IP of session {} with authID: {} from {} to {}.", new Object[]{session.getSessionID(), session.getAuthId(), oldIP, newIP});
                            session.setLocalIp(newIP);
                        }
                    }
                } else {
                    session = sessiondService.getSessionByRandomToken(randomToken);
                }
                if (session == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No session could be found for random token: {}", (Object)randomToken, (Object)new Throwable());
                    } else {
                        LOG.info("No session could be found for random token: {}", (Object)randomToken);
                    }
                    resp.sendError(403);
                    return;
                }
                LogProperties.putSessionProperties((Session)session);
                if (conf.isInsecure()) {
                    SessionUtility.removeOXCookies(session.getHash(), req, resp);
                }
                try {
                    Context context = ContextStorage.getInstance().getContext(session.getContextId());
                    User user = UserStorage.getInstance().getUser(session.getUserId(), context);
                    if (!context.isEnabled() || !user.isMailEnabled()) {
                        LOG.info("Status code 403 (FORBIDDEN): Either context {} or user {} not enabled", (Object)context.getContextId(), (Object)user.getId());
                        resp.sendError(403);
                        return;
                    }
                }
                catch (UndeclaredThrowableException e) {
                    LOG.info("Status code 403 (FORBIDDEN): Unexpected error occurred during login: {}", (Object)e.getMessage());
                    resp.sendError(403);
                    return;
                }
                catch (OXException e) {
                    LOG.info("Status code 403 (FORBIDDEN): Couldn't resolve context/user by identifier: {}/{}", (Object)session.getContextId(), (Object)session.getUserId());
                    resp.sendError(403);
                    return;
                }
                String client = req.getParameter("client");
                if (!conf.isInsecure()) {
                    hash = session.getHash();
                } else {
                    if (null == client) {
                        client = session.getClient();
                    } else {
                        session.setClient(client);
                    }
                    hash = HashCalculator.getInstance().getHash(req, client);
                    session.setHash(hash);
                }
                LoginServlet.writeSecretCookie(req, resp, session, hash, req.isSecure(), req.getServerName(), conf);
                resp.sendRedirect(LoginTools.generateRedirectURL(req.getParameter("uiWebPath"), req.getParameter("store"), session.getSessionID(), conf.getUiWebPath()));
            }
        });
        this.handlerMap.put(ACTION_CHANGEIP, new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                Response response = new Response();
                Session session = null;
                try {
                    String sessionId = req.getParameter("session");
                    if (null == sessionId) {
                        LOG.info("Parameter \"{}\" not found for action {}", (Object)"session", (Object)ACTION_CHANGEIP);
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
                    }
                    String newIP = req.getParameter("clientIP");
                    if (null == newIP) {
                        LOG.info("Parameter \"{}\" not found for action {}", (Object)"clientIP", (Object)ACTION_CHANGEIP);
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create("clientIP");
                    }
                    SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class, true);
                    session = sessiondService.getSession(sessionId);
                    if (session != null) {
                        LogProperties.putSessionProperties((Session)session);
                        LoginConfiguration conf = confReference.get();
                        SessionUtility.checkIP(conf.isIpCheck(), conf.getRanges(), session, req.getRemoteAddr(), conf.getIpCheckWhitelist());
                        String secret = SessionUtility.extractSecret(conf.getHashSource(), req, session.getHash(), session.getClient());
                        if (secret == null || !session.getSecret().equals(secret)) {
                            if (null != secret) {
                                LOG.info("Session secret is different. Given secret \"{}\" differs from secret in session \"{}\".", (Object)secret, (Object)session.getSecret());
                            }
                            throw SessionExceptionCodes.WRONG_SESSION_SECRET.create();
                        }
                        String oldIP = session.getLocalIp();
                        if (!newIP.equals(oldIP)) {
                            LOG.info("Changing IP of session {} with authID: {} from {} to {}", new Object[]{session.getSessionID(), session.getAuthId(), oldIP, newIP});
                            session.setLocalIp(newIP);
                        }
                    } else {
                        LOG.info("There is no session associated with session identifier: {}", (Object)sessionId);
                        throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
                    }
                    response.setData("1");
                }
                catch (OXException e) {
                    LOG.debug("", (Throwable)e);
                    response.setException(e);
                }
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                resp.setStatus(200);
                try {
                    ResponseWriter.write(response, resp.getWriter(), AJAXServlet.localeFrom(session));
                }
                catch (JSONException e) {
                    LoginServlet.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        this.handlerMap.put("redeem", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String hash;
                Session session;
                LoginConfiguration conf = confReference.get();
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String randomToken = null;
                if (conf.isRandomTokenEnabled()) {
                    randomToken = req.getParameter("random");
                }
                if (randomToken == null) {
                    String msg = "Random token is disable (as per default since considered as insecure). See \"com.openexchange.ajax.login.randomToken\" in 'login.properties' file.";
                    LOG.warn("Random token is disable (as per default since considered as insecure). See \"com.openexchange.ajax.login.randomToken\" in 'login.properties' file.", new Throwable("Random token is disable (as per default since considered as insecure). See \"com.openexchange.ajax.login.randomToken\" in 'login.properties' file."));
                    resp.sendError(400);
                    return;
                }
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                if (sessiondService == null) {
                    OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                    LOG.error("", (Throwable)se);
                    resp.sendError(403);
                    return;
                }
                if (conf.isInsecure()) {
                    if (conf.isRedirectIPChangeAllowed()) {
                        session = sessiondService.getSessionByRandomToken(randomToken, req.getRemoteAddr());
                    } else {
                        String newIP;
                        String oldIP;
                        session = sessiondService.getSessionByRandomToken(randomToken);
                        if (null != session && (null == (oldIP = session.getLocalIp()) || SessionUtility.isWhitelistedFromIPCheck(oldIP, conf.getRanges())) && !(newIP = req.getRemoteAddr()).equals(oldIP)) {
                            LOG.info("Changing IP of session {} with authID: {} from {} to {}.", new Object[]{session.getSessionID(), session.getAuthId(), oldIP, newIP});
                            session.setLocalIp(newIP);
                        }
                    }
                } else {
                    session = sessiondService.getSessionByRandomToken(randomToken);
                }
                if (session == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No session could be found for random token: {}", (Object)randomToken, (Object)new Throwable());
                    } else {
                        LOG.info("No session could be found for random token: {}", (Object)randomToken);
                    }
                    resp.sendError(403);
                    return;
                }
                LogProperties.putSessionProperties((Session)session);
                if (conf.isInsecure()) {
                    SessionUtility.removeOXCookies(session.getHash(), req, resp);
                }
                try {
                    Context context = ContextStorage.getInstance().getContext(session.getContextId());
                    User user = UserStorage.getInstance().getUser(session.getUserId(), context);
                    if (!context.isEnabled() || !user.isMailEnabled()) {
                        LOG.info("Status code 403 (FORBIDDEN): Either context {} or user {} not enabled", (Object)context.getContextId(), (Object)user.getId());
                        resp.sendError(403);
                        return;
                    }
                }
                catch (UndeclaredThrowableException e) {
                    LOG.info("Status code 403 (FORBIDDEN): Unexpected error occurred during login: {}", (Object)e.getMessage());
                    resp.sendError(403);
                    return;
                }
                catch (OXException e) {
                    LOG.info("Status code 403 (FORBIDDEN): Couldn't resolve context/user by identifier: {}/{}", (Object)session.getContextId(), (Object)session.getUserId());
                    resp.sendError(403);
                    return;
                }
                String client = req.getParameter("client");
                if (!conf.isInsecure()) {
                    hash = session.getHash();
                } else {
                    if (null == client) {
                        client = session.getClient();
                    } else {
                        session.setClient(client);
                    }
                    hash = HashCalculator.getInstance().getHash(req, client);
                    session.setHash(hash);
                }
                LoginServlet.writeSecretCookie(req, resp, session, hash, req.isSecure(), req.getServerName(), conf);
                try {
                    JSONObject json = new JSONObject();
                    LoginWriter.write(session, json);
                    LoginServlet.appendModules(session, json, req);
                    json.write((Writer)resp.getWriter());
                }
                catch (JSONException e) {
                    LoginServlet.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
    }

    public void init(ServletConfig config) throws ServletException {
        String errorPageTemplate;
        super.init(config);
        String uiWebPath = config.getInitParameter(ServerConfig.Property.UI_WEB_PATH.getPropertyName());
        boolean sessiondAutoLogin = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.SESSIOND_AUTOLOGIN.getPropertyName()));
        CookieHashSource hashSource = CookieHashSource.parse(config.getInitParameter(ServerConfig.Property.COOKIE_HASH.getPropertyName()));
        String httpAuthAutoLogin = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_AUTOLOGIN.getPropertyName());
        String defaultClient = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_CLIENT.getPropertyName());
        String clientVersion = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_VERSION.getPropertyName());
        String templateFileLocation = config.getInitParameter(ConfigurationProperty.ERROR_PAGE_TEMPLATE.getPropertyName());
        if (null == templateFileLocation) {
            errorPageTemplate = ERROR_PAGE_TEMPLATE;
        } else {
            File templateFile = new File(templateFileLocation);
            try {
                errorPageTemplate = IOTools.getFileContents(templateFile);
                LOG.info("Found an error page template at {}", (Object)templateFileLocation);
            }
            catch (FileNotFoundException e) {
                LOG.error("Could not find an error page template at {}, using default.", (Object)templateFileLocation);
                errorPageTemplate = ERROR_PAGE_TEMPLATE;
            }
        }
        int cookieExpiry = ConfigTools.parseTimespanSecs((String)config.getInitParameter(ServerConfig.Property.COOKIE_TTL.getPropertyName()));
        boolean cookieForceHTTPS = Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.COOKIE_FORCE_HTTPS.getPropertyName())) || Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.FORCE_HTTPS.getPropertyName()));
        boolean insecure = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.INSECURE.getPropertyName()));
        boolean ipCheck = Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.IP_CHECK.getPropertyName()));
        ClientWhitelist ipCheckWhitelist = new ClientWhitelist().add(config.getInitParameter(ServerConfig.Property.IP_CHECK_WHITELIST.getPropertyName()));
        boolean redirectIPChangeAllowed = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.REDIRECT_IP_CHANGE_ALLOWED.getPropertyName()));
        LinkedList<IPRange> ranges = new LinkedList<IPRange>();
        String tmp = config.getInitParameter(ConfigurationProperty.NO_IP_CHECK_RANGE.getPropertyName());
        if (tmp != null) {
            String[] lines;
            for (String line : lines = Strings.splitByCRLF((String)tmp)) {
                if ((line = line.replaceAll("\\s", "")).equals("") || line.length() != 0 && line.charAt(0) == '#') continue;
                ranges.add(IPRange.parseRange(line));
            }
        }
        boolean disableTrimLogin = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.DISABLE_TRIM_LOGIN.getPropertyName()));
        boolean formLoginWithoutAuthId = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.FORM_LOGIN_WITHOUT_AUTHID.getPropertyName()));
        boolean isRandomTokenEnabled = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.RANDOM_TOKEN.getPropertyName()));
        LoginConfiguration conf = new LoginConfiguration(uiWebPath, sessiondAutoLogin, hashSource, httpAuthAutoLogin, defaultClient, clientVersion, errorPageTemplate, cookieExpiry, cookieForceHTTPS, insecure, ipCheck, ipCheckWhitelist, redirectIPChangeAllowed, ranges, disableTrimLogin, formLoginWithoutAuthId, isRandomTokenEnabled);
        confReference.set(conf);
        this.handlerMap.put(ACTION_FORMLOGIN, new FormLogin(conf));
        this.handlerMap.put(ACTION_TOKENLOGIN, new TokenLogin(conf));
        this.handlerMap.put(ACTION_TOKENS, new Tokens(conf));
        this.handlerMap.put(ACTION_REDEEM_TOKEN, new RedeemToken(conf));
        Set<LoginRampUpService> rampUpServices = RAMP_UP_REF.get();
        this.handlerMap.put("autologin", new AutoLogin(conf, rampUpServices));
        this.handlerMap.put("oauth", new OAuthLogin(conf, rampUpServices));
        this.handlerMap.put(SERVLET_PATH_APPENDIX, new Login(conf, rampUpServices));
        this.handlerMap.put("rampup", new RampUp(rampUpServices));
        this.handlerMap.put("hasAutologin", new HasAutoLogin(conf));
        this.handlerMap.put("/httpAuth", new HTTPAuthLogin(conf));
    }

    public LoginRequestHandler addRequestHandler(String action, LoginRequestHandler handler) {
        return this.handlerMap.put(action, handler);
    }

    public LoginRequestHandler removeRequestHandler(String action) {
        return this.handlerMap.remove(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block8: {
            try {
                String action = req.getParameter("action");
                String subPath = LoginServlet.getServletSpecificURI(req);
                if (null != subPath && subPath.startsWith("/httpAuth")) {
                    this.handlerMap.get("/httpAuth").handleRequest(req, resp);
                    break block8;
                }
                if (null != action) {
                    this.doJSONAuth(req, resp, action);
                    break block8;
                }
                LoginServlet.logAndSendException(resp, AjaxExceptionCodes.MISSING_PARAMETER.create("action"));
                return;
            }
            catch (RateLimitedException e) {
                resp.setContentType("text/plain; charset=UTF-8");
                int retryAfter = e.getRetryAfter();
                if (retryAfter > 0) {
                    resp.setHeader("Retry-After", Integer.toString(retryAfter));
                }
                resp.sendError(429, "Too Many Requests - Your request is being rate limited.");
            }
            finally {
                LogProperties.removeProperties(LOG_PROPERTIES);
            }
        }
    }

    private void doJSONAuth(HttpServletRequest req, HttpServletResponse resp, String action) throws IOException {
        LoginRequestHandler handler = this.handlerMap.get(action);
        if (null == handler) {
            LoginServlet.logAndSendException(resp, AjaxExceptionCodes.UNKNOWN_ACTION.create(action));
            return;
        }
        handler.handleRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCookieReWrite(HttpServletRequest req, HttpServletResponse resp, CookieType type) throws OXException, JSONException, IOException {
        LoginConfiguration conf = confReference.get();
        if (!conf.isSessiondAutoLogin() && CookieType.SESSION == type) {
            throw AjaxExceptionCodes.DISABLED_ACTION.create("store");
        }
        SessiondService sessiond = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null == sessiond) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        String sessionId = req.getParameter("session");
        if (null == sessionId) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
        }
        ServerSession session = SessionUtility.getSession(conf.getHashSource(), req, sessionId, sessiond);
        try {
            SessionUtility.checkIP(conf.isIpCheck(), conf.getRanges(), session, req.getRemoteAddr(), conf.getIpCheckWhitelist());
            if (type == CookieType.SESSION) {
                LoginServlet.writeSessionCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName());
            } else {
                LoginServlet.writeSecretCookie(req, resp, session, session.getHash(), req.isSecure(), req.getServerName(), conf);
            }
            req.getSession();
            Response response = new Response();
            response.setData("1");
            ResponseWriter.write(response, resp.getWriter(), LoginServlet.localeFrom((Session)session));
        }
        finally {
            LogProperties.removeSessionProperties();
        }
    }

    protected void doStore(HttpServletRequest req, HttpServletResponse resp) throws OXException, JSONException, IOException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        this.doCookieReWrite(req, resp, CookieType.SESSION);
    }

    protected void doRefreshSecret(HttpServletRequest req, HttpServletResponse resp) throws OXException, JSONException, IOException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        this.doCookieReWrite(req, resp, CookieType.SECRET);
    }

    public static void logAndSendException(HttpServletResponse resp, OXException e) throws IOException {
        LOG.debug("", (Throwable)e);
        Send.sendResponse(new Response().setException(e), resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    public static void writeSessionCookie(HttpServletResponse resp, Session session, String hash, boolean secure, String serverName) {
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(SESSION_PREFIX + hash, session.getSessionID());
        LoginServlet.configureCookie(cookie, secure, serverName, confReference.get());
        resp.addCookie(cookie);
    }

    public static void addHeadersAndCookies(LoginResult result, HttpServletResponse resp) {
        Header[] headers;
        Cookie[] cookies = result.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                resp.addCookie(LoginServlet.wrapCookie(cookie));
            }
        }
        if (null != (headers = result.getHeaders())) {
            for (Header header : headers) {
                resp.addHeader(header.getName(), header.getValue());
            }
        }
    }

    private static javax.servlet.http.Cookie wrapCookie(Cookie cookie) {
        return new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
    }

    protected static void appendModules(Session session, JSONObject json, HttpServletRequest req) {
        String modules = "modules";
        if (LoginServlet.parseBoolean(req.getParameter("modules"))) {
            try {
                Setting setting = ConfigTree.getInstance().getSettingByPath("modules");
                SettingStorage.getInstance(session).readValues(setting);
                json.put("modules", ConfigMenu.convert2JS(setting));
            }
            catch (Exception e) {
                LOG.warn("Modules could not be added to login JSON response", (Throwable)e);
            }
        }
    }

    public static boolean parseBoolean(String parameter) {
        return "true".equalsIgnoreCase(parameter) || "1".equals(parameter) || "yes".equalsIgnoreCase(parameter) || "y".equalsIgnoreCase(parameter) || "on".equalsIgnoreCase(parameter);
    }

    public static void writeSecretCookie(HttpServletRequest req, HttpServletResponse resp, Session session, String hash, boolean secure, String serverName, LoginConfiguration conf) {
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(SECRET_PREFIX + hash, session.getSecret());
        LoginServlet.configureCookie(cookie, secure, serverName, conf);
        resp.addCookie(cookie);
        LoginServlet.writePublicSessionCookie(req, resp, session, secure, serverName, conf);
    }

    public static boolean writePublicSessionCookie(HttpServletRequest req, HttpServletResponse resp, Session session, boolean secure, String serverName, LoginConfiguration conf) {
        String altId = (String)session.getParameter(Session.PARAM_ALTERNATIVE_ID);
        if (null != altId) {
            javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(LoginServlet.getPublicSessionCookieName(req), altId);
            LoginServlet.configureCookie(cookie, secure, serverName, conf);
            resp.addCookie(cookie);
            return true;
        }
        return false;
    }

    public static void configureCookie(javax.servlet.http.Cookie cookie, boolean secure, String serverName, LoginConfiguration conf) {
        String domain;
        cookie.setPath("/");
        if (secure || conf.isCookieForceHTTPS() && !Cookies.isLocalLan(serverName)) {
            cookie.setSecure(true);
        }
        if (conf.isSessiondAutoLogin() || conf.getCookieExpiry() < 0) {
            cookie.setMaxAge(conf.getCookieExpiry());
        }
        if (null != (domain = Cookies.getDomainValue(null == serverName ? LoginServlet.determineServerNameByLogProperty() : serverName))) {
            cookie.setDomain(domain);
        }
    }

    private static String determineServerNameByLogProperty() {
        String serverName = LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.GRIZZLY_SERVER_NAME);
        return null == serverName ? LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.AJP_SERVER_NAME) : serverName;
    }

    static {
        EnumSet<LogProperties.Name> set = EnumSet.noneOf(LogProperties.Name.class);
        set.add(LogProperties.Name.LOGIN_AUTH_ID);
        set.add(LogProperties.Name.LOGIN_CLIENT);
        set.add(LogProperties.Name.LOGIN_CLIENT_IP);
        set.add(LogProperties.Name.LOGIN_LOGIN);
        set.add(LogProperties.Name.LOGIN_USER_AGENT);
        set.add(LogProperties.Name.LOGIN_VERSION);
        set.add(LogProperties.Name.SESSION_AUTH_ID);
        set.add(LogProperties.Name.SESSION_SESSION_ID);
        set.add(LogProperties.Name.SESSION_USER_ID);
        set.add(LogProperties.Name.SESSION_USER_NAME);
        set.add(LogProperties.Name.SESSION_CONTEXT_ID);
        set.add(LogProperties.Name.SESSION_CLIENT_ID);
        set.add(LogProperties.Name.SESSION_SESSION);
        LOG_PROPERTIES = Collections.unmodifiableSet(set);
        SESSION_PREFIX = "open-xchange-session-".intern();
        SECRET_PREFIX = "open-xchange-secret-".intern();
        PUBLIC_SESSION_PREFIX = "open-xchange-public-session-".intern();
        ACTION_CHANGEIP = "changeip".intern();
        RAMP_UP_REF = new AtomicReference();
        confReference = new AtomicReference();
    }

    private static enum CookieType {
        SESSION,
        SECRET;

    }
}

