/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.mbean;

import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.console.ServiceState;
import com.openexchange.osgi.mbean.DeferredActivatorMBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public final class DeferredActivatorMBeanImpl
extends StandardMBean
implements DeferredActivatorMBean {
    public DeferredActivatorMBeanImpl() throws NotCompliantMBeanException {
        super(DeferredActivatorMBean.class);
    }

    @Override
    public List<String> listMissingServices(String name) {
        ServiceState serviceState = DeferredActivator.getLookup().determineState(name);
        return serviceState.getMissingServices();
    }

    @Override
    public Map<String, List<String>> listAllMissingServices() {
        ConcurrentHashMap<String, List<String>> res = new ConcurrentHashMap<String, List<String>>();
        for (String bundleName : DeferredActivator.getLookup().getNames()) {
            ServiceState serviceState = DeferredActivator.getLookup().determineState(bundleName);
            List<String> list = serviceState.getMissingServices();
            if (list.isEmpty()) continue;
            res.put(bundleName, list);
        }
        return res;
    }

    @Override
    public boolean isActive(String name) {
        ServiceState serviceState = DeferredActivator.getLookup().determineState(name);
        return serviceState.getMissingServices().isEmpty();
    }

    @Override
    public List<String> listAvailableBundles() {
        return DeferredActivator.getLookup().getNames();
    }
}

