/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Strings {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern P_SPLIT_COMMA = Pattern.compile("\\s*,\\s*");
    private static final Pattern P_SPLIT_DOT = Pattern.compile("\\s*\\.\\s*");
    private static final Pattern P_SPLIT_AMP = Pattern.compile("&");
    private static final Pattern P_SPLIT_CRLF = Pattern.compile("\r?\n");
    private static final Pattern P_SPLIT_WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern PATTERN_CONTROL = Pattern.compile("[\\x00-\\x1F\\x7F]+");
    private static final CharsetDecoder UTF8_CHARSET_DECODER;
    private static char[] lowercases;

    private Strings() {
    }

    public static boolean startsWithAny(String s, String ... prefixes) {
        if (null == s) {
            return false;
        }
        boolean startsWith = false;
        int i = prefixes.length;
        while (!startsWith && i-- > 0) {
            String prefix = prefixes[i];
            startsWith = null == prefix ? false : s.startsWith(prefix, 0);
        }
        return startsWith;
    }

    public static String concat(Object ... objects) {
        if (null == objects || 0 == objects.length) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2048);
        for (Object object : objects) {
            sb.append(object == null ? "null" : object.toString());
        }
        return sb.toString();
    }

    public static String concat(String delimiter, Object ... objects) {
        if (null == objects) {
            return "";
        }
        if (null == delimiter) {
            return Strings.concat(objects);
        }
        int length = objects.length;
        if (length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2048);
        sb.append(objects[0] == null ? "null" : objects[0].toString());
        for (int i = 1; i < length; ++i) {
            sb.append(delimiter);
            sb.append(objects[i] == null ? "null" : objects[i].toString());
        }
        return sb.toString();
    }

    public static String concat(String delimiter, String ... strings) {
        if (null == strings) {
            return "";
        }
        if (null == delimiter) {
            return Strings.concat(strings);
        }
        int length = strings.length;
        if (length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2048);
        sb.append(strings[0] == null ? "null" : strings[0]);
        for (int i = 1; i < length; ++i) {
            sb.append(delimiter);
            sb.append(strings[i] == null ? "null" : strings[i]);
        }
        return sb.toString();
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u000e': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static byte[] toAsciiBytes(CharSequence cs) {
        return Charsets.toAsciiBytes(cs);
    }

    public static byte[] toAsciiBytes(String str) {
        return Charsets.toAsciiBytes(str);
    }

    public static void writeAsciiBytes(String str, OutputStream out) throws IOException {
        Charsets.writeAsciiBytes(str, out);
    }

    public static String[] splitByTokensOrQuotedStrings(String str) {
        if (null == str) {
            return null;
        }
        LinkedList<String> splitted = new LinkedList<String>();
        char inQuotes = '\u0000';
        boolean escaped = false;
        StringBuilder s = new StringBuilder(16);
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (Strings.isWhitespace(c)) {
                if (inQuotes > '\u0000') {
                    if (inQuotes == c && !escaped) {
                        inQuotes = '\u0000';
                    }
                    s.append(c);
                    escaped = false;
                    continue;
                }
                if (s.length() <= 0) continue;
                splitted.add(s.toString().trim());
                s.setLength(0);
                continue;
            }
            if ('\\' == c) {
                escaped = !escaped;
                s.append(c);
                continue;
            }
            if (!('\"' != c && '\'' != c || escaped)) {
                inQuotes = inQuotes > '\u0000' ? (char)'\u0000' : c;
            }
            s.append(c);
            escaped = false;
        }
        if (s.length() > 0) {
            splitted.add(s.toString().trim());
        }
        return splitted.toArray(new String[splitted.size()]);
    }

    public static String[] splitByDelimNotInQuotes(String str, char delim) {
        if (null == str) {
            return null;
        }
        LinkedList<String> splitted = new LinkedList<String>();
        boolean inQuotes = false;
        boolean escaped = false;
        StringBuilder s = new StringBuilder(16);
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == delim) {
                if (inQuotes) {
                    if ('\"' == c && !escaped) {
                        inQuotes = !inQuotes;
                    }
                    s.append(c);
                    escaped = false;
                    continue;
                }
                splitted.add(s.toString().trim());
                s.setLength(0);
                continue;
            }
            if ('\\' == c) {
                escaped = !escaped;
                s.append(c);
                continue;
            }
            if ('\"' == c && !escaped) {
                inQuotes = !inQuotes;
            }
            s.append(c);
            escaped = false;
        }
        splitted.add(s.toString().trim());
        return splitted.toArray(new String[splitted.size()]);
    }

    public static String[] splitByCommaNotInQuotes(String str) {
        return Strings.splitByDelimNotInQuotes(str, ',');
    }

    public static String[] splitByComma(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_COMMA.split(s, 0);
    }

    public static String[] splitByDots(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_DOT.split(s, 0);
    }

    public static String[] splitByAmps(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_AMP.split(s, 0);
    }

    public static String[] splitByCRLF(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_CRLF.split(s, 0);
    }

    public static String[] splitByWhitespaces(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_WHITESPACE.split(s, 0);
    }

    public static String replaceWhitespacesWith(String s, String replacement) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_WHITESPACE.matcher(s).replaceAll(null == replacement ? "" : Strings.quoteReplacement(replacement));
    }

    public static String quoteReplacement(String s) {
        if (Strings.isEmpty(s) || s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        int length = s.length();
        StringBuilder sb = new StringBuilder(length << 1);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String sanitizeString(String str) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        return PATTERN_CONTROL.matcher(str).replaceAll(" ");
    }

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    public static String fixCharsetProblem(String s) {
        if (Strings.isEmpty(s)) {
            return s;
        }
        try {
            byte[] bytes = s.getBytes(Charsets.ISO_8859_1);
            if (Strings.isUTF8Bytes(bytes)) {
                return new String(bytes, Charsets.UTF_8);
            }
            return s;
        }
        catch (UnsupportedCharsetException e) {
            return s;
        }
    }

    public static boolean isUTF8Bytes(byte[] bytes) {
        try {
            UTF8_CHARSET_DECODER.decode(ByteBuffer.wrap(bytes));
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    public static String join(Collection<? extends Object> coll, String connector) {
        if (coll == null) {
            return null;
        }
        int size = coll.size();
        if (size == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(size << 4);
        for (Object object : coll) {
            if (object == null) {
                builder.append("null");
            } else {
                builder.append(object.toString());
            }
            builder.append(connector);
        }
        return builder.substring(0, builder.length() - connector.length());
    }

    public static <T> String join(T[] arr, String connector) {
        return Strings.join(Arrays.asList(arr), connector);
    }

    public static String join(int[] arr, String connector) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i : arr) {
            list.add(Autoboxing.I(i));
        }
        return Strings.join(list, connector);
    }

    public static String join(byte[] arr, String connector) {
        LinkedList<Byte> list = new LinkedList<Byte>();
        byte[] arr$ = arr;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte i = arr$[i$];
            list.add(i);
        }
        return Strings.join(list, connector);
    }

    public static String trimBOM(String str) {
        byte[][] byteOrderMarks = new byte[][]{{0, 0, -2, -1}, {-1, -2, 0, 0}, {-17, -69, -65}, {-2, -1}, {-2, -1}};
        byte[] bytes = str.getBytes();
        for (byte[] bom : byteOrderMarks) {
            String pattern;
            if (bom.length > bytes.length || !str.startsWith(pattern = new String(bom))) continue;
            int bomLen = new String(bom).getBytes().length;
            int len = bytes.length - bomLen;
            byte[] trimmed = new byte[len];
            for (int i = 0; i < len; ++i) {
                trimmed[i] = bytes[i + bomLen];
            }
            return new String(trimmed);
        }
        return str;
    }

    public static String abbreviate(String str, int maxWidth) {
        return Strings.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        int off = offset;
        if (off > str.length()) {
            off = str.length();
        }
        if (str.length() - off < maxWidth - 3) {
            off = str.length() - (maxWidth - 3);
        }
        if (off <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (off + (maxWidth - 3) < str.length()) {
            return "..." + Strings.abbreviate(str.substring(off), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String quote(String s) {
        return Strings.concat(Character.valueOf('\"'), s, Character.valueOf('\"'));
    }

    public static String unquote(String s) {
        if (!Strings.isEmpty(s) && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String unparenthize(String s) {
        if (!Strings.isEmpty(s) && (s.startsWith("(") && s.endsWith(")") || s.startsWith("{") && s.endsWith("}") || s.startsWith("[") && s.endsWith("]"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String unchar(String s, char c) {
        return Strings.unchar(s, c, c);
    }

    public static String unchar(String s, char start, char end) {
        if (!Strings.isEmpty(s) && s.startsWith(Character.toString(start)) && s.endsWith(Character.toString(end))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String toCodePoints(String str) {
        if (null == str) {
            return null;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder(length << 1);
        for (int i = 0; i < length; ++i) {
            sb.append(' ').append(str.codePointAt(i));
        }
        return sb.deleteCharAt(0).toString();
    }

    public static void outCodePoints(String str, PrintStream out) {
        if (null == out) {
            System.out.println(Strings.toCodePoints(str));
        } else {
            out.println(Strings.toCodePoints(str));
        }
    }

    public static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    public static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    public static String asciiLowerCase(String s) {
        if (null == s) {
            return null;
        }
        char[] c = null;
        int i = s.length();
        while (i-- > 0) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 > '\u007f' || c1 == (c2 = lowercases[c1])) continue;
            c = s.toCharArray();
            c[i] = c2;
            break;
        }
        while (i-- > 0) {
            if (c[i] > 127) continue;
            c[i] = lowercases[c[i]];
        }
        return c == null ? s : new String(c);
    }

    public static List<String> splitAndTrim(String input, String separator) {
        if (input == null) {
            throw new IllegalArgumentException("Missing input");
        }
        if (Strings.isEmpty(input)) {
            return Collections.emptyList();
        }
        if (Strings.isEmpty(separator)) {
            throw new IllegalArgumentException("Missing separator");
        }
        ArrayList<String> trimmedSplits = new ArrayList<String>();
        try {
            String[] splits;
            for (String string : splits = input.split(separator)) {
                trimmedSplits.add(string.trim());
            }
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Illegal pattern syntax");
        }
        return trimmedSplits;
    }

    public static boolean equalsNormalized(String s1, String s2) {
        if (null == s1) {
            return null == s2;
        }
        if (null == s2) {
            return false;
        }
        return Normalizer.normalize(s1, Normalizer.Form.NFC).equals(Normalizer.normalize(s2, Normalizer.Form.NFC));
    }

    public static boolean equalsNormalizedIgnoreCase(String s1, String s2) {
        if (null == s1) {
            return null == s2;
        }
        if (null == s2) {
            return false;
        }
        return Normalizer.normalize(s1, Normalizer.Form.NFC).equalsIgnoreCase(Normalizer.normalize(s2, Normalizer.Form.NFC));
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int parseInt(String s) {
        if (s == null) {
            throw new NumberFormatException("Null string");
        }
        int len = s.length();
        if (len <= 0) {
            throw new NumberFormatException("Empty string");
        }
        int num = 0;
        int sign = -1;
        char ch = s.charAt(0);
        if (ch == '-') {
            if (len == 1) {
                throw new NumberFormatException("Missing digits:  " + s);
            }
            sign = 1;
        } else {
            int d = ch - 48;
            if (d < 0 || d > 9) {
                throw new NumberFormatException("Malformed:  " + s);
            }
            num = -d;
        }
        int max = sign == -1 ? -2147483647 : Integer.MIN_VALUE;
        int multmax = max / 10;
        int i = 1;
        while (i < len) {
            int d;
            if ((d = s.charAt(i++) - 48) < 0 || d > 9) {
                throw new NumberFormatException("Malformed:  " + s);
            }
            if (num < multmax) {
                throw new NumberFormatException("Over/underflow:  " + s);
            }
            if ((num *= 10) < max + d) {
                throw new NumberFormatException("Over/underflow:  " + s);
            }
            num -= d;
        }
        return sign * num;
    }

    public static int parsePositiveInt(String s) {
        if (s == null) {
            return -1;
        }
        int len = s.length();
        if (len <= 0) {
            return -1;
        }
        char ch = s.charAt(0);
        if (ch == '-') {
            return -1;
        }
        int d = ch - 48;
        if (d < 0 || d > 9) {
            return -1;
        }
        int num = -d;
        int sign = -1;
        int max = -2147483647;
        int multmax = -214748364;
        int i = 1;
        while (i < len) {
            int d2;
            if ((d2 = s.charAt(i++) - 48) < 0 || d2 > 9) {
                return -1;
            }
            if (num < -214748364) {
                return -1;
            }
            if ((num *= 10) < -2147483647 + d2) {
                return -1;
            }
            num -= d2;
        }
        return -1 * num;
    }

    public static String reverse(String string) {
        return new StringBuilder(string).reverse().toString();
    }

    public static String trimStart(String string, char ... trimChars) {
        if (null != string && null != trimChars && 0 < trimChars.length) {
            while (0 < string.length() && Strings.contains(string.charAt(0), trimChars)) {
                string = string.substring(1, string.length() - 1);
            }
        }
        return string;
    }

    public static String trimEnd(String string, char ... trimChars) {
        if (null != string && null != trimChars && 0 < trimChars.length) {
            while (0 < string.length() && Strings.contains(string.charAt(string.length() - 1), trimChars)) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }

    private static boolean contains(char c, char[] charArray) {
        for (char character : charArray) {
            if (c != character) continue;
            return true;
        }
        return false;
    }

    static {
        CharsetDecoder utf8Decoder = Charsets.UTF_8.newDecoder();
        utf8Decoder.onMalformedInput(CodingErrorAction.REPORT);
        utf8Decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        UTF8_CHARSET_DECODER = utf8Decoder;
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    }
}

