/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.event;

import com.openexchange.exception.OXException;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondEventConstants;
import com.openexchange.sessiond.event.SessiondEventListener;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class SessiondEventHandler
implements EventHandler {
    private final List<SessiondEventListener> listeners = new ArrayList<SessiondEventListener>();
    private final Set<Class<? extends SessiondEventListener>> classes = new HashSet<Class<? extends SessiondEventListener>>();

    public ServiceRegistration<EventHandler> registerSessiondEventHandler(BundleContext context) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
        ((Dictionary)properties).put("event.topics", SessiondEventConstants.getAllTopics());
        return context.registerService(EventHandler.class, (Object)this, properties);
    }

    public boolean addListener(SessiondEventListener listener) {
        Class<?> clazz = listener.getClass();
        if (this.classes.contains(clazz)) {
            return false;
        }
        this.classes.add(clazz);
        this.listeners.add(listener);
        return true;
    }

    public boolean removeListener(SessiondEventListener listener) {
        Class<?> clazz = listener.getClass();
        if (!this.classes.contains(clazz)) {
            return false;
        }
        this.classes.remove(clazz);
        this.listeners.remove(listener);
        return true;
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if ("com/openexchange/sessiond/remove/session".equals(topic)) {
            Session session = (Session)event.getProperty("com.openexchange.sessiond.session");
            for (SessiondEventListener listener : this.listeners) {
                listener.handleSessionRemoval(session);
            }
        } else if ("com/openexchange/sessiond/remove/container".equals(topic)) {
            Map sessions = (Map)event.getProperty("com.openexchange.sessiond.container");
            for (SessiondEventListener listener : this.listeners) {
                listener.handleContainerRemoval(sessions);
            }
        } else if ("com/openexchange/sessiond/remove/data".equals(topic)) {
            Map sessions = (Map)event.getProperty("com.openexchange.sessiond.container");
            for (SessiondEventListener listener : this.listeners) {
                listener.handleSessionDataRemoval(sessions);
            }
        } else if ("com/openexchange/sessiond/reactivate/session".equals(topic)) {
            Session session = (Session)event.getProperty("com.openexchange.sessiond.session");
            for (SessiondEventListener listener : this.listeners) {
                listener.handleSessionReactivation(session);
            }
        } else {
            OXException error = SessionExceptionCodes.UNKNOWN_EVENT_TOPIC.create(topic == null ? "null" : topic);
            for (SessiondEventListener listener : this.listeners) {
                listener.handleError(error);
            }
        }
    }
}

