/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.results;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.util.LinkedList;

public abstract class AbstractTimedResult<T>
implements TimedResult<T> {
    private final LastModifiedExtractorIterator results;
    long sequenceNumber;

    public AbstractTimedResult(SearchIterator<T> results) {
        this.results = new LastModifiedExtractorIterator(results);
    }

    @Override
    public SearchIterator<T> results() throws OXException {
        return this.results;
    }

    @Override
    public long sequenceNumber() throws OXException {
        if (this.results.hasNext()) {
            this.results.fastForward();
        }
        return this.sequenceNumber;
    }

    protected abstract long extractTimestamp(T var1);

    private class LastModifiedExtractorIterator
    implements SearchIterator<T> {
        private SearchIterator<T> results;
        private OXException oxexception;
        private boolean fastForwardDone;
        private final int size;

        public LastModifiedExtractorIterator(SearchIterator<T> results) {
            this.results = results;
            this.size = results.size();
        }

        @Override
        public void addWarning(OXException warning) {
            this.results.addWarning(warning);
        }

        @Override
        public void close() throws OXException {
            this.results.close();
        }

        @Override
        public OXException[] getWarnings() {
            return this.results.getWarnings();
        }

        @Override
        public boolean hasNext() throws OXException {
            return this.results.hasNext();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean hasWarnings() {
            return this.results.hasWarnings();
        }

        @Override
        public T next() throws OXException {
            if (this.oxexception != null) {
                throw this.oxexception;
            }
            Object nextObject = this.results.next();
            if (this.fastForwardDone) {
                return nextObject;
            }
            long timestamp = AbstractTimedResult.this.extractTimestamp(nextObject);
            if (timestamp > AbstractTimedResult.this.sequenceNumber) {
                AbstractTimedResult.this.sequenceNumber = timestamp;
            }
            return nextObject;
        }

        void fastForward() throws OXException {
            LinkedList moreValues = new LinkedList();
            while (this.hasNext()) {
                try {
                    moreValues.add(this.next());
                }
                catch (OXException e) {
                    this.oxexception = e;
                    break;
                }
            }
            OXException[] warnings = this.results.getWarnings();
            this.results = new SearchIteratorAdapter(moreValues.iterator());
            if (warnings != null) {
                for (OXException warning : warnings) {
                    this.results.addWarning(warning);
                }
            }
            this.fastForwardDone = true;
        }
    }
}

