/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.writer;

import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.impl.DummyResourceManager;
import com.openexchange.webdav.protocol.util.Utils;
import com.openexchange.webdav.xml.resources.PropfindAllPropsMarshaller;
import com.openexchange.webdav.xml.resources.PropfindPropNamesMarshaller;
import com.openexchange.webdav.xml.resources.PropfindResponseMarshaller;
import java.util.Date;
import java.util.HashSet;
import junit.framework.TestCase;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PropertiesWriterTest
extends TestCase {
    private static final Namespace DAV_NS = Namespace.getNamespace((String)"DAV:");
    private static final Namespace TEST_NS = Namespace.getNamespace((String)"http://www.open-xchange.com/namespace/webdav-test");
    private String testCollection = null;

    public void setUp() throws Exception {
        Thread.sleep(1L);
        this.testCollection = "testCollection" + System.currentTimeMillis() + "/";
        DummyResourceManager.getInstance().resolveCollection(this.testCollection).create();
    }

    public void tearDown() throws Exception {
        DummyResourceManager.getInstance().resolveCollection(this.testCollection).delete();
    }

    public void testBasic() throws Exception {
        WebdavResource resource = DummyResourceManager.getInstance().resolveResource(this.testCollection + "test.txt");
        resource.create();
        PropfindResponseMarshaller marshaller = new PropfindResponseMarshaller("", "UTF-8", false);
        marshaller.addProperty("DAV:", "getlastmodified");
        Element response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        int count = 0;
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
            PropertiesWriterTest.assertProp(element, DAV_NS, "getlastmodified", Utils.convert((Date)resource.getLastModified()));
            ++count;
        }
        PropertiesWriterTest.assertEquals((int)1, (int)count);
    }

    public void testManyProperties() throws Exception {
        WebdavResource resource = DummyResourceManager.getInstance().resolveResource(this.testCollection + "test.txt");
        resource.setDisplayName("myDisplayName");
        resource.create();
        PropfindResponseMarshaller marshaller = new PropfindResponseMarshaller("", "UTF-8", false);
        marshaller.addProperty("DAV:", "getlastmodified").addProperty("DAV:", "displayname");
        Element response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        int count = 0;
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
            PropertiesWriterTest.assertProp(element, DAV_NS, "getlastmodified", Utils.convert((Date)resource.getLastModified()));
            PropertiesWriterTest.assertProp(element, DAV_NS, "displayname", "myDisplayName");
            ++count;
        }
        PropertiesWriterTest.assertEquals((int)1, (int)count);
    }

    public void testPropertyNames() throws Exception {
        WebdavResource resource = DummyResourceManager.getInstance().resolveResource(this.testCollection + "test.txt");
        resource.create();
        PropfindPropNamesMarshaller marshaller = new PropfindPropNamesMarshaller("", "UTF-8");
        Element response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        HashSet<String> allProps = new HashSet<String>();
        for (Protocol.Property p : new Protocol().getKnownProperties()) {
            allProps.add(p.getName());
        }
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
            Element prop = element.getChild("prop", DAV_NS);
            for (Element child : prop.getChildren()) {
                PropertiesWriterTest.assertTrue((String)("Didn't expect " + child.getName()), (boolean)allProps.remove(child.getName()));
            }
        }
        PropertiesWriterTest.assertTrue((String)((Object)allProps).toString(), (boolean)allProps.isEmpty());
    }

    public void testAllProperties() throws Exception {
        WebdavResource resource = DummyResourceManager.getInstance().resolveResource(this.testCollection + "test.txt");
        resource.create();
        PropfindAllPropsMarshaller marshaller = new PropfindAllPropsMarshaller("", "UTF-8");
        Element response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        HashSet<String> allProps = new HashSet<String>();
        for (Protocol.Property p : new Protocol().getKnownProperties()) {
            allProps.add(p.getName());
        }
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
            Element prop = element.getChild("prop", DAV_NS);
            for (Element child : prop.getChildren()) {
                PropertiesWriterTest.assertTrue((boolean)allProps.remove(child.getName()));
            }
        }
        PropertiesWriterTest.assertTrue((String)((Object)allProps).toString(), (boolean)allProps.isEmpty());
    }

    public void testEmptyProperty() throws Exception {
        WebdavResource resource = DummyResourceManager.getInstance().resolveResource(this.testCollection + "test.txt");
        resource.create();
        PropfindResponseMarshaller marshaller = new PropfindResponseMarshaller("", "UTF-8", false);
        marshaller.addProperty("DAV:", "resourcetype");
        Element response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
            PropertiesWriterTest.assertProp(element, DAV_NS, "resourcetype", "");
        }
    }

    public void testDangerousChars() throws Exception {
        WebdavResource resource = DummyResourceManager.getInstance().resolveResource(this.testCollection + "test.txt");
        resource.setDisplayName("<&>");
        resource.create();
        PropfindResponseMarshaller marshaller = new PropfindResponseMarshaller("", "UTF-8", false);
        marshaller.addProperty("DAV:", "displayname");
        Element response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
            PropertiesWriterTest.assertProp(element, DAV_NS, "displayname", "<&>");
        }
    }

    public void testXMLProperty() throws Exception {
        Element quark;
        Element child;
        Element prop;
        WebdavResource resource = DummyResourceManager.getInstance().resolveResource(this.testCollection + "test.txt");
        WebdavProperty property = new WebdavProperty();
        property.setNamespace(TEST_NS.getURI());
        property.setName("test");
        property.setValue("<quark xmlns=\"http://www.open-xchange.com/namespace/webdav-test\"> In the left corner: The incredible Tessssssst Vallllhhhhuuuuuueeeee!</quark>");
        property.setXML(true);
        resource.putProperty(property);
        resource.create();
        PropfindResponseMarshaller marshaller = new PropfindResponseMarshaller("", "UTF-8", false);
        marshaller.addProperty(TEST_NS.getURI(), "test");
        Element response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
            prop = element.getChild("prop", DAV_NS);
            child = prop.getChild("test", TEST_NS);
            quark = child.getChild("quark", TEST_NS);
            PropertiesWriterTest.assertEquals((String)" In the left corner: The incredible Tessssssst Vallllhhhhuuuuuueeeee!", (String)quark.getText());
        }
        property.setValue("<quark xmlns=\"http://www.open-xchange.com/namespace/webdav-test\"> In the left corner: The incredible Tessssssst Vallllhhhhuuuuuueeeee!</quark><gnurk xmlns=\"http://www.open-xchange.com/namespace/webdav-test\"> In the right corner: The incredible other Tessssssst Vallllhhhhuuuuuueeeee!</gnurk>");
        resource.putProperty(property);
        resource.save();
        response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
            prop = element.getChild("prop", DAV_NS);
            child = prop.getChild("test", TEST_NS);
            quark = child.getChild("quark", TEST_NS);
            PropertiesWriterTest.assertEquals((String)" In the left corner: The incredible Tessssssst Vallllhhhhuuuuuueeeee!", (String)quark.getText());
            Element gnurk = child.getChild("gnurk", TEST_NS);
            PropertiesWriterTest.assertEquals((String)" In the right corner: The incredible other Tessssssst Vallllhhhhuuuuuueeeee!", (String)gnurk.getText());
        }
    }

    public void testNotExists() throws Exception {
        WebdavResource resource = DummyResourceManager.getInstance().resolveResource(this.testCollection + "test.txt");
        resource.setDisplayName("myDisplayName");
        resource.create();
        PropfindResponseMarshaller marshaller = new PropfindResponseMarshaller("", "UTF-8", false);
        marshaller.addProperty("DAV:", "getlastmodified").addProperty("DAV:", "displayname").addProperty("OX:", "notExist");
        Element response = (Element)marshaller.marshal(resource).get(0);
        PropertiesWriterTest.assertHref(response, "/" + this.testCollection + "test.txt");
        int count = 0;
        int status = 0;
        for (Element element : response.getChildren()) {
            if (!element.getName().equals("propstat")) continue;
            if (element.getChild("status", DAV_NS).getText().equals("HTTP/1.1 200 OK")) {
                PropertiesWriterTest.assertStatus(element, "HTTP/1.1 200 OK");
                PropertiesWriterTest.assertProp(element, DAV_NS, "getlastmodified", Utils.convert((Date)resource.getLastModified()));
                ++count;
                status += 2;
                continue;
            }
            if (!element.getChild("status", DAV_NS).getText().equals("HTTP/1.1 404 NOT FOUND")) continue;
            ++count;
            ++status;
        }
        PropertiesWriterTest.assertEquals((int)2, (int)count);
        PropertiesWriterTest.assertTrue((status == 3 ? 1 : 0) != 0);
    }

    private static final void assertHref(Element element, String uri) {
        PropertiesWriterTest.assertEquals((String)uri, (String)element.getChild("href", DAV_NS).getText());
    }

    private static final void assertStatus(Element element, String status) {
        PropertiesWriterTest.assertEquals((String)status, (String)element.getChild("status", DAV_NS).getText());
    }

    private static final void assertProp(Element element, Namespace namespace, String name, String content) {
        Element prop = element.getChild("prop", DAV_NS);
        Element child = prop.getChild(name, namespace);
        if (null != child) {
            PropertiesWriterTest.assertEquals((String)content, (String)child.getText());
            return;
        }
        PropertiesWriterTest.fail((String)("Couldn't find prop: " + name + " in namespace " + namespace.getURI()));
    }
}

