/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.writer;

import com.openexchange.test.XMLCompare;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.xml.WebdavLockWriter;
import junit.framework.TestCase;

public class LockWriterTest
extends TestCase {
    private final XMLCompare xmlCompare = new XMLCompare();

    public void testWriteLock() throws Exception {
        this.xmlCompare.setCheckTextNames("depth", "owner", "timeout", "href");
        WebdavLockWriter writer = new WebdavLockWriter();
        TestLock lock = new TestLock();
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setTimeout(-1L);
        lock.setToken("opaquelocktoken:blaaaa");
        String expect = "<blupp xmlns:D=\"DAV:\"> <D:activelock> <D:locktype><D:write /></D:locktype> <D:lockscope><D:exclusive/></D:lockscope> <D:depth>0</D:depth> <D:owner>me</D:owner> <D:timeout>Infinite</D:timeout> <D:locktoken><D:href>opaquelocktoken:blaaaa</D:href></D:locktoken> </D:activelock></blupp>";
        String got = "<blupp xmlns:D=\"DAV:\">" + writer.lock2xml((WebdavLock)lock) + "</blupp>";
        LockWriterTest.assertTrue((boolean)this.xmlCompare.compare(expect, got));
        lock.setScope(WebdavLock.Scope.SHARED_LITERAL);
        expect = "<blupp xmlns:D=\"DAV:\"><D:activelock> <D:locktype><D:write /></D:locktype> <D:lockscope><D:shared/></D:lockscope> <D:depth>0</D:depth> <D:owner>me</D:owner> <D:timeout>Infinite</D:timeout> <D:locktoken><D:href>opaquelocktoken:blaaaa</D:href></D:locktoken> </D:activelock></blupp>";
        got = "<blupp xmlns:D=\"DAV:\">" + writer.lock2xml((WebdavLock)lock) + "</blupp>";
        LockWriterTest.assertTrue((boolean)this.xmlCompare.compare(expect, got));
        lock.setDepth(1);
        expect = "<blupp xmlns:D=\"DAV:\"><D:activelock> <D:locktype><D:write /></D:locktype> <D:lockscope><D:shared/></D:lockscope> <D:depth>1</D:depth> <D:owner>me</D:owner> <D:timeout>Infinite</D:timeout> <D:locktoken><D:href>opaquelocktoken:blaaaa</D:href></D:locktoken> </D:activelock></blupp>";
        got = "<blupp xmlns:D=\"DAV:\">" + writer.lock2xml((WebdavLock)lock) + "</blupp>";
        LockWriterTest.assertTrue((boolean)this.xmlCompare.compare(expect, got));
        lock.setDepth(-1);
        expect = "<blupp xmlns:D=\"DAV:\"><D:activelock> <D:locktype><D:write /></D:locktype> <D:lockscope><D:shared/></D:lockscope> <D:depth>infinity</D:depth> <D:owner>me</D:owner> <D:timeout>Infinite</D:timeout> <D:locktoken><D:href>opaquelocktoken:blaaaa</D:href></D:locktoken> </D:activelock></blupp>";
        got = "<blupp xmlns:D=\"DAV:\">" + writer.lock2xml((WebdavLock)lock) + "</blupp>";
        LockWriterTest.assertTrue((boolean)this.xmlCompare.compare(expect, got));
        lock.setTimeout(23000L);
        expect = "<blupp xmlns:D=\"DAV:\"><D:activelock> <D:locktype><D:write /></D:locktype> <D:lockscope><D:shared/></D:lockscope> <D:depth>infinity</D:depth> <D:owner>me</D:owner> <D:timeout>Second-23</D:timeout> <D:locktoken><D:href>opaquelocktoken:blaaaa</D:href></D:locktoken> </D:activelock></blupp>";
        got = "<blupp xmlns:D=\"DAV:\">" + writer.lock2xml((WebdavLock)lock) + "</blupp>";
        LockWriterTest.assertTrue((boolean)this.xmlCompare.compare(expect, got));
    }

    private static final class TestLock
    extends WebdavLock {
        private long timeout;

        private TestLock() {
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }
    }
}

