/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.ifheader.IfHeader;
import com.openexchange.webdav.action.ifheader.IfHeaderEntity;
import com.openexchange.webdav.action.ifheader.IfHeaderList;
import com.openexchange.webdav.action.ifheader.IfHeaderParseException;
import com.openexchange.webdav.action.ifheader.IfHeaderParser;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;

public class IfHeaderParserTest
extends TestCase {
    public void testETag() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("([etag])");
        IfHeaderParserTest.assertEquals((int)1, (int)ifHeader.getLists().size());
        IfHeaderList list = ifHeader.getList(0);
        IfHeaderParserTest.assertEquals((int)1, (int)list.size());
        IfHeaderEntity entity = (IfHeaderEntity)list.get(0);
        IfHeaderParserTest.assertTrue((boolean)entity.isETag());
        IfHeaderParserTest.assertTrue((boolean)entity.mustMatch());
        IfHeaderParserTest.assertFalse((boolean)entity.isLockToken());
        IfHeaderParserTest.assertEquals((String)"etag", (String)entity.getPayload());
    }

    public void testLockToken() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("(<http://www.open-xchange.com/webdav/12345>)");
        IfHeaderParserTest.assertEquals((int)1, (int)ifHeader.getLists().size());
        IfHeaderList list = ifHeader.getList(0);
        IfHeaderParserTest.assertEquals((int)1, (int)list.size());
        IfHeaderEntity entity = (IfHeaderEntity)list.get(0);
        IfHeaderParserTest.assertTrue((boolean)entity.isLockToken());
        IfHeaderParserTest.assertTrue((boolean)entity.mustMatch());
        IfHeaderParserTest.assertEquals((String)"http://www.open-xchange.com/webdav/12345", (String)entity.getPayload());
    }

    public void testTrimETag() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("([   etag ])");
        IfHeaderParserTest.assertEquals((int)1, (int)ifHeader.getLists().size());
        IfHeaderList list = ifHeader.getList(0);
        IfHeaderParserTest.assertEquals((int)1, (int)list.size());
        IfHeaderEntity entity = (IfHeaderEntity)list.get(0);
        IfHeaderParserTest.assertTrue((boolean)entity.isETag());
        IfHeaderParserTest.assertTrue((boolean)entity.mustMatch());
        IfHeaderParserTest.assertFalse((boolean)entity.isLockToken());
        IfHeaderParserTest.assertEquals((String)"etag", (String)entity.getPayload());
    }

    public void testTrimLockToken() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("(<   http://www.open-xchange.com/webdav/12345 >)");
        IfHeaderParserTest.assertEquals((int)1, (int)ifHeader.getLists().size());
        IfHeaderList list = ifHeader.getList(0);
        IfHeaderParserTest.assertEquals((int)1, (int)list.size());
        IfHeaderEntity entity = (IfHeaderEntity)list.get(0);
        IfHeaderParserTest.assertTrue((boolean)entity.mustMatch());
        IfHeaderParserTest.assertTrue((boolean)entity.isLockToken());
        IfHeaderParserTest.assertEquals((String)"http://www.open-xchange.com/webdav/12345", (String)entity.getPayload());
    }

    public void testNot() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("(Not [etag] <lockToken> Not <lockToken2>)");
        IfHeaderParserTest.assertEquals((int)1, (int)ifHeader.getLists().size());
        IfHeaderList list = ifHeader.getList(0);
        IfHeaderParserTest.assertEquals((int)3, (int)list.size());
        int found = 0;
        for (IfHeaderEntity entity : list) {
            if ("etag".equals(entity.getPayload())) {
                IfHeaderParserTest.assertFalse((boolean)entity.mustMatch());
                ++found;
                continue;
            }
            if ("lockToken".equals(entity.getPayload())) {
                IfHeaderParserTest.assertTrue((boolean)entity.mustMatch());
                ++found;
                continue;
            }
            if (!"lockToken2".equals(entity.getPayload())) continue;
            IfHeaderParserTest.assertFalse((boolean)entity.mustMatch());
            ++found;
        }
        IfHeaderParserTest.assertEquals((int)3, (int)found);
    }

    public void testMany() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("([etag] <lockToken> [etag2] <lockToken2> <lockToken3> [etag3])");
        IfHeaderParserTest.assertEquals((int)1, (int)ifHeader.getLists().size());
        IfHeaderList list = ifHeader.getList(0);
        IfHeaderParserTest.assertEquals((int)6, (int)list.size());
        HashSet<String> etags = new HashSet<String>(Arrays.asList("etag", "etag2", "etag3"));
        HashSet<String> lockToken = new HashSet<String>(Arrays.asList("lockToken", "lockToken2", "lockToken3"));
        for (IfHeaderEntity entity : list) {
            if (entity.isETag()) {
                IfHeaderParserTest.assertTrue((String)entity.getPayload(), (boolean)etags.remove(entity.getPayload()));
                continue;
            }
            IfHeaderParserTest.assertTrue((String)entity.getPayload(), (boolean)lockToken.remove(entity.getPayload()));
        }
        IfHeaderParserTest.assertTrue((String)((Object)etags).toString(), (boolean)etags.isEmpty());
        IfHeaderParserTest.assertTrue((String)((Object)lockToken).toString(), (boolean)lockToken.isEmpty());
    }

    public void testUntaggedLists() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("([etag]) (<lockToken>) ([etag2])");
        IfHeaderParserTest.assertEquals((int)3, (int)ifHeader.getLists().size());
        HashSet<String> etags = new HashSet<String>(Arrays.asList("etag", "etag2"));
        HashSet<String> lockToken = new HashSet<String>(Arrays.asList("lockToken"));
        for (IfHeaderList list : ifHeader.getLists()) {
            IfHeaderParserTest.assertEquals((int)1, (int)list.size());
            IfHeaderParserTest.assertFalse((boolean)list.isTagged());
            IfHeaderEntity entity = list.get(0);
            if (entity.isETag()) {
                IfHeaderParserTest.assertTrue((String)entity.getPayload(), (boolean)etags.remove(entity.getPayload()));
                continue;
            }
            IfHeaderParserTest.assertTrue((String)entity.getPayload(), (boolean)lockToken.remove(entity.getPayload()));
        }
        IfHeaderParserTest.assertTrue((String)((Object)etags).toString(), (boolean)etags.isEmpty());
        IfHeaderParserTest.assertTrue((String)((Object)lockToken).toString(), (boolean)lockToken.isEmpty());
    }

    public void testTaggedLists() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("<http://myResource1> ([etag]) <  http://myResource2> (<lockToken>) <http://myResource3> ([etag2])");
        IfHeaderParserTest.assertEquals((int)3, (int)ifHeader.getLists().size());
        HashSet<String> etags = new HashSet<String>(Arrays.asList("etag", "etag2"));
        HashSet<String> lockToken = new HashSet<String>(Arrays.asList("lockToken"));
        HashSet<String> resources = new HashSet<String>(Arrays.asList("http://myResource1", "http://myResource2", "http://myResource3"));
        for (IfHeaderList list : ifHeader.getLists()) {
            IfHeaderParserTest.assertEquals((int)1, (int)list.size());
            IfHeaderParserTest.assertTrue((boolean)list.isTagged());
            IfHeaderParserTest.assertTrue((boolean)resources.remove(list.getTag()));
            IfHeaderEntity entity = list.get(0);
            if (entity.isETag()) {
                IfHeaderParserTest.assertTrue((String)entity.getPayload(), (boolean)etags.remove(entity.getPayload()));
                continue;
            }
            IfHeaderParserTest.assertTrue((String)entity.getPayload(), (boolean)lockToken.remove(entity.getPayload()));
        }
        IfHeaderParserTest.assertTrue((boolean)resources.isEmpty());
        IfHeaderParserTest.assertTrue((String)((Object)etags).toString(), (boolean)etags.isEmpty());
        IfHeaderParserTest.assertTrue((String)((Object)lockToken).toString(), (boolean)lockToken.isEmpty());
    }

    public void testGetRelevant() throws Exception {
        IfHeader ifHeader = new IfHeaderParser().parse("<http://myResource1> ([etag]) <  http://myResource1> (<lockToken>) <http://myResource3> ([etag2])");
        IfHeaderParserTest.assertEquals((int)3, (int)ifHeader.getLists().size());
        HashSet<String> etags = new HashSet<String>(Arrays.asList("etag"));
        HashSet<String> lockToken = new HashSet<String>(Arrays.asList("lockToken"));
        for (IfHeaderList list : ifHeader.getRelevant("http://myResource1")) {
            IfHeaderParserTest.assertEquals((int)1, (int)list.size());
            IfHeaderParserTest.assertTrue((boolean)list.isTagged());
            IfHeaderEntity entity = list.get(0);
            if (entity.isETag()) {
                IfHeaderParserTest.assertTrue((String)entity.getPayload(), (boolean)etags.remove(entity.getPayload()));
                continue;
            }
            IfHeaderParserTest.assertTrue((String)entity.getPayload(), (boolean)lockToken.remove(entity.getPayload()));
        }
        IfHeaderParserTest.assertTrue((String)((Object)etags).toString(), (boolean)etags.isEmpty());
        IfHeaderParserTest.assertTrue((String)((Object)lockToken).toString(), (boolean)lockToken.isEmpty());
    }

    public void testUnfinishedTag() throws Exception {
        this.assertException("<blabla ([gnatzel])", "Unfinished Tag", 1);
    }

    public void testUnfinishedList() throws Exception {
        this.assertException("<blabla> ([gnatzel]", "Unfinished List", 10);
    }

    public void testUnfinishedETag() throws Exception {
        this.assertException("<blabla> ([gnatzel)", "Unfinished ETag", 11);
    }

    public void testUnfinishedLockToken() throws Exception {
        this.assertException("<blabla> (<gnatzel)", "Unfinished LockToken", 11);
    }

    public void testInvalidNot() throws Exception {
        this.assertException("<blabla> (<gnatzel> NurgelWargelWahnsinn)", "Invalid character", 22);
    }

    private void assertException(String ifHeader, String errorMessage, int column) {
        try {
            new IfHeaderParser().parse("([etag])");
        }
        catch (IfHeaderParseException x) {
            IfHeaderParserTest.assertTrue((boolean)x.getMessage().contains(errorMessage));
            IfHeaderParserTest.assertEquals((int)column, (int)x.getColumn());
        }
    }
}

