/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet;

import com.openexchange.ajp13.servlet.ServletConfigLoader;
import com.openexchange.ajp13.servlet.ServletConfigWrapper;
import com.openexchange.ajp13.servlet.ServletContextWrapper;
import com.openexchange.test.TestInit;
import java.io.File;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import junit.framework.TestCase;

public class ServletConfigLoaderTest
extends TestCase {
    public void testLoadGeneralConfig() {
        ServletConfigLoader loader = new ServletConfigLoader(new File(TestInit.getTestProperty("testServletConfigs")));
        ServletConfig config = loader.getConfig("com.openexchange.servlets.ImaginaryServlet");
        ServletConfigLoaderTest.assertEquals((String)"13", (String)config.getInitParameter("cool.temperature"));
        ServletConfigLoaderTest.assertEquals((String)"Celsius", (String)config.getInitParameter("cool.scale"));
        ServletContext context = loader.getContext("com.openexchange.servlets.ImaginaryServlet");
        ServletConfigLoaderTest.assertEquals((String)"13", (String)context.getInitParameter("cool.temperature"));
        ServletConfigLoaderTest.assertEquals((String)"Celsius", (String)context.getInitParameter("cool.scale"));
    }

    public void testLoadSpecializedConfig() {
        ServletConfigLoader loader = new ServletConfigLoader(new File(TestInit.getTestProperty("testServletConfigs")));
        ServletConfig config = loader.getConfig("com.openexchange.servlets.OtherImaginaryServlet", "imaginary/other");
        ServletConfigLoaderTest.assertEquals((String)"overridden", (String)config.getInitParameter("overrideMe"));
        ServletConfigLoaderTest.assertEquals((String)"not overridden", (String)config.getInitParameter("dontOverrideMe"));
        ServletContext context = loader.getContext("com.openexchange.servlets.OtherImaginaryServlet", "imaginary/other");
        ServletConfigLoaderTest.assertEquals((String)"overridden", (String)context.getInitParameter("overrideMe"));
        ServletConfigLoaderTest.assertEquals((String)"not overridden", (String)context.getInitParameter("dontOverrideMe"));
        config = loader.getConfig("com.openexchange.servlets.OtherImaginaryServlet", "imaginary/other2");
        ServletConfigLoaderTest.assertEquals((String)"overridden2", (String)config.getInitParameter("overrideMe"));
        ServletConfigLoaderTest.assertEquals((String)"not overridden", (String)config.getInitParameter("dontOverrideMe"));
        context = loader.getContext("com.openexchange.servlets.OtherImaginaryServlet", "imaginary/other2");
        ServletConfigLoaderTest.assertEquals((String)"overridden2", (String)context.getInitParameter("overrideMe"));
        ServletConfigLoaderTest.assertEquals((String)"not overridden", (String)context.getInitParameter("dontOverrideMe"));
    }

    public void testLoadSpecializedOnly() {
        ServletConfigLoader loader = new ServletConfigLoader(new File(TestInit.getTestProperty("testServletConfigs")));
        ServletConfig config = loader.getConfig("com.openexchange.servlets.NotConfiguredServlet", "imaginary/other");
        ServletConfigLoaderTest.assertEquals((String)"overridden", (String)config.getInitParameter("overrideMe"));
        ServletConfigLoaderTest.assertNull((Object)config.getInitParameter("dontOverrideMe"));
    }

    public void testLoadSpecializedIgnoreWildcards() {
        ServletConfigLoader loader = new ServletConfigLoader(new File(TestInit.getTestProperty("testServletConfigs")));
        ServletConfig config = loader.getConfig("com.openexchange.servlets.OtherImaginaryServlet", "imaginary/other*");
        ServletConfigLoaderTest.assertEquals((String)"overridden", (String)config.getInitParameter("overrideMe"));
        ServletConfigLoaderTest.assertEquals((String)"not overridden", (String)config.getInitParameter("dontOverrideMe"));
    }

    public void testOnlySpecialized() {
        ServletConfigLoader loader = new ServletConfigLoader(new File(TestInit.getTestProperty("testServletConfigs")));
        ServletConfig config = loader.getConfig("com.openexchange.servlets.NotConfiguredServlet", "imaginary/otherest");
        ServletConfigLoaderTest.assertEquals((String)"13", (String)config.getInitParameter("cool.temperature"));
        ServletConfigLoaderTest.assertEquals((String)"Celsius", (String)config.getInitParameter("cool.scale"));
    }

    public void testDefault() {
        ServletConfigLoader loader = new ServletConfigLoader(new File(TestInit.getTestProperty("testServletConfigs")));
        ServletConfigWrapper config = new ServletConfigWrapper();
        ServletContextWrapper context = new ServletContextWrapper(config);
        config.setServletContextWrapper(context);
        loader.setDefaultConfig((ServletConfig)config);
        loader.setDefaultContext((ServletContext)context);
        ServletConfig configLookup = loader.getConfig("com.openexchange.servlets.UnconfiguredServlet");
        ServletContext contextLookup = loader.getContext("com.openexchange.servlets.UnconfiguredServlet");
        ServletConfigLoaderTest.assertEquals((Object)config, (Object)configLookup);
        ServletConfigLoaderTest.assertEquals((Object)context, (Object)contextLookup);
        configLookup = loader.getConfig("com.openexchange.servlets.UnconfiguredServlet", "some/path");
        contextLookup = loader.getContext("com.openexchange.servlets.UnconfiguredServlet", "some/path");
        ServletConfigLoaderTest.assertEquals((Object)config, (Object)configLookup);
        ServletConfigLoaderTest.assertEquals((Object)context, (Object)contextLookup);
    }
}

