/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.events;

import com.openexchange.event.CommonEvent;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.tools.events.TestEventAdmin;
import org.junit.Assert;

public class EventAssertions {
    public static void assertDeleteEvent(Class type, int parentFolderID, int objectID) {
        EventAssertions.assertEvent(type, 3, parentFolderID, objectID, false);
    }

    public static <T> T assertModificationEvent(Class<T> type, int parentFolderID, int objectID) {
        return EventAssertions.assertEvent(type, 2, parentFolderID, objectID, false);
    }

    public static <T> T assertModificationEventWithOldObject(Class<T> type, int parentFolderID, int objectID) {
        return EventAssertions.assertEvent(type, 2, parentFolderID, objectID, true);
    }

    public static <T> T assertEvent(Class<T> type, int action, int parentFolderID, int objectID, boolean checkForOldObject) {
        TestEventAdmin events = TestEventAdmin.getInstance();
        CommonEvent event = events.getNewest();
        CommonObject commonObject = (CommonObject)event.getActionObj();
        Assert.assertNotNull((Object)commonObject);
        Assert.assertTrue((boolean)type.isAssignableFrom(commonObject.getClass()));
        EventAssertions.assertEquals(action, event.getAction());
        EventAssertions.assertEquals(parentFolderID, commonObject.getParentFolderID());
        EventAssertions.assertEquals(objectID, commonObject.getObjectID());
        if (checkForOldObject) {
            CommonObject oldObject = (CommonObject)event.getOldObj();
            Assert.assertTrue((String)"Old Object was not set in the event", (oldObject != null ? 1 : 0) != 0);
            EventAssertions.assertEquals(objectID, oldObject.getObjectID());
        }
        return (T)commonObject;
    }

    public static void assertEquals(int expected, int other) {
        if (expected != other) {
            Assert.fail((String)("Expected: " + expected + " Got: " + other));
        }
    }
}

