/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.IntrospectionTools;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFixtures<T>
implements Fixtures<T> {
    private Class<T> klass = null;
    private final Map<Class, Transformator> transformators = new HashMap<Class, Transformator>();
    private final Map<String, Transformator> attributeTransformators = new HashMap<String, Transformator>();
    private final Map<String, List<String>> synonyms = new HashMap<String, List<String>>();
    private final List<String> entryNames;

    public AbstractFixtures(Class<T> klass, Map values) {
        this.klass = klass;
        this.entryNames = new ArrayList(values.keySet());
    }

    public void addTransformator(Transformator transformator, Class into) {
        this.transformators.put(into, transformator);
    }

    public void addTransformator(Transformator transformator, String attribute) {
        this.attributeTransformators.put(attribute, transformator);
    }

    public void addSynoym(String attribute, String ... syns) {
        List<String> synList = this.synonyms.get(attribute);
        if (synList == null) {
            synList = new ArrayList<String>();
            this.synonyms.put(attribute, synList);
        }
        for (String syn : syns) {
            synList.add(syn);
        }
    }

    @Override
    public List<String> getEntryNames() {
        return this.entryNames;
    }

    protected void apply(T bean, Map attributes) throws OXException {
        for (Object o : attributes.keySet()) {
            String value = null;
            if (attributes.containsKey(o) && null != attributes.get(o)) {
                value = attributes.get(o).toString();
            }
            Object param = value;
            Method[] setters = this.discoverSetters(o.toString());
            for (int i = 0; i < setters.length; ++i) {
                param = false == setters[i].getParameterTypes()[0].equals(String.class) ? this.getTransformator(setters[i].getParameterTypes()[0], o.toString()).transform(value) : (null != value ? value : null);
                try {
                    setters[i].invoke(bean, param);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    if (i < setters.length) continue;
                    throw new FixtureException(e);
                }
                catch (IllegalAccessException e) {
                    throw new FixtureException(e);
                }
                catch (InvocationTargetException e) {
                    throw new FixtureException(e);
                }
            }
        }
    }

    private Transformator getTransformator(Class aClass, String attribute) throws OXException {
        if (this.attributeTransformators.containsKey(attribute)) {
            return this.attributeTransformators.get(attribute);
        }
        if (!this.transformators.containsKey(aClass)) {
            this.transformators.put(aClass, new StringConstructorTransformator(aClass));
        }
        return this.transformators.get(aClass);
    }

    private Method discoverSetter(String attribute) throws OXException {
        ArrayList<String> methodNames = new ArrayList<String>();
        methodNames.add(IntrospectionTools.setterName(attribute));
        for (String synonym : this.getSynonyms(attribute)) {
            methodNames.add(IntrospectionTools.setterName(synonym));
        }
        for (Method method : this.klass.getMethods()) {
            for (String acceptableName : methodNames) {
                if (!method.getName().equalsIgnoreCase(acceptableName) || method.getParameterTypes().length != 1) continue;
                return method;
            }
        }
        throw new FixtureException("Don't know how to set attribute " + attribute);
    }

    private Method[] discoverSetters(String attribute) throws OXException {
        ArrayList<String> methodNames = new ArrayList<String>();
        methodNames.add(IntrospectionTools.setterName(attribute));
        methodNames.add(IntrospectionTools.adderName(attribute));
        for (String synonym : this.getSynonyms(attribute)) {
            methodNames.add(IntrospectionTools.adderName(synonym));
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.klass.getMethods()) {
            for (String acceptableName : methodNames) {
                if (!method.getName().equalsIgnoreCase(acceptableName) || method.getParameterTypes().length != 1) continue;
                methods.add(method);
            }
        }
        if (0 < methods.size()) {
            return methods.toArray(new Method[methods.size()]);
        }
        return new Method[0];
    }

    private List<String> getSynonyms(String attribute) {
        if (this.synonyms.containsKey(attribute)) {
            return this.synonyms.get(attribute);
        }
        return Collections.EMPTY_LIST;
    }

    private class StringConstructorTransformator
    implements Transformator {
        private Constructor<?> constructor;

        public StringConstructorTransformator(Class<?> aClass) throws OXException {
            try {
                this.constructor = aClass.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new FixtureException("I don't know how to turn a String into a " + aClass.toString(), e);
            }
        }

        @Override
        public Object transform(String value) throws OXException {
            try {
                return this.constructor.newInstance(value);
            }
            catch (InstantiationException e) {
                throw new FixtureException(e);
            }
            catch (IllegalAccessException e) {
                throw new FixtureException(e);
            }
            catch (InvocationTargetException e) {
                throw new FixtureException(e);
            }
        }
    }
}

