/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.resource.actions.ResourceNewResponse;
import com.openexchange.ajax.resource.actions.ResourceSearchRequest;
import com.openexchange.ajax.resource.actions.ResourceSearchResponse;
import com.openexchange.exception.OXException;
import com.openexchange.resource.Resource;
import com.openexchange.test.TestManager;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.junit.Assert;

public class ResourceTestManager
implements TestManager {
    private final List<Resource> createdEntites = new LinkedList<Resource>();
    private final AJAXClient client;
    private boolean failOnError;
    private Throwable lastException;
    private AbstractAJAXResponse lastResponse;
    private Date lastModified;

    private AJAXClient getClient() {
        return this.client;
    }

    @Override
    public boolean doesFailOnError() {
        return this.getFailOnError();
    }

    @Override
    public boolean getFailOnError() {
        return this.failOnError;
    }

    private void setLastException(Throwable t) {
        this.lastException = t;
    }

    @Override
    public Throwable getLastException() {
        return this.lastException;
    }

    @Override
    public AbstractAJAXResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public boolean hasLastException() {
        return this.lastException != null;
    }

    @Override
    public void setFailOnError(boolean doFail) {
        this.failOnError = doFail;
    }

    private void setLastModification(Date timestamp) {
        this.lastModified = timestamp;
    }

    public Date getLastModification() {
        return this.lastModified;
    }

    private void setLastResponse(AbstractAJAXResponse response) {
        this.lastResponse = response;
    }

    public ResourceTestManager(AJAXClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        boolean old = this.failOnError;
        this.setFailOnError(false);
        try {
            for (Resource resource : this.createdEntites) {
            }
        }
        finally {
            this.setFailOnError(old);
        }
    }

    public Resource generateDefaultResource() {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setMail("my.resource@domain.tdl");
        resource.setSimpleName("MySimpleResourceIdentifier");
        resource.setDisplayName("Resource 1337");
        resource.setDescription("MySimpleResourceIdentifier - Resource 1337");
        return resource;
    }

    public List<Resource> search(String pattern) throws JSONException {
        ResourceSearchResponse response = this.execute(new ResourceSearchRequest(pattern, this.getFailOnError()));
        this.extractInfo(response);
        return response.getResources();
    }

    protected <T extends AbstractAJAXResponse> T execute(AJAXRequest<T> request) {
        block6: {
            try {
                return this.getClient().execute(request);
            }
            catch (OXException e) {
                this.setLastException(e);
                if (this.failOnError) {
                    Assert.fail((String)("AjaxException during resource creation: " + e.getLocalizedMessage()));
                }
            }
            catch (IOException e) {
                this.setLastException(e);
                if (this.failOnError) {
                    Assert.fail((String)("IOException during resource creation: " + e.getLocalizedMessage()));
                }
            }
            catch (JSONException e) {
                this.setLastException(e);
                if (!this.failOnError) break block6;
                Assert.fail((String)("JsonException during resource creation: " + e.getLocalizedMessage()));
            }
        }
        return null;
    }

    protected void updateResource(Resource res, ResourceNewResponse response) throws JSONException {
        res.setLastModified(response.getTimestamp());
        res.setIdentifier(response.getID());
    }

    protected void extractInfo(AbstractAJAXResponse response) {
        this.setLastResponse(response);
        this.setLastModification(response.getTimestamp());
        if (response.hasError()) {
            this.setLastException(response.getException());
        }
    }
}

