/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.oauth.actions.AllOAuthAccountRequest;
import com.openexchange.ajax.oauth.actions.AllOAuthAccountResponse;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.RefreshSubscriptionRequest;
import com.openexchange.ajax.subscribe.source.action.GetSourceRequest;
import com.openexchange.ajax.subscribe.source.action.GetSourceResponse;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.google.actions.DeleteOAuthAccountRequest;
import com.openexchange.test.FolderTestManager;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public abstract class AbstractSubscribeTestEnvironment {
    protected AJAXClient ajaxClient;
    protected FolderTestManager folderMgr;
    private final Map<String, Integer> testFolders = new HashMap<String, Integer>();
    private final String serviceId;
    private int accountId = -1;

    protected AbstractSubscribeTestEnvironment(String serviceId) {
        this.serviceId = serviceId;
    }

    public void init() {
        try {
            this.initAJAXClient();
            this.initManagers();
            this.initEnvironment();
            this.createSubscriptions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAJAXClient() throws OXException, IOException, JSONException {
        this.ajaxClient = new AJAXClient(AJAXClient.User.User1);
    }

    private void initManagers() throws OXException, IOException, SAXException, JSONException {
        this.folderMgr = new FolderTestManager(this.ajaxClient);
    }

    protected abstract void initEnvironment() throws Exception;

    protected abstract void createSubscriptions() throws Exception;

    protected void createSubscription(int accountId, String sourceId, int module, int parent, int userId) throws Exception {
        FolderObject folder = this.createSubscriptionFolder(sourceId, module, parent, userId);
        DynamicFormDescription formDescription = this.createDynamicFormDescription(sourceId);
        Subscription subscription = this.createSubscription(formDescription, sourceId, accountId, folder.getObjectID());
        NewSubscriptionRequest subReq = new NewSubscriptionRequest(subscription, formDescription);
        NewSubscriptionResponse subResp = this.ajaxClient.execute(subReq);
        int subId = (Integer)subResp.getData();
        RefreshSubscriptionRequest refreshReq = new RefreshSubscriptionRequest(subId, Integer.toString(folder.getObjectID()));
        this.ajaxClient.execute(refreshReq);
        this.testFolders.put(sourceId, folder.getObjectID());
    }

    protected int getAccountId() throws OXException, IOException, JSONException {
        AllOAuthAccountRequest oauthReq;
        AllOAuthAccountResponse oauthResp;
        Object data;
        if (this.accountId < 0 && (data = (oauthResp = this.ajaxClient.execute(oauthReq = new AllOAuthAccountRequest())).getData()) instanceof JSONArray) {
            JSONArray array = (JSONArray)data;
            for (Object o : array.asList()) {
                LinkedHashMap json = (LinkedHashMap)o;
                if (!json.get("serviceId").equals(this.serviceId)) continue;
                this.accountId = (Integer)json.get("id");
            }
        }
        return this.accountId;
    }

    private FolderObject createSubscriptionFolder(String name, int module, int parentId, int userId) throws OXException, IOException, JSONException {
        FolderObject object = this.folderMgr.generatePublicFolder(name, module, parentId, userId);
        this.folderMgr.insertFolderOnServer(object);
        return object;
    }

    private DynamicFormDescription createDynamicFormDescription(String sourceId) throws Exception {
        GetSourceRequest getSrcReq = new GetSourceRequest(sourceId);
        GetSourceResponse getSrcResp = this.ajaxClient.execute(getSrcReq);
        Object data = getSrcResp.getData();
        if (getSrcResp.hasError()) {
            throw new Exception("Returned with errors: " + data);
        }
        JSONObject json = (JSONObject)data;
        JSONObject jsonFormDesc = json.getJSONArray("formDescription").getJSONObject(0);
        DynamicFormDescription formDescription = new DynamicFormDescription();
        FormElement fe = FormElement.custom((String)jsonFormDesc.getString("widget"), (String)jsonFormDesc.getString("name"), (String)jsonFormDesc.getString("displayName"));
        fe.setOption("type", jsonFormDesc.getJSONObject("options").getString("type"));
        fe.setMandatory(jsonFormDesc.getBoolean("mandatory"));
        formDescription.add(fe);
        return formDescription;
    }

    private Subscription createSubscription(DynamicFormDescription desc, String sourceId, int accountId, int folderId) {
        SubscriptionSource source = new SubscriptionSource();
        source.setId(sourceId);
        source.setFormDescription(desc);
        Subscription subscription = new Subscription();
        subscription.setSource(source);
        subscription.setFolderId(folderId);
        subscription.setConfiguration(Collections.singletonMap((Object)"account", (Object)accountId));
        return subscription;
    }

    protected void logout() throws OXException, IOException, JSONException {
        if (this.ajaxClient != null) {
            this.ajaxClient.logout();
        }
    }

    public Map<String, Integer> getTestFolders() {
        return this.testFolders;
    }

    public void cleanup() throws OXException, IOException, JSONException {
        if (this.folderMgr != null) {
            this.folderMgr.cleanUp();
        }
        this.deleteOAuthAccount();
        this.logout();
    }

    private void deleteOAuthAccount() throws OXException, IOException, JSONException {
        DeleteOAuthAccountRequest req = new DeleteOAuthAccountRequest(this.accountId);
        this.ajaxClient.execute(req);
    }
}

