/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.search.BodyTerm;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.FromTerm;
import com.openexchange.mail.search.HeaderTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SentDateTerm;
import com.openexchange.mail.search.SizeTerm;
import com.openexchange.mail.search.SubjectTerm;
import com.openexchange.mail.search.ToTerm;
import com.openexchange.mail.utils.DateUtils;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.mail.MessagingException;

public final class MailSearchTest
extends AbstractMailTest {
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    private static final MailField[] FIELDS_ID_AND_HEADER = new MailField[]{MailField.ID, MailField.HEADERS};
    private static final MailField[] FIELDS_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS};
    private static final MailField[] FIELDS_EVEN_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.FROM, MailField.TO, MailField.DISPOSITION_NOTIFICATION_TO, MailField.COLOR_LABEL, MailField.HEADERS, MailField.SUBJECT, MailField.THREAD_LEVEL, MailField.SIZE, MailField.PRIORITY};
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};
    private static final String RFC822_SRC = "From: \"Di Lella, Leonardo\" <leonardo.dilella@open-xchange.com>\nTo: dream-team@open-xchange.com,\n\tHolger Achtziger <Holger.Achtziger@open-xchange.com>\nMessage-ID: <32496175.17311207643539009.JavaMail.open-xchange@oxee>\nIn-Reply-To: <47F662C4.5060605@open-xchange.com>\nReferences: <47F662C4.5060605@open-xchange.com>\nSubject: =?UTF-8?Q?Re:_[dream-team]_Vserver_von_1und1_f=C3=BCr_alle_OX_Mitarbeiter?=\nMIME-Version: 1.0\nContent-Type: multipart/alternative; \n\tboundary=\"----=_Part_932_16478682.1207643538866\"\nX-Priority: 3\nX-Mailer: Open-Xchange Mailer v6.5.0-6342\nX-Scanner: exiscan *1Jj95n-0003af-00*Nlh5NV02rM6*\n\thttp://duncanthrax.net/exiscan/\nCc: \nX-BeenThere: dream-team@open-xchange.com\nX-Mailman-Version: 2.1.5\nPrecedence: list\nList-Id: Mailinglist for whole the dream-team of Open-Xchange - all members of\n\tOpen-Change <dream-team.open-xchange.com>\nList-Unsubscribe: <https://ox.open-xchange.com/mailman/listinfo/dream-team>,\n\t<mailto:dream-team-request@open-xchange.com?subject=unsubscribe>\nList-Archive: <https://ox.open-xchange.com/pipermail/dream-team>\nList-Post: <mailto:dream-team@open-xchange.com>\nList-Help: <mailto:dream-team-request@open-xchange.com?subject=help>\nList-Subscribe: <https://ox.open-xchange.com/mailman/listinfo/dream-team>,\n\t<mailto:dream-team-request@open-xchange.com?subject=subscribe>\nSender: dream-team-bounces@open-xchange.com\nErrors-To: dream-team-bounces@open-xchange.com\n\tHTML_MESSAGE,HTML_TITLE_EMPTY autolearn=no version=2.64\n\n------=_Part_932_16478682.1207643538866\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nHolger Achtziger <Holger.Achtziger@open-xchange.com> hat am 4. April 2008 um 19:17 geschrieben:\n\n> Hallo!\n\nHallo,\n\nwie lauten die Randbedingungen ? \n\n1) Wie lange zahlt uns 1&1 den Server (nur einen Jahr?) ?\n2) Privat oder nur geschaeftlich einsetzbar ?\n3) Was passiert bei einer OX-Kuendigung ?\n\nDanke.\n\n--\nbest regards\nLeonardo Di Lella\n\nOpen-Xchange GmbH\nhttp://www.open-xchange.com/wiki/index.php?title=User:Ledil\n\n[ledil (irc), leonardo_dilella (skype)]\n0x15208141 | 2829 F2BE 2242 91F0 24EB C0A7 258E F1A2 1520 8141\n------=_Part_932_16478682.1207643538866\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\">\n    <meta name=\"generator\"\n    content=\"HTML Tidy for Java (vers. 26 Sep 2004), see www.w3.org\" />\n\n    <title></title>\n  </head>\n\n  <body>\n    dfgfdgsssssssssssssssssssssssssssssss&gt; hat am\n    4. April 2008 um 19:17 geschrieben:<br />\n    <br />\n    &gt; Hallo!<br />\n    <br />\n    Hallo,<br />\n    <br />\n    wie lauten die Randbedingungen ? <br />\n    <br />\n    1) Wie lange zahlt uns safgggdfag ?<br />\n    2) PrivasdfASFGDGF einsetzbar sdfSddddddddddd ?<br />\n    3) Was paFSGADFGADFGDAFG SFADGASGRADdigung ?<br />\n    <br />\n    Danke.<br />\n    <br />\n\n    <div>\n      --<br />\n      best regards<br />\n      dfgdfgdfg<br />\n      <br />\n      Open-Xchange GmbH<br />\n      <a\n      href=\"http://www.open-xchange.com/wiki/index.php?title=User:Ledil\"\n       target=\"_blank\">http://www.open-xchange.com/wiki/index.php?title=User:Ledil</a><br />\n      <br />\n      [ngfgdh (irc), kkkoooo (skyphe)]<br />\n      0x15208141 | 2829 F2BE 2242 91F0 24EB C0A7 258E F1A2 1520 8141\n    </div>\n  </body>\n\n</html>\n\n------=_Part_932_16478682.1207643538866--\n\n";

    public MailSearchTest() {
    }

    public MailSearchTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailSearch() throws OXException, MessagingException, IOException {
        SessionObject session = this.getSession();
        MailMessage[] mails = MailSearchTest.getMessages(this.getTestMailDir(), -1);
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        String[] uids = mailAccess.getMessageStorage().appendMessages("INBOX", mails);
        try {
            int i;
            HeaderTerm term = new HeaderTerm(MessageHeaders.HDR_CONTENT_TYPE, "text/plain; charset=us-ascii");
            System.currentTimeMillis();
            MailMessage[] fetchedMails = mailAccess.getMessageStorage().searchMessages("INBOX", IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailSearchTest.assertFalse((String)"Mail ID is -1", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailSearchTest.assertTrue((String)"Missing Content-Type", (boolean)fetchedMails[i].containsContentType());
                MailSearchTest.assertTrue((String)"Unexpected Content-Type", (boolean)fetchedMails[i].getContentType().startsWith("text/plain"));
            }
            term = new FlagTerm(32, false);
            System.currentTimeMillis();
            fetchedMails = mailAccess.getMessageStorage().searchMessages("INBOX", IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_MORE);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailSearchTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailSearchTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                MailSearchTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                MailSearchTest.assertTrue((String)"Message contains flag \\Seen although only unseen messages should have been returned", ((fetchedMails[i].getFlags() & 0x20) == 0 ? 1 : 0) != 0);
            }
            term = new SizeTerm(ComparisonType.GREATER_THAN, 1023);
            System.currentTimeMillis();
            fetchedMails = mailAccess.getMessageStorage().searchMessages("INBOX", IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_EVEN_MORE);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailSearchTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailSearchTest.assertTrue((String)"Missing size", (boolean)fetchedMails[i].containsSize());
                MailSearchTest.assertTrue((String)"Unexpected size", (fetchedMails[i].getSize() > 1023L ? 1 : 0) != 0);
            }
            HashMap<String, String> map = new HashMap<String, String>(fetchedMails.length);
            for (int i2 = 0; i2 < fetchedMails.length && i2 < 100; ++i2) {
                String messageId = fetchedMails[i2].getFirstHeader(MessageHeaders.HDR_MESSAGE_ID);
                if (null == messageId || messageId.length() <= 0 || "null".equalsIgnoreCase(messageId)) continue;
                map.put(fetchedMails[i2].getMailId(), messageId);
            }
            int size = map.size();
            Iterator iter = map.entrySet().iterator();
            for (int i3 = 0; i3 < size; ++i3) {
                Map.Entry e = iter.next();
                term = new HeaderTerm(MessageHeaders.HDR_MESSAGE_ID, (String)e.getValue());
                System.currentTimeMillis();
                MailMessage[] searchedMails = mailAccess.getMessageStorage().searchMessages("INBOX", IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID_AND_HEADER);
                MailSearchTest.assertTrue((String)"Search failed: No result", (null != searchedMails ? 1 : 0) != 0);
                MailSearchTest.assertTrue((String)"Search failed: Non-matching result size", (searchedMails.length >= 1 ? 1 : 0) != 0);
                boolean found = false;
                for (int j = 0; j < searchedMails.length && !found; ++j) {
                    String messageId = searchedMails[j].getFirstHeader(MessageHeaders.HDR_MESSAGE_ID);
                    MailSearchTest.assertTrue((String)"Missing Message-Id", (null != messageId ? 1 : 0) != 0);
                    MailSearchTest.assertTrue((String)"Non-matching Message-Id", (boolean)messageId.equals(e.getValue()));
                    found = ((String)e.getKey()).equals(searchedMails[j].getMailId());
                }
                MailSearchTest.assertTrue((String)"Non-matching mail ID", (boolean)found);
            }
        }
        finally {
            mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
            mailAccess.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailSearchSmallMailbox() throws OXException, MessagingException, IOException {
        String parentFullname;
        SessionObject session = this.getSession();
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        String name = "TemporaryFolder";
        String fullname = null;
        MailFolder inbox = mailAccess.getFolderStorage().getFolder("INBOX");
        if (inbox.isHoldsFolders()) {
            fullname = inbox.getFullname() + inbox.getSeparator() + "TemporaryFolder";
            parentFullname = "INBOX";
        } else {
            fullname = "TemporaryFolder";
            parentFullname = "default";
        }
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setExists(false);
        mfd.setParentFullname(parentFullname);
        mfd.setSeparator(inbox.getSeparator());
        mfd.setSubscribed(false);
        mfd.setName("TemporaryFolder");
        MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
        p.setEntity(this.getUser());
        p.setAllPermission(128, 128, 128, 128);
        p.setFolderAdmin(true);
        p.setGroupPermission(false);
        mfd.addPermission(p);
        mailAccess.getFolderStorage().createFolder(mfd);
        try {
            int i;
            int i2;
            mailAccess.getMessageStorage().appendMessages(fullname, MailSearchTest.getMessages(this.getTestMailDir(), -1));
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])RFC822_SRC.getBytes(Charsets.US_ASCII));
            MailSearchTest.assertEquals((String)"Unexpected or missing Message-ID header: ", (String)"<32496175.17311207643539009.JavaMail.open-xchange@oxee>", (String)mail.getFirstHeader("Message-ID"));
            String uid = mailAccess.getMessageStorage().appendMessages(fullname, new MailMessage[]{mail})[0];
            ToTerm term = new ToTerm("dream-team@open-xchange.com");
            MailMessage[] result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            boolean found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by To search term", (boolean)found);
            term = new FromTerm("\"Di Lella, Leonardo\" <leonardo.dilella@open-xchange.com>");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by From search term", (boolean)found);
            term = new FromTerm("Di Lella");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by From search term", (boolean)found);
            term = new SubjectTerm("Vserver von 1und1");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Subject search term", (boolean)found);
            term = new SentDateTerm(ComparisonType.GREATER_THAN, DateUtils.getDateRFC822((String)"Tue, 8 Apr 2008 10:30:18 +0200 (CEST)"));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Sent Date search term", (boolean)found);
            term = new HeaderTerm("X-Priority", String.valueOf(3));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Header \"X-Priority\" search term", (boolean)found);
            term = new HeaderTerm("In-Reply-To", "<47F662C4.5060605@open-xchange.com>");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            MailSearchTest.assertTrue((String)("Unexpected result size: " + result.length), (result.length == 1 ? 1 : 0) != 0);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Header \"In-Reply-To\" search term", (boolean)found);
            term = new BodyTerm("4. April 2008 um 19:17 geschrieben");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by body search term", (boolean)found);
            long size = mailAccess.getMessageStorage().getMessage(fullname, uid, false).getSize();
            term = new SizeTerm(ComparisonType.GREATER_THAN, (int)(size - 10L));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
            term = new SizeTerm(ComparisonType.LESS_THAN, (int)(size + 10L));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
            term = new SizeTerm(ComparisonType.EQUALS, (int)size);
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
        }
        finally {
            if (fullname != null) {
                mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
            mailAccess.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailSearchLargeMailbox() throws OXException, MessagingException, IOException {
        String parentFullname;
        SessionObject session = this.getSession();
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        String name = "TemporaryFolder";
        String fullname = null;
        MailFolder inbox = mailAccess.getFolderStorage().getFolder("INBOX");
        if (inbox.isHoldsFolders()) {
            fullname = inbox.getFullname() + inbox.getSeparator() + "TemporaryFolder";
            parentFullname = "INBOX";
        } else {
            fullname = "TemporaryFolder";
            parentFullname = "default";
        }
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setExists(false);
        mfd.setParentFullname(parentFullname);
        mfd.setSeparator(inbox.getSeparator());
        mfd.setSubscribed(false);
        mfd.setName("TemporaryFolder");
        MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
        p.setEntity(this.getUser());
        p.setAllPermission(128, 128, 128, 128);
        p.setFolderAdmin(true);
        p.setGroupPermission(false);
        mfd.addPermission(p);
        mailAccess.getFolderStorage().createFolder(mfd);
        try {
            int i;
            int i2;
            MailMessage[] mails = MailSearchTest.getMessages(this.getTestMailDir(), -1);
            int breakEven = MailProperties.getInstance().getMailFetchLimit();
            String[] uids = mailAccess.getMessageStorage().appendMessages(fullname, mails);
            for (int count = mails.length; count < breakEven; count += uids.length) {
                mailAccess.getMessageStorage().copyMessages(fullname, fullname, uids, true);
            }
            mailAccess.getMessageStorage().appendMessages(fullname, mails);
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])RFC822_SRC.getBytes(Charsets.US_ASCII));
            String uid = mailAccess.getMessageStorage().appendMessages(fullname, new MailMessage[]{mail})[0];
            ToTerm term = new ToTerm("dream-team@open-xchange.com");
            MailMessage[] result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            boolean found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by To search term", (boolean)found);
            term = new FromTerm("\"Di Lella, Leonardo\" <leonardo.dilella@open-xchange.com>");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by From search term", (boolean)found);
            term = new FromTerm("Di Lella");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by From search term", (boolean)found);
            term = new SubjectTerm("Vserver von 1und1");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Subject search term", (boolean)found);
            term = new SentDateTerm(ComparisonType.GREATER_THAN, DateUtils.getDateRFC822((String)"Tue, 8 Apr 2008 10:30:18 +0200 (CEST)"));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Sent Date search term", (boolean)found);
            term = new HeaderTerm("X-Priority", String.valueOf(3));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Header \"X-Priority\" search term", (boolean)found);
            term = new HeaderTerm("In-Reply-To", "<47F662C4.5060605@open-xchange.com>");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            MailSearchTest.assertTrue((String)("Unexpected result size: " + result.length), (result.length == 1 ? 1 : 0) != 0);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Header \"In-Reply-To\" search term", (boolean)found);
            term = new BodyTerm("4. April 2008 um 19:17 geschrieben");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by body search term", (boolean)found);
            long size = mailAccess.getMessageStorage().getMessage(fullname, uid, false).getSize();
            term = new SizeTerm(ComparisonType.GREATER_THAN, (int)(size - 10L));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
            term = new SizeTerm(ComparisonType.LESS_THAN, (int)(size + 10L));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
            term = new SizeTerm(ComparisonType.EQUALS, (int)size);
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
        }
        finally {
            if (fullname != null) {
                mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
            mailAccess.close(false);
        }
    }
}

