/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import com.openexchange.exception.OXException;
import com.openexchange.i18n.parsing.I18NExceptionCode;
import com.openexchange.i18n.parsing.POParser;
import com.openexchange.i18n.parsing.Translations;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;

public class GettextParserTest
extends TestCase {
    public void setUp() {
    }

    public void testShouldParseSingleLineEntries() throws OXException {
        String poText = "msgid \"I am a message.\"\nmsgstr \"Ich bin eine Nachricht.\"\nmsgid \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.\"\n";
        Translations translations = this.parse("msgid \"I am a message.\"\nmsgstr \"Ich bin eine Nachricht.\"\nmsgid \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.\"\n");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "I am a message.", "Ich bin eine Nachricht.");
        GettextParserTest.assertTranslation(translations, "I am another message.", "Ich bin eine andere Nachricht.");
    }

    public void testShouldParseMultiLineEntries() throws OXException {
        String poText = "msgid \"\"\n\"This is part of a longer string\\n\"\n\"Typically multiline\"\nmsgstr \"\"\n\"Dies ist ein Teil einerer l\u00e4ngeren Zeichenkette\\n\"\n\"Typischerweise mehrzeilig\"\nmsgid \"\"\n\"This is another long string\\n\"\n\"Again multiline\\n\"\nmsgstr \"\"\n\"Dies ist ein weitere lange Zeichenkette\\n\"\n\"Ebenfalls mehrzeilig\\n\"\n";
        Translations translations = this.parse("msgid \"\"\n\"This is part of a longer string\\n\"\n\"Typically multiline\"\nmsgstr \"\"\n\"Dies ist ein Teil einerer l\u00e4ngeren Zeichenkette\\n\"\n\"Typischerweise mehrzeilig\"\nmsgid \"\"\n\"This is another long string\\n\"\n\"Again multiline\\n\"\nmsgstr \"\"\n\"Dies ist ein weitere lange Zeichenkette\\n\"\n\"Ebenfalls mehrzeilig\\n\"\n");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "This is part of a longer string\nTypically multiline", "Dies ist ein Teil einerer l\u00e4ngeren Zeichenkette\nTypischerweise mehrzeilig");
    }

    public void testShouldBeRobustWithCarriageReturns() throws OXException {
        String poText = "msgid \"\"\r\n\"This is part of a longer string\\n\"\r\n\"Typically multiline\"\nmsgstr \"\"\r\n\"Dies ist ein Teil einerer l\u00e4ngeren Zeichenkette\\n\"\r\n\"Typischerweise mehrzeilig\"\nmsgid \"\"\r\n\"This is another long string\\n\"\r\n\"Again multiline\\n\"\nmsgstr \"\"\r\n\"Dies ist ein weitere lange Zeichenkette\\n\"\r\n\"Ebenfalls mehrzeilig\\n\"\r\n";
        Translations translations = this.parse("msgid \"\"\r\n\"This is part of a longer string\\n\"\r\n\"Typically multiline\"\nmsgstr \"\"\r\n\"Dies ist ein Teil einerer l\u00e4ngeren Zeichenkette\\n\"\r\n\"Typischerweise mehrzeilig\"\nmsgid \"\"\r\n\"This is another long string\\n\"\r\n\"Again multiline\\n\"\nmsgstr \"\"\r\n\"Dies ist ein weitere lange Zeichenkette\\n\"\r\n\"Ebenfalls mehrzeilig\\n\"\r\n");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "This is part of a longer string\nTypically multiline", "Dies ist ein Teil einerer l\u00e4ngeren Zeichenkette\nTypischerweise mehrzeilig");
    }

    public void testShouldParsePluralForms() throws OXException {
        String poText = "msgid \"%d message\"\nmsgid_plural \"%d messages\"\nmsgstr[0] \"%d Nachricht\"\nmsgstr[1] \"%d Nachrichten\"\nmsgid \"Another message\"\nmsgstr \"Andere Nachricht\"\n";
        Translations translations = this.parse("msgid \"%d message\"\nmsgid_plural \"%d messages\"\nmsgstr[0] \"%d Nachricht\"\nmsgstr[1] \"%d Nachrichten\"\nmsgid \"Another message\"\nmsgstr \"Andere Nachricht\"\n");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "%d message", "%d Nachricht");
        GettextParserTest.assertTranslation(translations, "%d messages", "%d Nachricht");
        GettextParserTest.assertTranslation(translations, "Another message", "Andere Nachricht");
    }

    public void testShouldParseMultilinePlurals() throws OXException {
        String poText = "msgid \"\"\n\"A multiline message about\\n\"\n\"%d message\"\nmsgid_plural \"\"\n\"A multiline message about\\n\"\n\"%d messages\"\nmsgstr[0] \"\"\n\"Eine mehrzeilige Nachricht \u00fcber\\n\"\n\"%d Nachricht\"\nmsgstr[1] \"\"\n\"Eine mehrzeilige Nachricht \u00fcber\\n\"\n\"%d Nachrichten\"\nmsgid \"Another message\"\nmsgstr \"Andere Nachricht\"\n";
        Translations translations = this.parse("msgid \"\"\n\"A multiline message about\\n\"\n\"%d message\"\nmsgid_plural \"\"\n\"A multiline message about\\n\"\n\"%d messages\"\nmsgstr[0] \"\"\n\"Eine mehrzeilige Nachricht \u00fcber\\n\"\n\"%d Nachricht\"\nmsgstr[1] \"\"\n\"Eine mehrzeilige Nachricht \u00fcber\\n\"\n\"%d Nachrichten\"\nmsgid \"Another message\"\nmsgstr \"Andere Nachricht\"\n");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "A multiline message about\n%d message", "Eine mehrzeilige Nachricht \u00fcber\n%d Nachricht");
        GettextParserTest.assertTranslation(translations, "A multiline message about\n%d messages", "Eine mehrzeilige Nachricht \u00fcber\n%d Nachricht");
        GettextParserTest.assertTranslation(translations, "Another message", "Andere Nachricht");
    }

    public void testShouldIgnoreComments() throws OXException {
        String poText = "# This is a comment line.\nmsgid \"I am a message.\"\nmsgstr \"Ich bin eine Nachricht.\"\n# Comments are lines that start with #\nmsgid \"I am another message.\"\n# Comments can appear practically everywhere\nmsgstr \"Ich bin eine andere Nachricht.\"\n";
        Translations translations = this.parse("# This is a comment line.\nmsgid \"I am a message.\"\nmsgstr \"Ich bin eine Nachricht.\"\n# Comments are lines that start with #\nmsgid \"I am another message.\"\n# Comments can appear practically everywhere\nmsgstr \"Ich bin eine andere Nachricht.\"\n");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "I am a message.", "Ich bin eine Nachricht.");
        GettextParserTest.assertTranslation(translations, "I am another message.", "Ich bin eine andere Nachricht.");
    }

    public void testShouldIgnoreWhitespace() throws OXException {
        String poText = "msgid     \"I am a message.\"\nmsgstr    \"Ich bin eine Nachricht.\"    \nmsgid   \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.\"";
        Translations translations = this.parse("msgid     \"I am a message.\"\nmsgstr    \"Ich bin eine Nachricht.\"    \nmsgid   \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.\"");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "I am a message.", "Ich bin eine Nachricht.");
        GettextParserTest.assertTranslation(translations, "I am another message.", "Ich bin eine andere Nachricht.");
    }

    public void testShouldIgnoreEmptyLines() throws OXException {
        String poText = "msgid \"I am a message.\"\n\nmsgstr \"Ich bin eine Nachricht.\"\n\n\nmsgid \"I am another message.\"\n\n  \nmsgstr \"Ich bin eine andere Nachricht.\"\n";
        Translations translations = this.parse("msgid \"I am a message.\"\n\nmsgstr \"Ich bin eine Nachricht.\"\n\n\nmsgid \"I am another message.\"\n\n  \nmsgstr \"Ich bin eine andere Nachricht.\"\n");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "I am a message.", "Ich bin eine Nachricht.");
        GettextParserTest.assertTranslation(translations, "I am another message.", "Ich bin eine andere Nachricht.");
    }

    public void testShouldIgnoreMessageContext() throws OXException {
        String poText = "msgctxt Testing\nmsgid \"I am a message.\"\n\nmsgstr \"Ich bin eine Nachricht.\"\n\n\nmsgctxt Testing\nmsgid \"I am another message.\"\n\n  \nmsgstr \"Ich bin eine andere Nachricht.\"\n";
        Translations translations = this.parse("msgctxt Testing\nmsgid \"I am a message.\"\n\nmsgstr \"Ich bin eine Nachricht.\"\n\n\nmsgctxt Testing\nmsgid \"I am another message.\"\n\n  \nmsgstr \"Ich bin eine andere Nachricht.\"\n");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "I am a message.", "Ich bin eine Nachricht.");
        GettextParserTest.assertTranslation(translations, "I am another message.", "Ich bin eine andere Nachricht.");
    }

    public void testShouldSurviveRunawayStrings() throws OXException {
        String poText = "msgid \"I am a message.\"\nmsgstr \"Ich bin eine Nachricht.\nmsgid \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.";
        Translations translations = this.parse("msgid \"I am a message.\"\nmsgstr \"Ich bin eine Nachricht.\nmsgid \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.");
        GettextParserTest.assertNotNull((Object)translations);
        GettextParserTest.assertTranslation(translations, "I am a message.", "Ich bin eine Nachricht.");
        GettextParserTest.assertTranslation(translations, "I am another message.", "Ich bin eine andere Nachricht.");
    }

    public void testSyntaxError1() throws UnsupportedEncodingException {
        String poText = "msgid \"\"\nmsgstr \"Content-Type: text/plain; charset=UTF-8\\n\"\nmsgid \"I am a message.\"\nmsgstr \"Ich bin eine Nachricht.\nBLUPP! \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.\"";
        try {
            this.parse("msgid \"\"\nmsgstr \"Content-Type: text/plain; charset=UTF-8\\n\"\nmsgid \"I am a message.\"\nmsgstr \"Ich bin eine Nachricht.\nBLUPP! \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.\"".getBytes(Charsets.UTF_8));
            GettextParserTest.fail((String)"Expected parsing error");
        }
        catch (OXException x) {
            GettextParserTest.assertEquals((int)I18NExceptionCode.UNEXPECTED_TOKEN.getNumber(), (int)x.getCode());
            Object[] messageArgs = x.getLogArgs();
            String incorrectToken = (String)messageArgs[0];
            String filename = (String)messageArgs[1];
            int line = Autoboxing.i((Integer)((Integer)messageArgs[2]));
            String expectedList = (String)messageArgs[3];
            GettextParserTest.assertEquals((String)"BLUPP! \"I am another message.\"", (String)incorrectToken);
            GettextParserTest.assertEquals((String)"test.po", (String)filename);
            GettextParserTest.assertEquals((int)5, (int)line);
            GettextParserTest.assertEquals((String)"[msgid, msgctxt, msgstr, string, comment, eof]", (String)expectedList);
        }
    }

    public void testSyntaxError2() throws UnsupportedEncodingException {
        String poText = "msgid \"\"\nmsgstr \"Content-Type: text/plain; charset=UTF-8\\n\"\nmsgid \"I am a message.\"\nmsgid \"Ich bin eine Nachricht.\nmsgid \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.\"";
        try {
            this.parse("msgid \"\"\nmsgstr \"Content-Type: text/plain; charset=UTF-8\\n\"\nmsgid \"I am a message.\"\nmsgid \"Ich bin eine Nachricht.\nmsgid \"I am another message.\"\nmsgstr \"Ich bin eine andere Nachricht.\"".getBytes(Charsets.UTF_8));
            GettextParserTest.fail((String)"Expected parsing error");
        }
        catch (OXException x) {
            GettextParserTest.assertEquals((int)I18NExceptionCode.UNEXPECTED_TOKEN_CONSUME.getNumber(), (int)x.getCode());
            Object[] messageArgs = x.getLogArgs();
            String incorrectToken = (String)messageArgs[0];
            String filename = (String)messageArgs[1];
            int line = Autoboxing.i((Integer)((Integer)messageArgs[2]));
            String expectedList = (String)messageArgs[3];
            GettextParserTest.assertEquals((String)"msgid", (String)incorrectToken);
            GettextParserTest.assertEquals((String)"test.po", (String)filename);
            GettextParserTest.assertEquals((int)4, (int)line);
            GettextParserTest.assertEquals((String)"[msgstr]", (String)expectedList);
        }
    }

    public void testSyntaxError3() throws UnsupportedEncodingException {
        String poText = "msgid \"\"\nmsgstr \"Content-Type: text/plain; charset=UTF-8\\n\"\nmsgid \"I am a message.\"\nmsgstr[Blupp] \"Ich bin eine andere Nachricht.\"";
        try {
            this.parse("msgid \"\"\nmsgstr \"Content-Type: text/plain; charset=UTF-8\\n\"\nmsgid \"I am a message.\"\nmsgstr[Blupp] \"Ich bin eine andere Nachricht.\"".getBytes(Charsets.UTF_8));
            GettextParserTest.fail((String)"Expected parsing error");
        }
        catch (OXException x) {
            GettextParserTest.assertEquals((int)I18NExceptionCode.EXPECTED_NUMBER.getNumber(), (int)x.getCode());
            Object[] messageArgs = x.getLogArgs();
            String incorrectToken = (String)messageArgs[0];
            String filename = (String)messageArgs[1];
            int line = Autoboxing.i((Integer)((Integer)messageArgs[2]));
            GettextParserTest.assertEquals((String)"Blupp", (String)incorrectToken);
            GettextParserTest.assertEquals((String)"test.po", (String)filename);
            GettextParserTest.assertEquals((int)4, (int)line);
        }
    }

    public void testSyntaxError4() throws UnsupportedEncodingException {
        String poText = "msgid \"\"\nmsgstr \"Content-Type: text/plain; charset=UTF-8\\n\"\nmsgid \"I am a message.\"\nmsgstTUEDELUE \"Ich bin eine andere Nachricht.\"";
        try {
            this.parse("msgid \"\"\nmsgstr \"Content-Type: text/plain; charset=UTF-8\\n\"\nmsgid \"I am a message.\"\nmsgstTUEDELUE \"Ich bin eine andere Nachricht.\"".getBytes(Charsets.UTF_8));
            GettextParserTest.fail((String)"Expected parsing error");
        }
        catch (OXException x) {
            GettextParserTest.assertEquals((int)I18NExceptionCode.MALFORMED_TOKEN.getNumber(), (int)x.getCode());
            Object[] messageArgs = x.getLogArgs();
            String incorrectToken = (String)messageArgs[0];
            String expected = (String)messageArgs[1];
            String filename = (String)messageArgs[2];
            int line = Autoboxing.i((Integer)((Integer)messageArgs[3]));
            GettextParserTest.assertEquals((String)"T", (String)incorrectToken);
            GettextParserTest.assertEquals((String)"r", (String)expected);
            GettextParserTest.assertEquals((String)"test.po", (String)filename);
            GettextParserTest.assertEquals((int)4, (int)line);
        }
    }

    public void testIOException() {
        try {
            new POParser().parse((InputStream)new ExceptionThrowingInputStream(), "test.po");
        }
        catch (OXException e) {
            GettextParserTest.assertEquals((int)I18NExceptionCode.IO_EXCEPTION.getNumber(), (int)e.getCode());
            GettextParserTest.assertEquals((Object)"test.po", (Object)e.getLogArgs()[0]);
            GettextParserTest.assertEquals((String)"BUMM!", (String)e.getCause().getMessage());
        }
    }

    protected Translations parse(String poText) throws OXException {
        String withContentType = "msgid \"\"\nmsgstr \"\"\n\"Content-Type: text/plain; charset=UTF-8\\n\"\r\n" + poText;
        return this.parse(withContentType.getBytes(Charsets.UTF_8));
    }

    protected Translations parse(byte[] poText) throws OXException {
        return new POParser().parse((InputStream)new ByteArrayInputStream(poText), "test.po");
    }

    protected static void assertTranslation(Translations translations, String original, String expectedTranslation) {
        String actualTranslation = translations.translate(original);
        GettextParserTest.assertNotNull((String)("Could not find '" + original + "' in " + translations.getKnownStrings()), (Object)actualTranslation);
        GettextParserTest.assertEquals((String)expectedTranslation, (String)actualTranslation);
    }

    static final class ExceptionThrowingInputStream
    extends InputStream {
        ExceptionThrowingInputStream() {
        }

        @Override
        public int read() throws IOException {
            throw new IOException("BUMM!");
        }

        @Override
        public void close() {
        }
    }
}

